/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterServerVulnerabilityAssessmentsSettingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting#id SecurityCenterServerVulnerabilityAssessmentsSetting#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting#vulnerability_assessment_provider SecurityCenterServerVulnerabilityAssessmentsSetting#vulnerability_assessment_provider}
    */
    readonly vulnerabilityAssessmentProvider: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting#timeouts SecurityCenterServerVulnerabilityAssessmentsSetting#timeouts}
    */
    readonly timeouts?: SecurityCenterServerVulnerabilityAssessmentsSettingTimeouts;
}
export interface SecurityCenterServerVulnerabilityAssessmentsSettingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting#create SecurityCenterServerVulnerabilityAssessmentsSetting#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting#delete SecurityCenterServerVulnerabilityAssessmentsSetting#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting#read SecurityCenterServerVulnerabilityAssessmentsSetting#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting#update SecurityCenterServerVulnerabilityAssessmentsSetting#update}
    */
    readonly update?: string;
}
export declare function securityCenterServerVulnerabilityAssessmentsSettingTimeoutsToTerraform(struct?: SecurityCenterServerVulnerabilityAssessmentsSettingTimeouts | cdktf.IResolvable): any;
export declare function securityCenterServerVulnerabilityAssessmentsSettingTimeoutsToHclTerraform(struct?: SecurityCenterServerVulnerabilityAssessmentsSettingTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterServerVulnerabilityAssessmentsSettingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterServerVulnerabilityAssessmentsSettingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterServerVulnerabilityAssessmentsSettingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting azurerm_security_center_server_vulnerability_assessments_setting}
*/
export declare class SecurityCenterServerVulnerabilityAssessmentsSetting extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_server_vulnerability_assessments_setting";
    /**
    * Generates CDKTF code for importing a SecurityCenterServerVulnerabilityAssessmentsSetting resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityCenterServerVulnerabilityAssessmentsSetting to import
    * @param importFromId The id of the existing SecurityCenterServerVulnerabilityAssessmentsSetting that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityCenterServerVulnerabilityAssessmentsSetting to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_server_vulnerability_assessments_setting azurerm_security_center_server_vulnerability_assessments_setting} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterServerVulnerabilityAssessmentsSettingConfig
    */
    constructor(scope: Construct, id: string, config: SecurityCenterServerVulnerabilityAssessmentsSettingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _vulnerabilityAssessmentProvider?;
    get vulnerabilityAssessmentProvider(): string;
    set vulnerabilityAssessmentProvider(value: string);
    get vulnerabilityAssessmentProviderInput(): string | undefined;
    private _timeouts;
    get timeouts(): SecurityCenterServerVulnerabilityAssessmentsSettingTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterServerVulnerabilityAssessmentsSettingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecurityCenterServerVulnerabilityAssessmentsSettingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
