/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudContainerDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#addon_json SpringCloudContainerDeployment#addon_json}
    */
    readonly addonJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#application_performance_monitoring_ids SpringCloudContainerDeployment#application_performance_monitoring_ids}
    */
    readonly applicationPerformanceMonitoringIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#arguments SpringCloudContainerDeployment#arguments}
    */
    readonly arguments?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#commands SpringCloudContainerDeployment#commands}
    */
    readonly commands?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#environment_variables SpringCloudContainerDeployment#environment_variables}
    */
    readonly environmentVariables?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#id SpringCloudContainerDeployment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#image SpringCloudContainerDeployment#image}
    */
    readonly image: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#instance_count SpringCloudContainerDeployment#instance_count}
    */
    readonly instanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#language_framework SpringCloudContainerDeployment#language_framework}
    */
    readonly languageFramework?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#name SpringCloudContainerDeployment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#server SpringCloudContainerDeployment#server}
    */
    readonly server: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#spring_cloud_app_id SpringCloudContainerDeployment#spring_cloud_app_id}
    */
    readonly springCloudAppId: string;
    /**
    * quota block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#quota SpringCloudContainerDeployment#quota}
    */
    readonly quota?: SpringCloudContainerDeploymentQuota;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#timeouts SpringCloudContainerDeployment#timeouts}
    */
    readonly timeouts?: SpringCloudContainerDeploymentTimeouts;
}
export interface SpringCloudContainerDeploymentQuota {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#cpu SpringCloudContainerDeployment#cpu}
    */
    readonly cpu?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#memory SpringCloudContainerDeployment#memory}
    */
    readonly memory?: string;
}
export declare function springCloudContainerDeploymentQuotaToTerraform(struct?: SpringCloudContainerDeploymentQuotaOutputReference | SpringCloudContainerDeploymentQuota): any;
export declare function springCloudContainerDeploymentQuotaToHclTerraform(struct?: SpringCloudContainerDeploymentQuotaOutputReference | SpringCloudContainerDeploymentQuota): any;
export declare class SpringCloudContainerDeploymentQuotaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudContainerDeploymentQuota | undefined;
    set internalValue(value: SpringCloudContainerDeploymentQuota | undefined);
    private _cpu?;
    get cpu(): string;
    set cpu(value: string);
    resetCpu(): void;
    get cpuInput(): string | undefined;
    private _memory?;
    get memory(): string;
    set memory(value: string);
    resetMemory(): void;
    get memoryInput(): string | undefined;
}
export interface SpringCloudContainerDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#create SpringCloudContainerDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#delete SpringCloudContainerDeployment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#read SpringCloudContainerDeployment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#update SpringCloudContainerDeployment#update}
    */
    readonly update?: string;
}
export declare function springCloudContainerDeploymentTimeoutsToTerraform(struct?: SpringCloudContainerDeploymentTimeouts | cdktf.IResolvable): any;
export declare function springCloudContainerDeploymentTimeoutsToHclTerraform(struct?: SpringCloudContainerDeploymentTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudContainerDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudContainerDeploymentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudContainerDeploymentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment azurerm_spring_cloud_container_deployment}
*/
export declare class SpringCloudContainerDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_container_deployment";
    /**
    * Generates CDKTF code for importing a SpringCloudContainerDeployment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudContainerDeployment to import
    * @param importFromId The id of the existing SpringCloudContainerDeployment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudContainerDeployment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_container_deployment azurerm_spring_cloud_container_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudContainerDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudContainerDeploymentConfig);
    private _addonJson?;
    get addonJson(): string;
    set addonJson(value: string);
    resetAddonJson(): void;
    get addonJsonInput(): string | undefined;
    private _applicationPerformanceMonitoringIds?;
    get applicationPerformanceMonitoringIds(): string[];
    set applicationPerformanceMonitoringIds(value: string[]);
    resetApplicationPerformanceMonitoringIds(): void;
    get applicationPerformanceMonitoringIdsInput(): string[] | undefined;
    private _arguments?;
    get arguments(): string[];
    set arguments(value: string[]);
    resetArguments(): void;
    get argumentsInput(): string[] | undefined;
    private _commands?;
    get commands(): string[];
    set commands(value: string[]);
    resetCommands(): void;
    get commandsInput(): string[] | undefined;
    private _environmentVariables?;
    get environmentVariables(): {
        [key: string]: string;
    };
    set environmentVariables(value: {
        [key: string]: string;
    });
    resetEnvironmentVariables(): void;
    get environmentVariablesInput(): {
        [key: string]: string;
    } | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _instanceCount?;
    get instanceCount(): number;
    set instanceCount(value: number);
    resetInstanceCount(): void;
    get instanceCountInput(): number | undefined;
    private _languageFramework?;
    get languageFramework(): string;
    set languageFramework(value: string);
    resetLanguageFramework(): void;
    get languageFrameworkInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _server?;
    get server(): string;
    set server(value: string);
    get serverInput(): string | undefined;
    private _springCloudAppId?;
    get springCloudAppId(): string;
    set springCloudAppId(value: string);
    get springCloudAppIdInput(): string | undefined;
    private _quota;
    get quota(): SpringCloudContainerDeploymentQuotaOutputReference;
    putQuota(value: SpringCloudContainerDeploymentQuota): void;
    resetQuota(): void;
    get quotaInput(): SpringCloudContainerDeploymentQuota | undefined;
    private _timeouts;
    get timeouts(): SpringCloudContainerDeploymentTimeoutsOutputReference;
    putTimeouts(value: SpringCloudContainerDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudContainerDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
