/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SpringCloudGatewayRouteConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#filters SpringCloudGatewayRouteConfig#filters}
    */
    readonly filters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#id SpringCloudGatewayRouteConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#name SpringCloudGatewayRouteConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#predicates SpringCloudGatewayRouteConfig#predicates}
    */
    readonly predicates?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#protocol SpringCloudGatewayRouteConfig#protocol}
    */
    readonly protocol?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#spring_cloud_app_id SpringCloudGatewayRouteConfig#spring_cloud_app_id}
    */
    readonly springCloudAppId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#spring_cloud_gateway_id SpringCloudGatewayRouteConfig#spring_cloud_gateway_id}
    */
    readonly springCloudGatewayId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#sso_validation_enabled SpringCloudGatewayRouteConfig#sso_validation_enabled}
    */
    readonly ssoValidationEnabled?: boolean | cdktf.IResolvable;
    /**
    * open_api block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#open_api SpringCloudGatewayRouteConfig#open_api}
    */
    readonly openApi?: SpringCloudGatewayRouteConfigOpenApi;
    /**
    * route block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#route SpringCloudGatewayRouteConfig#route}
    */
    readonly route?: SpringCloudGatewayRouteConfigRoute[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#timeouts SpringCloudGatewayRouteConfig#timeouts}
    */
    readonly timeouts?: SpringCloudGatewayRouteConfigTimeouts;
}
export interface SpringCloudGatewayRouteConfigOpenApi {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#uri SpringCloudGatewayRouteConfig#uri}
    */
    readonly uri?: string;
}
export declare function springCloudGatewayRouteConfigOpenApiToTerraform(struct?: SpringCloudGatewayRouteConfigOpenApiOutputReference | SpringCloudGatewayRouteConfigOpenApi): any;
export declare function springCloudGatewayRouteConfigOpenApiToHclTerraform(struct?: SpringCloudGatewayRouteConfigOpenApiOutputReference | SpringCloudGatewayRouteConfigOpenApi): any;
export declare class SpringCloudGatewayRouteConfigOpenApiOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewayRouteConfigOpenApi | undefined;
    set internalValue(value: SpringCloudGatewayRouteConfigOpenApi | undefined);
    private _uri?;
    get uri(): string;
    set uri(value: string);
    resetUri(): void;
    get uriInput(): string | undefined;
}
export interface SpringCloudGatewayRouteConfigRoute {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#classification_tags SpringCloudGatewayRouteConfig#classification_tags}
    */
    readonly classificationTags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#description SpringCloudGatewayRouteConfig#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#filters SpringCloudGatewayRouteConfig#filters}
    */
    readonly filters?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#order SpringCloudGatewayRouteConfig#order}
    */
    readonly order: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#predicates SpringCloudGatewayRouteConfig#predicates}
    */
    readonly predicates?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#sso_validation_enabled SpringCloudGatewayRouteConfig#sso_validation_enabled}
    */
    readonly ssoValidationEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#title SpringCloudGatewayRouteConfig#title}
    */
    readonly title?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#token_relay SpringCloudGatewayRouteConfig#token_relay}
    */
    readonly tokenRelay?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#uri SpringCloudGatewayRouteConfig#uri}
    */
    readonly uri?: string;
}
export declare function springCloudGatewayRouteConfigRouteToTerraform(struct?: SpringCloudGatewayRouteConfigRoute | cdktf.IResolvable): any;
export declare function springCloudGatewayRouteConfigRouteToHclTerraform(struct?: SpringCloudGatewayRouteConfigRoute | cdktf.IResolvable): any;
export declare class SpringCloudGatewayRouteConfigRouteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SpringCloudGatewayRouteConfigRoute | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudGatewayRouteConfigRoute | cdktf.IResolvable | undefined);
    private _classificationTags?;
    get classificationTags(): string[];
    set classificationTags(value: string[]);
    resetClassificationTags(): void;
    get classificationTagsInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _filters?;
    get filters(): string[];
    set filters(value: string[]);
    resetFilters(): void;
    get filtersInput(): string[] | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    get orderInput(): number | undefined;
    private _predicates?;
    get predicates(): string[];
    set predicates(value: string[]);
    resetPredicates(): void;
    get predicatesInput(): string[] | undefined;
    private _ssoValidationEnabled?;
    get ssoValidationEnabled(): boolean | cdktf.IResolvable;
    set ssoValidationEnabled(value: boolean | cdktf.IResolvable);
    resetSsoValidationEnabled(): void;
    get ssoValidationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _tokenRelay?;
    get tokenRelay(): boolean | cdktf.IResolvable;
    set tokenRelay(value: boolean | cdktf.IResolvable);
    resetTokenRelay(): void;
    get tokenRelayInput(): boolean | cdktf.IResolvable | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    resetUri(): void;
    get uriInput(): string | undefined;
}
export declare class SpringCloudGatewayRouteConfigRouteList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: SpringCloudGatewayRouteConfigRoute[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SpringCloudGatewayRouteConfigRouteOutputReference;
}
export interface SpringCloudGatewayRouteConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#create SpringCloudGatewayRouteConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#delete SpringCloudGatewayRouteConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#read SpringCloudGatewayRouteConfig#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#update SpringCloudGatewayRouteConfig#update}
    */
    readonly update?: string;
}
export declare function springCloudGatewayRouteConfigTimeoutsToTerraform(struct?: SpringCloudGatewayRouteConfigTimeouts | cdktf.IResolvable): any;
export declare function springCloudGatewayRouteConfigTimeoutsToHclTerraform(struct?: SpringCloudGatewayRouteConfigTimeouts | cdktf.IResolvable): any;
export declare class SpringCloudGatewayRouteConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SpringCloudGatewayRouteConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SpringCloudGatewayRouteConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config azurerm_spring_cloud_gateway_route_config}
*/
export declare class SpringCloudGatewayRouteConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_spring_cloud_gateway_route_config";
    /**
    * Generates CDKTF code for importing a SpringCloudGatewayRouteConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SpringCloudGatewayRouteConfig to import
    * @param importFromId The id of the existing SpringCloudGatewayRouteConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SpringCloudGatewayRouteConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/spring_cloud_gateway_route_config azurerm_spring_cloud_gateway_route_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SpringCloudGatewayRouteConfigConfig
    */
    constructor(scope: Construct, id: string, config: SpringCloudGatewayRouteConfigConfig);
    private _filters?;
    get filters(): string[];
    set filters(value: string[]);
    resetFilters(): void;
    get filtersInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _predicates?;
    get predicates(): string[];
    set predicates(value: string[]);
    resetPredicates(): void;
    get predicatesInput(): string[] | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    resetProtocol(): void;
    get protocolInput(): string | undefined;
    private _springCloudAppId?;
    get springCloudAppId(): string;
    set springCloudAppId(value: string);
    resetSpringCloudAppId(): void;
    get springCloudAppIdInput(): string | undefined;
    private _springCloudGatewayId?;
    get springCloudGatewayId(): string;
    set springCloudGatewayId(value: string);
    get springCloudGatewayIdInput(): string | undefined;
    private _ssoValidationEnabled?;
    get ssoValidationEnabled(): boolean | cdktf.IResolvable;
    set ssoValidationEnabled(value: boolean | cdktf.IResolvable);
    resetSsoValidationEnabled(): void;
    get ssoValidationEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _openApi;
    get openApi(): SpringCloudGatewayRouteConfigOpenApiOutputReference;
    putOpenApi(value: SpringCloudGatewayRouteConfigOpenApi): void;
    resetOpenApi(): void;
    get openApiInput(): SpringCloudGatewayRouteConfigOpenApi | undefined;
    private _route;
    get route(): SpringCloudGatewayRouteConfigRouteList;
    putRoute(value: SpringCloudGatewayRouteConfigRoute[] | cdktf.IResolvable): void;
    resetRoute(): void;
    get routeInput(): cdktf.IResolvable | SpringCloudGatewayRouteConfigRoute[] | undefined;
    private _timeouts;
    get timeouts(): SpringCloudGatewayRouteConfigTimeoutsOutputReference;
    putTimeouts(value: SpringCloudGatewayRouteConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SpringCloudGatewayRouteConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
