/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlManagedInstanceFailoverGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#id SqlManagedInstanceFailoverGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#location SqlManagedInstanceFailoverGroup#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#managed_instance_name SqlManagedInstanceFailoverGroup#managed_instance_name}
    */
    readonly managedInstanceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#name SqlManagedInstanceFailoverGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#partner_managed_instance_id SqlManagedInstanceFailoverGroup#partner_managed_instance_id}
    */
    readonly partnerManagedInstanceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#readonly_endpoint_failover_policy_enabled SqlManagedInstanceFailoverGroup#readonly_endpoint_failover_policy_enabled}
    */
    readonly readonlyEndpointFailoverPolicyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#resource_group_name SqlManagedInstanceFailoverGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * read_write_endpoint_failover_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#read_write_endpoint_failover_policy SqlManagedInstanceFailoverGroup#read_write_endpoint_failover_policy}
    */
    readonly readWriteEndpointFailoverPolicy: SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#timeouts SqlManagedInstanceFailoverGroup#timeouts}
    */
    readonly timeouts?: SqlManagedInstanceFailoverGroupTimeouts;
}
export interface SqlManagedInstanceFailoverGroupPartnerRegion {
}
export declare function sqlManagedInstanceFailoverGroupPartnerRegionToTerraform(struct?: SqlManagedInstanceFailoverGroupPartnerRegion): any;
export declare function sqlManagedInstanceFailoverGroupPartnerRegionToHclTerraform(struct?: SqlManagedInstanceFailoverGroupPartnerRegion): any;
export declare class SqlManagedInstanceFailoverGroupPartnerRegionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SqlManagedInstanceFailoverGroupPartnerRegion | undefined;
    set internalValue(value: SqlManagedInstanceFailoverGroupPartnerRegion | undefined);
    get location(): string;
    get role(): string;
}
export declare class SqlManagedInstanceFailoverGroupPartnerRegionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SqlManagedInstanceFailoverGroupPartnerRegionOutputReference;
}
export interface SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#grace_minutes SqlManagedInstanceFailoverGroup#grace_minutes}
    */
    readonly graceMinutes?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#mode SqlManagedInstanceFailoverGroup#mode}
    */
    readonly mode: string;
}
export declare function sqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyToTerraform(struct?: SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference | SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy): any;
export declare function sqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyToHclTerraform(struct?: SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference | SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy): any;
export declare class SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    set internalValue(value: SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy | undefined);
    private _graceMinutes?;
    get graceMinutes(): number;
    set graceMinutes(value: number);
    resetGraceMinutes(): void;
    get graceMinutesInput(): number | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface SqlManagedInstanceFailoverGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#create SqlManagedInstanceFailoverGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#delete SqlManagedInstanceFailoverGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#read SqlManagedInstanceFailoverGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#update SqlManagedInstanceFailoverGroup#update}
    */
    readonly update?: string;
}
export declare function sqlManagedInstanceFailoverGroupTimeoutsToTerraform(struct?: SqlManagedInstanceFailoverGroupTimeouts | cdktf.IResolvable): any;
export declare function sqlManagedInstanceFailoverGroupTimeoutsToHclTerraform(struct?: SqlManagedInstanceFailoverGroupTimeouts | cdktf.IResolvable): any;
export declare class SqlManagedInstanceFailoverGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlManagedInstanceFailoverGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SqlManagedInstanceFailoverGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group azurerm_sql_managed_instance_failover_group}
*/
export declare class SqlManagedInstanceFailoverGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sql_managed_instance_failover_group";
    /**
    * Generates CDKTF code for importing a SqlManagedInstanceFailoverGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SqlManagedInstanceFailoverGroup to import
    * @param importFromId The id of the existing SqlManagedInstanceFailoverGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SqlManagedInstanceFailoverGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/sql_managed_instance_failover_group azurerm_sql_managed_instance_failover_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlManagedInstanceFailoverGroupConfig
    */
    constructor(scope: Construct, id: string, config: SqlManagedInstanceFailoverGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managedInstanceName?;
    get managedInstanceName(): string;
    set managedInstanceName(value: string);
    get managedInstanceNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _partnerManagedInstanceId?;
    get partnerManagedInstanceId(): string;
    set partnerManagedInstanceId(value: string);
    get partnerManagedInstanceIdInput(): string | undefined;
    private _partnerRegion;
    get partnerRegion(): SqlManagedInstanceFailoverGroupPartnerRegionList;
    private _readonlyEndpointFailoverPolicyEnabled?;
    get readonlyEndpointFailoverPolicyEnabled(): boolean | cdktf.IResolvable;
    set readonlyEndpointFailoverPolicyEnabled(value: boolean | cdktf.IResolvable);
    resetReadonlyEndpointFailoverPolicyEnabled(): void;
    get readonlyEndpointFailoverPolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get role(): string;
    private _readWriteEndpointFailoverPolicy;
    get readWriteEndpointFailoverPolicy(): SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicyOutputReference;
    putReadWriteEndpointFailoverPolicy(value: SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy): void;
    get readWriteEndpointFailoverPolicyInput(): SqlManagedInstanceFailoverGroupReadWriteEndpointFailoverPolicy | undefined;
    private _timeouts;
    get timeouts(): SqlManagedInstanceFailoverGroupTimeoutsOutputReference;
    putTimeouts(value: SqlManagedInstanceFailoverGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SqlManagedInstanceFailoverGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
