/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SubnetRouteTableAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association#id SubnetRouteTableAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association#route_table_id SubnetRouteTableAssociation#route_table_id}
    */
    readonly routeTableId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association#subnet_id SubnetRouteTableAssociation#subnet_id}
    */
    readonly subnetId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association#timeouts SubnetRouteTableAssociation#timeouts}
    */
    readonly timeouts?: SubnetRouteTableAssociationTimeouts;
}
export interface SubnetRouteTableAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association#create SubnetRouteTableAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association#delete SubnetRouteTableAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association#read SubnetRouteTableAssociation#read}
    */
    readonly read?: string;
}
export declare function subnetRouteTableAssociationTimeoutsToTerraform(struct?: SubnetRouteTableAssociationTimeouts | cdktf.IResolvable): any;
export declare function subnetRouteTableAssociationTimeoutsToHclTerraform(struct?: SubnetRouteTableAssociationTimeouts | cdktf.IResolvable): any;
export declare class SubnetRouteTableAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SubnetRouteTableAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SubnetRouteTableAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association azurerm_subnet_route_table_association}
*/
export declare class SubnetRouteTableAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_subnet_route_table_association";
    /**
    * Generates CDKTF code for importing a SubnetRouteTableAssociation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SubnetRouteTableAssociation to import
    * @param importFromId The id of the existing SubnetRouteTableAssociation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SubnetRouteTableAssociation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/subnet_route_table_association azurerm_subnet_route_table_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SubnetRouteTableAssociationConfig
    */
    constructor(scope: Construct, id: string, config: SubnetRouteTableAssociationConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _routeTableId?;
    get routeTableId(): string;
    set routeTableId(value: string);
    get routeTableIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): SubnetRouteTableAssociationTimeoutsOutputReference;
    putTimeouts(value: SubnetRouteTableAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SubnetRouteTableAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
