/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface VmwarePrivateCloudConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#id VmwarePrivateCloud#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#internet_connection_enabled VmwarePrivateCloud#internet_connection_enabled}
    */
    readonly internetConnectionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#location VmwarePrivateCloud#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#name VmwarePrivateCloud#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#network_subnet_cidr VmwarePrivateCloud#network_subnet_cidr}
    */
    readonly networkSubnetCidr: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#nsxt_password VmwarePrivateCloud#nsxt_password}
    */
    readonly nsxtPassword?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#resource_group_name VmwarePrivateCloud#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#sku_name VmwarePrivateCloud#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#tags VmwarePrivateCloud#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#vcenter_password VmwarePrivateCloud#vcenter_password}
    */
    readonly vcenterPassword?: string;
    /**
    * management_cluster block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#management_cluster VmwarePrivateCloud#management_cluster}
    */
    readonly managementCluster: VmwarePrivateCloudManagementCluster;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#timeouts VmwarePrivateCloud#timeouts}
    */
    readonly timeouts?: VmwarePrivateCloudTimeouts;
}
export interface VmwarePrivateCloudCircuit {
}
export declare function vmwarePrivateCloudCircuitToTerraform(struct?: VmwarePrivateCloudCircuit): any;
export declare function vmwarePrivateCloudCircuitToHclTerraform(struct?: VmwarePrivateCloudCircuit): any;
export declare class VmwarePrivateCloudCircuitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): VmwarePrivateCloudCircuit | undefined;
    set internalValue(value: VmwarePrivateCloudCircuit | undefined);
    get expressRouteId(): string;
    get expressRoutePrivatePeeringId(): string;
    get primarySubnetCidr(): string;
    get secondarySubnetCidr(): string;
}
export declare class VmwarePrivateCloudCircuitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): VmwarePrivateCloudCircuitOutputReference;
}
export interface VmwarePrivateCloudManagementCluster {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#size VmwarePrivateCloud#size}
    */
    readonly size: number;
}
export declare function vmwarePrivateCloudManagementClusterToTerraform(struct?: VmwarePrivateCloudManagementClusterOutputReference | VmwarePrivateCloudManagementCluster): any;
export declare function vmwarePrivateCloudManagementClusterToHclTerraform(struct?: VmwarePrivateCloudManagementClusterOutputReference | VmwarePrivateCloudManagementCluster): any;
export declare class VmwarePrivateCloudManagementClusterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VmwarePrivateCloudManagementCluster | undefined;
    set internalValue(value: VmwarePrivateCloudManagementCluster | undefined);
    get hosts(): string[];
    get id(): number;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
}
export interface VmwarePrivateCloudTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#create VmwarePrivateCloud#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#delete VmwarePrivateCloud#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#read VmwarePrivateCloud#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#update VmwarePrivateCloud#update}
    */
    readonly update?: string;
}
export declare function vmwarePrivateCloudTimeoutsToTerraform(struct?: VmwarePrivateCloudTimeouts | cdktf.IResolvable): any;
export declare function vmwarePrivateCloudTimeoutsToHclTerraform(struct?: VmwarePrivateCloudTimeouts | cdktf.IResolvable): any;
export declare class VmwarePrivateCloudTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): VmwarePrivateCloudTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: VmwarePrivateCloudTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud azurerm_vmware_private_cloud}
*/
export declare class VmwarePrivateCloud extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_vmware_private_cloud";
    /**
    * Generates CDKTF code for importing a VmwarePrivateCloud resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the VmwarePrivateCloud to import
    * @param importFromId The id of the existing VmwarePrivateCloud that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the VmwarePrivateCloud to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/vmware_private_cloud azurerm_vmware_private_cloud} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options VmwarePrivateCloudConfig
    */
    constructor(scope: Construct, id: string, config: VmwarePrivateCloudConfig);
    private _circuit;
    get circuit(): VmwarePrivateCloudCircuitList;
    get hcxCloudManagerEndpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _internetConnectionEnabled?;
    get internetConnectionEnabled(): boolean | cdktf.IResolvable;
    set internetConnectionEnabled(value: boolean | cdktf.IResolvable);
    resetInternetConnectionEnabled(): void;
    get internetConnectionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get managementSubnetCidr(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkSubnetCidr?;
    get networkSubnetCidr(): string;
    set networkSubnetCidr(value: string);
    get networkSubnetCidrInput(): string | undefined;
    get nsxtCertificateThumbprint(): string;
    get nsxtManagerEndpoint(): string;
    private _nsxtPassword?;
    get nsxtPassword(): string;
    set nsxtPassword(value: string);
    resetNsxtPassword(): void;
    get nsxtPasswordInput(): string | undefined;
    get provisioningSubnetCidr(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get vcenterCertificateThumbprint(): string;
    private _vcenterPassword?;
    get vcenterPassword(): string;
    set vcenterPassword(value: string);
    resetVcenterPassword(): void;
    get vcenterPasswordInput(): string | undefined;
    get vcsaEndpoint(): string;
    get vmotionSubnetCidr(): string;
    private _managementCluster;
    get managementCluster(): VmwarePrivateCloudManagementClusterOutputReference;
    putManagementCluster(value: VmwarePrivateCloudManagementCluster): void;
    get managementClusterInput(): VmwarePrivateCloudManagementCluster | undefined;
    private _timeouts;
    get timeouts(): VmwarePrivateCloudTimeoutsOutputReference;
    putTimeouts(value: VmwarePrivateCloudTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | VmwarePrivateCloudTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
