from enum import Enum, unique


class Command(Enum):
    """This class is hold the different instruction command."""

    CMD_NONE = 0
    CMD_INIT = 1
    CMD_STOP = 2
    CMD_RESET = 3
    CMD_MOVE = 4
    CMD_POS_ABS = 5
    CMD_POS_REL = 6
    CMD_POWER_ON = 7
    CMD_POWER_OFF = 8
    CMD_HOMING = 9
    CMD_SET_VELO = 10
    CMD_SET_ACCEL = 11
    CMD_SET_DECEL = 12
    CMD_SET_JERK = 13
    CMD_GEAR_IN_REL = 14
    CMD_GEAR_OUT = 15
    CMD_SET_PATH_VELO = 16
    CMD_SET_PATH_ACCEL = 17
    CMD_SET_PATH_DECEL = 18
    CMD_SET_PATH_JERK = 19
    CMD_REDEFINE_POSITION = 20
    CMD_START_PROGRAM = 22
    CMD_JUMP_TO_SETNUMBER = 23
    CMD_WAIT_FOR_CONDITION = 24
    CMD_WAIT_FOR_PATH_POSITION = 26
    CMD_WAIT_FOR_AXIS_POSITION = 27
    CMD_WAIT_TIME = 28
    CMD_NEXT_STEP = 29
    CMD_STOP_PROGRAM = 30
    CMD_CONTINUE_PROGRAM = 31
    CMD_POS_ABS_XYZ = 32
    CMD_POS_REL_XYZ = 33
    CMD_POS_SEG_ABS = 35
    CMD_CAM_IN_ABS = 36
    CMD_CAM_OUT = 37
    CMD_GEAR_IN_ABS = 39
    CMD_PATH_STOP = 40
    CMD_SET_PATH_DELTA = 41
    CMD_GEAR_IN_REL_SUPERIMPOSED = 42
    CMD_GEAR_IN_ABS_SUPERIMPOSED = 43
    CMD_GEAR_OUT_SUPERIMPOSED = 44
    CMD_CAM_IN_ABS_SUPERIMPOSED = 45
    CMD_CAM_OUT_SUPERIMPOSED = 46
    CMD_WAIT_FOR_AXIS_CLAMPED = 47
    CMD_WAIT_FOR_AXIS_OPERATING_AT_TORQUE_LIMIT = 48
    CMD_JMP = 56
    CMD_JMPN = 57
    CMD_INTERRUPT_PROGRAM = 58
    CMD_POS_BASIC_SEGMENT = 60
    CMD_WAIT_POS_BASIC_SEG_READY = 59
    CMD_WAIT_POS_BASIC_SEG_END = 61
    CMD_CREATE_SEG_BY_BASIC_SEG = 62
    CMD_RESET_RV_RANGE = 63
    CMD_CALC_VELO_PROFILE = 64
    CMD_POS_SEG_START = 65
    CMD_SET_CONDITION = 66
    CMD_SET_RV = 67
    CMD_INTERRUPT_MOTION = 68
    CMD_CONTINUE_MOTION = 69
    CMD_PATH_INTERRUPT = 70
    CMD_PATH_CONTINUE = 71
    CMD_CALC_PROFILE_TIME = 72
    CMD_POS_TO_LIMIT = 73
    CMD_STEP_TO_LIMIT = 74
    CMD_SET_ZONES = 75
    CMD_GET_COLL_DETAILS = 76
    CMD_CLEAR_COLL_DETAILS = 77
    CMD_ZONE_CHECK = 78
    CMD_POS_SYNC_AX_START = 79
    CMD_WAIT_POS_SEG_END = 80
    CMD_EMERGENCY_ON = 81
    CMD_CREATE_SEG = 82
    CMD_CREATE_FOL_SEG = 83
    CMD_POS_FOL_SEG = 84
    CMD_SET_CAM = 85
    CMD_SWITCH_CS = 86
    CMD_CREATE_POLY = 87
    CMD_ENABLE_TRACKING = 88
    CMD_CLONE_SEG = 89
    CMD_SET_STACK = 90
    CMD_INC_STACK = 91
    CMD_EXT_KINTRANS = 92
    CMD_EN_MOVE_TO_END_STOP = 93
    CMD_DIS_MOVE_TO_END_STOP = 94
    CMD_EN_TORQUE_LIMITING = 95
    CMD_DIS_TORQUE_LIMITING = 96
    CMD_CLOSE_GRIPPER = 97
    CMD_OPEN_GRIPPER = 98
    CMD_SET_MOTION_PROG_STATE = 99
    CMD_WRITE_PROGRAM_SET = 100
    CMD_READ_PROGRAM_SET = 101
    CMD_DELETE_PROGRAM_SET = 102
    CMD_INSERT_PROGRAM_SET = 103
    CMD_WRITE_POINT = 104
    CMD_READ_POINT = 105
    CMD_DELETE_POINT = 106
    CMD_INSERT_POINT = 107
    CMD_SAVE_DATASET = 108
    CMD_LOAD_DATASET = 109
    CMD_CLUTCH_CS = 110
    CMD_SET_TRACKING_SHIFT = 111
    CMD_OUTPUT_CAM = 112
    CMD_OUTPUT_CAM_STATE = 113
    CMD_CAM_IN_REL = 120
    CMD_CAM_IN_REL_SUPERIMPOSED = 121
    CMD_GEAR_IN_VELO = 122
    CMD_GEAR_IN_VELO_SUPERIMPOSED = 123
    CMD_GEAR_OUT_VELO = 124
    CMD_GEAR_OUT_VELO_SUPERIMPOSED = 125
    CMD_CONTINUE_MANUAL = 130

    default = CMD_NONE

    def get_description(self, language="en"):
        """get the command description.
        :param language: The description language. Supported language are 'en' and 'de'
        :return:  the command description.
        """
        descriptions = {
            "CMD_NONE": {
                "de": {
                    "descript_1": "Kein Kommando angewählt",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "No command passed",
                    "descript_2": "-"
                }
            },
            "CMD_INIT": {
                "de": {
                    "descript_1": "Initialisierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Inititalization",
                    "descript_2": "-"
                }
            },
            "CMD_STOP": {
                "de": {
                    "descript_1": "1. Abbruch eines aktiven Verfahrprogr. 2. Bahninterpolation stoppen ",
                    "descript_2": "3. Auflösung eines evtl. Gleichlaufverbundes 4. Stoppen der Achse(n)"
                },
                "en": {
                    "descript_1": "1. Abort an active motion prog. 2. Stop path interpolation",
                    "descript_2": "3. Dissolve any existing synchronism group  4. Stop the axis (axes)"
                }
            },
            "CMD_RESET": {
                "de": {
                    "descript_1": "Rücksetzen anstehender Bibliotheks- und TO-Fehler",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Reset active library and TO errors",
                    "descript_2": "-"
                }
            },
            "CMD_MOVE": {
                "de": {
                    "descript_1": "Beschleunigung der Achse auf Geschwindigkeitssollwert (Einzelachse)",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Acceleration of the axis to target velocity value (single axis)",
                    "descript_2": "-"
                }
            },
            "CMD_POS_ABS": {
                "de": {
                    "descript_1": "Absolute Einzelachspositionierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Absolute single axis positioning",
                    "descript_2": "-"
                }
            },
            "CMD_POS_REL": {
                "de": {
                    "descript_1": "Relative Einzelachspositionierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Relative single axis positioning",
                    "descript_2": "-"
                }
            },
            "CMD_POWER_ON": {
                "de": {
                    "descript_1": "Achsfreigabe(n) Lageregler",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Axis enable(s), position control",
                    "descript_2": "-"
                }
            },
            "CMD_POWER_OFF": {
                "de": {
                    "descript_1": "Wegnahme der Achsfreigabe(n), Lageregler sperren",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Cancel axis enable(s), disable position control",
                    "descript_2": "-"
                }
            },
            "CMD_HOMING": {
                "de": {
                    "descript_1": "Referenziervorgang starten",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Start referencing",
                    "descript_2": "-"
                }
            },
            "CMD_SET_VELO": {
                "de": {
                    "descript_1": "Setzen der Sollgeschwindigkeit einer Einzelachse",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set the target velocity of a single axis",
                    "descript_2": "-"
                }
            },
            "CMD_SET_ACCEL": {
                "de": {
                    "descript_1": "Setzen der positiven Achsbeschleunigung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set the positive axis acceleration",
                    "descript_2": "-"
                }
            },
            "CMD_SET_DECEL": {
                "de": {
                    "descript_1": "Setzen der negativen Achsbeschleunigung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set the negative axis acceleration",
                    "descript_2": "-"
                }
            },
            "CMD_SET_JERK ": {
                "de": {
                    "descript_1": "Setzen aller Ruckwerte",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set all jerk values",
                    "descript_2": "-"
                }
            },
            "CMD_GEAR_IN_REL": {
                "de": {
                    "descript_1": "Relativer Basisgleichlauf mit sofortiger Aufsynchronisierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Relative basic synchronism with immediate synchronization",
                    "descript_2": "-"
                }
            },
            "CMD_GEAR_OUT": {
                "de": {
                    "descript_1": "Basisgleichlauf deaktivieren mit sofortiger Absynchronisierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Deactivate basic synchronism with immediate desynchronization",
                    "descript_2": "-"
                }
            },
            "CMD_SET_PATH_VELO": {
                "de": {
                    "descript_1": "Setzen der Bahngeschwindigkeit",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set the path velocity",
                    "descript_2": "-"
                }
            },
            "CMD_SET_PATH_ACCEL": {
                "de": {
                    "descript_1": "Setzen der positiven Bahnbeschleunigung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set the positive path acceleration",
                    "descript_2": "-"
                }
            },
            "CMD_SET_PATH_DECEL": {
                "de": {
                    "descript_1": "Setzen der negativen Bahnbeschleunigung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set the negative path acceleration",
                    "descript_2": "-"
                }
            },
            "CMD_SET_PATH_JERK": {
                "de": {
                    "descript_1": "Setzen aller Ruckwerte der Bahn",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set all jerk values of the path",
                    "descript_2": "-"
                }
            },
            "CMD_REDEFINE_POSITION": {
                "de": {
                    "descript_1": "Setzen des Achskoordinatensystem",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set the axis coordinate system",
                    "descript_2": "-"
                }
            },
            "CMD_START_PROGRAM": {
                "de": {
                    "descript_1": "Start des Verfahrprogramms mit der angegebenen Satznummer",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Start motion FAPSDemonstratorAPI with the specified block number",
                    "descript_2": "-"
                }
            },
            "CMD_JUMP_TO_SETNUMBER": {
                "de": {
                    "descript_1": "Unbedingter Sprung innerhalb des Verfahrprogrammes",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Unconditional jump within the motion FAPSDemonstratorAPI",
                    "descript_2": "-"
                }
            },
            "CMD_WAIT_FOR_CONDITION": {
                "de": {
                    "descript_1": "Hält Verfahrprogrammabarbeitung solang an, bis die Bedingung erfüllt ist",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Halt motion FAPSDemonstratorAPI execution until condition is met",
                    "descript_2": "-"
                }
            },
            "CMD_WAIT_FOR_PATH_POSITION": {
                "de": {
                    "descript_1": "Hält Verfahrprogrammabarbeitung solange an, bis Vergleichsbedingung",
                    "descript_2": "der Bahnposition erfüllt ist"
                },
                "en": {
                    "descript_1": "Halt motion FAPSDemonstratorAPI execution until path position condition is met",
                    "descript_2": "-"
                }
            },
            "CMD_WAIT_FOR_AXIS_POSITION": {
                "de": {
                    "descript_1": "Hält Verfahrprogrammabarbeitung solange an, bis Vergleichsbedingung",
                    "descript_2": "der Einzelachsposition erfüllt ist"
                },
                "en": {
                    "descript_1": "Halt motion FAPSDemonstratorAPI execution until axis position condition is met",
                    "descript_2": "-"
                }
            },
            "CMD_WAIT_TIME": {
                "de": {
                    "descript_1": "Wartet mit angegebener Zeit, bevor das nächste Kommando abgearbeitet wird",
                    "descript_2": "Die Zeit wird in tMon vorgegeben"
                },
                "en": {
                    "descript_1": "Wait the specified time before executing the next command",
                    "descript_2": "The time is specified in tMon"
                }
            },
            "CMD_NEXT_STEP": {
                "de": {
                    "descript_1": "Verfahrprogramm wird schrittweise mit aufsteigender Satznummer abgearbeitet",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Execute motion FAPSDemonstratorAPI step by step in ascending order of block numbers",
                    "descript_2": "Each issuing of the command triggers execution of the next FAPSDemonstratorAPI block"
                }
            },
            "CMD_STOP_PROGRAM": {
                "de": {
                    "descript_1": "Stoppt das Verfahrprogramm, bearbeitet aktuellen Satz zu Ende",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Stop motion FAPSDemonstratorAPI, after completing execution of current block",
                    "descript_2": "-"
                }
            },
            "CMD_CONTINUE_PROGRAM": {
                "de": {
                    "descript_1": "Setzt das zuvor gestoppte Programm fort ",
                    "descript_2": "(alte Restwege, wenn vorhanden werden zu Ende verfahren)"
                },
                "en": {
                    "descript_1": "Continue previous stopped motion FAPSDemonstratorAPI,",
                    "descript_2": "any distances-to-go are traveled to their end"
                }
            },
            "CMD_POS_ABS_XYZ": {
                "de": {
                    "descript_1": "Absolute kartesische Bahnpositionierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Start absolute path positioning",
                    "descript_2": "-"
                }
            },
            "CMD_POS_REL_XYZ": {
                "de": {
                    "descript_1": "Relative kartesische Bahnpositionierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Start relative path positioning",
                    "descript_2": "-"
                }
            },
            "CMD_POS_SEG_ABS": {
                "de": {
                    "descript_1": "Start der Segmentpositionierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Start segment positioning",
                    "descript_2": "-"
                }
            },
            "CMD_CAM_IN_ABS": {
                "de": {
                    "descript_1": "Absoluter Basiskurvengleichlauf mit sofortiger Aufsynchronisierung",
                    "descript_2": "Kurve steht in der jeweiligen Technologie-Achsstrukur unter sAx[..]. toCam"
                },
                "en": {
                    "descript_1": "Absolute basic cam synchronism with immediate synchronization",
                    "descript_2": "Cam in the corresponding technology axis structure under sAx[..] toCam"
                }
            },
            "CMD_CAM_OUT ": {
                "de": {
                    "descript_1": "Basiskurvengleichlauf deaktivieren mit sofortiger Absynchronisierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Deactivate basic cam synchronism with immediate desynchronization",
                    "descript_2": "-"
                }
            },
            "CMD_GEAR_IN_ABS": {
                "de": {
                    "descript_1": "Absoluter Basisgleichlauf mit sofortiger Aufsynchronisierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Absolute basic synchronism with immediate synchronization",
                    "descript_2": "-"
                }
            },
            "CMD_PATH_STOP": {
                "de": {
                    "descript_1": "Stoppen des Bahnobjekts unter Beachtung der aktuellen Bahndynamiken",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Stop the path object, taking into account the current dynamic",
                    "descript_2": "properties of the path"
                }
            },
            "CMD_SET_PATH_DELTA": {
                "de": {
                    "descript_1": "Vorgabe der Bahnauflösung für dynamische Kollisionskontrolle bei",
                    "descript_2": "der Segmenterstellung (Defaultwert 2mm)"
                },
                "en": {
                    "descript_1": "Define the path resolution for dynamic collision monitoring when",
                    "descript_2": "calculating a segment (default value 2 mm)"
                }
            },
            "CMD_GEAR_IN_REL_SUPERIMPOSED": {
                "de": {
                    "descript_1": "Relativer überlagerter Gleichlauf mit sofortiger Aufsynchronisierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Relative superimpsed synchronism with immediate synchronization",
                    "descript_2": "-"
                }
            },
            "CMD_GEAR_IN_ABS_SUPERIMPOSED": {
                "de": {
                    "descript_1": "Absoluter überlagerter Gleichlauf mit sofortiger Aufsynchronisierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Absolute superimposed synchronism with immediate synchronization",
                    "descript_2": "-"
                }
            },
            "CMD_GEAR_OUT_SUPERIMPOSED": {
                "de": {
                    "descript_1": "Überlagerten Gleichlauf deaktivieren mit sofortiger Absynchronisierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Deactivate superimposed synchronism with immediate desynchronization",
                    "descript_2": "-"
                }
            },
            "CMD_CAM_IN_ABS_SUPERIMPOSED": {
                "de": {
                    "descript_1": "Absoluter überlagerter Kurvengleichlauf mit sofortiger Aufsynchronisierung",
                    "descript_2": "Kurve steht in der jeweiligen Technologie-Achsstrukur unter sAx[..]. toCam"
                },
                "en": {
                    "descript_1": "Absolute superimposed cam synchronism with immediate synchronization",
                    "descript_2": "Cam in the corresponding technology axis structure under sAx[..] toCam"
                }
            },
            "CMD_CAM_OUT_SUPERIMPOSED": {
                "de": {
                    "descript_1": "Überlagerten Kurvengleichlauf deaktivieren mit sofortiger Absynchronisierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Deactivate superimposed cam synchronism with immediate desynchronization",
                    "descript_2": "-"
                }
            },
            "CMD_WAIT_FOR_AXIS_CLAMPED": {
                "de": {
                    "descript_1": "Warte bis Achse geklemmt ist",
                    "descript_2": "CMD_EN_MOVE_TO_END_STOP"
                },
                "en": {
                    "descript_1": "Wait until axis is clamped",
                    "descript_2": "CMD_EN_MOVE_TO_END_STOP"
                }
            },
            "CMD_WAIT_FOR_AXIS_OPERATING_AT_TORQUE_LIMIT": {
                "de": {
                    "descript_1": "Warte bis Achse an der Drehmomentgrenze betrieben wird",
                    "descript_2": "CMD_EN_TORQUE_LIMITING"
                },
                "en": {
                    "descript_1": "Wait until axis is operated at the torque limit",
                    "descript_2": "CMD_EN_TORQUE_LIMITING"
                }
            },
            "CMD_JMP": {
                "de": {
                    "descript_1": "Bedingter Sprung innerhalb des Verfahrprogrammes",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Conditional jump within the motion FAPSDemonstratorAPI",
                    "descript_2": "-"
                }
            },
            "CMD_JMPN": {
                "de": {
                    "descript_1": "Unbedingter Sprung innerhalb des Verfahrprogrammes",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Conditional jump within the motion FAPSDemonstratorAPI",
                    "descript_2": "-"
                }
            },
            "CMD_INTERRUPT_PROGRAM": {
                "de": {
                    "descript_1": "Stoppt das Verfahrprogramm, bricht alle Bewegungen ab wobei Restwege",
                    "descript_2": "erhalten werden"
                },
                "en": {
                    "descript_1": "Stop motion FAPSDemonstratorAPI, abort any active motion,",
                    "descript_2": "distances-to-go remain stored"
                }
            },
            "CMD_POS_BASIC_SEGMENT": {
                "de": {
                    "descript_1": "Starte Einfachsegment",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Start basic segment",
                    "descript_2": "-"
                }
            },
            "CMD_WAIT_POS_BASIC_SEG_END": {
                "de": {
                    "descript_1": "Warte bis Positionierung Einfachsegment beendet ist",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Wait until positioning basic segement is finished",
                    "descript_2": "-"
                }
            },
            "CMD_CREATE_SEG_BY_BASIC_SEG": {
                "de": {
                    "descript_1": "Erstelle Segment aus Geometrie des",
                    "descript_2": "Einfachsegments"
                },
                "en": {
                    "descript_1": "Create segment based on the geometry of",
                    "descript_2": "the basic segment"
                }
            },
            "CMD_RESET_RV_RANGE": {
                "de": {
                    "descript_1": "Lösche Bereich des L-REAL Datenfeldes",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Delete range of the L-Real data array",
                    "descript_2": "-"
                }
            },
            "CMD_CALC_VELO_PROFILE": {
                "de": {
                    "descript_1": "Berechnen des Geschwindigkeitsprofils für ein vorhandenes Bahnsegment",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Calculate the velocity profile for an existing path segment",
                    "descript_2": "-"
                }
            },
            "CMD_POS_SEG_START": {
                "de": {
                    "descript_1": "Führt eine lineare Positionierung zum gewählten Punkt innerhalb des",
                    "descript_2": "angegebenen Segments aus"
                },
                "en": {
                    "descript_1": "Execute a linear positioning motion to the selected point",
                    "descript_2": "within the specified segment"
                }
            },
            "CMD_SET_CONDITION": {
                "de": {
                    "descript_1": "Setze boolesche Bedingung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set boolean condition",
                    "descript_2": "-"
                }
            },
            "CMD_SET_RV ": {
                "de": {
                    "descript_1": "Setze LREAL-Wert",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set LREAL-value",
                    "descript_2": "-"
                }
            },
            "CMD_INTERRUPT_MOTION": {
                "de": {
                    "descript_1": "Unterbricht aktuell laufende Achsbewegungen, wobei die Restwege",
                    "descript_2": "erhalten bleiben"
                },
                "en": {
                    "descript_1": "Stop currently running axis motion, distances-to-go remain stored",
                    "descript_2": "-"
                }
            },
            "CMD_CONTINUE_MOTION": {
                "de": {
                    "descript_1": "Setzt Achsbewegungen fort, Restwege werden abgefahren",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Continue axis motions, remaining distances-to-go are completed",
                    "descript_2": "-"
                }
            },
            "CMD_PATH_INTERRUPT": {
                "de": {
                    "descript_1": "Unterbricht eine aktuell laufende Bahnbewegung, wobei der Restweg",
                    "descript_2": "erhalten bleibt"
                },
                "en": {
                    "descript_1": "Stop the currently running path motion,",
                    "descript_2": "distance-to-go remains stored"
                }
            },
            "CMD_PATH_CONTINUE": {
                "de": {
                    "descript_1": "Setzt eine aktuell laufende Bahnbewegung fort, der Restweg wird zu",
                    "descript_2": "Ende verfahren"
                },
                "en": {
                    "descript_1": "Continue movement of the path axis,",
                    "descript_2": "the remaining distance-to-go is completed"
                }
            },
            "CMD_CALC_PROFILE_TIME": {
                "de": {
                    "descript_1": "Berechnen der Zeit, die für das Abfahren eines Geschwindigkeitsprofils",
                    "descript_2": "benötigt wird"
                },
                "en": {
                    "descript_1": "Calculate the time required to travel a velocity profile",
                    "descript_2": "Time is saved (in ms) in the segment.sVeloProfile.rCalcTime variable"
                }
            },
            "CMD_POS_TO_LIMIT": {
                "de": {
                    "descript_1": "Positioniert so weit wie möglich zum Zonenrand unter Vermeidung von",
                    "descript_2": "Kollisionen und unter Beachtung des angegebenen Sicherheitsabstands"
                },
                "en": {
                    "descript_1": "Position a geometric axis as far as possible in the specified direction",
                    "descript_2": "without causing a collision and maintaining the specified safety clearance to "
                                  "the zone edge."
                }
            },
            "CMD_STEP_TO_LIMIT": {
                "de": {
                    "descript_1": "Berechnen der Position, bis zu der ohne Kollision in Richtung",
                    "descript_2": "einer GeoAchse positioniert werden kann"
                },
                "en": {
                    "descript_1": "Calculate the maximum position to which a geometric axis can",
                    "descript_2": "be positioned in the specified direction without causing a collision"
                }
            },
            "CMD_SET_ZONES": {
                "de": {
                    "descript_1": "Zonen aktivieren / deaktivieren",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Activate / deactivate zones",
                    "descript_2": "-"
                }
            },
            "CMD_GET_COLL_DETAILS": {
                "de": {
                    "descript_1": "Das Kommando liefert deailierte Kollisionsinformationen zu einer Position.",
                    "descript_2": "Es werden die Bits boCollision der einzelnen aktivierten Zonen gesetzt."
                },
                "en": {
                    "descript_1": "Retrieve detailed collision information for a specified position.",
                    "descript_2": "The boCollision bits of the individual activated zones are set."
                }
            },
            "CMD_CLEAR_COLL_DETAILS": {
                "de": {
                    "descript_1": "Rücksetzen aller Kollisionsbits boCollision sowie der Sammelbits boCollStat",
                    "descript_2": "und boCollDyn in Abhängigkeit von Parameter 1"
                },
                "en": {
                    "descript_1": "Reset all boCollision collision bits, as well as the overall bits boCollStat",
                    "descript_2": "and boCollDyn, in accordance with Parameter 1"
                }
            },
            "CMD_ZONE_CHECK": {
                "de": {
                    "descript_1": "Aktivierung / Deaktivierung der Zonenüberwachung",
                    "descript_2": "für bestimmte Zonentypen"
                },
                "en": {
                    "descript_1": "Activates / deactivates the zone monitoring",
                    "descript_2": "for respective zone types"
                }
            },
            "CMD_POS_SYNC_AX_START": {
                "de": {
                    "descript_1": "Positionierung der Synchronachse zur Sollposition",
                    "descript_2": "am Anfang oder Ende des betreffenden Segments"
                },
                "en": {
                    "descript_1": "Positioning of the synchronous axis to the set position",
                    "descript_2": "at the begin or end of the respective segment"
                }
            },
            "CMD_WAIT_POS_SEG_END": {
                "de": {
                    "descript_1": "Warten auf das Erreichen des Segmentendes beim Abfahren des",
                    "descript_2": "aktuellen Segments"
                },
                "en": {
                    "descript_1": "Wait until the segment end is reached when traveling the current segment",
                    "descript_2": "-"
                }
            },
            "CMD_EMERGENCY_ON": {
                "de": {
                    "descript_1": "Not-Halt Sequenz",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Emergency stop sequence",
                    "descript_2": "-"
                }
            },
            "CMD_CREATE_SEG": {
                "de": {
                    "descript_1": "Berechnung des angegebenen Segments",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Calculate the specified segment",
                    "descript_2": "-"
                }
            },
            "CMD_CREATE_FOL_SEG": {
                "de": {
                    "descript_1": "Berechnung eines Folgesegments anhand eines Quellsegments zum fliegenden",
                    "descript_2": "Segmentwechsel mittels des Kommandos CMD_POS_FOL_SEG"
                },
                "en": {
                    "descript_1": "Calculate the following segment on the basis of a source segment,",
                    "descript_2": "for on-the-fly segment switching by way of the CMD_POS_FOL_SEG command"
                }
            },
            "CMD_POS_FOL_SEG": {
                "de": {
                    "descript_1": "Ablösendes Positionieren des Folgesegments",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Substitutional positioning of the following segment",
                    "descript_2": "-"
                }
            },
            "CMD_SET_CAM": {
                "de": {
                    "descript_1": "Setze TO-Kurvenscheibe während des Betriebs",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Set To cam disk during operation",
                    "descript_2": "-"
                }
            },
            "CMD_SWITCH_CS": {
                "de": {
                    "descript_1": "Dieses Kommando initiiert einen Wechsel des Koordinatensystems",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Initiates switching of the coordinate system",
                    "descript_2": "-"
                }
            },
            "CMD_CREATE_POLY": {
                "de": {
                    "descript_1": "-",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "-",
                    "descript_2": "-"
                }
            },
            "CMD_ENABLE_TRACKING": {
                "de": {
                    "descript_1": "Mit diesem Kommando wird der eigentliche Aufsynchronisiervorgang bei",
                    "descript_2": "einem Wechsel in ein OCS mit veränderlichem Leitwert eingeleitet"
                },
                "en": {
                    "descript_1": "Initiates the actual process of synchronization when switching to",
                    "descript_2": "an OCS with variable master value"
                }
            },
            "CMD_CLONE_SEG": {
                "de": {
                    "descript_1": "Das Kommando kopiert ein Segment in ein Zielsegment und kann zum Erzeugen",
                    "descript_2": "von mehreren Stapelsegmenten verwendet werden"
                },
                "en": {
                    "descript_1": "The command copies a segment into a target segment and can be used to generate",
                    "descript_2": "stacking segments"
                }
            },
            "CMD_SET_STACK": {
                "de": {
                    "descript_1": "Das Kommando setzt die Anzahl von Lagenoffsets (relative Stapelhöhe) an Anfang",
                    "descript_2": "und am Ende eines Segments"
                },
                "en": {
                    "descript_1": "The command sets the number of layer offsets /relative stacking height)",
                    "descript_2": "at the start and at the end of a segment"
                }
            },
            "CMD_INC_STACK": {
                "de": {
                    "descript_1": "Das Kommando erhöht bzw. verringert die relative Stapelhöhe am Anfang",
                    "descript_2": "und am Ende eines Segments"
                },
                "en": {
                    "descript_1": "The command increases or reduces the number of layers in a stack",
                    "descript_2": "at the start and end of a segment"
                }
            },
            "CMD_EXT_KINTRANS": {
                "de": {
                    "descript_1": "Aktivierung / Deaktivierung der externen (freien) Transformation",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Activates / deactivates the external (free) transformation",
                    "descript_2": "-"
                }
            },
            "CMD_EN_MOVE_TO_END_STOP": {
                "de": {
                    "descript_1": "Aktiviert die Funktion Fahren auf Festanschlag",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Activates the function Move to endstop",
                    "descript_2": "-"
                }
            },
            "CMD_DIS_MOVE_TO_END_STOP": {
                "de": {
                    "descript_1": "Deaktiviert die Funktion Fahren auf Festanschlag",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Deactivates the function Move to endstop",
                    "descript_2": "-"
                }
            },
            "CMD_EN_TORQUE_LIMITING": {
                "de": {
                    "descript_1": "Aktiviert die Momentenreduzierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Activates the torque reduction",
                    "descript_2": "-"
                }
            },
            "CMD_DIS_TORQUE_LIMITING": {
                "de": {
                    "descript_1": "Deaktiviert die Momentenreduzierung",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Deactivates the torque reduction",
                    "descript_2": "-"
                }
            },
            "CMD_CLOSE_GRIPPER": {
                "de": {
                    "descript_1": "Positioniert die Greiferachse auf die angegebene Position",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Positions the gripper axis to the set position",
                    "descript_2": "-"
                }
            },
            "CMD_OPEN_GRIPPER": {
                "de": {
                    "descript_1": "Positioniert die Greiferachse auf die angegebene Position",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Positions the gripper axis to the set position",
                    "descript_2": "-"
                }
            },
            "CMD_SET_MOTION_PROG_STATE": {
                "de": {
                    "descript_1": "Ausgabe des Programmstatus an die Variable",
                    "descript_2": "...FAPSDemonstratorAPI.i32MotionProgramState"
                },
                "en": {
                    "descript_1": "Output of the FAPSDemonstratorAPI status at the variable",
                    "descript_2": "...FAPSDemonstratorAPI.i32MotionProgramState"
                }
            },
            "CMD_WRITE_PROGRAM_SET": {
                "de": {
                    "descript_1": "Programmsatz ins Handlingsprogramm überschreiben",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Overwrite FAPSDemonstratorAPI block into handling FAPSDemonstratorAPI",
                    "descript_2": "-"
                }
            },
            "CMD_READ_PROGRAM_SET": {
                "de": {
                    "descript_1": "Programmsatz aus Handlingsprogramm lesen",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Read FAPSDemonstratorAPI block from handling FAPSDemonstratorAPI",
                    "descript_2": "-"
                }
            },
            "CMD_DELETE_PROGRAM_SET": {
                "de": {
                    "descript_1": "Programmsatz im Handlingsprogramm löschen",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Delete FAPSDemonstratorAPI block from handling FAPSDemonstratorAPI",
                    "descript_2": "-"
                }
            },
            "CMD_INSERT_PROGRAM_SET": {
                "de": {
                    "descript_1": "Programmsatz ins Handlingsprogramm einfügen",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Insert FAPSDemonstratorAPI block into handling FAPSDemonstratorAPI",
                    "descript_2": "-"
                }
            },
            "CMD_WRITE_POINT": {
                "de": {
                    "descript_1": "Punkt in Segmenttabeelle überschreiben",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Overwrite point into segment table",
                    "descript_2": "-"
                }
            },
            "CMD_READ_POINT": {
                "de": {
                    "descript_1": "Punkt aus Segmenttabeelle lesen",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Read point from segment table",
                    "descript_2": "-"
                }
            },
            "CMD_DELETE_POINT": {
                "de": {
                    "descript_1": "Punkt in Segmenttabeelle löschen",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Delete point from segment table",
                    "descript_2": "-"
                }
            },
            "CMD_INSERT_POINT": {
                "de": {
                    "descript_1": "Punkt in Segmenttabeelle einfügen",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Insert point into segment table",
                    "descript_2": "-"
                }
            },
            "CMD_SAVE_DATASET": {
                "de": {
                    "descript_1": "Handlingsprogramm und Segmenttabellen auf Memory Card löschen",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Save handling FAPSDemonstratorAPI and segment tables on the memory card",
                    "descript_2": "-"
                }
            },
            "CMD_LOAD_DATASET": {
                "de": {
                    "descript_1": "Handlingsprogramm und Segmenttabellen von der Memory Card laden",
                    "descript_2": "-"
                },
                "en": {
                    "descript_1": "Load handling FAPSDemonstratorAPI and segment tables from the memory card",
                    "descript_2": "-"
                }
            },
            "CMD_CLUTCH_CS": {
                "de": {
                    "descript_1": "Ein vorbereitetes CS wird direkt eingekoppelt. Ist im neuen CS",
                    "descript_2": "eine Bewegung aktiv, erfolgt ein Stop im neuen CS"
                },
                "en": {
                    "descript_1": "A prepared CS is directly switched to. Is a motion in the new CS",
                    "descript_2": "active, a stop is excecuted in the new CS"
                }
            },
            "CMD_SET_TRACKING_SHIFT": {
                "de": {
                    "descript_1": "Setzt den Offset (rTrackingShift) eines bewegten OCS zu",
                    "descript_2": "dessen konfigurierter Basislage"
                },
                "en": {
                    "descript_1": "Sets the offset (rTrackingShift) of a moving OCS respective to",
                    "descript_2": "its configured base position"
                }
            },
            "CMD_OUTPUT_CAM": {
                "de": {
                    "descript_1": "Dieses Kommando schaltet die Bearbeitung der Nockenfunktionalität",
                    "descript_2": "ein oder aus"
                },
                "en": {
                    "descript_1": "This command enables and disables the execution of",
                    "descript_2": "the output cam functionality"
                }
            },
            "CMD_OUTPUT_CAM_STATE": {
                "de": {
                    "descript_1": "Mit diesem Kommando lässt sich der Ausgang eines einzelnen Nocken",
                    "descript_2": "oder aller vorhandenen Nocken ein- / ausschalten"
                },
                "en": {
                    "descript_1": "This command sets or resets the state of one single output cam",
                    "descript_2": "or of all implemented output cams"
                }
            },
            "CMD_CAM_IN_REL": {
                "de": {
                    "descript_1": "Das Kommando startet einen relativen Basis-Kurvenscheiben-",
                    "descript_2": "gleichlauf"
                },
                "en": {
                    "descript_1": "The Command starts a relative basic camming",
                    "descript_2": "-"
                }
            },
            "CMD_CAM_IN_REL_SUPERIMPOSED": {
                "de": {
                    "descript_1": "Das Kommando startet einen relativen überlagerten Kurvenscheiben-",
                    "descript_2": "gleichlauf"
                },
                "en": {
                    "descript_1": "The Command starts a relative superimposed camming",
                    "descript_2": "-"
                }
            },
            "CMD_GEAR_IN_VELO": {
                "de": {
                    "descript_1": "Das Kommando startet einen Basis Geschwindigkeits-",
                    "descript_2": "gleichlauf"
                },
                "en": {
                    "descript_1": "The command starts a basic velocity gearing",
                    "descript_2": "-"
                }
            },
            "CMD_GEAR_IN_VELO_SUPERIMPOSED": {
                "de": {
                    "descript_1": "Das Kommando startet einen überlagerten Geschwindigkeits-",
                    "descript_2": "gleichlauf"
                },
                "en": {
                    "descript_1": "The command starts a superimposed velocity gearing",
                    "descript_2": "-"
                }
            },
            "CMD_GEAR_OUT_VELO": {
                "de": {
                    "descript_1": "Das Kommanod deaktiviert einen Basis Geschwindigkeits-",
                    "descript_2": "gleichlauf"
                },
                "en": {
                    "descript_1": "The command deactivates a basic velocity gearing",
                    "descript_2": "-"
                }
            },
            "CMD_GEAR_OUT_VELO_SUPERIMPOSED": {
                "de": {
                    "descript_1": "Das Kommando deaktiviert einen überlagerten Geschwindigkeits-",
                    "descript_2": "gleichlauf"
                },
                "en": {
                    "descript_1": "The command deactivates a superimposed velocity gearing",
                    "descript_2": "-"
                }
            },
            "CMD_CONTINUE_MANUAL": {
                "de": {
                    "descript_1": "Zuvor gesetztes CMD_EMERGENCY_ON wird zurückgenommen",
                    "descript_2": "und der Betrieb fortgesetzt"
                },
                "en": {
                    "descript_1": "Disables a previously set CMD_EMERGENCY_ON",
                    "descript_2": "and continues the motion"
                }
            }
        }
        return "" + descriptions[self.name][language]["descript_1"] + descriptions[self.name][language]["descript_2"]
