"""init

Revision ID: ddebc53e7879
Revises: 
Create Date: 2023-12-15 21:57:46.846203

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = 'ddebc53e7879'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('rosemary_tasks',
    sa.Column('id', sa.BIGINT(), autoincrement=True, nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('data', sa.JSON(), nullable=True),
    sa.Column('type_task', sa.Enum('REPEATABLE', 'CRON', 'MANUAL', 'NOT_SETUP', name='typetaskrosemary'), nullable=False),
    sa.Column('status', sa.Enum('NEW', 'IN_PROGRESS', 'FAILED', 'FATAL', 'CANCELED', 'FINISHED', name='statustaskrosemary'), nullable=False),
    sa.Column('retry', sa.Integer(), nullable=False),
    sa.Column('max_retry', sa.Integer(), nullable=False),
    sa.Column('error', sa.String(), nullable=True),
    sa.Column('task_return', sa.String(), nullable=True),
    sa.Column('worker', sa.UUID(), nullable=True),
    sa.Column('timeout', sa.Integer(), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_rosemary_tasks_id'), 'rosemary_tasks', ['id'], unique=False)
    op.create_table('rosemary_worker',
    sa.Column('id', sa.BIGINT(), autoincrement=True, nullable=False),
    sa.Column('uuid', sa.UUID(), nullable=False),
    sa.Column('status', sa.Enum('WORKING', 'KILLED', 'CHECKING', name='statusworkerrosemary'), nullable=False),
    sa.Column('ping_time', sa.DateTime(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('uuid')
    )
    op.create_index(op.f('ix_rosemary_worker_id'), 'rosemary_worker', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_rosemary_worker_id'), table_name='rosemary_worker')
    op.drop_table('rosemary_worker')
    op.drop_index(op.f('ix_rosemary_tasks_id'), table_name='rosemary_tasks')
    op.drop_table('rosemary_tasks')
    # ### end Alembic commands ###
