import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermAutomationVariableStringConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string.html#automation_account_name DataAzurermAutomationVariableString#automation_account_name}.
     *
     * @stability stable
     */
    readonly automationAccountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string.html#name DataAzurermAutomationVariableString#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string.html#resource_group_name DataAzurermAutomationVariableString#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string.html#timeouts DataAzurermAutomationVariableString#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermAutomationVariableStringTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermAutomationVariableStringTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string.html#read DataAzurermAutomationVariableString#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermAutomationVariableStringTimeoutsToTerraform(struct?: DataAzurermAutomationVariableStringTimeoutsOutputReference | DataAzurermAutomationVariableStringTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermAutomationVariableStringTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermAutomationVariableStringTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermAutomationVariableStringTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string.html azurerm_automation_variable_string}.
 *
 * @stability stable
 */
export declare class DataAzurermAutomationVariableString extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/automation_variable_string.html azurerm_automation_variable_string} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermAutomationVariableStringConfig);
    private _automationAccountName?;
    /**
     * @stability stable
     */
    get automationAccountName(): string;
    /**
     * @stability stable
     */
    set automationAccountName(value: string);
    /**
     * @stability stable
     */
    get automationAccountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get encrypted(): any;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get value(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermAutomationVariableStringTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermAutomationVariableStringTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermAutomationVariableStringTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
