import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault.html#name DataAzurermKeyVault#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault.html#resource_group_name DataAzurermKeyVault#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault.html#timeouts DataAzurermKeyVault#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermKeyVaultTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultAccessPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get applicationId(): string;
    /**
     * @stability stable
     */
    get certificatePermissions(): string[];
    /**
     * @stability stable
     */
    get keyPermissions(): string[];
    /**
     * @stability stable
     */
    get objectId(): string;
    /**
     * @stability stable
     */
    get secretPermissions(): string[];
    /**
     * @stability stable
     */
    get storagePermissions(): string[];
    /**
     * @stability stable
     */
    get tenantId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultNetworkAcls extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get bypass(): string;
    /**
     * @stability stable
     */
    get defaultAction(): string;
    /**
     * @stability stable
     */
    get ipRules(): string[];
    /**
     * @stability stable
     */
    get virtualNetworkSubnetIds(): string[];
}
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault.html#read DataAzurermKeyVault#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultTimeoutsToTerraform(struct?: DataAzurermKeyVaultTimeoutsOutputReference | DataAzurermKeyVaultTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermKeyVaultTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermKeyVaultTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault.html azurerm_key_vault}.
 *
 * @stability stable
 */
export declare class DataAzurermKeyVault extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault.html azurerm_key_vault} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultConfig);
    /**
     * @stability stable
     */
    accessPolicy(index: string): DataAzurermKeyVaultAccessPolicy;
    /**
     * @stability stable
     */
    get enableRbacAuthorization(): any;
    /**
     * @stability stable
     */
    get enabledForDeployment(): any;
    /**
     * @stability stable
     */
    get enabledForDiskEncryption(): any;
    /**
     * @stability stable
     */
    get enabledForTemplateDeployment(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    networkAcls(index: string): DataAzurermKeyVaultNetworkAcls;
    /**
     * @stability stable
     */
    get purgeProtectionEnabled(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    get softDeleteEnabled(): any;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get vaultUri(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermKeyVaultTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermKeyVaultTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermKeyVaultTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
