import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermMonitorLogProfileConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile.html#name DataAzurermMonitorLogProfile#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile.html#timeouts DataAzurermMonitorLogProfile#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermMonitorLogProfileTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermMonitorLogProfileRetentionPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get days(): number;
    /**
     * @stability stable
     */
    get enabled(): any;
}
/**
 * @stability stable
 */
export interface DataAzurermMonitorLogProfileTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile.html#read DataAzurermMonitorLogProfile#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermMonitorLogProfileTimeoutsToTerraform(struct?: DataAzurermMonitorLogProfileTimeoutsOutputReference | DataAzurermMonitorLogProfileTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermMonitorLogProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermMonitorLogProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermMonitorLogProfileTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile.html azurerm_monitor_log_profile}.
 *
 * @stability stable
 */
export declare class DataAzurermMonitorLogProfile extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_log_profile.html azurerm_monitor_log_profile} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorLogProfileConfig);
    /**
     * @stability stable
     */
    get categories(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get locations(): string[];
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    retentionPolicy(index: string): DataAzurermMonitorLogProfileRetentionPolicy;
    /**
     * @stability stable
     */
    get servicebusRuleId(): string;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermMonitorLogProfileTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermMonitorLogProfileTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermMonitorLogProfileTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
