import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermPolicyVirtualMachineConfigurationAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_virtual_machine_configuration_assignment.html#name DataAzurermPolicyVirtualMachineConfigurationAssignment#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_virtual_machine_configuration_assignment.html#resource_group_name DataAzurermPolicyVirtualMachineConfigurationAssignment#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_virtual_machine_configuration_assignment.html#virtual_machine_name DataAzurermPolicyVirtualMachineConfigurationAssignment#virtual_machine_name}.
     *
     * @stability stable
     */
    readonly virtualMachineName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_virtual_machine_configuration_assignment.html#timeouts DataAzurermPolicyVirtualMachineConfigurationAssignment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_virtual_machine_configuration_assignment.html#read DataAzurermPolicyVirtualMachineConfigurationAssignment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermPolicyVirtualMachineConfigurationAssignmentTimeoutsToTerraform(struct?: DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeoutsOutputReference | DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/policy_virtual_machine_configuration_assignment.html azurerm_policy_virtual_machine_configuration_assignment}.
 *
 * @stability stable
 */
export declare class DataAzurermPolicyVirtualMachineConfigurationAssignment extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/policy_virtual_machine_configuration_assignment.html azurerm_policy_virtual_machine_configuration_assignment} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermPolicyVirtualMachineConfigurationAssignmentConfig);
    /**
     * @stability stable
     */
    get assignmentHash(): string;
    /**
     * @stability stable
     */
    get complianceStatus(): string;
    /**
     * @stability stable
     */
    get contentHash(): string;
    /**
     * @stability stable
     */
    get contentUri(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastComplianceStatusChecked(): string;
    /**
     * @stability stable
     */
    get latestReportId(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _virtualMachineName?;
    /**
     * @stability stable
     */
    get virtualMachineName(): string;
    /**
     * @stability stable
     */
    set virtualMachineName(value: string);
    /**
     * @stability stable
     */
    get virtualMachineNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermPolicyVirtualMachineConfigurationAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
