import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermVirtualNetworkGatewayConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection.html#name DataAzurermVirtualNetworkGatewayConnection#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection.html#resource_group_name DataAzurermVirtualNetworkGatewayConnection#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection.html#timeouts DataAzurermVirtualNetworkGatewayConnection#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermVirtualNetworkGatewayConnectionTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayConnectionIpsecPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dhGroup(): string;
    /**
     * @stability stable
     */
    get ikeEncryption(): string;
    /**
     * @stability stable
     */
    get ikeIntegrity(): string;
    /**
     * @stability stable
     */
    get ipsecEncryption(): string;
    /**
     * @stability stable
     */
    get ipsecIntegrity(): string;
    /**
     * @stability stable
     */
    get pfsGroup(): string;
    /**
     * @stability stable
     */
    get saDatasize(): number;
    /**
     * @stability stable
     */
    get saLifetime(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get localAddressCidrs(): string[];
    /**
     * @stability stable
     */
    get remoteAddressCidrs(): string[];
}
/**
 * @stability stable
 */
export interface DataAzurermVirtualNetworkGatewayConnectionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection.html#read DataAzurermVirtualNetworkGatewayConnection#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermVirtualNetworkGatewayConnectionTimeoutsToTerraform(struct?: DataAzurermVirtualNetworkGatewayConnectionTimeoutsOutputReference | DataAzurermVirtualNetworkGatewayConnectionTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermVirtualNetworkGatewayConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermVirtualNetworkGatewayConnectionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection.html azurerm_virtual_network_gateway_connection}.
 *
 * @stability stable
 */
export declare class DataAzurermVirtualNetworkGatewayConnection extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_network_gateway_connection.html azurerm_virtual_network_gateway_connection} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualNetworkGatewayConnectionConfig);
    /**
     * @stability stable
     */
    get authorizationKey(): string;
    /**
     * @stability stable
     */
    get connectionProtocol(): string;
    /**
     * @stability stable
     */
    get dpdTimeoutSeconds(): number;
    /**
     * @stability stable
     */
    get egressBytesTransferred(): number;
    /**
     * @stability stable
     */
    get enableBgp(): any;
    /**
     * @stability stable
     */
    get expressRouteCircuitId(): string;
    /**
     * @stability stable
     */
    get expressRouteGatewayBypass(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ingressBytesTransferred(): number;
    /**
     * @stability stable
     */
    ipsecPolicy(index: string): DataAzurermVirtualNetworkGatewayConnectionIpsecPolicy;
    /**
     * @stability stable
     */
    get localAzureIpAddressEnabled(): any;
    /**
     * @stability stable
     */
    get localNetworkGatewayId(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get peerVirtualNetworkGatewayId(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get resourceGuid(): string;
    /**
     * @stability stable
     */
    get routingWeight(): number;
    /**
     * @stability stable
     */
    get sharedKey(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    trafficSelectorPolicy(index: string): DataAzurermVirtualNetworkGatewayConnectionTrafficSelectorPolicy;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    get usePolicyBasedTrafficSelectors(): any;
    /**
     * @stability stable
     */
    get virtualNetworkGatewayId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermVirtualNetworkGatewayConnectionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermVirtualNetworkGatewayConnectionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermVirtualNetworkGatewayConnectionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
