import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureDatabricksConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#access_token DataFactoryLinkedServiceAzureDatabricks#access_token}.
     *
     * @stability stable
     */
    readonly accessToken?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#adb_domain DataFactoryLinkedServiceAzureDatabricks#adb_domain}.
     *
     * @stability stable
     */
    readonly adbDomain: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#additional_properties DataFactoryLinkedServiceAzureDatabricks#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#annotations DataFactoryLinkedServiceAzureDatabricks#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#data_factory_id DataFactoryLinkedServiceAzureDatabricks#data_factory_id}.
     *
     * @stability stable
     */
    readonly dataFactoryId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#data_factory_name DataFactoryLinkedServiceAzureDatabricks#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#description DataFactoryLinkedServiceAzureDatabricks#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#existing_cluster_id DataFactoryLinkedServiceAzureDatabricks#existing_cluster_id}.
     *
     * @stability stable
     */
    readonly existingClusterId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#integration_runtime_name DataFactoryLinkedServiceAzureDatabricks#integration_runtime_name}.
     *
     * @stability stable
     */
    readonly integrationRuntimeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#msi_work_space_resource_id DataFactoryLinkedServiceAzureDatabricks#msi_work_space_resource_id}.
     *
     * @stability stable
     */
    readonly msiWorkSpaceResourceId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#name DataFactoryLinkedServiceAzureDatabricks#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#parameters DataFactoryLinkedServiceAzureDatabricks#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#resource_group_name DataFactoryLinkedServiceAzureDatabricks#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * instance_pool block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#instance_pool DataFactoryLinkedServiceAzureDatabricks#instance_pool}
     *
     * @stability stable
     */
    readonly instancePool?: DataFactoryLinkedServiceAzureDatabricksInstancePool;
    /**
     * key_vault_password block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#key_vault_password DataFactoryLinkedServiceAzureDatabricks#key_vault_password}
     *
     * @stability stable
     */
    readonly keyVaultPassword?: DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword;
    /**
     * new_cluster_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#new_cluster_config DataFactoryLinkedServiceAzureDatabricks#new_cluster_config}
     *
     * @stability stable
     */
    readonly newClusterConfig?: DataFactoryLinkedServiceAzureDatabricksNewClusterConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#timeouts DataFactoryLinkedServiceAzureDatabricks#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryLinkedServiceAzureDatabricksTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureDatabricksInstancePool {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#cluster_version DataFactoryLinkedServiceAzureDatabricks#cluster_version}.
     *
     * @stability stable
     */
    readonly clusterVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#instance_pool_id DataFactoryLinkedServiceAzureDatabricks#instance_pool_id}.
     *
     * @stability stable
     */
    readonly instancePoolId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#max_number_of_workers DataFactoryLinkedServiceAzureDatabricks#max_number_of_workers}.
     *
     * @stability stable
     */
    readonly maxNumberOfWorkers?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#min_number_of_workers DataFactoryLinkedServiceAzureDatabricks#min_number_of_workers}.
     *
     * @stability stable
     */
    readonly minNumberOfWorkers?: number;
}
export declare function dataFactoryLinkedServiceAzureDatabricksInstancePoolToTerraform(struct?: DataFactoryLinkedServiceAzureDatabricksInstancePoolOutputReference | DataFactoryLinkedServiceAzureDatabricksInstancePool): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureDatabricksInstancePoolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceAzureDatabricksInstancePool | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceAzureDatabricksInstancePool | undefined);
    private _clusterVersion?;
    /**
     * @stability stable
     */
    get clusterVersion(): string;
    /**
     * @stability stable
     */
    set clusterVersion(value: string);
    /**
     * @stability stable
     */
    get clusterVersionInput(): string | undefined;
    private _instancePoolId?;
    /**
     * @stability stable
     */
    get instancePoolId(): string;
    /**
     * @stability stable
     */
    set instancePoolId(value: string);
    /**
     * @stability stable
     */
    get instancePoolIdInput(): string | undefined;
    private _maxNumberOfWorkers?;
    /**
     * @stability stable
     */
    get maxNumberOfWorkers(): number;
    /**
     * @stability stable
     */
    set maxNumberOfWorkers(value: number);
    /**
     * @stability stable
     */
    resetMaxNumberOfWorkers(): void;
    /**
     * @stability stable
     */
    get maxNumberOfWorkersInput(): number | undefined;
    private _minNumberOfWorkers?;
    /**
     * @stability stable
     */
    get minNumberOfWorkers(): number;
    /**
     * @stability stable
     */
    set minNumberOfWorkers(value: number);
    /**
     * @stability stable
     */
    resetMinNumberOfWorkers(): void;
    /**
     * @stability stable
     */
    get minNumberOfWorkersInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#linked_service_name DataFactoryLinkedServiceAzureDatabricks#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#secret_name DataFactoryLinkedServiceAzureDatabricks#secret_name}.
     *
     * @stability stable
     */
    readonly secretName: string;
}
export declare function dataFactoryLinkedServiceAzureDatabricksKeyVaultPasswordToTerraform(struct?: DataFactoryLinkedServiceAzureDatabricksKeyVaultPasswordOutputReference | DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureDatabricksKeyVaultPasswordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword | undefined);
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _secretName?;
    /**
     * @stability stable
     */
    get secretName(): string;
    /**
     * @stability stable
     */
    set secretName(value: string);
    /**
     * @stability stable
     */
    get secretNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureDatabricksNewClusterConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#cluster_version DataFactoryLinkedServiceAzureDatabricks#cluster_version}.
     *
     * @stability stable
     */
    readonly clusterVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#custom_tags DataFactoryLinkedServiceAzureDatabricks#custom_tags}.
     *
     * @stability stable
     */
    readonly customTags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#driver_node_type DataFactoryLinkedServiceAzureDatabricks#driver_node_type}.
     *
     * @stability stable
     */
    readonly driverNodeType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#init_scripts DataFactoryLinkedServiceAzureDatabricks#init_scripts}.
     *
     * @stability stable
     */
    readonly initScripts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#log_destination DataFactoryLinkedServiceAzureDatabricks#log_destination}.
     *
     * @stability stable
     */
    readonly logDestination?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#max_number_of_workers DataFactoryLinkedServiceAzureDatabricks#max_number_of_workers}.
     *
     * @stability stable
     */
    readonly maxNumberOfWorkers?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#min_number_of_workers DataFactoryLinkedServiceAzureDatabricks#min_number_of_workers}.
     *
     * @stability stable
     */
    readonly minNumberOfWorkers?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#node_type DataFactoryLinkedServiceAzureDatabricks#node_type}.
     *
     * @stability stable
     */
    readonly nodeType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#spark_config DataFactoryLinkedServiceAzureDatabricks#spark_config}.
     *
     * @stability stable
     */
    readonly sparkConfig?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#spark_environment_variables DataFactoryLinkedServiceAzureDatabricks#spark_environment_variables}.
     *
     * @stability stable
     */
    readonly sparkEnvironmentVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
}
export declare function dataFactoryLinkedServiceAzureDatabricksNewClusterConfigToTerraform(struct?: DataFactoryLinkedServiceAzureDatabricksNewClusterConfigOutputReference | DataFactoryLinkedServiceAzureDatabricksNewClusterConfig): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureDatabricksNewClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceAzureDatabricksNewClusterConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceAzureDatabricksNewClusterConfig | undefined);
    private _clusterVersion?;
    /**
     * @stability stable
     */
    get clusterVersion(): string;
    /**
     * @stability stable
     */
    set clusterVersion(value: string);
    /**
     * @stability stable
     */
    get clusterVersionInput(): string | undefined;
    private _customTags?;
    /**
     * @stability stable
     */
    get customTags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set customTags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCustomTags(): void;
    /**
     * @stability stable
     */
    get customTagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _driverNodeType?;
    /**
     * @stability stable
     */
    get driverNodeType(): string;
    /**
     * @stability stable
     */
    set driverNodeType(value: string);
    /**
     * @stability stable
     */
    resetDriverNodeType(): void;
    /**
     * @stability stable
     */
    get driverNodeTypeInput(): string | undefined;
    private _initScripts?;
    /**
     * @stability stable
     */
    get initScripts(): string[];
    /**
     * @stability stable
     */
    set initScripts(value: string[]);
    /**
     * @stability stable
     */
    resetInitScripts(): void;
    /**
     * @stability stable
     */
    get initScriptsInput(): string[] | undefined;
    private _logDestination?;
    /**
     * @stability stable
     */
    get logDestination(): string;
    /**
     * @stability stable
     */
    set logDestination(value: string);
    /**
     * @stability stable
     */
    resetLogDestination(): void;
    /**
     * @stability stable
     */
    get logDestinationInput(): string | undefined;
    private _maxNumberOfWorkers?;
    /**
     * @stability stable
     */
    get maxNumberOfWorkers(): number;
    /**
     * @stability stable
     */
    set maxNumberOfWorkers(value: number);
    /**
     * @stability stable
     */
    resetMaxNumberOfWorkers(): void;
    /**
     * @stability stable
     */
    get maxNumberOfWorkersInput(): number | undefined;
    private _minNumberOfWorkers?;
    /**
     * @stability stable
     */
    get minNumberOfWorkers(): number;
    /**
     * @stability stable
     */
    set minNumberOfWorkers(value: number);
    /**
     * @stability stable
     */
    resetMinNumberOfWorkers(): void;
    /**
     * @stability stable
     */
    get minNumberOfWorkersInput(): number | undefined;
    private _nodeType?;
    /**
     * @stability stable
     */
    get nodeType(): string;
    /**
     * @stability stable
     */
    set nodeType(value: string);
    /**
     * @stability stable
     */
    get nodeTypeInput(): string | undefined;
    private _sparkConfig?;
    /**
     * @stability stable
     */
    get sparkConfig(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sparkConfig(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSparkConfig(): void;
    /**
     * @stability stable
     */
    get sparkConfigInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _sparkEnvironmentVariables?;
    /**
     * @stability stable
     */
    get sparkEnvironmentVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sparkEnvironmentVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSparkEnvironmentVariables(): void;
    /**
     * @stability stable
     */
    get sparkEnvironmentVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureDatabricksTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#create DataFactoryLinkedServiceAzureDatabricks#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#delete DataFactoryLinkedServiceAzureDatabricks#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#read DataFactoryLinkedServiceAzureDatabricks#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html#update DataFactoryLinkedServiceAzureDatabricks#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryLinkedServiceAzureDatabricksTimeoutsToTerraform(struct?: DataFactoryLinkedServiceAzureDatabricksTimeoutsOutputReference | DataFactoryLinkedServiceAzureDatabricksTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureDatabricksTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceAzureDatabricksTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceAzureDatabricksTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html azurerm_data_factory_linked_service_azure_databricks}.
 *
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureDatabricks extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_databricks.html azurerm_data_factory_linked_service_azure_databricks} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryLinkedServiceAzureDatabricksConfig);
    private _accessToken?;
    /**
     * @stability stable
     */
    get accessToken(): string;
    /**
     * @stability stable
     */
    set accessToken(value: string);
    /**
     * @stability stable
     */
    resetAccessToken(): void;
    /**
     * @stability stable
     */
    get accessTokenInput(): string | undefined;
    private _adbDomain?;
    /**
     * @stability stable
     */
    get adbDomain(): string;
    /**
     * @stability stable
     */
    set adbDomain(value: string);
    /**
     * @stability stable
     */
    get adbDomainInput(): string | undefined;
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    /**
     * @stability stable
     */
    get dataFactoryId(): string;
    /**
     * @stability stable
     */
    set dataFactoryId(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryId(): void;
    /**
     * @stability stable
     */
    get dataFactoryIdInput(): string | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    resetDataFactoryName(): void;
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _existingClusterId?;
    /**
     * @stability stable
     */
    get existingClusterId(): string;
    /**
     * @stability stable
     */
    set existingClusterId(value: string);
    /**
     * @stability stable
     */
    resetExistingClusterId(): void;
    /**
     * @stability stable
     */
    get existingClusterIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationRuntimeName?;
    /**
     * @stability stable
     */
    get integrationRuntimeName(): string;
    /**
     * @stability stable
     */
    set integrationRuntimeName(value: string);
    /**
     * @stability stable
     */
    resetIntegrationRuntimeName(): void;
    /**
     * @stability stable
     */
    get integrationRuntimeNameInput(): string | undefined;
    private _msiWorkSpaceResourceId?;
    /**
     * @stability stable
     */
    get msiWorkSpaceResourceId(): string;
    /**
     * @stability stable
     */
    set msiWorkSpaceResourceId(value: string);
    /**
     * @stability stable
     */
    resetMsiWorkSpaceResourceId(): void;
    /**
     * @stability stable
     */
    get msiWorkSpaceResourceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _instancePool;
    /**
     * @stability stable
     */
    get instancePool(): DataFactoryLinkedServiceAzureDatabricksInstancePoolOutputReference;
    /**
     * @stability stable
     */
    putInstancePool(value: DataFactoryLinkedServiceAzureDatabricksInstancePool): void;
    /**
     * @stability stable
     */
    resetInstancePool(): void;
    /**
     * @stability stable
     */
    get instancePoolInput(): DataFactoryLinkedServiceAzureDatabricksInstancePool | undefined;
    private _keyVaultPassword;
    /**
     * @stability stable
     */
    get keyVaultPassword(): DataFactoryLinkedServiceAzureDatabricksKeyVaultPasswordOutputReference;
    /**
     * @stability stable
     */
    putKeyVaultPassword(value: DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword): void;
    /**
     * @stability stable
     */
    resetKeyVaultPassword(): void;
    /**
     * @stability stable
     */
    get keyVaultPasswordInput(): DataFactoryLinkedServiceAzureDatabricksKeyVaultPassword | undefined;
    private _newClusterConfig;
    /**
     * @stability stable
     */
    get newClusterConfig(): DataFactoryLinkedServiceAzureDatabricksNewClusterConfigOutputReference;
    /**
     * @stability stable
     */
    putNewClusterConfig(value: DataFactoryLinkedServiceAzureDatabricksNewClusterConfig): void;
    /**
     * @stability stable
     */
    resetNewClusterConfig(): void;
    /**
     * @stability stable
     */
    get newClusterConfigInput(): DataFactoryLinkedServiceAzureDatabricksNewClusterConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryLinkedServiceAzureDatabricksTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryLinkedServiceAzureDatabricksTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryLinkedServiceAzureDatabricksTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
