import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DevTestGlobalVmShutdownScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#daily_recurrence_time DevTestGlobalVmShutdownSchedule#daily_recurrence_time}.
     *
     * @stability stable
     */
    readonly dailyRecurrenceTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#enabled DevTestGlobalVmShutdownSchedule#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#location DevTestGlobalVmShutdownSchedule#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#tags DevTestGlobalVmShutdownSchedule#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#timezone DevTestGlobalVmShutdownSchedule#timezone}.
     *
     * @stability stable
     */
    readonly timezone: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#virtual_machine_id DevTestGlobalVmShutdownSchedule#virtual_machine_id}.
     *
     * @stability stable
     */
    readonly virtualMachineId: string;
    /**
     * notification_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#notification_settings DevTestGlobalVmShutdownSchedule#notification_settings}
     *
     * @stability stable
     */
    readonly notificationSettings: DevTestGlobalVmShutdownScheduleNotificationSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#timeouts DevTestGlobalVmShutdownSchedule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DevTestGlobalVmShutdownScheduleTimeouts;
}
/**
 * @stability stable
 */
export interface DevTestGlobalVmShutdownScheduleNotificationSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#email DevTestGlobalVmShutdownSchedule#email}.
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#enabled DevTestGlobalVmShutdownSchedule#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#time_in_minutes DevTestGlobalVmShutdownSchedule#time_in_minutes}.
     *
     * @stability stable
     */
    readonly timeInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#webhook_url DevTestGlobalVmShutdownSchedule#webhook_url}.
     *
     * @stability stable
     */
    readonly webhookUrl?: string;
}
export declare function devTestGlobalVmShutdownScheduleNotificationSettingsToTerraform(struct?: DevTestGlobalVmShutdownScheduleNotificationSettingsOutputReference | DevTestGlobalVmShutdownScheduleNotificationSettings): any;
/**
 * @stability stable
 */
export declare class DevTestGlobalVmShutdownScheduleNotificationSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestGlobalVmShutdownScheduleNotificationSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestGlobalVmShutdownScheduleNotificationSettings | undefined);
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    resetEmail(): void;
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _timeInMinutes?;
    /**
     * @stability stable
     */
    get timeInMinutes(): number;
    /**
     * @stability stable
     */
    set timeInMinutes(value: number);
    /**
     * @stability stable
     */
    resetTimeInMinutes(): void;
    /**
     * @stability stable
     */
    get timeInMinutesInput(): number | undefined;
    private _webhookUrl?;
    /**
     * @stability stable
     */
    get webhookUrl(): string;
    /**
     * @stability stable
     */
    set webhookUrl(value: string);
    /**
     * @stability stable
     */
    resetWebhookUrl(): void;
    /**
     * @stability stable
     */
    get webhookUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DevTestGlobalVmShutdownScheduleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#create DevTestGlobalVmShutdownSchedule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#delete DevTestGlobalVmShutdownSchedule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#read DevTestGlobalVmShutdownSchedule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html#update DevTestGlobalVmShutdownSchedule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function devTestGlobalVmShutdownScheduleTimeoutsToTerraform(struct?: DevTestGlobalVmShutdownScheduleTimeoutsOutputReference | DevTestGlobalVmShutdownScheduleTimeouts): any;
/**
 * @stability stable
 */
export declare class DevTestGlobalVmShutdownScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DevTestGlobalVmShutdownScheduleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DevTestGlobalVmShutdownScheduleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html azurerm_dev_test_global_vm_shutdown_schedule}.
 *
 * @stability stable
 */
export declare class DevTestGlobalVmShutdownSchedule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dev_test_global_vm_shutdown_schedule.html azurerm_dev_test_global_vm_shutdown_schedule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DevTestGlobalVmShutdownScheduleConfig);
    private _dailyRecurrenceTime?;
    /**
     * @stability stable
     */
    get dailyRecurrenceTime(): string;
    /**
     * @stability stable
     */
    set dailyRecurrenceTime(value: string);
    /**
     * @stability stable
     */
    get dailyRecurrenceTimeInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _virtualMachineId?;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    /**
     * @stability stable
     */
    set virtualMachineId(value: string);
    /**
     * @stability stable
     */
    get virtualMachineIdInput(): string | undefined;
    private _notificationSettings;
    /**
     * @stability stable
     */
    get notificationSettings(): DevTestGlobalVmShutdownScheduleNotificationSettingsOutputReference;
    /**
     * @stability stable
     */
    putNotificationSettings(value: DevTestGlobalVmShutdownScheduleNotificationSettings): void;
    /**
     * @stability stable
     */
    get notificationSettingsInput(): DevTestGlobalVmShutdownScheduleNotificationSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DevTestGlobalVmShutdownScheduleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DevTestGlobalVmShutdownScheduleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DevTestGlobalVmShutdownScheduleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
