import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HpcCacheBlobNfsTargetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#access_policy_name HpcCacheBlobNfsTarget#access_policy_name}.
     *
     * @stability stable
     */
    readonly accessPolicyName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#cache_name HpcCacheBlobNfsTarget#cache_name}.
     *
     * @stability stable
     */
    readonly cacheName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#name HpcCacheBlobNfsTarget#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#namespace_path HpcCacheBlobNfsTarget#namespace_path}.
     *
     * @stability stable
     */
    readonly namespacePath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#resource_group_name HpcCacheBlobNfsTarget#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#storage_container_id HpcCacheBlobNfsTarget#storage_container_id}.
     *
     * @stability stable
     */
    readonly storageContainerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#usage_model HpcCacheBlobNfsTarget#usage_model}.
     *
     * @stability stable
     */
    readonly usageModel: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#timeouts HpcCacheBlobNfsTarget#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HpcCacheBlobNfsTargetTimeouts;
}
/**
 * @stability stable
 */
export interface HpcCacheBlobNfsTargetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#create HpcCacheBlobNfsTarget#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#delete HpcCacheBlobNfsTarget#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#read HpcCacheBlobNfsTarget#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html#update HpcCacheBlobNfsTarget#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hpcCacheBlobNfsTargetTimeoutsToTerraform(struct?: HpcCacheBlobNfsTargetTimeoutsOutputReference | HpcCacheBlobNfsTargetTimeouts): any;
/**
 * @stability stable
 */
export declare class HpcCacheBlobNfsTargetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HpcCacheBlobNfsTargetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HpcCacheBlobNfsTargetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html azurerm_hpc_cache_blob_nfs_target}.
 *
 * @stability stable
 */
export declare class HpcCacheBlobNfsTarget extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hpc_cache_blob_nfs_target.html azurerm_hpc_cache_blob_nfs_target} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HpcCacheBlobNfsTargetConfig);
    private _accessPolicyName?;
    /**
     * @stability stable
     */
    get accessPolicyName(): string;
    /**
     * @stability stable
     */
    set accessPolicyName(value: string);
    /**
     * @stability stable
     */
    resetAccessPolicyName(): void;
    /**
     * @stability stable
     */
    get accessPolicyNameInput(): string | undefined;
    private _cacheName?;
    /**
     * @stability stable
     */
    get cacheName(): string;
    /**
     * @stability stable
     */
    set cacheName(value: string);
    /**
     * @stability stable
     */
    get cacheNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespacePath?;
    /**
     * @stability stable
     */
    get namespacePath(): string;
    /**
     * @stability stable
     */
    set namespacePath(value: string);
    /**
     * @stability stable
     */
    get namespacePathInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _storageContainerId?;
    /**
     * @stability stable
     */
    get storageContainerId(): string;
    /**
     * @stability stable
     */
    set storageContainerId(value: string);
    /**
     * @stability stable
     */
    get storageContainerIdInput(): string | undefined;
    private _usageModel?;
    /**
     * @stability stable
     */
    get usageModel(): string;
    /**
     * @stability stable
     */
    set usageModel(value: string);
    /**
     * @stability stable
     */
    get usageModelInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HpcCacheBlobNfsTargetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HpcCacheBlobNfsTargetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HpcCacheBlobNfsTargetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
