import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MysqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#administrator_login MysqlServer#administrator_login}.
     *
     * @stability stable
     */
    readonly administratorLogin?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#administrator_login_password MysqlServer#administrator_login_password}.
     *
     * @stability stable
     */
    readonly administratorLoginPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#auto_grow_enabled MysqlServer#auto_grow_enabled}.
     *
     * @stability stable
     */
    readonly autoGrowEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#backup_retention_days MysqlServer#backup_retention_days}.
     *
     * @stability stable
     */
    readonly backupRetentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#create_mode MysqlServer#create_mode}.
     *
     * @stability stable
     */
    readonly createMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#creation_source_server_id MysqlServer#creation_source_server_id}.
     *
     * @stability stable
     */
    readonly creationSourceServerId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#geo_redundant_backup_enabled MysqlServer#geo_redundant_backup_enabled}.
     *
     * @stability stable
     */
    readonly geoRedundantBackupEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#infrastructure_encryption_enabled MysqlServer#infrastructure_encryption_enabled}.
     *
     * @stability stable
     */
    readonly infrastructureEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#location MysqlServer#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#name MysqlServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#public_network_access_enabled MysqlServer#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#resource_group_name MysqlServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#restore_point_in_time MysqlServer#restore_point_in_time}.
     *
     * @stability stable
     */
    readonly restorePointInTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#sku_name MysqlServer#sku_name}.
     *
     * @stability stable
     */
    readonly skuName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#ssl_enforcement MysqlServer#ssl_enforcement}.
     *
     * @stability stable
     */
    readonly sslEnforcement?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#ssl_enforcement_enabled MysqlServer#ssl_enforcement_enabled}.
     *
     * @stability stable
     */
    readonly sslEnforcementEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#ssl_minimal_tls_version_enforced MysqlServer#ssl_minimal_tls_version_enforced}.
     *
     * @stability stable
     */
    readonly sslMinimalTlsVersionEnforced?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#storage_mb MysqlServer#storage_mb}.
     *
     * @stability stable
     */
    readonly storageMb?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#tags MysqlServer#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#version MysqlServer#version}.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#identity MysqlServer#identity}
     *
     * @stability stable
     */
    readonly identity?: MysqlServerIdentity;
    /**
     * storage_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#storage_profile MysqlServer#storage_profile}
     *
     * @stability stable
     */
    readonly storageProfile?: MysqlServerStorageProfile;
    /**
     * threat_detection_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#threat_detection_policy MysqlServer#threat_detection_policy}
     *
     * @stability stable
     */
    readonly threatDetectionPolicy?: MysqlServerThreatDetectionPolicy;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#timeouts MysqlServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MysqlServerTimeouts;
}
/**
 * @stability stable
 */
export interface MysqlServerIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#type MysqlServer#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function mysqlServerIdentityToTerraform(struct?: MysqlServerIdentityOutputReference | MysqlServerIdentity): any;
/**
 * @stability stable
 */
export declare class MysqlServerIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MysqlServerIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MysqlServerIdentity | undefined);
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MysqlServerStorageProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#auto_grow MysqlServer#auto_grow}.
     *
     * @stability stable
     */
    readonly autoGrow?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#backup_retention_days MysqlServer#backup_retention_days}.
     *
     * @stability stable
     */
    readonly backupRetentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#geo_redundant_backup MysqlServer#geo_redundant_backup}.
     *
     * @stability stable
     */
    readonly geoRedundantBackup?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#storage_mb MysqlServer#storage_mb}.
     *
     * @stability stable
     */
    readonly storageMb?: number;
}
export declare function mysqlServerStorageProfileToTerraform(struct?: MysqlServerStorageProfileOutputReference | MysqlServerStorageProfile): any;
/**
 * @stability stable
 */
export declare class MysqlServerStorageProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MysqlServerStorageProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MysqlServerStorageProfile | undefined);
    private _autoGrow?;
    /**
     * @stability stable
     */
    get autoGrow(): string;
    /**
     * @stability stable
     */
    set autoGrow(value: string);
    /**
     * @stability stable
     */
    resetAutoGrow(): void;
    /**
     * @stability stable
     */
    get autoGrowInput(): string | undefined;
    private _backupRetentionDays?;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    set backupRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetBackupRetentionDays(): void;
    /**
     * @stability stable
     */
    get backupRetentionDaysInput(): number | undefined;
    private _geoRedundantBackup?;
    /**
     * @stability stable
     */
    get geoRedundantBackup(): string;
    /**
     * @stability stable
     */
    set geoRedundantBackup(value: string);
    /**
     * @stability stable
     */
    resetGeoRedundantBackup(): void;
    /**
     * @stability stable
     */
    get geoRedundantBackupInput(): string | undefined;
    private _storageMb?;
    /**
     * @stability stable
     */
    get storageMb(): number;
    /**
     * @stability stable
     */
    set storageMb(value: number);
    /**
     * @stability stable
     */
    resetStorageMb(): void;
    /**
     * @stability stable
     */
    get storageMbInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MysqlServerThreatDetectionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#disabled_alerts MysqlServer#disabled_alerts}.
     *
     * @stability stable
     */
    readonly disabledAlerts?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#email_account_admins MysqlServer#email_account_admins}.
     *
     * @stability stable
     */
    readonly emailAccountAdmins?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#email_addresses MysqlServer#email_addresses}.
     *
     * @stability stable
     */
    readonly emailAddresses?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#enabled MysqlServer#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#retention_days MysqlServer#retention_days}.
     *
     * @stability stable
     */
    readonly retentionDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#storage_account_access_key MysqlServer#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#storage_endpoint MysqlServer#storage_endpoint}.
     *
     * @stability stable
     */
    readonly storageEndpoint?: string;
}
export declare function mysqlServerThreatDetectionPolicyToTerraform(struct?: MysqlServerThreatDetectionPolicyOutputReference | MysqlServerThreatDetectionPolicy): any;
/**
 * @stability stable
 */
export declare class MysqlServerThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MysqlServerThreatDetectionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MysqlServerThreatDetectionPolicy | undefined);
    private _disabledAlerts?;
    /**
     * @stability stable
     */
    get disabledAlerts(): string[];
    /**
     * @stability stable
     */
    set disabledAlerts(value: string[]);
    /**
     * @stability stable
     */
    resetDisabledAlerts(): void;
    /**
     * @stability stable
     */
    get disabledAlertsInput(): string[] | undefined;
    private _emailAccountAdmins?;
    /**
     * @stability stable
     */
    get emailAccountAdmins(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set emailAccountAdmins(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEmailAccountAdmins(): void;
    /**
     * @stability stable
     */
    get emailAccountAdminsInput(): boolean | cdktf.IResolvable | undefined;
    private _emailAddresses?;
    /**
     * @stability stable
     */
    get emailAddresses(): string[];
    /**
     * @stability stable
     */
    set emailAddresses(value: string[]);
    /**
     * @stability stable
     */
    resetEmailAddresses(): void;
    /**
     * @stability stable
     */
    get emailAddressesInput(): string[] | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionDays?;
    /**
     * @stability stable
     */
    get retentionDays(): number;
    /**
     * @stability stable
     */
    set retentionDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionDays(): void;
    /**
     * @stability stable
     */
    get retentionDaysInput(): number | undefined;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountAccessKey(): void;
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageEndpoint?;
    /**
     * @stability stable
     */
    get storageEndpoint(): string;
    /**
     * @stability stable
     */
    set storageEndpoint(value: string);
    /**
     * @stability stable
     */
    resetStorageEndpoint(): void;
    /**
     * @stability stable
     */
    get storageEndpointInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MysqlServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#create MysqlServer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#delete MysqlServer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#read MysqlServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html#update MysqlServer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mysqlServerTimeoutsToTerraform(struct?: MysqlServerTimeoutsOutputReference | MysqlServerTimeouts): any;
/**
 * @stability stable
 */
export declare class MysqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MysqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MysqlServerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html azurerm_mysql_server}.
 *
 * @stability stable
 */
export declare class MysqlServer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mysql_server.html azurerm_mysql_server} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MysqlServerConfig);
    private _administratorLogin?;
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    set administratorLogin(value: string);
    /**
     * @stability stable
     */
    resetAdministratorLogin(): void;
    /**
     * @stability stable
     */
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    /**
     * @stability stable
     */
    get administratorLoginPassword(): string;
    /**
     * @stability stable
     */
    set administratorLoginPassword(value: string);
    /**
     * @stability stable
     */
    resetAdministratorLoginPassword(): void;
    /**
     * @stability stable
     */
    get administratorLoginPasswordInput(): string | undefined;
    private _autoGrowEnabled?;
    /**
     * @stability stable
     */
    get autoGrowEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoGrowEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoGrowEnabled(): void;
    /**
     * @stability stable
     */
    get autoGrowEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _backupRetentionDays?;
    /**
     * @stability stable
     */
    get backupRetentionDays(): number;
    /**
     * @stability stable
     */
    set backupRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetBackupRetentionDays(): void;
    /**
     * @stability stable
     */
    get backupRetentionDaysInput(): number | undefined;
    private _createMode?;
    /**
     * @stability stable
     */
    get createMode(): string;
    /**
     * @stability stable
     */
    set createMode(value: string);
    /**
     * @stability stable
     */
    resetCreateMode(): void;
    /**
     * @stability stable
     */
    get createModeInput(): string | undefined;
    private _creationSourceServerId?;
    /**
     * @stability stable
     */
    get creationSourceServerId(): string;
    /**
     * @stability stable
     */
    set creationSourceServerId(value: string);
    /**
     * @stability stable
     */
    resetCreationSourceServerId(): void;
    /**
     * @stability stable
     */
    get creationSourceServerIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get fqdn(): string;
    private _geoRedundantBackupEnabled?;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set geoRedundantBackupEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetGeoRedundantBackupEnabled(): void;
    /**
     * @stability stable
     */
    get geoRedundantBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _infrastructureEncryptionEnabled?;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set infrastructureEncryptionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInfrastructureEncryptionEnabled(): void;
    /**
     * @stability stable
     */
    get infrastructureEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _restorePointInTime?;
    /**
     * @stability stable
     */
    get restorePointInTime(): string;
    /**
     * @stability stable
     */
    set restorePointInTime(value: string);
    /**
     * @stability stable
     */
    resetRestorePointInTime(): void;
    /**
     * @stability stable
     */
    get restorePointInTimeInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _sslEnforcement?;
    /**
     * @stability stable
     */
    get sslEnforcement(): string;
    /**
     * @stability stable
     */
    set sslEnforcement(value: string);
    /**
     * @stability stable
     */
    resetSslEnforcement(): void;
    /**
     * @stability stable
     */
    get sslEnforcementInput(): string | undefined;
    private _sslEnforcementEnabled?;
    /**
     * @stability stable
     */
    get sslEnforcementEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sslEnforcementEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSslEnforcementEnabled(): void;
    /**
     * @stability stable
     */
    get sslEnforcementEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sslMinimalTlsVersionEnforced?;
    /**
     * @stability stable
     */
    get sslMinimalTlsVersionEnforced(): string;
    /**
     * @stability stable
     */
    set sslMinimalTlsVersionEnforced(value: string);
    /**
     * @stability stable
     */
    resetSslMinimalTlsVersionEnforced(): void;
    /**
     * @stability stable
     */
    get sslMinimalTlsVersionEnforcedInput(): string | undefined;
    private _storageMb?;
    /**
     * @stability stable
     */
    get storageMb(): number;
    /**
     * @stability stable
     */
    set storageMb(value: number);
    /**
     * @stability stable
     */
    resetStorageMb(): void;
    /**
     * @stability stable
     */
    get storageMbInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): MysqlServerIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: MysqlServerIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): MysqlServerIdentity | undefined;
    private _storageProfile;
    /**
     * @stability stable
     */
    get storageProfile(): MysqlServerStorageProfileOutputReference;
    /**
     * @stability stable
     */
    putStorageProfile(value: MysqlServerStorageProfile): void;
    /**
     * @stability stable
     */
    resetStorageProfile(): void;
    /**
     * @stability stable
     */
    get storageProfileInput(): MysqlServerStorageProfile | undefined;
    private _threatDetectionPolicy;
    /**
     * @stability stable
     */
    get threatDetectionPolicy(): MysqlServerThreatDetectionPolicyOutputReference;
    /**
     * @stability stable
     */
    putThreatDetectionPolicy(value: MysqlServerThreatDetectionPolicy): void;
    /**
     * @stability stable
     */
    resetThreatDetectionPolicy(): void;
    /**
     * @stability stable
     */
    get threatDetectionPolicyInput(): MysqlServerThreatDetectionPolicy | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MysqlServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MysqlServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MysqlServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
