"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageManagementPolicy = exports.StorageManagementPolicyTimeoutsOutputReference = exports.storageManagementPolicyTimeoutsToTerraform = exports.storageManagementPolicyRuleToTerraform = exports.StorageManagementPolicyRuleFiltersOutputReference = exports.storageManagementPolicyRuleFiltersToTerraform = exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = exports.StorageManagementPolicyRuleActionsOutputReference = exports.storageManagementPolicyRuleActionsToTerraform = exports.StorageManagementPolicyRuleActionsVersionOutputReference = exports.storageManagementPolicyRuleActionsVersionToTerraform = exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = exports.storageManagementPolicyRuleActionsSnapshotToTerraform = exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function storageManagementPolicyRuleActionsBaseBlobToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        delete_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceModificationGreaterThan),
        tier_to_archive_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToArchiveAfterDaysSinceModificationGreaterThan),
        tier_to_cool_after_days_since_modification_greater_than: cdktf.numberToTerraform(struct.tierToCoolAfterDaysSinceModificationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsBaseBlobToTerraform = storageManagementPolicyRuleActionsBaseBlobToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleActionsBaseBlobOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._deleteAfterDaysSinceModificationGreaterThan) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceModificationGreaterThan = this._deleteAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToArchiveAfterDaysSinceModificationGreaterThan) {
            hasAnyValues = true;
            internalValueResult.tierToArchiveAfterDaysSinceModificationGreaterThan = this._tierToArchiveAfterDaysSinceModificationGreaterThan;
        }
        if (this._tierToCoolAfterDaysSinceModificationGreaterThan) {
            hasAnyValues = true;
            internalValueResult.tierToCoolAfterDaysSinceModificationGreaterThan = this._tierToCoolAfterDaysSinceModificationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._deleteAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._deleteAfterDaysSinceModificationGreaterThan = value.deleteAfterDaysSinceModificationGreaterThan;
            this._tierToArchiveAfterDaysSinceModificationGreaterThan = value.tierToArchiveAfterDaysSinceModificationGreaterThan;
            this._tierToCoolAfterDaysSinceModificationGreaterThan = value.tierToCoolAfterDaysSinceModificationGreaterThan;
        }
    }
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_modification_greater_than');
    }
    /**
     * @stability stable
     */
    set deleteAfterDaysSinceModificationGreaterThan(value) {
        this._deleteAfterDaysSinceModificationGreaterThan = value;
    }
    /**
     * @stability stable
     */
    resetDeleteAfterDaysSinceModificationGreaterThan() {
        this._deleteAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceModificationGreaterThanInput() {
        return this._deleteAfterDaysSinceModificationGreaterThan;
    }
    /**
     * @stability stable
     */
    get tierToArchiveAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_archive_after_days_since_modification_greater_than');
    }
    /**
     * @stability stable
     */
    set tierToArchiveAfterDaysSinceModificationGreaterThan(value) {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = value;
    }
    /**
     * @stability stable
     */
    resetTierToArchiveAfterDaysSinceModificationGreaterThan() {
        this._tierToArchiveAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tierToArchiveAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToArchiveAfterDaysSinceModificationGreaterThan;
    }
    /**
     * @stability stable
     */
    get tierToCoolAfterDaysSinceModificationGreaterThan() {
        return this.getNumberAttribute('tier_to_cool_after_days_since_modification_greater_than');
    }
    /**
     * @stability stable
     */
    set tierToCoolAfterDaysSinceModificationGreaterThan(value) {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = value;
    }
    /**
     * @stability stable
     */
    resetTierToCoolAfterDaysSinceModificationGreaterThan() {
        this._tierToCoolAfterDaysSinceModificationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get tierToCoolAfterDaysSinceModificationGreaterThanInput() {
        return this._tierToCoolAfterDaysSinceModificationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsBaseBlobOutputReference = StorageManagementPolicyRuleActionsBaseBlobOutputReference;
_a = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsBaseBlobOutputReference[_a] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsBaseBlobOutputReference", version: "0.3.51" };
function storageManagementPolicyRuleActionsSnapshotToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation_greater_than: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreationGreaterThan),
    };
}
exports.storageManagementPolicyRuleActionsSnapshotToTerraform = storageManagementPolicyRuleActionsSnapshotToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleActionsSnapshotOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreationGreaterThan) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreationGreaterThan = this._deleteAfterDaysSinceCreationGreaterThan;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreationGreaterThan = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreationGreaterThan = value.deleteAfterDaysSinceCreationGreaterThan;
        }
    }
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationGreaterThan() {
        return this.getNumberAttribute('delete_after_days_since_creation_greater_than');
    }
    /**
     * @stability stable
     */
    set deleteAfterDaysSinceCreationGreaterThan(value) {
        this._deleteAfterDaysSinceCreationGreaterThan = value;
    }
    /**
     * @stability stable
     */
    resetDeleteAfterDaysSinceCreationGreaterThan() {
        this._deleteAfterDaysSinceCreationGreaterThan = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationGreaterThanInput() {
        return this._deleteAfterDaysSinceCreationGreaterThan;
    }
}
exports.StorageManagementPolicyRuleActionsSnapshotOutputReference = StorageManagementPolicyRuleActionsSnapshotOutputReference;
_b = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsSnapshotOutputReference[_b] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsSnapshotOutputReference", version: "0.3.51" };
function storageManagementPolicyRuleActionsVersionToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        change_tier_to_archive_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToArchiveAfterDaysSinceCreation),
        change_tier_to_cool_after_days_since_creation: cdktf.numberToTerraform(struct.changeTierToCoolAfterDaysSinceCreation),
        delete_after_days_since_creation: cdktf.numberToTerraform(struct.deleteAfterDaysSinceCreation),
    };
}
exports.storageManagementPolicyRuleActionsVersionToTerraform = storageManagementPolicyRuleActionsVersionToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleActionsVersionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._changeTierToArchiveAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.changeTierToArchiveAfterDaysSinceCreation = this._changeTierToArchiveAfterDaysSinceCreation;
        }
        if (this._changeTierToCoolAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.changeTierToCoolAfterDaysSinceCreation = this._changeTierToCoolAfterDaysSinceCreation;
        }
        if (this._deleteAfterDaysSinceCreation) {
            hasAnyValues = true;
            internalValueResult.deleteAfterDaysSinceCreation = this._deleteAfterDaysSinceCreation;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._changeTierToArchiveAfterDaysSinceCreation = undefined;
            this._changeTierToCoolAfterDaysSinceCreation = undefined;
            this._deleteAfterDaysSinceCreation = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._changeTierToArchiveAfterDaysSinceCreation = value.changeTierToArchiveAfterDaysSinceCreation;
            this._changeTierToCoolAfterDaysSinceCreation = value.changeTierToCoolAfterDaysSinceCreation;
            this._deleteAfterDaysSinceCreation = value.deleteAfterDaysSinceCreation;
        }
    }
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_archive_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set changeTierToArchiveAfterDaysSinceCreation(value) {
        this._changeTierToArchiveAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetChangeTierToArchiveAfterDaysSinceCreation() {
        this._changeTierToArchiveAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreationInput() {
        return this._changeTierToArchiveAfterDaysSinceCreation;
    }
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreation() {
        return this.getNumberAttribute('change_tier_to_cool_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set changeTierToCoolAfterDaysSinceCreation(value) {
        this._changeTierToCoolAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetChangeTierToCoolAfterDaysSinceCreation() {
        this._changeTierToCoolAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreationInput() {
        return this._changeTierToCoolAfterDaysSinceCreation;
    }
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreation() {
        return this.getNumberAttribute('delete_after_days_since_creation');
    }
    /**
     * @stability stable
     */
    set deleteAfterDaysSinceCreation(value) {
        this._deleteAfterDaysSinceCreation = value;
    }
    /**
     * @stability stable
     */
    resetDeleteAfterDaysSinceCreation() {
        this._deleteAfterDaysSinceCreation = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationInput() {
        return this._deleteAfterDaysSinceCreation;
    }
}
exports.StorageManagementPolicyRuleActionsVersionOutputReference = StorageManagementPolicyRuleActionsVersionOutputReference;
_c = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsVersionOutputReference[_c] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsVersionOutputReference", version: "0.3.51" };
function storageManagementPolicyRuleActionsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        base_blob: storageManagementPolicyRuleActionsBaseBlobToTerraform(struct.baseBlob),
        snapshot: storageManagementPolicyRuleActionsSnapshotToTerraform(struct.snapshot),
        version: storageManagementPolicyRuleActionsVersionToTerraform(struct.version),
    };
}
exports.storageManagementPolicyRuleActionsToTerraform = storageManagementPolicyRuleActionsToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleActionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
        // base_blob - computed: false, optional: true, required: false
        this._baseBlob = new StorageManagementPolicyRuleActionsBaseBlobOutputReference(this, "base_blob", true);
        // snapshot - computed: false, optional: true, required: false
        this._snapshot = new StorageManagementPolicyRuleActionsSnapshotOutputReference(this, "snapshot", true);
        // version - computed: false, optional: true, required: false
        this._version = new StorageManagementPolicyRuleActionsVersionOutputReference(this, "version", true);
    }
    /**
     * @stability stable
     */
    get internalValue() {
        var _h, _j, _k, _l, _m, _o;
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if ((_h = this._baseBlob) === null || _h === void 0 ? void 0 : _h.internalValue) {
            hasAnyValues = true;
            internalValueResult.baseBlob = (_j = this._baseBlob) === null || _j === void 0 ? void 0 : _j.internalValue;
        }
        if ((_k = this._snapshot) === null || _k === void 0 ? void 0 : _k.internalValue) {
            hasAnyValues = true;
            internalValueResult.snapshot = (_l = this._snapshot) === null || _l === void 0 ? void 0 : _l.internalValue;
        }
        if ((_m = this._version) === null || _m === void 0 ? void 0 : _m.internalValue) {
            hasAnyValues = true;
            internalValueResult.version = (_o = this._version) === null || _o === void 0 ? void 0 : _o.internalValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._baseBlob.internalValue = undefined;
            this._snapshot.internalValue = undefined;
            this._version.internalValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._baseBlob.internalValue = value.baseBlob;
            this._snapshot.internalValue = value.snapshot;
            this._version.internalValue = value.version;
        }
    }
    /**
     * @stability stable
     */
    get baseBlob() {
        return this._baseBlob;
    }
    /**
     * @stability stable
     */
    putBaseBlob(value) {
        this._baseBlob.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetBaseBlob() {
        this._baseBlob.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get baseBlobInput() {
        return this._baseBlob.internalValue;
    }
    /**
     * @stability stable
     */
    get snapshot() {
        return this._snapshot;
    }
    /**
     * @stability stable
     */
    putSnapshot(value) {
        this._snapshot.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetSnapshot() {
        this._snapshot.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get snapshotInput() {
        return this._snapshot.internalValue;
    }
    /**
     * @stability stable
     */
    get version() {
        return this._version;
    }
    /**
     * @stability stable
     */
    putVersion(value) {
        this._version.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetVersion() {
        this._version.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get versionInput() {
        return this._version.internalValue;
    }
}
exports.StorageManagementPolicyRuleActionsOutputReference = StorageManagementPolicyRuleActionsOutputReference;
_d = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleActionsOutputReference[_d] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleActionsOutputReference", version: "0.3.51" };
function storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        name: cdktf.stringToTerraform(struct.name),
        operation: cdktf.stringToTerraform(struct.operation),
        value: cdktf.stringToTerraform(struct.value),
    };
}
exports.storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform = storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform;
function storageManagementPolicyRuleFiltersToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        blob_types: cdktf.listMapper(cdktf.stringToTerraform)(struct.blobTypes),
        prefix_match: cdktf.listMapper(cdktf.stringToTerraform)(struct.prefixMatch),
        match_blob_index_tag: cdktf.listMapper(storageManagementPolicyRuleFiltersMatchBlobIndexTagToTerraform)(struct.matchBlobIndexTag),
    };
}
exports.storageManagementPolicyRuleFiltersToTerraform = storageManagementPolicyRuleFiltersToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyRuleFiltersOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._blobTypes) {
            hasAnyValues = true;
            internalValueResult.blobTypes = this._blobTypes;
        }
        if (this._prefixMatch) {
            hasAnyValues = true;
            internalValueResult.prefixMatch = this._prefixMatch;
        }
        if (this._matchBlobIndexTag) {
            hasAnyValues = true;
            internalValueResult.matchBlobIndexTag = this._matchBlobIndexTag;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._blobTypes = undefined;
            this._prefixMatch = undefined;
            this._matchBlobIndexTag = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._blobTypes = value.blobTypes;
            this._prefixMatch = value.prefixMatch;
            this._matchBlobIndexTag = value.matchBlobIndexTag;
        }
    }
    /**
     * @stability stable
     */
    get blobTypes() {
        return this.getListAttribute('blob_types');
    }
    /**
     * @stability stable
     */
    set blobTypes(value) {
        this._blobTypes = value;
    }
    /**
     * @stability stable
     */
    resetBlobTypes() {
        this._blobTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get blobTypesInput() {
        return this._blobTypes;
    }
    /**
     * @stability stable
     */
    get prefixMatch() {
        return this.getListAttribute('prefix_match');
    }
    /**
     * @stability stable
     */
    set prefixMatch(value) {
        this._prefixMatch = value;
    }
    /**
     * @stability stable
     */
    resetPrefixMatch() {
        this._prefixMatch = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get prefixMatchInput() {
        return this._prefixMatch;
    }
    /**
     * @stability stable
     */
    get matchBlobIndexTag() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('match_blob_index_tag');
    }
    /**
     * @stability stable
     */
    set matchBlobIndexTag(value) {
        this._matchBlobIndexTag = value;
    }
    /**
     * @stability stable
     */
    resetMatchBlobIndexTag() {
        this._matchBlobIndexTag = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get matchBlobIndexTagInput() {
        return this._matchBlobIndexTag;
    }
}
exports.StorageManagementPolicyRuleFiltersOutputReference = StorageManagementPolicyRuleFiltersOutputReference;
_e = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyRuleFiltersOutputReference[_e] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyRuleFiltersOutputReference", version: "0.3.51" };
function storageManagementPolicyRuleToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        enabled: cdktf.booleanToTerraform(struct.enabled),
        name: cdktf.stringToTerraform(struct.name),
        actions: storageManagementPolicyRuleActionsToTerraform(struct.actions),
        filters: storageManagementPolicyRuleFiltersToTerraform(struct.filters),
    };
}
exports.storageManagementPolicyRuleToTerraform = storageManagementPolicyRuleToTerraform;
function storageManagementPolicyTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
        read: cdktf.stringToTerraform(struct.read),
        update: cdktf.stringToTerraform(struct.update),
    };
}
exports.storageManagementPolicyTimeoutsToTerraform = storageManagementPolicyTimeoutsToTerraform;
/**
 * @stability stable
 */
class StorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    /**
     * @stability stable
     */
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        if (this._read) {
            hasAnyValues = true;
            internalValueResult.read = this._read;
        }
        if (this._update) {
            hasAnyValues = true;
            internalValueResult.update = this._update;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    /**
     * @stability stable
     */
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
            this._read = undefined;
            this._update = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
            this._read = value.read;
            this._update = value.update;
        }
    }
    /**
     * @stability stable
     */
    get create() {
        return this.getStringAttribute('create');
    }
    /**
     * @stability stable
     */
    set create(value) {
        this._create = value;
    }
    /**
     * @stability stable
     */
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get createInput() {
        return this._create;
    }
    /**
     * @stability stable
     */
    get delete() {
        return this.getStringAttribute('delete');
    }
    /**
     * @stability stable
     */
    set delete(value) {
        this._delete = value;
    }
    /**
     * @stability stable
     */
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get deleteInput() {
        return this._delete;
    }
    /**
     * @stability stable
     */
    get read() {
        return this.getStringAttribute('read');
    }
    /**
     * @stability stable
     */
    set read(value) {
        this._read = value;
    }
    /**
     * @stability stable
     */
    resetRead() {
        this._read = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get readInput() {
        return this._read;
    }
    /**
     * @stability stable
     */
    get update() {
        return this.getStringAttribute('update');
    }
    /**
     * @stability stable
     */
    set update(value) {
        this._update = value;
    }
    /**
     * @stability stable
     */
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get updateInput() {
        return this._update;
    }
}
exports.StorageManagementPolicyTimeoutsOutputReference = StorageManagementPolicyTimeoutsOutputReference;
_f = JSII_RTTI_SYMBOL_1;
StorageManagementPolicyTimeoutsOutputReference[_f] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicyTimeoutsOutputReference", version: "0.3.51" };
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy.html azurerm_storage_management_policy}.
 *
 * @stability stable
 */
class StorageManagementPolicy extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/storage_management_policy.html azurerm_storage_management_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'azurerm_storage_management_policy',
            terraformGeneratorMetadata: {
                providerName: 'azurerm'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new StorageManagementPolicyTimeoutsOutputReference(this, "timeouts", true);
        this._storageAccountId = config.storageAccountId;
        this._rule = config.rule;
        this._timeouts.internalValue = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // id - computed: true, optional: true, required: false
    /**
     * @stability stable
     */
    get id() {
        return this.getStringAttribute('id');
    }
    /**
     * @stability stable
     */
    get storageAccountId() {
        return this.getStringAttribute('storage_account_id');
    }
    /**
     * @stability stable
     */
    set storageAccountId(value) {
        this._storageAccountId = value;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get storageAccountIdInput() {
        return this._storageAccountId;
    }
    /**
     * @stability stable
     */
    get rule() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('rule');
    }
    /**
     * @stability stable
     */
    set rule(value) {
        this._rule = value;
    }
    /**
     * @stability stable
     */
    resetRule() {
        this._rule = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get ruleInput() {
        return this._rule;
    }
    /**
     * @stability stable
     */
    get timeouts() {
        return this._timeouts;
    }
    /**
     * @stability stable
     */
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    /**
     * @stability stable
     */
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    /**
     * @stability stable
     */
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    /**
     * @stability stable
     */
    synthesizeAttributes() {
        return {
            storage_account_id: cdktf.stringToTerraform(this._storageAccountId),
            rule: cdktf.listMapper(storageManagementPolicyRuleToTerraform)(this._rule),
            timeouts: storageManagementPolicyTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.StorageManagementPolicy = StorageManagementPolicy;
_g = JSII_RTTI_SYMBOL_1;
StorageManagementPolicy[_g] = { fqn: "@cdktf/provider-azurerm.StorageManagementPolicy", version: "0.3.51" };
// =================
// STATIC PROPERTIES
// =================
/**
 * @stability stable
 */
StorageManagementPolicy.tfResourceType = "azurerm_storage_management_policy";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcmFnZS1tYW5hZ2VtZW50LXBvbGljeS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9zdG9yYWdlLW1hbmFnZW1lbnQtcG9saWN5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBSUEsK0JBQStCO0FBcUIvQixTQUFnQixxREFBcUQsQ0FBQyxNQUErRztJQUNuTCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDakQsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLGlEQUFpRCxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsMkNBQTJDLENBQUM7UUFDL0gsMERBQTBELEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxrREFBa0QsQ0FBQztRQUMvSSx1REFBdUQsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLCtDQUErQyxDQUFDO0tBQzFJLENBQUE7QUFDSCxDQUFDO0FBVkQsc0hBVUM7Ozs7QUFFRCxNQUFhLHlEQUEwRCxTQUFRLEtBQUssQ0FBQyxhQUFhOzs7Ozs7O0lBSWhHLFlBQW1CLGlCQUEyQyxFQUFFLGtCQUEwQixFQUFFLFlBQXFCO1FBQy9HLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxZQUFZLENBQUMsQ0FBQztRQUpyRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztJQUs5QixDQUFDOzs7O0lBRUQsSUFBVyxhQUFhO1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsSUFBSSxJQUFJLENBQUMsNENBQTRDLEVBQUU7WUFDckQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQywyQ0FBMkMsR0FBRyxJQUFJLENBQUMsNENBQTRDLENBQUM7U0FDckg7UUFDRCxJQUFJLElBQUksQ0FBQyxtREFBbUQsRUFBRTtZQUM1RCxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLGtEQUFrRCxHQUFHLElBQUksQ0FBQyxtREFBbUQsQ0FBQztTQUNuSTtRQUNELElBQUksSUFBSSxDQUFDLGdEQUFnRCxFQUFFO1lBQ3pELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsK0NBQStDLEdBQUcsSUFBSSxDQUFDLGdEQUFnRCxDQUFDO1NBQzdIO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQzs7OztJQUVELElBQVcsYUFBYSxDQUFDLEtBQTZEO1FBQ3BGLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsNENBQTRDLEdBQUcsU0FBUyxDQUFDO1lBQzlELElBQUksQ0FBQyxtREFBbUQsR0FBRyxTQUFTLENBQUM7WUFDckUsSUFBSSxDQUFDLGdEQUFnRCxHQUFHLFNBQVMsQ0FBQztTQUNuRTthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLDRDQUE0QyxHQUFHLEtBQUssQ0FBQywyQ0FBMkMsQ0FBQztZQUN0RyxJQUFJLENBQUMsbURBQW1ELEdBQUcsS0FBSyxDQUFDLGtEQUFrRCxDQUFDO1lBQ3BILElBQUksQ0FBQyxnREFBZ0QsR0FBRyxLQUFLLENBQUMsK0NBQStDLENBQUM7U0FDL0c7SUFDSCxDQUFDOzs7O0lBSUQsSUFBVywyQ0FBMkM7UUFDcEQsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsbURBQW1ELENBQUMsQ0FBQztJQUN0RixDQUFDOzs7O0lBQ0QsSUFBVywyQ0FBMkMsQ0FBQyxLQUFhO1FBQ2xFLElBQUksQ0FBQyw0Q0FBNEMsR0FBRyxLQUFLLENBQUM7SUFDNUQsQ0FBQzs7OztJQUNNLGdEQUFnRDtRQUNyRCxJQUFJLENBQUMsNENBQTRDLEdBQUcsU0FBUyxDQUFDO0lBQ2hFLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxnREFBZ0Q7UUFDekQsT0FBTyxJQUFJLENBQUMsNENBQTRDLENBQUM7SUFDM0QsQ0FBQzs7OztJQUlELElBQVcsa0RBQWtEO1FBQzNELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLDREQUE0RCxDQUFDLENBQUM7SUFDL0YsQ0FBQzs7OztJQUNELElBQVcsa0RBQWtELENBQUMsS0FBYTtRQUN6RSxJQUFJLENBQUMsbURBQW1ELEdBQUcsS0FBSyxDQUFDO0lBQ25FLENBQUM7Ozs7SUFDTSx1REFBdUQ7UUFDNUQsSUFBSSxDQUFDLG1EQUFtRCxHQUFHLFNBQVMsQ0FBQztJQUN2RSxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsdURBQXVEO1FBQ2hFLE9BQU8sSUFBSSxDQUFDLG1EQUFtRCxDQUFDO0lBQ2xFLENBQUM7Ozs7SUFJRCxJQUFXLCtDQUErQztRQUN4RCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyx5REFBeUQsQ0FBQyxDQUFDO0lBQzVGLENBQUM7Ozs7SUFDRCxJQUFXLCtDQUErQyxDQUFDLEtBQWE7UUFDdEUsSUFBSSxDQUFDLGdEQUFnRCxHQUFHLEtBQUssQ0FBQztJQUNoRSxDQUFDOzs7O0lBQ00sb0RBQW9EO1FBQ3pELElBQUksQ0FBQyxnREFBZ0QsR0FBRyxTQUFTLENBQUM7SUFDcEUsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLG9EQUFvRDtRQUM3RCxPQUFPLElBQUksQ0FBQyxnREFBZ0QsQ0FBQztJQUMvRCxDQUFDOztBQXZGSCw4SEF3RkM7OztBQVVELFNBQWdCLHFEQUFxRCxDQUFDLE1BQStHO0lBQ25MLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUNqRCxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsZ0RBQWdELEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyx5Q0FBeUMsQ0FBQztRQUM1SCw2Q0FBNkMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLHNDQUFzQyxDQUFDO1FBQ3RILDZDQUE2QyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsdUNBQXVDLENBQUM7S0FDeEgsQ0FBQTtBQUNILENBQUM7QUFWRCxzSEFVQzs7OztBQUVELE1BQWEseURBQTBELFNBQVEsS0FBSyxDQUFDLGFBQWE7Ozs7Ozs7SUFJaEcsWUFBbUIsaUJBQTJDLEVBQUUsa0JBQTBCLEVBQUUsWUFBcUI7UUFDL0csS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFlBQVksQ0FBQyxDQUFDO1FBSnJELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBSzlCLENBQUM7Ozs7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQywwQ0FBMEMsRUFBRTtZQUNuRCxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLHlDQUF5QyxHQUFHLElBQUksQ0FBQywwQ0FBMEMsQ0FBQztTQUNqSDtRQUNELElBQUksSUFBSSxDQUFDLHVDQUF1QyxFQUFFO1lBQ2hELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMsc0NBQXNDLEdBQUcsSUFBSSxDQUFDLHVDQUF1QyxDQUFDO1NBQzNHO1FBQ0QsSUFBSSxJQUFJLENBQUMsd0NBQXdDLEVBQUU7WUFDakQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyx1Q0FBdUMsR0FBRyxJQUFJLENBQUMsd0NBQXdDLENBQUM7U0FDN0c7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDOzs7O0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBNkQ7UUFDcEYsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQywwQ0FBMEMsR0FBRyxTQUFTLENBQUM7WUFDNUQsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLFNBQVMsQ0FBQztZQUN6RCxJQUFJLENBQUMsd0NBQXdDLEdBQUcsU0FBUyxDQUFDO1NBQzNEO2FBQ0k7WUFDSCxJQUFJLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUMsQ0FBQztZQUNyRCxJQUFJLENBQUMsMENBQTBDLEdBQUcsS0FBSyxDQUFDLHlDQUF5QyxDQUFDO1lBQ2xHLElBQUksQ0FBQyx1Q0FBdUMsR0FBRyxLQUFLLENBQUMsc0NBQXNDLENBQUM7WUFDNUYsSUFBSSxDQUFDLHdDQUF3QyxHQUFHLEtBQUssQ0FBQyx1Q0FBdUMsQ0FBQztTQUMvRjtJQUNILENBQUM7Ozs7SUFJRCxJQUFXLHlDQUF5QztRQUNsRCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxrREFBa0QsQ0FBQyxDQUFDO0lBQ3JGLENBQUM7Ozs7SUFDRCxJQUFXLHlDQUF5QyxDQUFDLEtBQWE7UUFDaEUsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLEtBQUssQ0FBQztJQUMxRCxDQUFDOzs7O0lBQ00sOENBQThDO1FBQ25ELElBQUksQ0FBQywwQ0FBMEMsR0FBRyxTQUFTLENBQUM7SUFDOUQsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLDhDQUE4QztRQUN2RCxPQUFPLElBQUksQ0FBQywwQ0FBMEMsQ0FBQztJQUN6RCxDQUFDOzs7O0lBSUQsSUFBVyxzQ0FBc0M7UUFDL0MsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsK0NBQStDLENBQUMsQ0FBQztJQUNsRixDQUFDOzs7O0lBQ0QsSUFBVyxzQ0FBc0MsQ0FBQyxLQUFhO1FBQzdELElBQUksQ0FBQyx1Q0FBdUMsR0FBRyxLQUFLLENBQUM7SUFDdkQsQ0FBQzs7OztJQUNNLDJDQUEyQztRQUNoRCxJQUFJLENBQUMsdUNBQXVDLEdBQUcsU0FBUyxDQUFDO0lBQzNELENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVywyQ0FBMkM7UUFDcEQsT0FBTyxJQUFJLENBQUMsdUNBQXVDLENBQUM7SUFDdEQsQ0FBQzs7OztJQUlELElBQVcsdUNBQXVDO1FBQ2hELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLCtDQUErQyxDQUFDLENBQUM7SUFDbEYsQ0FBQzs7OztJQUNELElBQVcsdUNBQXVDLENBQUMsS0FBYTtRQUM5RCxJQUFJLENBQUMsd0NBQXdDLEdBQUcsS0FBSyxDQUFDO0lBQ3hELENBQUM7Ozs7SUFDTSw0Q0FBNEM7UUFDakQsSUFBSSxDQUFDLHdDQUF3QyxHQUFHLFNBQVMsQ0FBQztJQUM1RCxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsNENBQTRDO1FBQ3JELE9BQU8sSUFBSSxDQUFDLHdDQUF3QyxDQUFDO0lBQ3ZELENBQUM7O0FBdkZILDhIQXdGQzs7O0FBVUQsU0FBZ0Isb0RBQW9ELENBQUMsTUFBNkc7SUFDaEwsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQ2pELElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxnREFBZ0QsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLHlDQUF5QyxDQUFDO1FBQzVILDZDQUE2QyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsc0NBQXNDLENBQUM7UUFDdEgsZ0NBQWdDLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyw0QkFBNEIsQ0FBQztLQUNoRyxDQUFBO0FBQ0gsQ0FBQztBQVZELG9IQVVDOzs7O0FBRUQsTUFBYSx3REFBeUQsU0FBUSxLQUFLLENBQUMsYUFBYTs7Ozs7OztJQUkvRixZQUFtQixpQkFBMkMsRUFBRSxrQkFBMEIsRUFBRSxZQUFxQjtRQUMvRyxLQUFLLENBQUMsaUJBQWlCLEVBQUUsa0JBQWtCLEVBQUUsWUFBWSxDQUFDLENBQUM7UUFKckQsa0JBQWEsR0FBRyxLQUFLLENBQUM7SUFLOUIsQ0FBQzs7OztJQUVELElBQVcsYUFBYTtRQUN0QixJQUFJLFlBQVksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDO1FBQ3RDLE1BQU0sbUJBQW1CLEdBQVEsRUFBRSxDQUFDO1FBQ3BDLElBQUksSUFBSSxDQUFDLDBDQUEwQyxFQUFFO1lBQ25ELFlBQVksR0FBRyxJQUFJLENBQUM7WUFDcEIsbUJBQW1CLENBQUMseUNBQXlDLEdBQUcsSUFBSSxDQUFDLDBDQUEwQyxDQUFDO1NBQ2pIO1FBQ0QsSUFBSSxJQUFJLENBQUMsdUNBQXVDLEVBQUU7WUFDaEQsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxzQ0FBc0MsR0FBRyxJQUFJLENBQUMsdUNBQXVDLENBQUM7U0FDM0c7UUFDRCxJQUFJLElBQUksQ0FBQyw2QkFBNkIsRUFBRTtZQUN0QyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLDRCQUE0QixHQUFHLElBQUksQ0FBQyw2QkFBNkIsQ0FBQztTQUN2RjtRQUNELE9BQU8sWUFBWSxDQUFDLENBQUMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0lBQ3hELENBQUM7Ozs7SUFFRCxJQUFXLGFBQWEsQ0FBQyxLQUE0RDtRQUNuRixJQUFJLEtBQUssS0FBSyxTQUFTLEVBQUU7WUFDdkIsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUM7WUFDM0IsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLFNBQVMsQ0FBQztZQUM1RCxJQUFJLENBQUMsdUNBQXVDLEdBQUcsU0FBUyxDQUFDO1lBQ3pELElBQUksQ0FBQyw2QkFBNkIsR0FBRyxTQUFTLENBQUM7U0FDaEQ7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQywwQ0FBMEMsR0FBRyxLQUFLLENBQUMseUNBQXlDLENBQUM7WUFDbEcsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLEtBQUssQ0FBQyxzQ0FBc0MsQ0FBQztZQUM1RixJQUFJLENBQUMsNkJBQTZCLEdBQUcsS0FBSyxDQUFDLDRCQUE0QixDQUFDO1NBQ3pFO0lBQ0gsQ0FBQzs7OztJQUlELElBQVcseUNBQXlDO1FBQ2xELE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLGtEQUFrRCxDQUFDLENBQUM7SUFDckYsQ0FBQzs7OztJQUNELElBQVcseUNBQXlDLENBQUMsS0FBYTtRQUNoRSxJQUFJLENBQUMsMENBQTBDLEdBQUcsS0FBSyxDQUFDO0lBQzFELENBQUM7Ozs7SUFDTSw4Q0FBOEM7UUFDbkQsSUFBSSxDQUFDLDBDQUEwQyxHQUFHLFNBQVMsQ0FBQztJQUM5RCxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsOENBQThDO1FBQ3ZELE9BQU8sSUFBSSxDQUFDLDBDQUEwQyxDQUFDO0lBQ3pELENBQUM7Ozs7SUFJRCxJQUFXLHNDQUFzQztRQUMvQyxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO0lBQ2xGLENBQUM7Ozs7SUFDRCxJQUFXLHNDQUFzQyxDQUFDLEtBQWE7UUFDN0QsSUFBSSxDQUFDLHVDQUF1QyxHQUFHLEtBQUssQ0FBQztJQUN2RCxDQUFDOzs7O0lBQ00sMkNBQTJDO1FBQ2hELElBQUksQ0FBQyx1Q0FBdUMsR0FBRyxTQUFTLENBQUM7SUFDM0QsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLDJDQUEyQztRQUNwRCxPQUFPLElBQUksQ0FBQyx1Q0FBdUMsQ0FBQztJQUN0RCxDQUFDOzs7O0lBSUQsSUFBVyw0QkFBNEI7UUFDckMsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsa0NBQWtDLENBQUMsQ0FBQztJQUNyRSxDQUFDOzs7O0lBQ0QsSUFBVyw0QkFBNEIsQ0FBQyxLQUFhO1FBQ25ELElBQUksQ0FBQyw2QkFBNkIsR0FBRyxLQUFLLENBQUM7SUFDN0MsQ0FBQzs7OztJQUNNLGlDQUFpQztRQUN0QyxJQUFJLENBQUMsNkJBQTZCLEdBQUcsU0FBUyxDQUFDO0lBQ2pELENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxpQ0FBaUM7UUFDMUMsT0FBTyxJQUFJLENBQUMsNkJBQTZCLENBQUM7SUFDNUMsQ0FBQzs7QUF2RkgsNEhBd0ZDOzs7QUFVRCxTQUFnQiw2Q0FBNkMsQ0FBQyxNQUErRjtJQUMzSixJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUFFLE9BQU8sTUFBTSxDQUFDO0tBQUU7SUFDakQsSUFBSSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvSEFBb0gsQ0FBQyxDQUFDO0tBQ3ZJO0lBQ0QsT0FBTztRQUNMLFNBQVMsRUFBRSxxREFBcUQsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ2xGLFFBQVEsRUFBRSxxREFBcUQsQ0FBQyxNQUFPLENBQUMsUUFBUSxDQUFDO1FBQ2pGLE9BQU8sRUFBRSxvREFBb0QsQ0FBQyxNQUFPLENBQUMsT0FBTyxDQUFDO0tBQy9FLENBQUE7QUFDSCxDQUFDO0FBVkQsc0dBVUM7Ozs7QUFFRCxNQUFhLGlEQUFrRCxTQUFRLEtBQUssQ0FBQyxhQUFhOzs7Ozs7O0lBSXhGLFlBQW1CLGlCQUEyQyxFQUFFLGtCQUEwQixFQUFFLFlBQXFCO1FBQy9HLEtBQUssQ0FBQyxpQkFBaUIsRUFBRSxrQkFBa0IsRUFBRSxZQUFZLENBQUMsQ0FBQztRQUpyRCxrQkFBYSxHQUFHLEtBQUssQ0FBQztRQXdDOUIsK0RBQStEO1FBQ3ZELGNBQVMsR0FBRyxJQUFJLHlEQUF5RCxDQUFDLElBQVcsRUFBRSxXQUFXLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFlbEgsOERBQThEO1FBQ3RELGNBQVMsR0FBRyxJQUFJLHlEQUF5RCxDQUFDLElBQVcsRUFBRSxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFlakgsNkRBQTZEO1FBQ3JELGFBQVEsR0FBRyxJQUFJLHdEQUF3RCxDQUFDLElBQVcsRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFwRTlHLENBQUM7Ozs7SUFFRCxJQUFXLGFBQWE7O1FBQ3RCLElBQUksWUFBWSxHQUFHLElBQUksQ0FBQyxhQUFhLENBQUM7UUFDdEMsTUFBTSxtQkFBbUIsR0FBUSxFQUFFLENBQUM7UUFDcEMsVUFBSSxJQUFJLENBQUMsU0FBUywwQ0FBRSxhQUFhLEVBQUU7WUFDakMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLFNBQUcsSUFBSSxDQUFDLFNBQVMsMENBQUUsYUFBYSxDQUFDO1NBQzlEO1FBQ0QsVUFBSSxJQUFJLENBQUMsU0FBUywwQ0FBRSxhQUFhLEVBQUU7WUFDakMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxRQUFRLFNBQUcsSUFBSSxDQUFDLFNBQVMsMENBQUUsYUFBYSxDQUFDO1NBQzlEO1FBQ0QsVUFBSSxJQUFJLENBQUMsUUFBUSwwQ0FBRSxhQUFhLEVBQUU7WUFDaEMsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxPQUFPLFNBQUcsSUFBSSxDQUFDLFFBQVEsMENBQUUsYUFBYSxDQUFDO1NBQzVEO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQzs7OztJQUVELElBQVcsYUFBYSxDQUFDLEtBQXFEO1FBQzVFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7WUFDekMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsU0FBUyxDQUFDO1lBQ3pDLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxHQUFHLFNBQVMsQ0FBQztTQUN6QzthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztZQUM5QyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1lBQzlDLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7U0FDN0M7SUFDSCxDQUFDOzs7O0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDOzs7O0lBQ00sV0FBVyxDQUFDLEtBQWlEO1FBQ2xFLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDOzs7O0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztJQUN0QyxDQUFDOzs7O0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDOzs7O0lBQ00sV0FBVyxDQUFDLEtBQWlEO1FBQ2xFLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDOzs7O0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztJQUN0QyxDQUFDOzs7O0lBSUQsSUFBVyxPQUFPO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQztJQUN2QixDQUFDOzs7O0lBQ00sVUFBVSxDQUFDLEtBQWdEO1FBQ2hFLElBQUksQ0FBQyxRQUFRLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN0QyxDQUFDOzs7O0lBQ00sWUFBWTtRQUNqQixJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDMUMsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQztJQUNyQyxDQUFDOztBQXZGSCw4R0F3RkM7OztBQVVELFNBQWdCLDhEQUE4RCxDQUFDLE1BQTREO0lBQ3pJLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUNqRCxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsSUFBSSxDQUFDO1FBQzNDLFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLFNBQVMsQ0FBQztRQUNyRCxLQUFLLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxLQUFLLENBQUM7S0FDOUMsQ0FBQTtBQUNILENBQUM7QUFWRCx3SUFVQztBQVdELFNBQWdCLDZDQUE2QyxDQUFDLE1BQStGO0lBQzNKLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUNqRCxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDLENBQUMsTUFBTyxDQUFDLFNBQVMsQ0FBQztRQUN4RSxZQUFZLEVBQUUsS0FBSyxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxNQUFPLENBQUMsV0FBVyxDQUFDO1FBQzVFLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxVQUFVLENBQUMsOERBQThELENBQUMsQ0FBQyxNQUFPLENBQUMsaUJBQWlCLENBQUM7S0FDbEksQ0FBQTtBQUNILENBQUM7QUFWRCxzR0FVQzs7OztBQUVELE1BQWEsaURBQWtELFNBQVEsS0FBSyxDQUFDLGFBQWE7Ozs7Ozs7SUFJeEYsWUFBbUIsaUJBQTJDLEVBQUUsa0JBQTBCLEVBQUUsWUFBcUI7UUFDL0csS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFlBQVksQ0FBQyxDQUFDO1FBSnJELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBSzlCLENBQUM7Ozs7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDbkIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQztTQUNqRDtRQUNELElBQUksSUFBSSxDQUFDLFlBQVksRUFBRTtZQUNyQixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDO1NBQ3JEO1FBQ0QsSUFBSSxJQUFJLENBQUMsa0JBQWtCLEVBQUU7WUFDM0IsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxpQkFBaUIsR0FBRyxJQUFJLENBQUMsa0JBQWtCLENBQUM7U0FDakU7UUFDRCxPQUFPLFlBQVksQ0FBQyxDQUFDLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDLFNBQVMsQ0FBQztJQUN4RCxDQUFDOzs7O0lBRUQsSUFBVyxhQUFhLENBQUMsS0FBcUQ7UUFDNUUsSUFBSSxLQUFLLEtBQUssU0FBUyxFQUFFO1lBQ3ZCLElBQUksQ0FBQyxhQUFhLEdBQUcsS0FBSyxDQUFDO1lBQzNCLElBQUksQ0FBQyxVQUFVLEdBQUcsU0FBUyxDQUFDO1lBQzVCLElBQUksQ0FBQyxZQUFZLEdBQUcsU0FBUyxDQUFDO1lBQzlCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7U0FDckM7YUFDSTtZQUNILElBQUksQ0FBQyxhQUFhLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxNQUFNLEtBQUssQ0FBQyxDQUFDO1lBQ3JELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFNBQVMsQ0FBQztZQUNsQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7WUFDdEMsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQztTQUNuRDtJQUNILENBQUM7Ozs7SUFJRCxJQUFXLFNBQVM7UUFDbEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDN0MsQ0FBQzs7OztJQUNELElBQVcsU0FBUyxDQUFDLEtBQWU7UUFDbEMsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQzs7OztJQUNNLGNBQWM7UUFDbkIsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7SUFDOUIsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLGNBQWM7UUFDdkIsT0FBTyxJQUFJLENBQUMsVUFBVSxDQUFDO0lBQ3pCLENBQUM7Ozs7SUFJRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDL0MsQ0FBQzs7OztJQUNELElBQVcsV0FBVyxDQUFDLEtBQWU7UUFDcEMsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUM7SUFDNUIsQ0FBQzs7OztJQUNNLGdCQUFnQjtRQUNyQixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztJQUNoQyxDQUFDO0lBQ0Qsb0RBQW9EOzs7O0lBQ3BELElBQVcsZ0JBQWdCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FBQztJQUMzQixDQUFDOzs7O0lBSUQsSUFBVyxpQkFBaUI7UUFDMUIsb0RBQW9EO1FBQ3BELE9BQU8sSUFBSSxDQUFDLHlCQUF5QixDQUFDLHNCQUFzQixDQUFRLENBQUM7SUFDdkUsQ0FBQzs7OztJQUNELElBQVcsaUJBQWlCLENBQUMsS0FBNEQ7UUFDdkYsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQztJQUNsQyxDQUFDOzs7O0lBQ00sc0JBQXNCO1FBQzNCLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxTQUFTLENBQUM7SUFDdEMsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLHNCQUFzQjtRQUMvQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQztJQUNqQyxDQUFDOztBQXhGSCw4R0F5RkM7OztBQVlELFNBQWdCLHNDQUFzQyxDQUFDLE1BQW9DO0lBQ3pGLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQUUsT0FBTyxNQUFNLENBQUM7S0FBRTtJQUNqRCxJQUFJLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLENBQUMsRUFBRTtRQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG9IQUFvSCxDQUFDLENBQUM7S0FDdkk7SUFDRCxPQUFPO1FBQ0wsT0FBTyxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxNQUFPLENBQUMsT0FBTyxDQUFDO1FBQ2xELElBQUksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLElBQUksQ0FBQztRQUMzQyxPQUFPLEVBQUUsNkNBQTZDLENBQUMsTUFBTyxDQUFDLE9BQU8sQ0FBQztRQUN2RSxPQUFPLEVBQUUsNkNBQTZDLENBQUMsTUFBTyxDQUFDLE9BQU8sQ0FBQztLQUN4RSxDQUFBO0FBQ0gsQ0FBQztBQVhELHdGQVdDO0FBYUQsU0FBZ0IsMENBQTBDLENBQUMsTUFBeUY7SUFDbEosSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLEVBQUU7UUFBRSxPQUFPLE1BQU0sQ0FBQztLQUFFO0lBQ2pELElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxFQUFFO1FBQ2xDLE1BQU0sSUFBSSxLQUFLLENBQUMsb0hBQW9ILENBQUMsQ0FBQztLQUN2STtJQUNELE9BQU87UUFDTCxNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxNQUFNLENBQUM7UUFDL0MsTUFBTSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxNQUFPLENBQUMsTUFBTSxDQUFDO1FBQy9DLElBQUksRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTyxDQUFDLElBQUksQ0FBQztRQUMzQyxNQUFNLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLE1BQU8sQ0FBQyxNQUFNLENBQUM7S0FDaEQsQ0FBQTtBQUNILENBQUM7QUFYRCxnR0FXQzs7OztBQUVELE1BQWEsOENBQStDLFNBQVEsS0FBSyxDQUFDLGFBQWE7Ozs7Ozs7SUFJckYsWUFBbUIsaUJBQTJDLEVBQUUsa0JBQTBCLEVBQUUsWUFBcUI7UUFDL0csS0FBSyxDQUFDLGlCQUFpQixFQUFFLGtCQUFrQixFQUFFLFlBQVksQ0FBQyxDQUFDO1FBSnJELGtCQUFhLEdBQUcsS0FBSyxDQUFDO0lBSzlCLENBQUM7Ozs7SUFFRCxJQUFXLGFBQWE7UUFDdEIsSUFBSSxZQUFZLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQztRQUN0QyxNQUFNLG1CQUFtQixHQUFRLEVBQUUsQ0FBQztRQUNwQyxJQUFJLElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDaEIsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztTQUMzQztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNoQixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ2QsWUFBWSxHQUFHLElBQUksQ0FBQztZQUNwQixtQkFBbUIsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQztTQUN2QztRQUNELElBQUksSUFBSSxDQUFDLE9BQU8sRUFBRTtZQUNoQixZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3BCLG1CQUFtQixDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO1NBQzNDO1FBQ0QsT0FBTyxZQUFZLENBQUMsQ0FBQyxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUM7SUFDeEQsQ0FBQzs7OztJQUVELElBQVcsYUFBYSxDQUFDLEtBQWtEO1FBQ3pFLElBQUksS0FBSyxLQUFLLFNBQVMsRUFBRTtZQUN2QixJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztZQUMzQixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztZQUN6QixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztZQUN6QixJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztZQUN2QixJQUFJLENBQUMsT0FBTyxHQUFHLFNBQVMsQ0FBQztTQUMxQjthQUNJO1lBQ0gsSUFBSSxDQUFDLGFBQWEsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUM7WUFDckQsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1lBQzVCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztZQUM1QixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7WUFDeEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1NBQzdCO0lBQ0gsQ0FBQzs7OztJQUlELElBQVcsTUFBTTtRQUNmLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzNDLENBQUM7Ozs7SUFDRCxJQUFXLE1BQU0sQ0FBQyxLQUFhO1FBQzdCLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0lBQ3ZCLENBQUM7Ozs7SUFDTSxXQUFXO1FBQ2hCLElBQUksQ0FBQyxPQUFPLEdBQUcsU0FBUyxDQUFDO0lBQzNCLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxXQUFXO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQztJQUN0QixDQUFDOzs7O0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQzs7OztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQzs7OztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7Ozs7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDOzs7O0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDOzs7O0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDOzs7O0lBSUQsSUFBVyxNQUFNO1FBQ2YsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDM0MsQ0FBQzs7OztJQUNELElBQVcsTUFBTSxDQUFDLEtBQWE7UUFDN0IsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7SUFDdkIsQ0FBQzs7OztJQUNNLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxTQUFTLENBQUM7SUFDM0IsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLFdBQVc7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDO0lBQ3RCLENBQUM7O0FBN0dILHdHQThHQzs7Ozs7Ozs7QUFHRCxNQUFhLHVCQUF3QixTQUFRLEtBQUssQ0FBQyxpQkFBaUI7SUFPbEUsY0FBYztJQUNkLGNBQWM7SUFDZCxjQUFjOzs7Ozs7OztJQUdkLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQXFDO1FBQ3BGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsbUNBQW1DO1lBQzFELDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsU0FBUzthQUN4QjtZQUNELFFBQVEsRUFBRSxNQUFNLENBQUMsUUFBUTtZQUN6QixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsS0FBSyxFQUFFLE1BQU0sQ0FBQyxLQUFLO1lBQ25CLFNBQVMsRUFBRSxNQUFNLENBQUMsU0FBUztTQUM1QixDQUFDLENBQUM7UUE2Q0wsOERBQThEO1FBQ3RELGNBQVMsR0FBRyxJQUFJLDhDQUE4QyxDQUFDLElBQVcsRUFBRSxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUE3Q3BHLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxNQUFNLENBQUMsZ0JBQWdCLENBQUM7UUFDakQsSUFBSSxDQUFDLEtBQUssR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDO1FBQ3pCLElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7SUFDakQsQ0FBQztJQUVELGFBQWE7SUFDYixhQUFhO0lBQ2IsYUFBYTtJQUViLHVEQUF1RDs7OztJQUN2RCxJQUFXLEVBQUU7UUFDWCxPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUN2QyxDQUFDOzs7O0lBSUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2RCxDQUFDOzs7O0lBQ0QsSUFBVyxnQkFBZ0IsQ0FBQyxLQUFhO1FBQ3ZDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7SUFDakMsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLHFCQUFxQjtRQUM5QixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDOzs7O0lBSUQsSUFBVyxJQUFJO1FBQ2Isb0RBQW9EO1FBQ3BELE9BQU8sSUFBSSxDQUFDLHlCQUF5QixDQUFDLE1BQU0sQ0FBUSxDQUFDO0lBQ3ZELENBQUM7Ozs7SUFDRCxJQUFXLElBQUksQ0FBQyxLQUFvQztRQUNsRCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDOzs7O0lBQ00sU0FBUztRQUNkLElBQUksQ0FBQyxLQUFLLEdBQUcsU0FBUyxDQUFDO0lBQ3pCLENBQUM7SUFDRCxvREFBb0Q7Ozs7SUFDcEQsSUFBVyxTQUFTO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDOzs7O0lBSUQsSUFBVyxRQUFRO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQztJQUN4QixDQUFDOzs7O0lBQ00sV0FBVyxDQUFDLEtBQXNDO1FBQ3ZELElBQUksQ0FBQyxTQUFTLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQztJQUN2QyxDQUFDOzs7O0lBQ00sYUFBYTtRQUNsQixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsR0FBRyxTQUFTLENBQUM7SUFDM0MsQ0FBQztJQUNELG9EQUFvRDs7OztJQUNwRCxJQUFXLGFBQWE7UUFDdEIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQztJQUN0QyxDQUFDO0lBRUQsWUFBWTtJQUNaLFlBQVk7SUFDWixZQUFZOzs7O0lBRUYsb0JBQW9CO1FBQzVCLE9BQU87WUFDTCxrQkFBa0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDO1lBQ25FLElBQUksRUFBRSxLQUFLLENBQUMsVUFBVSxDQUFDLHNDQUFzQyxDQUFDLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQztZQUMxRSxRQUFRLEVBQUUsMENBQTBDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxhQUFhLENBQUM7U0FDbkYsQ0FBQztJQUNKLENBQUM7O0FBN0ZILDBEQThGQzs7O0FBNUZDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9COzs7O0FBQ0csc0NBQWMsR0FBVyxtQ0FBbUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy9henVyZXJtL3Ivc3RvcmFnZV9tYW5hZ2VtZW50X3BvbGljeS5odG1sXG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lDb25maWcgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgc3RvcmFnZUFjY291bnRJZDogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcnVsZT86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZVtdO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGltZW91dHM/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzO1xufVxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2Ige1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2JUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2JPdXRwdXRSZWZlcmVuY2UgfCBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2IpOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4pLFxuICAgIHRpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW46IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEudGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4pLFxuICAgIHRpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW46IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEudGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4pLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2JPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklUZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsIGlzU2luZ2xlSXRlbTogYm9vbGVhbikge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGlzU2luZ2xlSXRlbSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3RpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC50aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHRoaXMuX3RpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICAgIH1cbiAgICBpZiAodGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4pIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW47XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2IgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fdGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl90aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHVuZGVmaW5lZDtcbiAgICB9XG4gICAgZWxzZSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBPYmplY3Qua2V5cyh2YWx1ZSkubGVuZ3RoID09PSAwO1xuICAgICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHZhbHVlLmRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW47XG4gICAgICB0aGlzLl90aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHZhbHVlLnRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICAgICAgdGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB2YWx1ZS50aWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbjtcbiAgICB9XG4gIH1cblxuICAvLyBkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuJyk7XG4gIH1cbiAgcHVibGljIHNldCBkZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGVsZXRlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbigpIHtcbiAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZWxldGVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW47XG4gIH1cblxuICAvLyB0aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9tb2RpZmljYXRpb25fZ3JlYXRlcl90aGFuIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3RpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCB0aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ3RpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4nKTtcbiAgfVxuICBwdWJsaWMgc2V0IHRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl90aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKCkge1xuICAgIHRoaXMuX3RpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB0aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl90aWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VNb2RpZmljYXRpb25HcmVhdGVyVGhhbjtcbiAgfVxuXG4gIC8vIHRpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX21vZGlmaWNhdGlvbl9ncmVhdGVyX3RoYW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IHRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgndGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfbW9kaWZpY2F0aW9uX2dyZWF0ZXJfdGhhbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4odmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX3RpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0VGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4oKSB7XG4gICAgdGhpcy5fdGllclRvQ29vbEFmdGVyRGF5c1NpbmNlTW9kaWZpY2F0aW9uR3JlYXRlclRoYW4gPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RpZXJUb0Nvb2xBZnRlckRheXNTaW5jZU1vZGlmaWNhdGlvbkdyZWF0ZXJUaGFuO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdCB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uPzogbnVtYmVyO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuPzogbnVtYmVyO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90VG9UZXJyYWZvcm0oc3RydWN0PzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90T3V0cHV0UmVmZXJlbmNlIHwgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90KTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgY2hhbmdlX3RpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybShzdHJ1Y3QhLmNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKSxcbiAgICBjaGFuZ2VfdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb246IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24pLFxuICAgIGRlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uX2dyZWF0ZXJfdGhhbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4pLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zU25hcHNob3RPdXRwdXRSZWZlcmVuY2UgZXh0ZW5kcyBjZGt0Zi5Db21wbGV4T2JqZWN0IHtcbiAgcHJpdmF0ZSBpc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3IodGVycmFmb3JtUmVzb3VyY2U6IGNka3RmLklUZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlOiBzdHJpbmcsIGlzU2luZ2xlSXRlbTogYm9vbGVhbikge1xuICAgIHN1cGVyKHRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGUsIGlzU2luZ2xlSXRlbSk7XG4gIH1cblxuICBwdWJsaWMgZ2V0IGludGVybmFsVmFsdWUoKTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90IHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbikge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgIH1cbiAgICBpZiAodGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4gPSB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW47XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zU25hcHNob3QgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlLmNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgICAgdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZS5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbiA9IHZhbHVlLmRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbjtcbiAgICB9XG4gIH1cblxuICAvLyBjaGFuZ2VfdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnY2hhbmdlX3RpZXJfdG9fYXJjaGl2ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBjaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbigpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gIH1cblxuICAvLyBjaGFuZ2VfdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnY2hhbmdlX3RpZXJfdG9fY29vbF9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBjaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRDaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbigpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gIH1cblxuICAvLyBkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbl9ncmVhdGVyX3RoYW4gLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBkZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uR3JlYXRlclRoYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbl9ncmVhdGVyX3RoYW4nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuKCkge1xuICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbkdyZWF0ZXJUaGFuSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb25HcmVhdGVyVGhhbjtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uPzogbnVtYmVyO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvblRvVGVycmFmb3JtKHN0cnVjdD86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uT3V0cHV0UmVmZXJlbmNlIHwgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1ZlcnNpb24pOiBhbnkge1xuICBpZiAoIWNka3RmLmNhbkluc3BlY3Qoc3RydWN0KSkgeyByZXR1cm4gc3RydWN0OyB9XG4gIGlmIChjZGt0Zi5pc0NvbXBsZXhFbGVtZW50KHN0cnVjdCkpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoXCJBIGNvbXBsZXggZWxlbWVudCB3YXMgdXNlZCBhcyBjb25maWd1cmF0aW9uLCB0aGlzIGlzIG5vdCBzdXBwb3J0ZWQ6IGh0dHBzOi8vY2RrLnRmL2NvbXBsZXgtb2JqZWN0LWFzLWNvbmZpZ3VyYXRpb25cIik7XG4gIH1cbiAgcmV0dXJuIHtcbiAgICBjaGFuZ2VfdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb246IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24pLFxuICAgIGNoYW5nZV90aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0oc3RydWN0IS5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiksXG4gICAgZGVsZXRlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb246IGNka3RmLm51bWJlclRvVGVycmFmb3JtKHN0cnVjdCEuZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiksXG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JVGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLCBpc1NpbmdsZUl0ZW06IGJvb2xlYW4pIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBpc1NpbmdsZUl0ZW0pO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbikge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgIH1cbiAgICBpZiAodGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbikge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb247XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbiB8IHVuZGVmaW5lZCkge1xuICAgIGlmICh2YWx1ZSA9PT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aGlzLmlzRW1wdHlPYmplY3QgPSBmYWxzZTtcbiAgICAgIHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlLmNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgICAgdGhpcy5fY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZS5jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgICAgIHRoaXMuX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24gPSB2YWx1ZS5kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICAgIH1cbiAgfVxuXG4gIC8vIGNoYW5nZV90aWVyX3RvX2FyY2hpdmVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQXJjaGl2ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjaGFuZ2VfdGllcl90b19hcmNoaXZlX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHRoaXMuX2NoYW5nZVRpZXJUb0FyY2hpdmVBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jaGFuZ2VUaWVyVG9BcmNoaXZlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgfVxuXG4gIC8vIGNoYW5nZV90aWVyX3RvX2Nvb2xfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgY2hhbmdlVGllclRvQ29vbEFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdjaGFuZ2VfdGllcl90b19jb29sX2FmdGVyX2RheXNfc2luY2VfY3JlYXRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uKCkge1xuICAgIHRoaXMuX2NoYW5nZVRpZXJUb0Nvb2xBZnRlckRheXNTaW5jZUNyZWF0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jaGFuZ2VUaWVyVG9Db29sQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbjtcbiAgfVxuXG4gIC8vIGRlbGV0ZV9hZnRlcl9kYXlzX3NpbmNlX2NyZWF0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2RlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGRlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdkZWxldGVfYWZ0ZXJfZGF5c19zaW5jZV9jcmVhdGlvbicpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldERlbGV0ZUFmdGVyRGF5c1NpbmNlQ3JlYXRpb24oKSB7XG4gICAgdGhpcy5fZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgZGVsZXRlQWZ0ZXJEYXlzU2luY2VDcmVhdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9kZWxldGVBZnRlckRheXNTaW5jZUNyZWF0aW9uO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYmFzZUJsb2I/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zQmFzZUJsb2I7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBzbmFwc2hvdD86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdDtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZlcnNpb24/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNUb1RlcnJhZm9ybShzdHJ1Y3Q/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zT3V0cHV0UmVmZXJlbmNlIHwgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9ucyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGJhc2VfYmxvYjogc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iVG9UZXJyYWZvcm0oc3RydWN0IS5iYXNlQmxvYiksXG4gICAgc25hcHNob3Q6IHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNTbmFwc2hvdFRvVGVycmFmb3JtKHN0cnVjdCEuc25hcHNob3QpLFxuICAgIHZlcnNpb246IHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNWZXJzaW9uVG9UZXJyYWZvcm0oc3RydWN0IS52ZXJzaW9uKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSVRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZywgaXNTaW5nbGVJdGVtOiBib29sZWFuKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgaXNTaW5nbGVJdGVtKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9iYXNlQmxvYj8uaW50ZXJuYWxWYWx1ZSkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuYmFzZUJsb2IgPSB0aGlzLl9iYXNlQmxvYj8uaW50ZXJuYWxWYWx1ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX3NuYXBzaG90Py5pbnRlcm5hbFZhbHVlKSB7XG4gICAgICBoYXNBbnlWYWx1ZXMgPSB0cnVlO1xuICAgICAgaW50ZXJuYWxWYWx1ZVJlc3VsdC5zbmFwc2hvdCA9IHRoaXMuX3NuYXBzaG90Py5pbnRlcm5hbFZhbHVlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fdmVyc2lvbj8uaW50ZXJuYWxWYWx1ZSkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQudmVyc2lvbiA9IHRoaXMuX3ZlcnNpb24/LmludGVybmFsVmFsdWU7XG4gICAgfVxuICAgIHJldHVybiBoYXNBbnlWYWx1ZXMgPyBpbnRlcm5hbFZhbHVlUmVzdWx0IDogdW5kZWZpbmVkO1xuICB9XG5cbiAgcHVibGljIHNldCBpbnRlcm5hbFZhbHVlKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zIHwgdW5kZWZpbmVkKSB7XG4gICAgaWYgKHZhbHVlID09PSB1bmRlZmluZWQpIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuICAgICAgdGhpcy5fYmFzZUJsb2IuaW50ZXJuYWxWYWx1ZSA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX3NuYXBzaG90LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl92ZXJzaW9uLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gICAgfVxuICAgIGVsc2Uge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gT2JqZWN0LmtleXModmFsdWUpLmxlbmd0aCA9PT0gMDtcbiAgICAgIHRoaXMuX2Jhc2VCbG9iLmludGVybmFsVmFsdWUgPSB2YWx1ZS5iYXNlQmxvYjtcbiAgICAgIHRoaXMuX3NuYXBzaG90LmludGVybmFsVmFsdWUgPSB2YWx1ZS5zbmFwc2hvdDtcbiAgICAgIHRoaXMuX3ZlcnNpb24uaW50ZXJuYWxWYWx1ZSA9IHZhbHVlLnZlcnNpb247XG4gICAgfVxuICB9XG5cbiAgLy8gYmFzZV9ibG9iIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Jhc2VCbG9iID0gbmV3IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnNCYXNlQmxvYk91dHB1dFJlZmVyZW5jZSh0aGlzIGFzIGFueSwgXCJiYXNlX2Jsb2JcIiwgdHJ1ZSk7XG4gIHB1YmxpYyBnZXQgYmFzZUJsb2IoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Jhc2VCbG9iO1xuICB9XG4gIHB1YmxpYyBwdXRCYXNlQmxvYih2YWx1ZTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc0Jhc2VCbG9iKSB7XG4gICAgdGhpcy5fYmFzZUJsb2IuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEJhc2VCbG9iKCkge1xuICAgIHRoaXMuX2Jhc2VCbG9iLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJhc2VCbG9iSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2Jhc2VCbG9iLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyBzbmFwc2hvdCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9zbmFwc2hvdCA9IG5ldyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zU25hcHNob3RPdXRwdXRSZWZlcmVuY2UodGhpcyBhcyBhbnksIFwic25hcHNob3RcIiwgdHJ1ZSk7XG4gIHB1YmxpYyBnZXQgc25hcHNob3QoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NuYXBzaG90O1xuICB9XG4gIHB1YmxpYyBwdXRTbmFwc2hvdCh2YWx1ZTogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1NuYXBzaG90KSB7XG4gICAgdGhpcy5fc25hcHNob3QuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFNuYXBzaG90KCkge1xuICAgIHRoaXMuX3NuYXBzaG90LmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHNuYXBzaG90SW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3NuYXBzaG90LmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyB2ZXJzaW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3ZlcnNpb24gPSBuZXcgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1ZlcnNpb25PdXRwdXRSZWZlcmVuY2UodGhpcyBhcyBhbnksIFwidmVyc2lvblwiLCB0cnVlKTtcbiAgcHVibGljIGdldCB2ZXJzaW9uKCkge1xuICAgIHJldHVybiB0aGlzLl92ZXJzaW9uO1xuICB9XG4gIHB1YmxpYyBwdXRWZXJzaW9uKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVBY3Rpb25zVmVyc2lvbikge1xuICAgIHRoaXMuX3ZlcnNpb24uaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFZlcnNpb24oKSB7XG4gICAgdGhpcy5fdmVyc2lvbi5pbnRlcm5hbFZhbHVlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCB2ZXJzaW9uSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3ZlcnNpb24uaW50ZXJuYWxWYWx1ZTtcbiAgfVxufVxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzTWF0Y2hCbG9iSW5kZXhUYWcge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgb3BlcmF0aW9uPzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdmFsdWU6IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNNYXRjaEJsb2JJbmRleFRhZ1RvVGVycmFmb3JtKHN0cnVjdD86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNNYXRjaEJsb2JJbmRleFRhZyk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIG5hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEubmFtZSksXG4gICAgb3BlcmF0aW9uOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLm9wZXJhdGlvbiksXG4gICAgdmFsdWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEudmFsdWUpLFxuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVycyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYmxvYlR5cGVzPzogc3RyaW5nW107XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHByZWZpeE1hdGNoPzogc3RyaW5nW107XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBtYXRjaEJsb2JJbmRleFRhZz86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNNYXRjaEJsb2JJbmRleFRhZ1tdO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc1RvVGVycmFmb3JtKHN0cnVjdD86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnNPdXRwdXRSZWZlcmVuY2UgfCBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgYmxvYl90eXBlczogY2RrdGYubGlzdE1hcHBlcihjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSkoc3RydWN0IS5ibG9iVHlwZXMpLFxuICAgIHByZWZpeF9tYXRjaDogY2RrdGYubGlzdE1hcHBlcihjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSkoc3RydWN0IS5wcmVmaXhNYXRjaCksXG4gICAgbWF0Y2hfYmxvYl9pbmRleF90YWc6IGNka3RmLmxpc3RNYXBwZXIoc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc01hdGNoQmxvYkluZGV4VGFnVG9UZXJyYWZvcm0pKHN0cnVjdCEubWF0Y2hCbG9iSW5kZXhUYWcpLFxuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzT3V0cHV0UmVmZXJlbmNlIGV4dGVuZHMgY2RrdGYuQ29tcGxleE9iamVjdCB7XG4gIHByaXZhdGUgaXNFbXB0eU9iamVjdCA9IGZhbHNlO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGNvbnN0cnVjdG9yKHRlcnJhZm9ybVJlc291cmNlOiBjZGt0Zi5JVGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZTogc3RyaW5nLCBpc1NpbmdsZUl0ZW06IGJvb2xlYW4pIHtcbiAgICBzdXBlcih0ZXJyYWZvcm1SZXNvdXJjZSwgdGVycmFmb3JtQXR0cmlidXRlLCBpc1NpbmdsZUl0ZW0pO1xuICB9XG5cbiAgcHVibGljIGdldCBpbnRlcm5hbFZhbHVlKCk6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnMgfCB1bmRlZmluZWQge1xuICAgIGxldCBoYXNBbnlWYWx1ZXMgPSB0aGlzLmlzRW1wdHlPYmplY3Q7XG4gICAgY29uc3QgaW50ZXJuYWxWYWx1ZVJlc3VsdDogYW55ID0ge307XG4gICAgaWYgKHRoaXMuX2Jsb2JUeXBlcykge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuYmxvYlR5cGVzID0gdGhpcy5fYmxvYlR5cGVzO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcHJlZml4TWF0Y2gpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnByZWZpeE1hdGNoID0gdGhpcy5fcHJlZml4TWF0Y2g7XG4gICAgfVxuICAgIGlmICh0aGlzLl9tYXRjaEJsb2JJbmRleFRhZykge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQubWF0Y2hCbG9iSW5kZXhUYWcgPSB0aGlzLl9tYXRjaEJsb2JJbmRleFRhZztcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUZpbHRlcnMgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9ibG9iVHlwZXMgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9wcmVmaXhNYXRjaCA9IHVuZGVmaW5lZDtcbiAgICAgIHRoaXMuX21hdGNoQmxvYkluZGV4VGFnID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9ibG9iVHlwZXMgPSB2YWx1ZS5ibG9iVHlwZXM7XG4gICAgICB0aGlzLl9wcmVmaXhNYXRjaCA9IHZhbHVlLnByZWZpeE1hdGNoO1xuICAgICAgdGhpcy5fbWF0Y2hCbG9iSW5kZXhUYWcgPSB2YWx1ZS5tYXRjaEJsb2JJbmRleFRhZztcbiAgICB9XG4gIH1cblxuICAvLyBibG9iX3R5cGVzIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2Jsb2JUeXBlcz86IHN0cmluZ1tdOyBcbiAgcHVibGljIGdldCBibG9iVHlwZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgnYmxvYl90eXBlcycpO1xuICB9XG4gIHB1YmxpYyBzZXQgYmxvYlR5cGVzKHZhbHVlOiBzdHJpbmdbXSkge1xuICAgIHRoaXMuX2Jsb2JUeXBlcyA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldEJsb2JUeXBlcygpIHtcbiAgICB0aGlzLl9ibG9iVHlwZXMgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGJsb2JUeXBlc0lucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9ibG9iVHlwZXM7XG4gIH1cblxuICAvLyBwcmVmaXhfbWF0Y2ggLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfcHJlZml4TWF0Y2g/OiBzdHJpbmdbXTsgXG4gIHB1YmxpYyBnZXQgcHJlZml4TWF0Y2goKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TGlzdEF0dHJpYnV0ZSgncHJlZml4X21hdGNoJyk7XG4gIH1cbiAgcHVibGljIHNldCBwcmVmaXhNYXRjaCh2YWx1ZTogc3RyaW5nW10pIHtcbiAgICB0aGlzLl9wcmVmaXhNYXRjaCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFByZWZpeE1hdGNoKCkge1xuICAgIHRoaXMuX3ByZWZpeE1hdGNoID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBwcmVmaXhNYXRjaElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9wcmVmaXhNYXRjaDtcbiAgfVxuXG4gIC8vIG1hdGNoX2Jsb2JfaW5kZXhfdGFnIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21hdGNoQmxvYkluZGV4VGFnPzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc01hdGNoQmxvYkluZGV4VGFnW107IFxuICBwdWJsaWMgZ2V0IG1hdGNoQmxvYkluZGV4VGFnKCkge1xuICAgIC8vIEdldHRpbmcgdGhlIGNvbXB1dGVkIHZhbHVlIGlzIG5vdCB5ZXQgaW1wbGVtZW50ZWRcbiAgICByZXR1cm4gdGhpcy5pbnRlcnBvbGF0aW9uRm9yQXR0cmlidXRlKCdtYXRjaF9ibG9iX2luZGV4X3RhZycpIGFzIGFueTtcbiAgfVxuICBwdWJsaWMgc2V0IG1hdGNoQmxvYkluZGV4VGFnKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVGaWx0ZXJzTWF0Y2hCbG9iSW5kZXhUYWdbXSkge1xuICAgIHRoaXMuX21hdGNoQmxvYkluZGV4VGFnID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0TWF0Y2hCbG9iSW5kZXhUYWcoKSB7XG4gICAgdGhpcy5fbWF0Y2hCbG9iSW5kZXhUYWcgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG1hdGNoQmxvYkluZGV4VGFnSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX21hdGNoQmxvYkluZGV4VGFnO1xuICB9XG59XG5leHBvcnQgaW50ZXJmYWNlIFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZW5hYmxlZDogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IG5hbWU6IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGFjdGlvbnM6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZUFjdGlvbnM7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBmaWx0ZXJzPzogU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVycztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZVRvVGVycmFmb3JtKHN0cnVjdD86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZSk6IGFueSB7XG4gIGlmICghY2RrdGYuY2FuSW5zcGVjdChzdHJ1Y3QpKSB7IHJldHVybiBzdHJ1Y3Q7IH1cbiAgaWYgKGNka3RmLmlzQ29tcGxleEVsZW1lbnQoc3RydWN0KSkge1xuICAgIHRocm93IG5ldyBFcnJvcihcIkEgY29tcGxleCBlbGVtZW50IHdhcyB1c2VkIGFzIGNvbmZpZ3VyYXRpb24sIHRoaXMgaXMgbm90IHN1cHBvcnRlZDogaHR0cHM6Ly9jZGsudGYvY29tcGxleC1vYmplY3QtYXMtY29uZmlndXJhdGlvblwiKTtcbiAgfVxuICByZXR1cm4ge1xuICAgIGVuYWJsZWQ6IGNka3RmLmJvb2xlYW5Ub1RlcnJhZm9ybShzdHJ1Y3QhLmVuYWJsZWQpLFxuICAgIG5hbWU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEubmFtZSksXG4gICAgYWN0aW9uczogc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlQWN0aW9uc1RvVGVycmFmb3JtKHN0cnVjdCEuYWN0aW9ucyksXG4gICAgZmlsdGVyczogc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lSdWxlRmlsdGVyc1RvVGVycmFmb3JtKHN0cnVjdCEuZmlsdGVycyksXG4gIH1cbn1cblxuZXhwb3J0IGludGVyZmFjZSBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY3JlYXRlPzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBkZWxldGU/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcmVhZD86IHN0cmluZztcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdXBkYXRlPzogc3RyaW5nO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0c1RvVGVycmFmb3JtKHN0cnVjdD86IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5VGltZW91dHNPdXRwdXRSZWZlcmVuY2UgfCBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzKTogYW55IHtcbiAgaWYgKCFjZGt0Zi5jYW5JbnNwZWN0KHN0cnVjdCkpIHsgcmV0dXJuIHN0cnVjdDsgfVxuICBpZiAoY2RrdGYuaXNDb21wbGV4RWxlbWVudChzdHJ1Y3QpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKFwiQSBjb21wbGV4IGVsZW1lbnQgd2FzIHVzZWQgYXMgY29uZmlndXJhdGlvbiwgdGhpcyBpcyBub3Qgc3VwcG9ydGVkOiBodHRwczovL2Nkay50Zi9jb21wbGV4LW9iamVjdC1hcy1jb25maWd1cmF0aW9uXCIpO1xuICB9XG4gIHJldHVybiB7XG4gICAgY3JlYXRlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLmNyZWF0ZSksXG4gICAgZGVsZXRlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybShzdHJ1Y3QhLmRlbGV0ZSksXG4gICAgcmVhZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0oc3RydWN0IS5yZWFkKSxcbiAgICB1cGRhdGU6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHN0cnVjdCEudXBkYXRlKSxcbiAgfVxufVxuXG5leHBvcnQgY2xhc3MgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0c091dHB1dFJlZmVyZW5jZSBleHRlbmRzIGNka3RmLkNvbXBsZXhPYmplY3Qge1xuICBwcml2YXRlIGlzRW1wdHlPYmplY3QgPSBmYWxzZTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcih0ZXJyYWZvcm1SZXNvdXJjZTogY2RrdGYuSVRlcnJhZm9ybVJlc291cmNlLCB0ZXJyYWZvcm1BdHRyaWJ1dGU6IHN0cmluZywgaXNTaW5nbGVJdGVtOiBib29sZWFuKSB7XG4gICAgc3VwZXIodGVycmFmb3JtUmVzb3VyY2UsIHRlcnJhZm9ybUF0dHJpYnV0ZSwgaXNTaW5nbGVJdGVtKTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgaW50ZXJuYWxWYWx1ZSgpOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzIHwgdW5kZWZpbmVkIHtcbiAgICBsZXQgaGFzQW55VmFsdWVzID0gdGhpcy5pc0VtcHR5T2JqZWN0O1xuICAgIGNvbnN0IGludGVybmFsVmFsdWVSZXN1bHQ6IGFueSA9IHt9O1xuICAgIGlmICh0aGlzLl9jcmVhdGUpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LmNyZWF0ZSA9IHRoaXMuX2NyZWF0ZTtcbiAgICB9XG4gICAgaWYgKHRoaXMuX2RlbGV0ZSkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQuZGVsZXRlID0gdGhpcy5fZGVsZXRlO1xuICAgIH1cbiAgICBpZiAodGhpcy5fcmVhZCkge1xuICAgICAgaGFzQW55VmFsdWVzID0gdHJ1ZTtcbiAgICAgIGludGVybmFsVmFsdWVSZXN1bHQucmVhZCA9IHRoaXMuX3JlYWQ7XG4gICAgfVxuICAgIGlmICh0aGlzLl91cGRhdGUpIHtcbiAgICAgIGhhc0FueVZhbHVlcyA9IHRydWU7XG4gICAgICBpbnRlcm5hbFZhbHVlUmVzdWx0LnVwZGF0ZSA9IHRoaXMuX3VwZGF0ZTtcbiAgICB9XG4gICAgcmV0dXJuIGhhc0FueVZhbHVlcyA/IGludGVybmFsVmFsdWVSZXN1bHQgOiB1bmRlZmluZWQ7XG4gIH1cblxuICBwdWJsaWMgc2V0IGludGVybmFsVmFsdWUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5VGltZW91dHMgfCB1bmRlZmluZWQpIHtcbiAgICBpZiAodmFsdWUgPT09IHVuZGVmaW5lZCkge1xuICAgICAgdGhpcy5pc0VtcHR5T2JqZWN0ID0gZmFsc2U7XG4gICAgICB0aGlzLl9jcmVhdGUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9kZWxldGUgPSB1bmRlZmluZWQ7XG4gICAgICB0aGlzLl9yZWFkID0gdW5kZWZpbmVkO1xuICAgICAgdGhpcy5fdXBkYXRlID0gdW5kZWZpbmVkO1xuICAgIH1cbiAgICBlbHNlIHtcbiAgICAgIHRoaXMuaXNFbXB0eU9iamVjdCA9IE9iamVjdC5rZXlzKHZhbHVlKS5sZW5ndGggPT09IDA7XG4gICAgICB0aGlzLl9jcmVhdGUgPSB2YWx1ZS5jcmVhdGU7XG4gICAgICB0aGlzLl9kZWxldGUgPSB2YWx1ZS5kZWxldGU7XG4gICAgICB0aGlzLl9yZWFkID0gdmFsdWUucmVhZDtcbiAgICAgIHRoaXMuX3VwZGF0ZSA9IHZhbHVlLnVwZGF0ZTtcbiAgICB9XG4gIH1cblxuICAvLyBjcmVhdGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfY3JlYXRlPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBjcmVhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0U3RyaW5nQXR0cmlidXRlKCdjcmVhdGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNyZWF0ZSh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fY3JlYXRlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0Q3JlYXRlKCkge1xuICAgIHRoaXMuX2NyZWF0ZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgY3JlYXRlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2NyZWF0ZTtcbiAgfVxuXG4gIC8vIGRlbGV0ZSAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZWxldGU/OiBzdHJpbmc7IFxuICBwdWJsaWMgZ2V0IGRlbGV0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2RlbGV0ZScpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVsZXRlKHZhbHVlOiBzdHJpbmcpIHtcbiAgICB0aGlzLl9kZWxldGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWxldGUoKSB7XG4gICAgdGhpcy5fZGVsZXRlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZWxldGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVsZXRlO1xuICB9XG5cbiAgLy8gcmVhZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9yZWFkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCByZWFkKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgncmVhZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgcmVhZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fcmVhZCA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJlYWQoKSB7XG4gICAgdGhpcy5fcmVhZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcmVhZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9yZWFkO1xuICB9XG5cbiAgLy8gdXBkYXRlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3VwZGF0ZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdXBkYXRlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgndXBkYXRlJyk7XG4gIH1cbiAgcHVibGljIHNldCB1cGRhdGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3VwZGF0ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFVwZGF0ZSgpIHtcbiAgICB0aGlzLl91cGRhdGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHVwZGF0ZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl91cGRhdGU7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3kgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1SZXNvdXJjZSB7XG5cbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgLy8gU1RBVElDIFBST1BFUlRJRVNcbiAgLy8gPT09PT09PT09PT09PT09PT1cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSB0ZlJlc291cmNlVHlwZTogc3RyaW5nID0gXCJhenVyZXJtX3N0b3JhZ2VfbWFuYWdlbWVudF9wb2xpY3lcIjtcblxuICAvLyA9PT09PT09PT09PVxuICAvLyBJTklUSUFMSVpFUlxuICAvLyA9PT09PT09PT09PVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeUNvbmZpZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAnYXp1cmVybV9zdG9yYWdlX21hbmFnZW1lbnRfcG9saWN5JyxcbiAgICAgIHRlcnJhZm9ybUdlbmVyYXRvck1ldGFkYXRhOiB7XG4gICAgICAgIHByb3ZpZGVyTmFtZTogJ2F6dXJlcm0nXG4gICAgICB9LFxuICAgICAgcHJvdmlkZXI6IGNvbmZpZy5wcm92aWRlcixcbiAgICAgIGRlcGVuZHNPbjogY29uZmlnLmRlcGVuZHNPbixcbiAgICAgIGNvdW50OiBjb25maWcuY291bnQsXG4gICAgICBsaWZlY3ljbGU6IGNvbmZpZy5saWZlY3ljbGVcbiAgICB9KTtcbiAgICB0aGlzLl9zdG9yYWdlQWNjb3VudElkID0gY29uZmlnLnN0b3JhZ2VBY2NvdW50SWQ7XG4gICAgdGhpcy5fcnVsZSA9IGNvbmZpZy5ydWxlO1xuICAgIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUgPSBjb25maWcudGltZW91dHM7XG4gIH1cblxuICAvLyA9PT09PT09PT09XG4gIC8vIEFUVFJJQlVURVNcbiAgLy8gPT09PT09PT09PVxuXG4gIC8vIGlkIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cblxuICAvLyBzdG9yYWdlX2FjY291bnRfaWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfc3RvcmFnZUFjY291bnRJZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgc3RvcmFnZUFjY291bnRJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3N0b3JhZ2VfYWNjb3VudF9pZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgc3RvcmFnZUFjY291bnRJZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5fc3RvcmFnZUFjY291bnRJZCA9IHZhbHVlO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBzdG9yYWdlQWNjb3VudElkSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3N0b3JhZ2VBY2NvdW50SWQ7XG4gIH1cblxuICAvLyBydWxlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX3J1bGU/OiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVJ1bGVbXTsgXG4gIHB1YmxpYyBnZXQgcnVsZSgpIHtcbiAgICAvLyBHZXR0aW5nIHRoZSBjb21wdXRlZCB2YWx1ZSBpcyBub3QgeWV0IGltcGxlbWVudGVkXG4gICAgcmV0dXJuIHRoaXMuaW50ZXJwb2xhdGlvbkZvckF0dHJpYnV0ZSgncnVsZScpIGFzIGFueTtcbiAgfVxuICBwdWJsaWMgc2V0IHJ1bGUodmFsdWU6IFN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZVtdKSB7XG4gICAgdGhpcy5fcnVsZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFJ1bGUoKSB7XG4gICAgdGhpcy5fcnVsZSA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgcnVsZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9ydWxlO1xuICB9XG5cbiAgLy8gdGltZW91dHMgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdGltZW91dHMgPSBuZXcgU3RvcmFnZU1hbmFnZW1lbnRQb2xpY3lUaW1lb3V0c091dHB1dFJlZmVyZW5jZSh0aGlzIGFzIGFueSwgXCJ0aW1lb3V0c1wiLCB0cnVlKTtcbiAgcHVibGljIGdldCB0aW1lb3V0cygpIHtcbiAgICByZXR1cm4gdGhpcy5fdGltZW91dHM7XG4gIH1cbiAgcHVibGljIHB1dFRpbWVvdXRzKHZhbHVlOiBTdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzKSB7XG4gICAgdGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldFRpbWVvdXRzKCkge1xuICAgIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHRpbWVvdXRzSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX3RpbWVvdXRzLmludGVybmFsVmFsdWU7XG4gIH1cblxuICAvLyA9PT09PT09PT1cbiAgLy8gU1lOVEhFU0lTXG4gIC8vID09PT09PT09PVxuXG4gIHByb3RlY3RlZCBzeW50aGVzaXplQXR0cmlidXRlcygpOiB7IFtuYW1lOiBzdHJpbmddOiBhbnkgfSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHN0b3JhZ2VfYWNjb3VudF9pZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fc3RvcmFnZUFjY291bnRJZCksXG4gICAgICBydWxlOiBjZGt0Zi5saXN0TWFwcGVyKHN0b3JhZ2VNYW5hZ2VtZW50UG9saWN5UnVsZVRvVGVycmFmb3JtKSh0aGlzLl9ydWxlKSxcbiAgICAgIHRpbWVvdXRzOiBzdG9yYWdlTWFuYWdlbWVudFBvbGljeVRpbWVvdXRzVG9UZXJyYWZvcm0odGhpcy5fdGltZW91dHMuaW50ZXJuYWxWYWx1ZSksXG4gICAgfTtcbiAgfVxufVxuIl19