# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSqlCollectionLogInsightsResult',
    'AwaitableGetSqlCollectionLogInsightsResult',
    'get_sql_collection_log_insights',
    'get_sql_collection_log_insights_output',
]

@pulumi.output_type
class GetSqlCollectionLogInsightsResult:
    """
    A collection of values returned by getSqlCollectionLogInsights.
    """
    def __init__(__self__, filters=None, group_by=None, id=None, sql_collection_id=None, sql_collection_log_insights_collections=None, time_ended=None, time_started=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if group_by and not isinstance(group_by, str):
            raise TypeError("Expected argument 'group_by' to be a str")
        pulumi.set(__self__, "group_by", group_by)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sql_collection_id and not isinstance(sql_collection_id, str):
            raise TypeError("Expected argument 'sql_collection_id' to be a str")
        pulumi.set(__self__, "sql_collection_id", sql_collection_id)
        if sql_collection_log_insights_collections and not isinstance(sql_collection_log_insights_collections, list):
            raise TypeError("Expected argument 'sql_collection_log_insights_collections' to be a list")
        pulumi.set(__self__, "sql_collection_log_insights_collections", sql_collection_log_insights_collections)
        if time_ended and not isinstance(time_ended, str):
            raise TypeError("Expected argument 'time_ended' to be a str")
        pulumi.set(__self__, "time_ended", time_ended)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSqlCollectionLogInsightsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="groupBy")
    def group_by(self) -> Optional[str]:
        return pulumi.get(self, "group_by")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sqlCollectionId")
    def sql_collection_id(self) -> str:
        return pulumi.get(self, "sql_collection_id")

    @property
    @pulumi.getter(name="sqlCollectionLogInsightsCollections")
    def sql_collection_log_insights_collections(self) -> Sequence['outputs.GetSqlCollectionLogInsightsSqlCollectionLogInsightsCollectionResult']:
        """
        The list of sql_collection_log_insights_collection.
        """
        return pulumi.get(self, "sql_collection_log_insights_collections")

    @property
    @pulumi.getter(name="timeEnded")
    def time_ended(self) -> str:
        """
        The time at which the aggregation ended.
        """
        return pulumi.get(self, "time_ended")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The time at which the aggregation started.
        """
        return pulumi.get(self, "time_started")


class AwaitableGetSqlCollectionLogInsightsResult(GetSqlCollectionLogInsightsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlCollectionLogInsightsResult(
            filters=self.filters,
            group_by=self.group_by,
            id=self.id,
            sql_collection_id=self.sql_collection_id,
            sql_collection_log_insights_collections=self.sql_collection_log_insights_collections,
            time_ended=self.time_ended,
            time_started=self.time_started)


def get_sql_collection_log_insights(filters: Optional[Sequence[pulumi.InputType['GetSqlCollectionLogInsightsFilterArgs']]] = None,
                                    group_by: Optional[str] = None,
                                    sql_collection_id: Optional[str] = None,
                                    time_ended: Optional[str] = None,
                                    time_started: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlCollectionLogInsightsResult:
    """
    This data source provides the list of Sql Collection Log Insights in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of the SQL collection log analytics.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_collection_log_insights = oci.DataSafe.get_sql_collection_log_insights(sql_collection_id=oci_data_safe_sql_collection["test_sql_collection"]["id"],
        time_ended=var["sql_collection_log_insight_time_ended"],
        time_started=var["sql_collection_log_insight_time_started"],
        group_by=var["sql_collection_log_insight_group_by"])
    ```


    :param str group_by: The group by parameter to summarize SQL collection log insights aggregation.
    :param str sql_collection_id: The OCID of the SQL collection resource.
    :param str time_ended: An optional filter to return the stats of the SQL collection logs collected before the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    :param str time_started: An optional filter to return the stats of the SQL collection logs collected after the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['groupBy'] = group_by
    __args__['sqlCollectionId'] = sql_collection_id
    __args__['timeEnded'] = time_ended
    __args__['timeStarted'] = time_started
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSqlCollectionLogInsights:getSqlCollectionLogInsights', __args__, opts=opts, typ=GetSqlCollectionLogInsightsResult).value

    return AwaitableGetSqlCollectionLogInsightsResult(
        filters=pulumi.get(__ret__, 'filters'),
        group_by=pulumi.get(__ret__, 'group_by'),
        id=pulumi.get(__ret__, 'id'),
        sql_collection_id=pulumi.get(__ret__, 'sql_collection_id'),
        sql_collection_log_insights_collections=pulumi.get(__ret__, 'sql_collection_log_insights_collections'),
        time_ended=pulumi.get(__ret__, 'time_ended'),
        time_started=pulumi.get(__ret__, 'time_started'))


@_utilities.lift_output_func(get_sql_collection_log_insights)
def get_sql_collection_log_insights_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSqlCollectionLogInsightsFilterArgs']]]]] = None,
                                           group_by: Optional[pulumi.Input[Optional[str]]] = None,
                                           sql_collection_id: Optional[pulumi.Input[str]] = None,
                                           time_ended: Optional[pulumi.Input[str]] = None,
                                           time_started: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSqlCollectionLogInsightsResult]:
    """
    This data source provides the list of Sql Collection Log Insights in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of the SQL collection log analytics.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_collection_log_insights = oci.DataSafe.get_sql_collection_log_insights(sql_collection_id=oci_data_safe_sql_collection["test_sql_collection"]["id"],
        time_ended=var["sql_collection_log_insight_time_ended"],
        time_started=var["sql_collection_log_insight_time_started"],
        group_by=var["sql_collection_log_insight_group_by"])
    ```


    :param str group_by: The group by parameter to summarize SQL collection log insights aggregation.
    :param str sql_collection_id: The OCID of the SQL collection resource.
    :param str time_ended: An optional filter to return the stats of the SQL collection logs collected before the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    :param str time_started: An optional filter to return the stats of the SQL collection logs collected after the date-time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
    """
    ...
