# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SensitiveTypeArgs', 'SensitiveType']

@pulumi.input_type
class SensitiveTypeArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 entity_type: pulumi.Input[str],
                 comment_pattern: Optional[pulumi.Input[str]] = None,
                 data_pattern: Optional[pulumi.Input[str]] = None,
                 default_masking_format_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name_pattern: Optional[pulumi.Input[str]] = None,
                 parent_category_id: Optional[pulumi.Input[str]] = None,
                 search_type: Optional[pulumi.Input[str]] = None,
                 short_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SensitiveType resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the sensitive type should be created.
        :param pulumi.Input[str] entity_type: (Updatable) The entity type. It can be either a sensitive type with regular expressions or a sensitive category used for grouping similar sensitive types.
        :param pulumi.Input[str] comment_pattern: (Updatable) A regular expression to be used by data discovery for matching column comments.
        :param pulumi.Input[str] data_pattern: (Updatable) A regular expression to be used by data discovery for matching column data values.
        :param pulumi.Input[str] default_masking_format_id: (Updatable) The OCID of the library masking format that should be used to mask the sensitive columns associated with the sensitive type.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the sensitive type.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the sensitive type. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name_pattern: (Updatable) A regular expression to be used by data discovery for matching column names.
        :param pulumi.Input[str] parent_category_id: (Updatable) The OCID of the parent sensitive category.
        :param pulumi.Input[str] search_type: (Updatable) The search type indicating how the column name, comment and data patterns should be used by data discovery. [Learn more](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/sensitive-types.html#GUID-1D1AD98E-B93F-4FF2-80AE-CB7D8A14F6CC).
        :param pulumi.Input[str] short_name: (Updatable) The short name of the sensitive type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "entity_type", entity_type)
        if comment_pattern is not None:
            pulumi.set(__self__, "comment_pattern", comment_pattern)
        if data_pattern is not None:
            pulumi.set(__self__, "data_pattern", data_pattern)
        if default_masking_format_id is not None:
            pulumi.set(__self__, "default_masking_format_id", default_masking_format_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name_pattern is not None:
            pulumi.set(__self__, "name_pattern", name_pattern)
        if parent_category_id is not None:
            pulumi.set(__self__, "parent_category_id", parent_category_id)
        if search_type is not None:
            pulumi.set(__self__, "search_type", search_type)
        if short_name is not None:
            pulumi.set(__self__, "short_name", short_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment where the sensitive type should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The entity type. It can be either a sensitive type with regular expressions or a sensitive category used for grouping similar sensitive types.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="commentPattern")
    def comment_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A regular expression to be used by data discovery for matching column comments.
        """
        return pulumi.get(self, "comment_pattern")

    @comment_pattern.setter
    def comment_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment_pattern", value)

    @property
    @pulumi.getter(name="dataPattern")
    def data_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A regular expression to be used by data discovery for matching column data values.
        """
        return pulumi.get(self, "data_pattern")

    @data_pattern.setter
    def data_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_pattern", value)

    @property
    @pulumi.getter(name="defaultMaskingFormatId")
    def default_masking_format_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the library masking format that should be used to mask the sensitive columns associated with the sensitive type.
        """
        return pulumi.get(self, "default_masking_format_id")

    @default_masking_format_id.setter
    def default_masking_format_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_masking_format_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the sensitive type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the sensitive type. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="namePattern")
    def name_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A regular expression to be used by data discovery for matching column names.
        """
        return pulumi.get(self, "name_pattern")

    @name_pattern.setter
    def name_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_pattern", value)

    @property
    @pulumi.getter(name="parentCategoryId")
    def parent_category_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the parent sensitive category.
        """
        return pulumi.get(self, "parent_category_id")

    @parent_category_id.setter
    def parent_category_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_category_id", value)

    @property
    @pulumi.getter(name="searchType")
    def search_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The search type indicating how the column name, comment and data patterns should be used by data discovery. [Learn more](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/sensitive-types.html#GUID-1D1AD98E-B93F-4FF2-80AE-CB7D8A14F6CC).
        """
        return pulumi.get(self, "search_type")

    @search_type.setter
    def search_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_type", value)

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The short name of the sensitive type.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "short_name")

    @short_name.setter
    def short_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "short_name", value)


@pulumi.input_type
class _SensitiveTypeState:
    def __init__(__self__, *,
                 comment_pattern: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_pattern: Optional[pulumi.Input[str]] = None,
                 default_masking_format_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 entity_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name_pattern: Optional[pulumi.Input[str]] = None,
                 parent_category_id: Optional[pulumi.Input[str]] = None,
                 search_type: Optional[pulumi.Input[str]] = None,
                 short_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SensitiveType resources.
        :param pulumi.Input[str] comment_pattern: (Updatable) A regular expression to be used by data discovery for matching column comments.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the sensitive type should be created.
        :param pulumi.Input[str] data_pattern: (Updatable) A regular expression to be used by data discovery for matching column data values.
        :param pulumi.Input[str] default_masking_format_id: (Updatable) The OCID of the library masking format that should be used to mask the sensitive columns associated with the sensitive type.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the sensitive type.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the sensitive type. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[str] entity_type: (Updatable) The entity type. It can be either a sensitive type with regular expressions or a sensitive category used for grouping similar sensitive types.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name_pattern: (Updatable) A regular expression to be used by data discovery for matching column names.
        :param pulumi.Input[str] parent_category_id: (Updatable) The OCID of the parent sensitive category.
        :param pulumi.Input[str] search_type: (Updatable) The search type indicating how the column name, comment and data patterns should be used by data discovery. [Learn more](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/sensitive-types.html#GUID-1D1AD98E-B93F-4FF2-80AE-CB7D8A14F6CC).
        :param pulumi.Input[str] short_name: (Updatable) The short name of the sensitive type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] source: Specifies whether the sensitive type is user-defined or predefined.
        :param pulumi.Input[str] state: The current state of the sensitive type.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the sensitive type was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the sensitive type was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        if comment_pattern is not None:
            pulumi.set(__self__, "comment_pattern", comment_pattern)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if data_pattern is not None:
            pulumi.set(__self__, "data_pattern", data_pattern)
        if default_masking_format_id is not None:
            pulumi.set(__self__, "default_masking_format_id", default_masking_format_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name_pattern is not None:
            pulumi.set(__self__, "name_pattern", name_pattern)
        if parent_category_id is not None:
            pulumi.set(__self__, "parent_category_id", parent_category_id)
        if search_type is not None:
            pulumi.set(__self__, "search_type", search_type)
        if short_name is not None:
            pulumi.set(__self__, "short_name", short_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="commentPattern")
    def comment_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A regular expression to be used by data discovery for matching column comments.
        """
        return pulumi.get(self, "comment_pattern")

    @comment_pattern.setter
    def comment_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment_pattern", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment where the sensitive type should be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dataPattern")
    def data_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A regular expression to be used by data discovery for matching column data values.
        """
        return pulumi.get(self, "data_pattern")

    @data_pattern.setter
    def data_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_pattern", value)

    @property
    @pulumi.getter(name="defaultMaskingFormatId")
    def default_masking_format_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the library masking format that should be used to mask the sensitive columns associated with the sensitive type.
        """
        return pulumi.get(self, "default_masking_format_id")

    @default_masking_format_id.setter
    def default_masking_format_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_masking_format_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the sensitive type.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the sensitive type. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The entity type. It can be either a sensitive type with regular expressions or a sensitive category used for grouping similar sensitive types.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="namePattern")
    def name_pattern(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A regular expression to be used by data discovery for matching column names.
        """
        return pulumi.get(self, "name_pattern")

    @name_pattern.setter
    def name_pattern(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_pattern", value)

    @property
    @pulumi.getter(name="parentCategoryId")
    def parent_category_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the parent sensitive category.
        """
        return pulumi.get(self, "parent_category_id")

    @parent_category_id.setter
    def parent_category_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_category_id", value)

    @property
    @pulumi.getter(name="searchType")
    def search_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The search type indicating how the column name, comment and data patterns should be used by data discovery. [Learn more](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/sensitive-types.html#GUID-1D1AD98E-B93F-4FF2-80AE-CB7D8A14F6CC).
        """
        return pulumi.get(self, "search_type")

    @search_type.setter
    def search_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "search_type", value)

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The short name of the sensitive type.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "short_name")

    @short_name.setter
    def short_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "short_name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the sensitive type is user-defined or predefined.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the sensitive type.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the sensitive type was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the sensitive type was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class SensitiveType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment_pattern: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_pattern: Optional[pulumi.Input[str]] = None,
                 default_masking_format_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 entity_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name_pattern: Optional[pulumi.Input[str]] = None,
                 parent_category_id: Optional[pulumi.Input[str]] = None,
                 search_type: Optional[pulumi.Input[str]] = None,
                 short_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Sensitive Type resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new sensitive type, which can be a basic sensitive type with regular expressions or a sensitive category.
        While sensitive types are used for data discovery, sensitive categories are used for logically grouping the related
        or similar sensitive types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_type = oci.data_safe.SensitiveType("testSensitiveType",
            compartment_id=var["compartment_id"],
            entity_type=var["sensitive_type_entity_type"],
            comment_pattern=var["sensitive_type_comment_pattern"],
            data_pattern=var["sensitive_type_data_pattern"],
            default_masking_format_id=oci_data_safe_default_masking_format["test_default_masking_format"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["sensitive_type_description"],
            display_name=var["sensitive_type_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            name_pattern=var["sensitive_type_name_pattern"],
            parent_category_id=oci_marketplace_category["test_category"]["id"],
            search_type=var["sensitive_type_search_type"],
            short_name=var["sensitive_type_short_name"])
        ```

        ## Import

        SensitiveTypes can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataSafe/sensitiveType:SensitiveType test_sensitive_type "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment_pattern: (Updatable) A regular expression to be used by data discovery for matching column comments.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the sensitive type should be created.
        :param pulumi.Input[str] data_pattern: (Updatable) A regular expression to be used by data discovery for matching column data values.
        :param pulumi.Input[str] default_masking_format_id: (Updatable) The OCID of the library masking format that should be used to mask the sensitive columns associated with the sensitive type.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the sensitive type.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the sensitive type. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[str] entity_type: (Updatable) The entity type. It can be either a sensitive type with regular expressions or a sensitive category used for grouping similar sensitive types.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name_pattern: (Updatable) A regular expression to be used by data discovery for matching column names.
        :param pulumi.Input[str] parent_category_id: (Updatable) The OCID of the parent sensitive category.
        :param pulumi.Input[str] search_type: (Updatable) The search type indicating how the column name, comment and data patterns should be used by data discovery. [Learn more](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/sensitive-types.html#GUID-1D1AD98E-B93F-4FF2-80AE-CB7D8A14F6CC).
        :param pulumi.Input[str] short_name: (Updatable) The short name of the sensitive type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensitiveTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sensitive Type resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new sensitive type, which can be a basic sensitive type with regular expressions or a sensitive category.
        While sensitive types are used for data discovery, sensitive categories are used for logically grouping the related
        or similar sensitive types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_type = oci.data_safe.SensitiveType("testSensitiveType",
            compartment_id=var["compartment_id"],
            entity_type=var["sensitive_type_entity_type"],
            comment_pattern=var["sensitive_type_comment_pattern"],
            data_pattern=var["sensitive_type_data_pattern"],
            default_masking_format_id=oci_data_safe_default_masking_format["test_default_masking_format"]["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["sensitive_type_description"],
            display_name=var["sensitive_type_display_name"],
            freeform_tags={
                "Department": "Finance",
            },
            name_pattern=var["sensitive_type_name_pattern"],
            parent_category_id=oci_marketplace_category["test_category"]["id"],
            search_type=var["sensitive_type_search_type"],
            short_name=var["sensitive_type_short_name"])
        ```

        ## Import

        SensitiveTypes can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataSafe/sensitiveType:SensitiveType test_sensitive_type "id"
        ```

        :param str resource_name: The name of the resource.
        :param SensitiveTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensitiveTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment_pattern: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 data_pattern: Optional[pulumi.Input[str]] = None,
                 default_masking_format_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 entity_type: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 name_pattern: Optional[pulumi.Input[str]] = None,
                 parent_category_id: Optional[pulumi.Input[str]] = None,
                 search_type: Optional[pulumi.Input[str]] = None,
                 short_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensitiveTypeArgs.__new__(SensitiveTypeArgs)

            __props__.__dict__["comment_pattern"] = comment_pattern
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["data_pattern"] = data_pattern
            __props__.__dict__["default_masking_format_id"] = default_masking_format_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if entity_type is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type'")
            __props__.__dict__["entity_type"] = entity_type
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name_pattern"] = name_pattern
            __props__.__dict__["parent_category_id"] = parent_category_id
            __props__.__dict__["search_type"] = search_type
            __props__.__dict__["short_name"] = short_name
            __props__.__dict__["source"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(SensitiveType, __self__).__init__(
            'oci:DataSafe/sensitiveType:SensitiveType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comment_pattern: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            data_pattern: Optional[pulumi.Input[str]] = None,
            default_masking_format_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            entity_type: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            name_pattern: Optional[pulumi.Input[str]] = None,
            parent_category_id: Optional[pulumi.Input[str]] = None,
            search_type: Optional[pulumi.Input[str]] = None,
            short_name: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'SensitiveType':
        """
        Get an existing SensitiveType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment_pattern: (Updatable) A regular expression to be used by data discovery for matching column comments.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment where the sensitive type should be created.
        :param pulumi.Input[str] data_pattern: (Updatable) A regular expression to be used by data discovery for matching column data values.
        :param pulumi.Input[str] default_masking_format_id: (Updatable) The OCID of the library masking format that should be used to mask the sensitive columns associated with the sensitive type.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) The description of the sensitive type.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the sensitive type. The name does not have to be unique, and it's changeable.
        :param pulumi.Input[str] entity_type: (Updatable) The entity type. It can be either a sensitive type with regular expressions or a sensitive category used for grouping similar sensitive types.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] name_pattern: (Updatable) A regular expression to be used by data discovery for matching column names.
        :param pulumi.Input[str] parent_category_id: (Updatable) The OCID of the parent sensitive category.
        :param pulumi.Input[str] search_type: (Updatable) The search type indicating how the column name, comment and data patterns should be used by data discovery. [Learn more](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/sensitive-types.html#GUID-1D1AD98E-B93F-4FF2-80AE-CB7D8A14F6CC).
        :param pulumi.Input[str] short_name: (Updatable) The short name of the sensitive type.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] source: Specifies whether the sensitive type is user-defined or predefined.
        :param pulumi.Input[str] state: The current state of the sensitive type.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the sensitive type was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the sensitive type was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensitiveTypeState.__new__(_SensitiveTypeState)

        __props__.__dict__["comment_pattern"] = comment_pattern
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["data_pattern"] = data_pattern
        __props__.__dict__["default_masking_format_id"] = default_masking_format_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["entity_type"] = entity_type
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["name_pattern"] = name_pattern
        __props__.__dict__["parent_category_id"] = parent_category_id
        __props__.__dict__["search_type"] = search_type
        __props__.__dict__["short_name"] = short_name
        __props__.__dict__["source"] = source
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return SensitiveType(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="commentPattern")
    def comment_pattern(self) -> pulumi.Output[str]:
        """
        (Updatable) A regular expression to be used by data discovery for matching column comments.
        """
        return pulumi.get(self, "comment_pattern")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment where the sensitive type should be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataPattern")
    def data_pattern(self) -> pulumi.Output[str]:
        """
        (Updatable) A regular expression to be used by data discovery for matching column data values.
        """
        return pulumi.get(self, "data_pattern")

    @property
    @pulumi.getter(name="defaultMaskingFormatId")
    def default_masking_format_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the library masking format that should be used to mask the sensitive columns associated with the sensitive type.
        """
        return pulumi.get(self, "default_masking_format_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the sensitive type.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the sensitive type. The name does not have to be unique, and it's changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The entity type. It can be either a sensitive type with regular expressions or a sensitive category used for grouping similar sensitive types.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="namePattern")
    def name_pattern(self) -> pulumi.Output[str]:
        """
        (Updatable) A regular expression to be used by data discovery for matching column names.
        """
        return pulumi.get(self, "name_pattern")

    @property
    @pulumi.getter(name="parentCategoryId")
    def parent_category_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the parent sensitive category.
        """
        return pulumi.get(self, "parent_category_id")

    @property
    @pulumi.getter(name="searchType")
    def search_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The search type indicating how the column name, comment and data patterns should be used by data discovery. [Learn more](https://docs.oracle.com/en/cloud/paas/data-safe/udscs/sensitive-types.html#GUID-1D1AD98E-B93F-4FF2-80AE-CB7D8A14F6CC).
        """
        return pulumi.get(self, "search_type")

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The short name of the sensitive type.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "short_name")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        Specifies whether the sensitive type is user-defined or predefined.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the sensitive type.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the sensitive type was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the sensitive type was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

