# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BackendArgs', 'Backend']

@pulumi.input_type
class BackendArgs:
    def __init__(__self__, *,
                 backendset_name: pulumi.Input[str],
                 ip_address: pulumi.Input[str],
                 load_balancer_id: pulumi.Input[str],
                 port: pulumi.Input[int],
                 backup: Optional[pulumi.Input[bool]] = None,
                 drain: Optional[pulumi.Input[bool]] = None,
                 offline: Optional[pulumi.Input[bool]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Backend resource.
        :param pulumi.Input[str] backendset_name: The name of the backend set to add the backend server to.  Example: `example_backend_set`
        :param pulumi.Input[str] ip_address: The IP address of the backend server.  Example: `10.0.0.3`
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend set and servers.
        :param pulumi.Input[int] port: The communication port for the backend server.  Example: `8080`
        :param pulumi.Input[bool] backup: (Updatable) Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.
               
               **Note:** You cannot add a backend server marked as `backup` to a backend set that uses the IP Hash policy.
               
               Example: `false`
        :param pulumi.Input[bool] drain: (Updatable) Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        :param pulumi.Input[bool] offline: (Updatable) Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param pulumi.Input[int] weight: (Updatable) The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "backendset_name", backendset_name)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "port", port)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if drain is not None:
            pulumi.set(__self__, "drain", drain)
        if offline is not None:
            pulumi.set(__self__, "offline", offline)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="backendsetName")
    def backendset_name(self) -> pulumi.Input[str]:
        """
        The name of the backend set to add the backend server to.  Example: `example_backend_set`
        """
        return pulumi.get(self, "backendset_name")

    @backendset_name.setter
    def backendset_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "backendset_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend set and servers.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.

        **Note:** You cannot add a backend server marked as `backup` to a backend set that uses the IP Hash policy.

        Example: `false`
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter
    def drain(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "drain")

    @drain.setter
    def drain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drain", value)

    @property
    @pulumi.getter
    def offline(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "offline")

    @offline.setter
    def offline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "offline", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class _BackendState:
    def __init__(__self__, *,
                 backendset_name: Optional[pulumi.Input[str]] = None,
                 backup: Optional[pulumi.Input[bool]] = None,
                 drain: Optional[pulumi.Input[bool]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 offline: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 weight: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Backend resources.
        :param pulumi.Input[str] backendset_name: The name of the backend set to add the backend server to.  Example: `example_backend_set`
        :param pulumi.Input[bool] backup: (Updatable) Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.
               
               **Note:** You cannot add a backend server marked as `backup` to a backend set that uses the IP Hash policy.
               
               Example: `false`
        :param pulumi.Input[bool] drain: (Updatable) Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        :param pulumi.Input[str] ip_address: The IP address of the backend server.  Example: `10.0.0.3`
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend set and servers.
        :param pulumi.Input[str] name: A read-only field showing the IP address and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`
        :param pulumi.Input[bool] offline: (Updatable) Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param pulumi.Input[int] port: The communication port for the backend server.  Example: `8080`
        :param pulumi.Input[int] weight: (Updatable) The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if backendset_name is not None:
            pulumi.set(__self__, "backendset_name", backendset_name)
        if backup is not None:
            pulumi.set(__self__, "backup", backup)
        if drain is not None:
            pulumi.set(__self__, "drain", drain)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if offline is not None:
            pulumi.set(__self__, "offline", offline)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="backendsetName")
    def backendset_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the backend set to add the backend server to.  Example: `example_backend_set`
        """
        return pulumi.get(self, "backendset_name")

    @backendset_name.setter
    def backendset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backendset_name", value)

    @property
    @pulumi.getter
    def backup(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.

        **Note:** You cannot add a backend server marked as `backup` to a backend set that uses the IP Hash policy.

        Example: `false`
        """
        return pulumi.get(self, "backup")

    @backup.setter
    def backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup", value)

    @property
    @pulumi.getter
    def drain(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "drain")

    @drain.setter
    def drain(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drain", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend set and servers.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A read-only field showing the IP address and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def offline(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "offline")

    @offline.setter
    def offline(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "offline", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


class Backend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backendset_name: Optional[pulumi.Input[str]] = None,
                 backup: Optional[pulumi.Input[bool]] = None,
                 drain: Optional[pulumi.Input[bool]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 offline: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource provides the Backend resource in Oracle Cloud Infrastructure Load Balancer service.

        Adds a backend server to a backend set.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_backend = oci.load_balancer.Backend("testBackend",
            backendset_name=oci_load_balancer_backend_set["test_backend_set"]["name"],
            ip_address=var["backend_ip_address"],
            load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
            port=var["backend_port"],
            backup=var["backend_backup"],
            drain=var["backend_drain"],
            offline=var["backend_offline"],
            weight=var["backend_weight"])
        ```

        ## Import

        Backends can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:LoadBalancer/backend:Backend test_backend "loadBalancers/{loadBalancerId}/backendSets/{backendSetName}/backends/{backendName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backendset_name: The name of the backend set to add the backend server to.  Example: `example_backend_set`
        :param pulumi.Input[bool] backup: (Updatable) Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.
               
               **Note:** You cannot add a backend server marked as `backup` to a backend set that uses the IP Hash policy.
               
               Example: `false`
        :param pulumi.Input[bool] drain: (Updatable) Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        :param pulumi.Input[str] ip_address: The IP address of the backend server.  Example: `10.0.0.3`
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend set and servers.
        :param pulumi.Input[bool] offline: (Updatable) Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param pulumi.Input[int] port: The communication port for the backend server.  Example: `8080`
        :param pulumi.Input[int] weight: (Updatable) The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Backend resource in Oracle Cloud Infrastructure Load Balancer service.

        Adds a backend server to a backend set.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_backend = oci.load_balancer.Backend("testBackend",
            backendset_name=oci_load_balancer_backend_set["test_backend_set"]["name"],
            ip_address=var["backend_ip_address"],
            load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
            port=var["backend_port"],
            backup=var["backend_backup"],
            drain=var["backend_drain"],
            offline=var["backend_offline"],
            weight=var["backend_weight"])
        ```

        ## Import

        Backends can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:LoadBalancer/backend:Backend test_backend "loadBalancers/{loadBalancerId}/backendSets/{backendSetName}/backends/{backendName}"
        ```

        :param str resource_name: The name of the resource.
        :param BackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backendset_name: Optional[pulumi.Input[str]] = None,
                 backup: Optional[pulumi.Input[bool]] = None,
                 drain: Optional[pulumi.Input[bool]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 offline: Optional[pulumi.Input[bool]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 weight: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendArgs.__new__(BackendArgs)

            if backendset_name is None and not opts.urn:
                raise TypeError("Missing required property 'backendset_name'")
            __props__.__dict__["backendset_name"] = backendset_name
            __props__.__dict__["backup"] = backup
            __props__.__dict__["drain"] = drain
            if ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address'")
            __props__.__dict__["ip_address"] = ip_address
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["offline"] = offline
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["weight"] = weight
            __props__.__dict__["name"] = None
            __props__.__dict__["state"] = None
        super(Backend, __self__).__init__(
            'oci:LoadBalancer/backend:Backend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backendset_name: Optional[pulumi.Input[str]] = None,
            backup: Optional[pulumi.Input[bool]] = None,
            drain: Optional[pulumi.Input[bool]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            load_balancer_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            offline: Optional[pulumi.Input[bool]] = None,
            port: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            weight: Optional[pulumi.Input[int]] = None) -> 'Backend':
        """
        Get an existing Backend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backendset_name: The name of the backend set to add the backend server to.  Example: `example_backend_set`
        :param pulumi.Input[bool] backup: (Updatable) Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.
               
               **Note:** You cannot add a backend server marked as `backup` to a backend set that uses the IP Hash policy.
               
               Example: `false`
        :param pulumi.Input[bool] drain: (Updatable) Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        :param pulumi.Input[str] ip_address: The IP address of the backend server.  Example: `10.0.0.3`
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend set and servers.
        :param pulumi.Input[str] name: A read-only field showing the IP address and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`
        :param pulumi.Input[bool] offline: (Updatable) Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        :param pulumi.Input[int] port: The communication port for the backend server.  Example: `8080`
        :param pulumi.Input[int] weight: (Updatable) The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendState.__new__(_BackendState)

        __props__.__dict__["backendset_name"] = backendset_name
        __props__.__dict__["backup"] = backup
        __props__.__dict__["drain"] = drain
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["offline"] = offline
        __props__.__dict__["port"] = port
        __props__.__dict__["state"] = state
        __props__.__dict__["weight"] = weight
        return Backend(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backendsetName")
    def backendset_name(self) -> pulumi.Output[str]:
        """
        The name of the backend set to add the backend server to.  Example: `example_backend_set`
        """
        return pulumi.get(self, "backendset_name")

    @property
    @pulumi.getter
    def backup(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) Whether the load balancer should treat this server as a backup unit. If `true`, the load balancer forwards no ingress traffic to this backend server unless all other backend servers not marked as "backup" fail the health check policy.

        **Note:** You cannot add a backend server marked as `backup` to a backend set that uses the IP Hash policy.

        Example: `false`
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter
    def drain(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether the load balancer should drain this server. Servers marked "drain" receive no new incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "drain")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The IP address of the backend server.  Example: `10.0.0.3`
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer associated with the backend set and servers.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A read-only field showing the IP address and port that uniquely identify this backend server in the backend set.  Example: `10.0.0.3:8080`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def offline(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether the load balancer should treat this server as offline. Offline servers receive no incoming traffic.  Example: `false`
        """
        return pulumi.get(self, "offline")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        The communication port for the backend server.  Example: `8080`
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def weight(self) -> pulumi.Output[int]:
        """
        (Updatable) The load balancing policy weight assigned to the server. Backend servers with a higher weight receive a larger proportion of incoming traffic. For example, a server weighted '3' receives 3 times the number of new connections as a server weighted '1'. For more information on load balancing policies, see [How Load Balancing Policies Work](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/lbpolicies.htm).  Example: `3` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "weight")

