# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['TableReplicaInitArgs', 'TableReplica']

@pulumi.input_type
class TableReplicaInitArgs:
    def __init__(__self__, *,
                 region: pulumi.Input[str],
                 table_name_or_id: pulumi.Input[str],
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 max_read_units: Optional[pulumi.Input[int]] = None,
                 max_write_units: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a TableReplica resource.
        :param pulumi.Input[str] region: Name of the remote region in standard Oracle Cloud Infrastructure format, i.e. us-ashburn-1
        :param pulumi.Input[str] table_name_or_id: A table name within the compartment, or a table OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] compartment_id: The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        :param pulumi.Input[int] max_read_units: Maximum sustained read throughput limit for the new replica table. If not specified, the local table's read limit is used.
        :param pulumi.Input[int] max_write_units: Maximum sustained write throughput limit for the new replica table. If not specified, the local table's write limit is used.
        """
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "table_name_or_id", table_name_or_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if max_read_units is not None:
            pulumi.set(__self__, "max_read_units", max_read_units)
        if max_write_units is not None:
            pulumi.set(__self__, "max_write_units", max_write_units)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        Name of the remote region in standard Oracle Cloud Infrastructure format, i.e. us-ashburn-1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="tableNameOrId")
    def table_name_or_id(self) -> pulumi.Input[str]:
        """
        A table name within the compartment, or a table OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "table_name_or_id")

    @table_name_or_id.setter
    def table_name_or_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name_or_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="maxReadUnits")
    def max_read_units(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum sustained read throughput limit for the new replica table. If not specified, the local table's read limit is used.
        """
        return pulumi.get(self, "max_read_units")

    @max_read_units.setter
    def max_read_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_read_units", value)

    @property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum sustained write throughput limit for the new replica table. If not specified, the local table's write limit is used.
        """
        return pulumi.get(self, "max_write_units")

    @max_write_units.setter
    def max_write_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_write_units", value)


@pulumi.input_type
class _TableReplicaState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 max_read_units: Optional[pulumi.Input[int]] = None,
                 max_write_units: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 table_name_or_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TableReplica resources.
        :param pulumi.Input[str] compartment_id: The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        :param pulumi.Input[int] max_read_units: Maximum sustained read throughput limit for the new replica table. If not specified, the local table's read limit is used.
        :param pulumi.Input[int] max_write_units: Maximum sustained write throughput limit for the new replica table. If not specified, the local table's write limit is used.
        :param pulumi.Input[str] region: Name of the remote region in standard Oracle Cloud Infrastructure format, i.e. us-ashburn-1
        :param pulumi.Input[str] table_name_or_id: A table name within the compartment, or a table OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if max_read_units is not None:
            pulumi.set(__self__, "max_read_units", max_read_units)
        if max_write_units is not None:
            pulumi.set(__self__, "max_write_units", max_write_units)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if table_name_or_id is not None:
            pulumi.set(__self__, "table_name_or_id", table_name_or_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="maxReadUnits")
    def max_read_units(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum sustained read throughput limit for the new replica table. If not specified, the local table's read limit is used.
        """
        return pulumi.get(self, "max_read_units")

    @max_read_units.setter
    def max_read_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_read_units", value)

    @property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum sustained write throughput limit for the new replica table. If not specified, the local table's write limit is used.
        """
        return pulumi.get(self, "max_write_units")

    @max_write_units.setter
    def max_write_units(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_write_units", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the remote region in standard Oracle Cloud Infrastructure format, i.e. us-ashburn-1
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="tableNameOrId")
    def table_name_or_id(self) -> Optional[pulumi.Input[str]]:
        """
        A table name within the compartment, or a table OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "table_name_or_id")

    @table_name_or_id.setter
    def table_name_or_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name_or_id", value)


class TableReplica(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 max_read_units: Optional[pulumi.Input[int]] = None,
                 max_write_units: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 table_name_or_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Table Replica resource in Oracle Cloud Infrastructure NoSQL Database service.

        Add a replica for this table

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_table_replica = oci.nosql.TableReplica("testTableReplica",
            region=var["table_replica_region"],
            table_name_or_id=oci_nosql_table_name_or["test_table_name_or"]["id"],
            compartment_id=var["compartment_id"],
            max_read_units=var["table_replica_max_read_units"],
            max_write_units=var["table_replica_max_write_units"])
        ```

        ## Import

        TableReplicas can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Nosql/tableReplica:TableReplica test_table_replica "tables/{tableNameOrId}/replicas/{region}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        :param pulumi.Input[int] max_read_units: Maximum sustained read throughput limit for the new replica table. If not specified, the local table's read limit is used.
        :param pulumi.Input[int] max_write_units: Maximum sustained write throughput limit for the new replica table. If not specified, the local table's write limit is used.
        :param pulumi.Input[str] region: Name of the remote region in standard Oracle Cloud Infrastructure format, i.e. us-ashburn-1
        :param pulumi.Input[str] table_name_or_id: A table name within the compartment, or a table OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TableReplicaInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Table Replica resource in Oracle Cloud Infrastructure NoSQL Database service.

        Add a replica for this table

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_table_replica = oci.nosql.TableReplica("testTableReplica",
            region=var["table_replica_region"],
            table_name_or_id=oci_nosql_table_name_or["test_table_name_or"]["id"],
            compartment_id=var["compartment_id"],
            max_read_units=var["table_replica_max_read_units"],
            max_write_units=var["table_replica_max_write_units"])
        ```

        ## Import

        TableReplicas can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Nosql/tableReplica:TableReplica test_table_replica "tables/{tableNameOrId}/replicas/{region}"
        ```

        :param str resource_name: The name of the resource.
        :param TableReplicaInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TableReplicaInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 max_read_units: Optional[pulumi.Input[int]] = None,
                 max_write_units: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 table_name_or_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TableReplicaInitArgs.__new__(TableReplicaInitArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["max_read_units"] = max_read_units
            __props__.__dict__["max_write_units"] = max_write_units
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            if table_name_or_id is None and not opts.urn:
                raise TypeError("Missing required property 'table_name_or_id'")
            __props__.__dict__["table_name_or_id"] = table_name_or_id
        super(TableReplica, __self__).__init__(
            'oci:Nosql/tableReplica:TableReplica',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            max_read_units: Optional[pulumi.Input[int]] = None,
            max_write_units: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            table_name_or_id: Optional[pulumi.Input[str]] = None) -> 'TableReplica':
        """
        Get an existing TableReplica resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        :param pulumi.Input[int] max_read_units: Maximum sustained read throughput limit for the new replica table. If not specified, the local table's read limit is used.
        :param pulumi.Input[int] max_write_units: Maximum sustained write throughput limit for the new replica table. If not specified, the local table's write limit is used.
        :param pulumi.Input[str] region: Name of the remote region in standard Oracle Cloud Infrastructure format, i.e. us-ashburn-1
        :param pulumi.Input[str] table_name_or_id: A table name within the compartment, or a table OCID.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TableReplicaState.__new__(_TableReplicaState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["max_read_units"] = max_read_units
        __props__.__dict__["max_write_units"] = max_write_units
        __props__.__dict__["region"] = region
        __props__.__dict__["table_name_or_id"] = table_name_or_id
        return TableReplica(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the table's compartment.  Required if the tableNameOrId path parameter is a table name. Optional if tableNameOrId is an OCID.  If tableNameOrId is an OCID, and compartmentId is supplied, the latter must match the identified table's compartmentId.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="maxReadUnits")
    def max_read_units(self) -> pulumi.Output[int]:
        """
        Maximum sustained read throughput limit for the new replica table. If not specified, the local table's read limit is used.
        """
        return pulumi.get(self, "max_read_units")

    @property
    @pulumi.getter(name="maxWriteUnits")
    def max_write_units(self) -> pulumi.Output[int]:
        """
        Maximum sustained write throughput limit for the new replica table. If not specified, the local table's write limit is used.
        """
        return pulumi.get(self, "max_write_units")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Name of the remote region in standard Oracle Cloud Infrastructure format, i.e. us-ashburn-1
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="tableNameOrId")
    def table_name_or_id(self) -> pulumi.Output[str]:
        """
        A table name within the compartment, or a table OCID.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "table_name_or_id")

