# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetPrivateApplicationPackageResult',
    'AwaitableGetPrivateApplicationPackageResult',
    'get_private_application_package',
    'get_private_application_package_output',
]

@pulumi.output_type
class GetPrivateApplicationPackageResult:
    """
    A collection of values returned by getPrivateApplicationPackage.
    """
    def __init__(__self__, content_url=None, display_name=None, id=None, mime_type=None, package_type=None, private_application_id=None, private_application_package_id=None, time_created=None, version=None):
        if content_url and not isinstance(content_url, str):
            raise TypeError("Expected argument 'content_url' to be a str")
        pulumi.set(__self__, "content_url", content_url)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mime_type and not isinstance(mime_type, str):
            raise TypeError("Expected argument 'mime_type' to be a str")
        pulumi.set(__self__, "mime_type", mime_type)
        if package_type and not isinstance(package_type, str):
            raise TypeError("Expected argument 'package_type' to be a str")
        pulumi.set(__self__, "package_type", package_type)
        if private_application_id and not isinstance(private_application_id, str):
            raise TypeError("Expected argument 'private_application_id' to be a str")
        pulumi.set(__self__, "private_application_id", private_application_id)
        if private_application_package_id and not isinstance(private_application_package_id, str):
            raise TypeError("Expected argument 'private_application_package_id' to be a str")
        pulumi.set(__self__, "private_application_package_id", private_application_package_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> str:
        return pulumi.get(self, "content_url")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The display name of the package.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        return pulumi.get(self, "mime_type")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The specified package's type.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="privateApplicationId")
    def private_application_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the private application where the package is hosted.
        """
        return pulumi.get(self, "private_application_id")

    @property
    @pulumi.getter(name="privateApplicationPackageId")
    def private_application_package_id(self) -> str:
        return pulumi.get(self, "private_application_package_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the private application package was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2021-05-27T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The package version.
        """
        return pulumi.get(self, "version")


class AwaitableGetPrivateApplicationPackageResult(GetPrivateApplicationPackageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPrivateApplicationPackageResult(
            content_url=self.content_url,
            display_name=self.display_name,
            id=self.id,
            mime_type=self.mime_type,
            package_type=self.package_type,
            private_application_id=self.private_application_id,
            private_application_package_id=self.private_application_package_id,
            time_created=self.time_created,
            version=self.version)


def get_private_application_package(private_application_package_id: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPrivateApplicationPackageResult:
    """
    This data source provides details about a specific Private Application Package resource in Oracle Cloud Infrastructure Service Catalog service.

    Gets the details of a specific package within a given private application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_application_package = oci.ServiceCatalog.get_private_application_package(private_application_package_id=oci_service_catalog_private_application_package["test_private_application_package"]["id"])
    ```


    :param str private_application_package_id: The unique identifier for the private application package.
    """
    __args__ = dict()
    __args__['privateApplicationPackageId'] = private_application_package_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceCatalog/getPrivateApplicationPackage:getPrivateApplicationPackage', __args__, opts=opts, typ=GetPrivateApplicationPackageResult).value

    return AwaitableGetPrivateApplicationPackageResult(
        content_url=pulumi.get(__ret__, 'content_url'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        mime_type=pulumi.get(__ret__, 'mime_type'),
        package_type=pulumi.get(__ret__, 'package_type'),
        private_application_id=pulumi.get(__ret__, 'private_application_id'),
        private_application_package_id=pulumi.get(__ret__, 'private_application_package_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_private_application_package)
def get_private_application_package_output(private_application_package_id: Optional[pulumi.Input[str]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPrivateApplicationPackageResult]:
    """
    This data source provides details about a specific Private Application Package resource in Oracle Cloud Infrastructure Service Catalog service.

    Gets the details of a specific package within a given private application.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_private_application_package = oci.ServiceCatalog.get_private_application_package(private_application_package_id=oci_service_catalog_private_application_package["test_private_application_package"]["id"])
    ```


    :param str private_application_package_id: The unique identifier for the private application package.
    """
    ...
