from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkRenderingCore

class vtkAbstractContextBufferId(vtkmodules.vtkCommonCore.vtkObject):
    def Allocate(self) -> None: ...
    def GetContext(self) -> 'vtkRenderWindow': ...
    def GetHeight(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPickedItem(self, x:int, y:int) -> int: ...
    def GetWidth(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsAllocated(self) -> bool: ...
    def IsSupported(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAbstractContextBufferId': ...
    def ReleaseGraphicsResources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractContextBufferId': ...
    def SetContext(self, context:'vtkRenderWindow') -> None: ...
    def SetHeight(self, _arg:int) -> None: ...
    def SetValues(self, srcXmin:int, srcYmin:int) -> None: ...
    def SetWidth(self, _arg:int) -> None: ...

class vtkAbstractContextItem(vtkmodules.vtkCommonCore.vtkObject):
    def AddItem(self, item:'vtkAbstractContextItem') -> int: ...
    def ClearItems(self) -> None: ...
    def GetInteractive(self) -> bool: ...
    def GetItem(self, index:int) -> 'vtkAbstractContextItem': ...
    def GetItemIndex(self, item:'vtkAbstractContextItem') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfItems(self) -> int: ...
    def GetParent(self) -> 'vtkAbstractContextItem': ...
    def GetPickedItem(self, mouse:'vtkContextMouseEvent') -> 'vtkAbstractContextItem': ...
    def GetScene(self) -> 'vtkContextScene': ...
    def GetVisible(self) -> bool: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def KeyPressEvent(self, key:'vtkContextKeyEvent') -> bool: ...
    def KeyReleaseEvent(self, key:'vtkContextKeyEvent') -> bool: ...
    def Lower(self, index:int) -> int: ...
    def MapFromParent(self, point:'vtkVector2f') -> 'vtkVector2f': ...
    def MapFromScene(self, point:'vtkVector2f') -> 'vtkVector2f': ...
    def MapToParent(self, point:'vtkVector2f') -> 'vtkVector2f': ...
    def MapToScene(self, point:'vtkVector2f') -> 'vtkVector2f': ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseDoubleClickEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseEnterEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseLeaveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseWheelEvent(self, mouse:'vtkContextMouseEvent', delta:int) -> bool: ...
    def NewInstance(self) -> 'vtkAbstractContextItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PaintChildren(self, painter:'vtkContext2D') -> bool: ...
    def Raise(self, index:int) -> int: ...
    def ReleaseGraphicsResources(self) -> None: ...
    @overload
    def RemoveItem(self, item:'vtkAbstractContextItem') -> bool: ...
    @overload
    def RemoveItem(self, index:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAbstractContextItem': ...
    def SetInteractive(self, _arg:bool) -> None: ...
    def SetParent(self, parent:'vtkAbstractContextItem') -> None: ...
    def SetScene(self, scene:'vtkContextScene') -> None: ...
    def SetVisible(self, _arg:bool) -> None: ...
    def StackAbove(self, index:int, under:int) -> int: ...
    def StackUnder(self, child:int, above:int) -> int: ...
    def Update(self) -> None: ...

class vtkContextItem(vtkAbstractContextItem):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContextItem': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContextItem': ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetTransform(self, __a:'vtkContextTransform') -> None: ...

class vtkBlockItem(vtkContextItem):
    BOTTOM:int
    CENTER:int
    CUSTOM:int
    LEFT:int
    RIGHT:int
    TOP:int
    def AutoComputeDimensionsOff(self) -> None: ...
    def AutoComputeDimensionsOn(self) -> None: ...
    def GetAutoComputeDimensions(self) -> bool: ...
    def GetBrush(self) -> 'vtkBrush': ...
    def GetDimensions(self) -> Tuple[float, float, float, float]: ...
    def GetHorizontalAlignment(self) -> int: ...
    def GetLabel(self) -> str: ...
    def GetLabelProperties(self) -> 'vtkTextProperty': ...
    def GetMargins(self) -> Tuple[int, int]: ...
    def GetMouseOverBrush(self) -> 'vtkBrush': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPadding(self) -> Tuple[int, int]: ...
    def GetPen(self) -> 'vtkPen': ...
    def GetVerticalAlignment(self) -> int: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseButtonReleaseEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseEnterEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseLeaveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def NewInstance(self) -> 'vtkBlockItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBlockItem': ...
    def SetAutoComputeDimensions(self, _arg:bool) -> None: ...
    @overload
    def SetDimensions(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float) -> None: ...
    @overload
    def SetDimensions(self, _arg:Sequence[float]) -> None: ...
    def SetHorizontalAlignment(self, _arg:int) -> None: ...
    def SetLabel(self, label:str) -> None: ...
    def SetLabelProperties(self, __a:'vtkTextProperty') -> None: ...
    @overload
    def SetMargins(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetMargins(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetPadding(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetPadding(self, _arg:Sequence[int]) -> None: ...
    def SetVerticalAlignment(self, _arg:int) -> None: ...

class vtkBrush(vtkmodules.vtkCommonCore.vtkObject):
    class TextureProperty(int): ...
    Linear:'TextureProperty'
    Nearest:'TextureProperty'
    Repeat:'TextureProperty'
    Stretch:'TextureProperty'
    def DeepCopy(self, brush:'vtkBrush') -> None: ...
    @overload
    def GetColor(self, color:MutableSequence[int]) -> None: ...
    @overload
    def GetColor(self) -> Pointer: ...
    def GetColorF(self, color:MutableSequence[float]) -> None: ...
    def GetColorObject(self) -> 'vtkColor4ub': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> int: ...
    def GetOpacityF(self) -> float: ...
    def GetTexture(self) -> 'vtkImageData': ...
    def GetTextureProperties(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBrush': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBrush': ...
    @overload
    def SetColor(self, color:MutableSequence[int]) -> None: ...
    @overload
    def SetColor(self, r:int, g:int, b:int) -> None: ...
    @overload
    def SetColor(self, r:int, g:int, b:int, a:int) -> None: ...
    @overload
    def SetColor(self, color:'vtkColor4ub') -> None: ...
    @overload
    def SetColorF(self, color:MutableSequence[float]) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float, a:float) -> None: ...
    def SetOpacity(self, a:int) -> None: ...
    def SetOpacityF(self, a:float) -> None: ...
    def SetTexture(self, image:'vtkImageData') -> None: ...
    def SetTextureProperties(self, _arg:int) -> None: ...

class vtkContext2D(vtkmodules.vtkCommonCore.vtkObject):
    def AppendTransform(self, transform:'vtkTransform2D') -> None: ...
    def ApplyBrush(self, brush:'vtkBrush') -> None: ...
    def ApplyId(self, id:int) -> None: ...
    def ApplyPen(self, pen:'vtkPen') -> None: ...
    def ApplyTextProp(self, prop:'vtkTextProperty') -> None: ...
    def Begin(self, device:'vtkContextDevice2D') -> bool: ...
    def BufferIdModeBegin(self, bufferId:'vtkAbstractContextBufferId') -> None: ...
    def BufferIdModeEnd(self) -> None: ...
    def ComputeFontSizeForBoundedString(self, string:str, width:float, height:float) -> int: ...
    def ComputeJustifiedStringBounds(self, string:str, bounds:MutableSequence[float]) -> None: ...
    @overload
    def ComputeStringBounds(self, string:str, bounds:'vtkPoints2D') -> None: ...
    @overload
    def ComputeStringBounds(self, string:str, bounds:MutableSequence[float]) -> None: ...
    def DrawArc(self, x:float, y:float, r:float, startAngle:float, stopAngle:float) -> None: ...
    def DrawEllipse(self, x:float, y:float, rx:float, ry:float) -> None: ...
    def DrawEllipseWedge(self, x:float, y:float, outRx:float, outRy:float, inRx:float, inRy:float, startAngle:float, stopAngle:float) -> None: ...
    def DrawEllipticArc(self, x:float, y:float, rX:float, rY:float, startAngle:float, stopAngle:float) -> None: ...
    @overload
    def DrawImage(self, x:float, y:float, image:'vtkImageData') -> None: ...
    @overload
    def DrawImage(self, x:float, y:float, scale:float, image:'vtkImageData') -> None: ...
    @overload
    def DrawImage(self, pos:'vtkRectf', image:'vtkImageData') -> None: ...
    @overload
    def DrawLine(self, x1:float, y1:float, x2:float, y2:float) -> None: ...
    @overload
    def DrawLine(self, p:MutableSequence[float]) -> None: ...
    @overload
    def DrawLine(self, points:'vtkPoints2D') -> None: ...
    @overload
    def DrawLines(self, points:'vtkPoints2D') -> None: ...
    @overload
    def DrawLines(self, points:MutableSequence[float], n:int) -> None: ...
    @overload
    def DrawMarkers(self, shape:int, highlight:bool, points:MutableSequence[float], n:int, colors:MutableSequence[int], nc_comps:int) -> None: ...
    @overload
    def DrawMarkers(self, shape:int, highlight:bool, points:MutableSequence[float], n:int) -> None: ...
    @overload
    def DrawMarkers(self, shape:int, highlight:bool, points:'vtkPoints2D') -> None: ...
    @overload
    def DrawMarkers(self, shape:int, highlight:bool, points:'vtkPoints2D', colors:'vtkUnsignedCharArray') -> None: ...
    @overload
    def DrawMathTextString(self, point:'vtkPoints2D', string:str) -> None: ...
    @overload
    def DrawMathTextString(self, x:float, y:float, string:str) -> None: ...
    @overload
    def DrawMathTextString(self, point:'vtkPoints2D', string:str, fallback:str) -> None: ...
    @overload
    def DrawMathTextString(self, x:float, y:float, string:str, fallback:str) -> None: ...
    def DrawPoint(self, x:float, y:float) -> None: ...
    @overload
    def DrawPointSprites(self, sprite:'vtkImageData', points:'vtkPoints2D') -> None: ...
    @overload
    def DrawPointSprites(self, sprite:'vtkImageData', points:'vtkPoints2D', colors:'vtkUnsignedCharArray') -> None: ...
    @overload
    def DrawPointSprites(self, sprite:'vtkImageData', points:MutableSequence[float], n:int, colors:MutableSequence[int], nc_comps:int) -> None: ...
    @overload
    def DrawPointSprites(self, sprite:'vtkImageData', points:MutableSequence[float], n:int) -> None: ...
    @overload
    def DrawPoints(self, x:MutableSequence[float], y:MutableSequence[float], n:int) -> None: ...
    @overload
    def DrawPoints(self, points:'vtkPoints2D') -> None: ...
    @overload
    def DrawPoints(self, points:MutableSequence[float], n:int) -> None: ...
    @overload
    def DrawPoly(self, x:MutableSequence[float], y:MutableSequence[float], n:int) -> None: ...
    @overload
    def DrawPoly(self, points:'vtkPoints2D') -> None: ...
    @overload
    def DrawPoly(self, points:MutableSequence[float], n:int) -> None: ...
    @overload
    def DrawPoly(self, points:MutableSequence[float], n:int, colors:MutableSequence[int], nc_comps:int) -> None: ...
    def DrawPolyData(self, x:float, y:float, polyData:'vtkPolyData', colors:'vtkUnsignedCharArray', scalarMode:int) -> None: ...
    @overload
    def DrawPolygon(self, x:MutableSequence[float], y:MutableSequence[float], n:int) -> None: ...
    @overload
    def DrawPolygon(self, points:'vtkPoints2D') -> None: ...
    @overload
    def DrawPolygon(self, points:MutableSequence[float], n:int) -> None: ...
    @overload
    def DrawPolygon(self, x:MutableSequence[float], y:MutableSequence[float], n:int, color:MutableSequence[int], nc_comps:int) -> None: ...
    @overload
    def DrawPolygon(self, points:'vtkPoints2D', color:MutableSequence[int], nc_comps:int) -> None: ...
    @overload
    def DrawPolygon(self, points:MutableSequence[float], n:int, color:MutableSequence[int], nc_comps:int) -> None: ...
    @overload
    def DrawQuad(self, x1:float, y1:float, x2:float, y2:float, x3:float, y3:float, x4:float, y4:float) -> None: ...
    @overload
    def DrawQuad(self, p:MutableSequence[float]) -> None: ...
    @overload
    def DrawQuadStrip(self, points:'vtkPoints2D') -> None: ...
    @overload
    def DrawQuadStrip(self, p:MutableSequence[float], n:int) -> None: ...
    def DrawRect(self, x:float, y:float, w:float, h:float) -> None: ...
    @overload
    def DrawString(self, point:'vtkPoints2D', string:str) -> None: ...
    @overload
    def DrawString(self, x:float, y:float, string:str) -> None: ...
    @overload
    def DrawStringRect(self, rect:'vtkPoints2D', string:str) -> None: ...
    @overload
    def DrawStringRect(self, rect:Sequence[float], string:str) -> None: ...
    def DrawWedge(self, x:float, y:float, outRadius:float, inRadius:float, startAngle:float, stopAngle:float) -> None: ...
    def End(self) -> bool: ...
    @staticmethod
    def FloatToInt(x:float) -> int: ...
    def GetBrush(self) -> 'vtkBrush': ...
    def GetBufferIdMode(self) -> bool: ...
    def GetContext3D(self) -> 'vtkContext3D': ...
    def GetDevice(self) -> 'vtkContextDevice2D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPen(self) -> 'vtkPen': ...
    def GetTextProp(self) -> 'vtkTextProperty': ...
    def GetTransform(self) -> 'vtkTransform2D': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MathTextIsSupported(self) -> bool: ...
    def NewInstance(self) -> 'vtkContext2D': ...
    def PopMatrix(self) -> None: ...
    def PushMatrix(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContext2D': ...
    def SetContext3D(self, context:'vtkContext3D') -> None: ...
    def SetTransform(self, transform:'vtkTransform2D') -> None: ...

class vtkContext3D(vtkmodules.vtkCommonCore.vtkObject):
    def AppendTransform(self, transform:'vtkTransform') -> None: ...
    def ApplyBrush(self, brush:'vtkBrush') -> None: ...
    def ApplyPen(self, pen:'vtkPen') -> None: ...
    def Begin(self, device:'vtkContextDevice3D') -> bool: ...
    def DisableClippingPlane(self, i:int) -> None: ...
    def DrawLine(self, start:'vtkVector3f', end:'vtkVector3f') -> None: ...
    def DrawPoint(self, point:'vtkVector3f') -> None: ...
    @overload
    def DrawPoints(self, points:Sequence[float], n:int) -> None: ...
    @overload
    def DrawPoints(self, points:Sequence[float], n:int, colors:MutableSequence[int], nc_comps:int) -> None: ...
    def DrawPoly(self, points:Sequence[float], n:int) -> None: ...
    def DrawTriangleMesh(self, mesh:Sequence[float], n:int, colors:Sequence[int] , nc:int) -> None: ...
    def EnableClippingPlane(self, i:int, planeEquation:MutableSequence[float]) -> None: ...
    def End(self) -> bool: ...
    def GetDevice(self) -> 'vtkContextDevice3D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTransform(self) -> 'vtkTransform': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContext3D': ...
    def PopMatrix(self) -> None: ...
    def PushMatrix(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContext3D': ...
    def SetTransform(self, transform:'vtkTransform') -> None: ...

class vtkContextActor(vtkmodules.vtkRenderingCore.vtkProp):
    def GetContext(self) -> 'vtkContext2D': ...
    def GetForceDevice(self) -> 'vtkContextDevice2D': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScene(self) -> 'vtkContextScene': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContextActor': ...
    def ReleaseGraphicsResources(self, window:'vtkWindow') -> None: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContextActor': ...
    def SetForceDevice(self, dev:'vtkContextDevice2D') -> None: ...
    def SetScene(self, scene:'vtkContextScene') -> None: ...

class vtkContextClip(vtkAbstractContextItem):
    def GetHeight(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRect(self, rect:MutableSequence[float]) -> None: ...
    def GetWidth(self) -> float: ...
    def GetX(self) -> float: ...
    def GetY(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContextClip': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContextClip': ...
    def SetClip(self, x:float, y:float, width:float, height:float) -> None: ...
    def Update(self) -> None: ...

class vtkContextDevice2D(vtkmodules.vtkCommonCore.vtkObject):
    class TextureProperty(int): ...
    Linear:'TextureProperty'
    Nearest:'TextureProperty'
    Repeat:'TextureProperty'
    Stretch:'TextureProperty'
    def ApplyBrush(self, brush:'vtkBrush') -> None: ...
    def ApplyPen(self, pen:'vtkPen') -> None: ...
    def ApplyTextProp(self, prop:'vtkTextProperty') -> None: ...
    def Begin(self, __a:'vtkViewport') -> None: ...
    def BufferIdModeBegin(self, bufferId:'vtkAbstractContextBufferId') -> None: ...
    def BufferIdModeEnd(self) -> None: ...
    def ComputeJustifiedStringBounds(self, string:str, bounds:MutableSequence[float]) -> None: ...
    def ComputeStringBounds(self, string:str, bounds:MutableSequence[float]) -> None: ...
    def DisableClipping(self) -> None: ...
    def DrawColoredPolygon(self, points:MutableSequence[float], numPoints:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawEllipseWedge(self, x:float, y:float, outRx:float, outRy:float, inRx:float, inRy:float, startAngle:float, stopAngle:float) -> None: ...
    def DrawEllipticArc(self, x:float, y:float, rX:float, rY:float, startAngle:float, stopAngle:float) -> None: ...
    @overload
    def DrawImage(self, p:MutableSequence[float], scale:float, image:'vtkImageData') -> None: ...
    @overload
    def DrawImage(self, pos:'vtkRectf', image:'vtkImageData') -> None: ...
    def DrawLines(self, f:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawMarkers(self, shape:int, highlight:bool, points:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawMathTextString(self, point:MutableSequence[float], string:str) -> None: ...
    def DrawPointSprites(self, sprite:'vtkImageData', points:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawPoints(self, points:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawPoly(self, points:MutableSequence[float], n:int, colors:MutableSequence[int]=..., nc_comps:int=0) -> None: ...
    def DrawPolyData(self, p:MutableSequence[float], scale:float, polyData:'vtkPolyData', colors:'vtkUnsignedCharArray', scalarMode:int) -> None: ...
    def DrawPolygon(self, p:MutableSequence[float], n:int) -> None: ...
    def DrawQuad(self, __a:MutableSequence[float], __b:int) -> None: ...
    def DrawQuadStrip(self, __a:MutableSequence[float], __b:int) -> None: ...
    def DrawString(self, point:MutableSequence[float], string:str) -> None: ...
    def EnableClipping(self, enable:bool) -> None: ...
    def End(self) -> None: ...
    def GetBrush(self) -> 'vtkBrush': ...
    def GetBufferIdMode(self) -> bool: ...
    def GetHeight(self) -> int: ...
    def GetMatrix(self, m:'vtkMatrix3x3') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPen(self) -> 'vtkPen': ...
    def GetTextProp(self) -> 'vtkTextProperty': ...
    def GetViewportRect(self) -> 'vtkRecti': ...
    def GetViewportSize(self) -> 'vtkVector2i': ...
    def GetWidth(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MathTextIsSupported(self) -> bool: ...
    def MultiplyMatrix(self, m:'vtkMatrix3x3') -> None: ...
    def NewInstance(self) -> 'vtkContextDevice2D': ...
    def PopMatrix(self) -> None: ...
    def PushMatrix(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContextDevice2D': ...
    def SetClipping(self, x:MutableSequence[int]) -> None: ...
    def SetColor4(self, color:MutableSequence[int]) -> None: ...
    def SetLineType(self, type:int) -> None: ...
    def SetLineWidth(self, width:float) -> None: ...
    def SetMatrix(self, m:'vtkMatrix3x3') -> None: ...
    def SetPointSize(self, size:float) -> None: ...
    def SetTexture(self, image:'vtkImageData', properties:int) -> None: ...
    def SetViewportRect(self, rect:'vtkRecti') -> None: ...
    def SetViewportSize(self, size:'vtkVector2i') -> None: ...

class vtkContextDevice3D(vtkmodules.vtkCommonCore.vtkObject):
    def ApplyBrush(self, brush:'vtkBrush') -> None: ...
    def ApplyPen(self, pen:'vtkPen') -> None: ...
    def DisableClipping(self) -> None: ...
    def DisableClippingPlane(self, i:int) -> None: ...
    def DrawLines(self, verts:Sequence[float], n:int, colors:Sequence[int]=..., nc:int=0) -> None: ...
    def DrawPoints(self, verts:Sequence[float], n:int, colors:Sequence[int]=..., nc:int=0) -> None: ...
    def DrawPoly(self, verts:Sequence[float], n:int, colors:Sequence[int]=..., nc:int=0) -> None: ...
    def DrawTriangleMesh(self, mesh:Sequence[float], n:int, colors:Sequence[int] , nc:int) -> None: ...
    def EnableClipping(self, enable:bool) -> None: ...
    def EnableClippingPlane(self, i:int, planeEquation:MutableSequence[float]) -> None: ...
    def GetMatrix(self, m:'vtkMatrix4x4') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MultiplyMatrix(self, m:'vtkMatrix4x4') -> None: ...
    def NewInstance(self) -> 'vtkContextDevice3D': ...
    def PopMatrix(self) -> None: ...
    def PushMatrix(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContextDevice3D': ...
    def SetClipping(self, rect:'vtkRecti') -> None: ...
    def SetMatrix(self, m:'vtkMatrix4x4') -> None: ...

class vtkContextKeyEvent(object):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkContextKeyEvent') -> None: ...
    def GetInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def GetKeyCode(self) -> str: ...
    def GetPosition(self) -> 'vtkVector2i': ...
    def SetInteractor(self, interactor:'vtkRenderWindowInteractor') -> None: ...
    def SetPosition(self, position:'vtkVector2i') -> None: ...

class vtkContextMapper2D(vtkmodules.vtkCommonExecutionModel.vtkAlgorithm):
    def GetInput(self) -> 'vtkTable': ...
    def GetInputAbstractArrayToProcess(self, idx:int, input:'vtkDataObject') -> 'vtkAbstractArray': ...
    def GetInputArrayToProcess(self, idx:int, input:'vtkDataObject') -> 'vtkDataArray': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContextMapper2D': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContextMapper2D': ...
    def SetInputData(self, input:'vtkTable') -> None: ...

class vtkContextMouseEvent(object):
    ALT_MODIFIER:int
    CONTROL_MODIFIER:int
    LEFT_BUTTON:int
    MIDDLE_BUTTON:int
    NO_BUTTON:int
    NO_MODIFIER:int
    RIGHT_BUTTON:int
    SHIFT_MODIFIER:int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, __a:'vtkContextMouseEvent') -> None: ...
    def GetButton(self) -> int: ...
    def GetInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def GetLastPos(self) -> 'vtkVector2f': ...
    def GetLastScenePos(self) -> 'vtkVector2f': ...
    def GetLastScreenPos(self) -> 'vtkVector2i': ...
    def GetModifiers(self) -> int: ...
    def GetPos(self) -> 'vtkVector2f': ...
    def GetScenePos(self) -> 'vtkVector2f': ...
    def GetScreenPos(self) -> 'vtkVector2i': ...
    def SetButton(self, button:int) -> None: ...
    def SetInteractor(self, interactor:'vtkRenderWindowInteractor') -> None: ...
    def SetLastPos(self, pos:'vtkVector2f') -> None: ...
    def SetLastScenePos(self, pos:'vtkVector2f') -> None: ...
    def SetLastScreenPos(self, pos:'vtkVector2i') -> None: ...
    def SetPos(self, pos:'vtkVector2f') -> None: ...
    def SetScenePos(self, pos:'vtkVector2f') -> None: ...
    def SetScreenPos(self, pos:'vtkVector2i') -> None: ...

class vtkContextScene(vtkmodules.vtkCommonCore.vtkObject):
    class SelectionModifier(int): ...
    SELECTION_ADDITION:'SelectionModifier'
    SELECTION_DEFAULT:'SelectionModifier'
    SELECTION_SUBTRACTION:'SelectionModifier'
    SELECTION_TOGGLE:'SelectionModifier'
    def AddItem(self, item:'vtkAbstractContextItem') -> int: ...
    def ClearItems(self) -> None: ...
    def GetAnnotationLink(self) -> 'vtkAnnotationLink': ...
    def GetBufferId(self) -> 'vtkAbstractContextBufferId': ...
    def GetDirty(self) -> bool: ...
    def GetGeometry(self) -> Tuple[int, int]: ...
    def GetItem(self, index:int) -> 'vtkAbstractContextItem': ...
    def GetLastPainter(self) -> 'vtkWeakPointer_I12vtkContext2DE': ...
    def GetLogicalTileScale(self) -> 'vtkVector2i': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfItems(self) -> int: ...
    def GetOrigin(self) -> Tuple[int, int]: ...
    @overload
    def GetPickedItem(self, x:int, y:int) -> int: ...
    @overload
    def GetPickedItem(self) -> 'vtkAbstractContextItem': ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetScaleTiles(self) -> bool: ...
    def GetSceneBottom(self) -> int: ...
    def GetSceneHeight(self) -> int: ...
    def GetSceneLeft(self) -> int: ...
    def GetSceneWidth(self) -> int: ...
    def GetTransform(self) -> 'vtkTransform2D': ...
    def GetUseBufferId(self) -> bool: ...
    def GetViewHeight(self) -> int: ...
    def GetViewWidth(self) -> int: ...
    def HasTransform(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContextScene': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def ReleaseGraphicsResources(self) -> None: ...
    @overload
    def RemoveItem(self, item:'vtkAbstractContextItem') -> bool: ...
    @overload
    def RemoveItem(self, index:int) -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContextScene': ...
    def ScaleTilesOff(self) -> None: ...
    def ScaleTilesOn(self) -> None: ...
    def SetAnnotationLink(self, link:'vtkAnnotationLink') -> None: ...
    def SetDirty(self, isDirty:bool) -> None: ...
    @overload
    def SetGeometry(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetGeometry(self, _arg:Sequence[int]) -> None: ...
    @overload
    def SetOrigin(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[int]) -> None: ...
    def SetRenderer(self, renderer:'vtkRenderer') -> None: ...
    def SetScaleTiles(self, _arg:bool) -> None: ...
    def SetTransform(self, transform:'vtkTransform2D') -> None: ...
    def SetUseBufferId(self, _arg:bool) -> None: ...

class vtkContextTransform(vtkAbstractContextItem):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPanModifier(self) -> int: ...
    def GetPanMouseButton(self) -> int: ...
    def GetPanYOnMouseWheel(self) -> bool: ...
    def GetSecondaryPanModifier(self) -> int: ...
    def GetSecondaryPanMouseButton(self) -> int: ...
    def GetSecondaryZoomModifier(self) -> int: ...
    def GetSecondaryZoomMouseButton(self) -> int: ...
    def GetTransform(self) -> 'vtkTransform2D': ...
    def GetZoomModifier(self) -> int: ...
    def GetZoomMouseButton(self) -> int: ...
    def GetZoomOnMouseWheel(self) -> bool: ...
    def Hit(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def Identity(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MapFromParent(self, point:'vtkVector2f') -> 'vtkVector2f': ...
    def MapToParent(self, point:'vtkVector2f') -> 'vtkVector2f': ...
    def MouseButtonPressEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseMoveEvent(self, mouse:'vtkContextMouseEvent') -> bool: ...
    def MouseWheelEvent(self, mouse:'vtkContextMouseEvent', delta:int) -> bool: ...
    def NewInstance(self) -> 'vtkContextTransform': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def PanYOnMouseWheelOff(self) -> None: ...
    def PanYOnMouseWheelOn(self) -> None: ...
    def Rotate(self, angle:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContextTransform': ...
    def Scale(self, dx:float, dy:float) -> None: ...
    def SetPanModifier(self, _arg:int) -> None: ...
    def SetPanMouseButton(self, _arg:int) -> None: ...
    def SetPanYOnMouseWheel(self, _arg:bool) -> None: ...
    def SetSecondaryPanModifier(self, _arg:int) -> None: ...
    def SetSecondaryPanMouseButton(self, _arg:int) -> None: ...
    def SetSecondaryZoomModifier(self, _arg:int) -> None: ...
    def SetSecondaryZoomMouseButton(self, _arg:int) -> None: ...
    def SetZoomModifier(self, _arg:int) -> None: ...
    def SetZoomMouseButton(self, _arg:int) -> None: ...
    def SetZoomOnMouseWheel(self, _arg:bool) -> None: ...
    def Translate(self, dx:float, dy:float) -> None: ...
    def Update(self) -> None: ...
    def ZoomOnMouseWheelOff(self) -> None: ...
    def ZoomOnMouseWheelOn(self) -> None: ...

class vtkImageItem(vtkContextItem):
    def GetImage(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPosition(self) -> Tuple[float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageItem': ...
    def SetImage(self, image:'vtkImageData') -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPosition(self, _arg:Sequence[float]) -> None: ...

class vtkPolyDataItem(vtkContextItem):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPolyData(self) -> 'vtkPolyData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataItem': ...
    def SetMappedColors(self, colors:'vtkUnsignedCharArray') -> None: ...
    def SetPolyData(self, polyData:'vtkPolyData') -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPosition(self, _arg:Sequence[float]) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...

class vtkLabeledContourPolyDataItem(vtkPolyDataItem):
    def GetLabelVisibility(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSkipDistance(self) -> float: ...
    def GetTextProperties(self) -> 'vtkTextPropertyCollection': ...
    def GetTextPropertyMapping(self) -> 'vtkDoubleArray': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkLabeledContourPolyDataItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLabeledContourPolyDataItem': ...
    def SetLabelVisibility(self, _arg:bool) -> None: ...
    def SetSkipDistance(self, _arg:float) -> None: ...
    def SetTextProperties(self, coll:'vtkTextPropertyCollection') -> None: ...
    def SetTextProperty(self, tprop:'vtkTextProperty') -> None: ...
    def SetTextPropertyMapping(self, mapping:'vtkDoubleArray') -> None: ...

class vtkMarkerUtilities(vtkmodules.vtkCommonCore.vtkObject):
    CIRCLE:int
    CROSS:int
    DIAMOND:int
    NONE:int
    PLUS:int
    SQUARE:int
    @staticmethod
    def GenerateMarker(data:'vtkImageData', style:int, width:int) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkMarkerUtilities': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkMarkerUtilities': ...

class vtkPen(vtkmodules.vtkCommonCore.vtkObject):
    DASH_DOT_DOT_LINE:int
    DASH_DOT_LINE:int
    DASH_LINE:int
    DENSE_DOT_LINE:int
    DOT_LINE:int
    NO_PEN:int
    SOLID_LINE:int
    def DeepCopy(self, pen:'vtkPen') -> None: ...
    @overload
    def GetColor(self, color:MutableSequence[int]) -> None: ...
    @overload
    def GetColor(self) -> Pointer: ...
    def GetColorF(self, color:MutableSequence[float]) -> None: ...
    def GetColorObject(self) -> 'vtkColor4ub': ...
    def GetLineType(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> int: ...
    def GetWidth(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPen': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPen': ...
    @overload
    def SetColor(self, color:MutableSequence[int]) -> None: ...
    @overload
    def SetColor(self, r:int, g:int, b:int) -> None: ...
    @overload
    def SetColor(self, r:int, g:int, b:int, a:int) -> None: ...
    @overload
    def SetColor(self, color:'vtkColor4ub') -> None: ...
    @overload
    def SetColorF(self, color:MutableSequence[float]) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetColorF(self, r:float, g:float, b:float, a:float) -> None: ...
    def SetLineType(self, type:int) -> None: ...
    def SetOpacity(self, a:int) -> None: ...
    def SetOpacityF(self, a:float) -> None: ...
    def SetWidth(self, _arg:float) -> None: ...

class vtkPropItem(vtkAbstractContextItem):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPropObject(self) -> 'vtkProp': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPropItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    def ReleaseGraphicsResources(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPropItem': ...
    def SetPropObject(self, PropObject:'vtkProp') -> None: ...

class vtkTooltipItem(vtkContextItem):
    def GetBrush(self) -> 'vtkBrush': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPen(self) -> 'vtkPen': ...
    def GetPosition(self) -> Tuple[float, float]: ...
    def GetPositionVector(self) -> 'vtkVector2f': ...
    def GetText(self) -> str: ...
    def GetTextProperties(self) -> 'vtkTextProperty': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTooltipItem': ...
    def Paint(self, painter:'vtkContext2D') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTooltipItem': ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPosition(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPosition(self, pos:'vtkVector2f') -> None: ...
    def SetText(self, text:str) -> None: ...
    def Update(self) -> None: ...

