"""Implementations of 'EnumWithSelectedValue' in Python.

As Python does not have an implicit operator, this is the next
best solution for implementing these types properly.
"""
from __future__ import annotations

from enum import Enum
from typing import List, TypeVar

from mastapy.gears.gear_designs.cylindrical import _1080
from mastapy._internal import mixins
from mastapy._internal.python_net import python_net_import

_ARRAY = python_net_import("System", "Array")
_ENUM_WITH_SELECTED_VALUE = python_net_import(
    "SMT.MastaAPI.Utility.Property", "EnumWithSelectedValue"
)


__docformat__ = "restructuredtext en"
__all__ = ("EnumWithSelectedValue_ResidualStressCalculationMethod",)


Self = TypeVar("Self", bound="EnumWithSelectedValue_ResidualStressCalculationMethod")


class EnumWithSelectedValue_ResidualStressCalculationMethod(
    mixins.EnumWithSelectedValueMixin, Enum
):
    """EnumWithSelectedValue_ResidualStressCalculationMethod

    A specific implementation of 'EnumWithSelectedValue' for 'ResidualStressCalculationMethod' types.
    """

    __qualname__ = "ResidualStressCalculationMethod"

    @classmethod
    def wrapper_type(cls) -> "_ENUM_WITH_SELECTED_VALUE":
        """Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _ENUM_WITH_SELECTED_VALUE

    @classmethod
    def wrapped_type(cls) -> "_1080.ResidualStressCalculationMethod":
        """Wrapped Pythonnet type of this class.

        Note:
            This property is readonly
        """

        return _1080.ResidualStressCalculationMethod

    @classmethod
    def implicit_type(cls) -> "_1080.ResidualStressCalculationMethod.type_()":
        """Implicit Pythonnet type of this class.

        Note:
            This property is readonly.
        """

        return _1080.ResidualStressCalculationMethod.type_()

    @property
    def selected_value(self: Self) -> "_1080.ResidualStressCalculationMethod":
        """mastapy.gears.gear_designs.cylindrical.ResidualStressCalculationMethod

        Note:
            This property is readonly.
        """
        return None

    @property
    def available_values(self: Self) -> "List[_1080.ResidualStressCalculationMethod]":
        """List[mastapy.gears.gear_designs.cylindrical.ResidualStressCalculationMethod]

        Note:
            This property is readonly.
        """
        return None
