"""WormType"""
from __future__ import annotations

from typing import TypeVar, Any
from enum import Enum

from mastapy._internal.python_net import python_net_import

_WORM_TYPE = python_net_import("SMT.MastaAPI.Gears", "WormType")


__docformat__ = "restructuredtext en"
__all__ = ("WormType",)


Self = TypeVar("Self", bound="WormType")


class WormType(Enum):
    """WormType

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls):
        return _WORM_TYPE

    ZA = 0
    ZN = 1
    ZI = 2
    ZK = 3


def __enum_setattr(self: Self, attr: str, value: Any):
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: Self, attr: str):
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


WormType.__setattr__ = __enum_setattr
WormType.__delattr__ = __enum_delattr
