"""PinionConvex"""
from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar

from mastapy._internal import constructor
from mastapy import _0
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_PINION_CONVEX = python_net_import(
    "SMT.MastaAPI.Gears.Manufacturing.Bevel", "PinionConvex"
)

if TYPE_CHECKING:
    from mastapy.gears.manufacturing.bevel.basic_machine_settings import _826
    from mastapy.gears.manufacturing.bevel import _809


__docformat__ = "restructuredtext en"
__all__ = ("PinionConvex",)


Self = TypeVar("Self", bound="PinionConvex")


class PinionConvex(_0.APIBase):
    """PinionConvex

    This is a mastapy class.
    """

    TYPE = _PINION_CONVEX
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_PinionConvex")

    class _Cast_PinionConvex:
        """Special nested class for casting PinionConvex to subclasses."""

        def __init__(self: "PinionConvex._Cast_PinionConvex", parent: "PinionConvex"):
            self._parent = parent

        @property
        def pinion_convex(self: "PinionConvex._Cast_PinionConvex") -> "PinionConvex":
            return self._parent

        def __getattr__(self: "PinionConvex._Cast_PinionConvex", name: str):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "PinionConvex.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def pinion_convex_ib_configuration(
        self: Self,
    ) -> "_826.BasicConicalGearMachineSettingsGenerated":
        """mastapy.gears.manufacturing.bevel.basic_machine_settings.BasicConicalGearMachineSettingsGenerated

        Note:
            This property is readonly.
        """
        temp = self.wrapped.PinionConvexIBConfiguration

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def pinion_cutter_parameters_convex(
        self: Self,
    ) -> "_809.PinionFinishMachineSettings":
        """mastapy.gears.manufacturing.bevel.PinionFinishMachineSettings

        Note:
            This property is readonly.
        """
        temp = self.wrapped.PinionCutterParametersConvex

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def cast_to(self: Self) -> "PinionConvex._Cast_PinionConvex":
        return self._Cast_PinionConvex(self)
