"""PackagingLimits"""
from __future__ import annotations

from typing import TypeVar, Union, Tuple

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy._internal.implicit import overridable
from mastapy._internal.overridable_constructor import _unpack_overridable
from mastapy._internal import constructor
from mastapy.utility import _1604
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_PACKAGING_LIMITS = python_net_import("SMT.MastaAPI.Geometry", "PackagingLimits")


__docformat__ = "restructuredtext en"
__all__ = ("PackagingLimits",)


Self = TypeVar("Self", bound="PackagingLimits")


class PackagingLimits(_1604.IndependentReportablePropertiesBase["PackagingLimits"]):
    """PackagingLimits

    This is a mastapy class.
    """

    TYPE = _PACKAGING_LIMITS
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_PackagingLimits")

    class _Cast_PackagingLimits:
        """Special nested class for casting PackagingLimits to subclasses."""

        def __init__(
            self: "PackagingLimits._Cast_PackagingLimits", parent: "PackagingLimits"
        ):
            self._parent = parent

        @property
        def independent_reportable_properties_base(
            self: "PackagingLimits._Cast_PackagingLimits",
        ) -> "_1604.IndependentReportablePropertiesBase":
            pass

            return self._parent._cast(_1604.IndependentReportablePropertiesBase)

        @property
        def packaging_limits(
            self: "PackagingLimits._Cast_PackagingLimits",
        ) -> "PackagingLimits":
            return self._parent

        def __getattr__(self: "PackagingLimits._Cast_PackagingLimits", name: str):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "PackagingLimits.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def maximum_x(self: Self) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.MaximumX

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @maximum_x.setter
    @enforce_parameter_types
    def maximum_x(self: Self, value: "Union[float, Tuple[float, bool]]"):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.MaximumX = value

    @property
    def maximum_y(self: Self) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.MaximumY

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @maximum_y.setter
    @enforce_parameter_types
    def maximum_y(self: Self, value: "Union[float, Tuple[float, bool]]"):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.MaximumY = value

    @property
    def maximum_z(self: Self) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.MaximumZ

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @maximum_z.setter
    @enforce_parameter_types
    def maximum_z(self: Self, value: "Union[float, Tuple[float, bool]]"):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.MaximumZ = value

    @property
    def minimum_x(self: Self) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.MinimumX

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @minimum_x.setter
    @enforce_parameter_types
    def minimum_x(self: Self, value: "Union[float, Tuple[float, bool]]"):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.MinimumX = value

    @property
    def minimum_y(self: Self) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.MinimumY

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @minimum_y.setter
    @enforce_parameter_types
    def minimum_y(self: Self, value: "Union[float, Tuple[float, bool]]"):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.MinimumY = value

    @property
    def minimum_z(self: Self) -> "overridable.Overridable_float":
        """Overridable[float]"""
        temp = self.wrapped.MinimumZ

        if temp is None:
            return 0.0

        return constructor.new_from_mastapy(
            "mastapy._internal.implicit.overridable", "Overridable_float"
        )(temp)

    @minimum_z.setter
    @enforce_parameter_types
    def minimum_z(self: Self, value: "Union[float, Tuple[float, bool]]"):
        wrapper_type = overridable.Overridable_float.wrapper_type()
        enclosed_type = overridable.Overridable_float.implicit_type()
        value, is_overridden = _unpack_overridable(value)
        value = wrapper_type[enclosed_type](
            enclosed_type(value) if value is not None else 0.0, is_overridden
        )
        self.wrapped.MinimumZ = value

    @property
    def cast_to(self: Self) -> "PackagingLimits._Cast_PackagingLimits":
        return self._Cast_PackagingLimits(self)
