"""CouplingHalfCompoundPowerFlow"""
from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar, List

from mastapy._internal import conversion
from mastapy.system_model.analyses_and_results.power_flows.compound import _4265
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_COUPLING_HALF_COMPOUND_POWER_FLOW = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.PowerFlows.Compound",
    "CouplingHalfCompoundPowerFlow",
)

if TYPE_CHECKING:
    from mastapy.system_model.analyses_and_results.power_flows import _4091
    from mastapy.system_model.analyses_and_results.power_flows.compound import (
        _4211,
        _4216,
        _4230,
        _4270,
        _4276,
        _4280,
        _4292,
        _4302,
        _4303,
        _4304,
        _4307,
        _4308,
        _4213,
        _4267,
    )
    from mastapy.system_model.analyses_and_results.analysis_cases import _7567, _7564
    from mastapy.system_model.analyses_and_results import _2672


__docformat__ = "restructuredtext en"
__all__ = ("CouplingHalfCompoundPowerFlow",)


Self = TypeVar("Self", bound="CouplingHalfCompoundPowerFlow")


class CouplingHalfCompoundPowerFlow(_4265.MountableComponentCompoundPowerFlow):
    """CouplingHalfCompoundPowerFlow

    This is a mastapy class.
    """

    TYPE = _COUPLING_HALF_COMPOUND_POWER_FLOW
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_CouplingHalfCompoundPowerFlow")

    class _Cast_CouplingHalfCompoundPowerFlow:
        """Special nested class for casting CouplingHalfCompoundPowerFlow to subclasses."""

        def __init__(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
            parent: "CouplingHalfCompoundPowerFlow",
        ):
            self._parent = parent

        @property
        def mountable_component_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4265.MountableComponentCompoundPowerFlow":
            return self._parent._cast(_4265.MountableComponentCompoundPowerFlow)

        @property
        def component_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4213.ComponentCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4213,
            )

            return self._parent._cast(_4213.ComponentCompoundPowerFlow)

        @property
        def part_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4267.PartCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4267,
            )

            return self._parent._cast(_4267.PartCompoundPowerFlow)

        @property
        def part_compound_analysis(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_7567.PartCompoundAnalysis":
            from mastapy.system_model.analyses_and_results.analysis_cases import _7567

            return self._parent._cast(_7567.PartCompoundAnalysis)

        @property
        def design_entity_compound_analysis(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_7564.DesignEntityCompoundAnalysis":
            from mastapy.system_model.analyses_and_results.analysis_cases import _7564

            return self._parent._cast(_7564.DesignEntityCompoundAnalysis)

        @property
        def design_entity_analysis(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_2672.DesignEntityAnalysis":
            from mastapy.system_model.analyses_and_results import _2672

            return self._parent._cast(_2672.DesignEntityAnalysis)

        @property
        def clutch_half_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4211.ClutchHalfCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4211,
            )

            return self._parent._cast(_4211.ClutchHalfCompoundPowerFlow)

        @property
        def concept_coupling_half_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4216.ConceptCouplingHalfCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4216,
            )

            return self._parent._cast(_4216.ConceptCouplingHalfCompoundPowerFlow)

        @property
        def cvt_pulley_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4230.CVTPulleyCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4230,
            )

            return self._parent._cast(_4230.CVTPulleyCompoundPowerFlow)

        @property
        def part_to_part_shear_coupling_half_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4270.PartToPartShearCouplingHalfCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4270,
            )

            return self._parent._cast(
                _4270.PartToPartShearCouplingHalfCompoundPowerFlow
            )

        @property
        def pulley_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4276.PulleyCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4276,
            )

            return self._parent._cast(_4276.PulleyCompoundPowerFlow)

        @property
        def rolling_ring_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4280.RollingRingCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4280,
            )

            return self._parent._cast(_4280.RollingRingCompoundPowerFlow)

        @property
        def spring_damper_half_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4292.SpringDamperHalfCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4292,
            )

            return self._parent._cast(_4292.SpringDamperHalfCompoundPowerFlow)

        @property
        def synchroniser_half_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4302.SynchroniserHalfCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4302,
            )

            return self._parent._cast(_4302.SynchroniserHalfCompoundPowerFlow)

        @property
        def synchroniser_part_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4303.SynchroniserPartCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4303,
            )

            return self._parent._cast(_4303.SynchroniserPartCompoundPowerFlow)

        @property
        def synchroniser_sleeve_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4304.SynchroniserSleeveCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4304,
            )

            return self._parent._cast(_4304.SynchroniserSleeveCompoundPowerFlow)

        @property
        def torque_converter_pump_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4307.TorqueConverterPumpCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4307,
            )

            return self._parent._cast(_4307.TorqueConverterPumpCompoundPowerFlow)

        @property
        def torque_converter_turbine_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "_4308.TorqueConverterTurbineCompoundPowerFlow":
            from mastapy.system_model.analyses_and_results.power_flows.compound import (
                _4308,
            )

            return self._parent._cast(_4308.TorqueConverterTurbineCompoundPowerFlow)

        @property
        def coupling_half_compound_power_flow(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
        ) -> "CouplingHalfCompoundPowerFlow":
            return self._parent

        def __getattr__(
            self: "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow",
            name: str,
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "CouplingHalfCompoundPowerFlow.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def component_analysis_cases(self: Self) -> "List[_4091.CouplingHalfPowerFlow]":
        """List[mastapy.system_model.analyses_and_results.power_flows.CouplingHalfPowerFlow]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ComponentAnalysisCases

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def component_analysis_cases_ready(
        self: Self,
    ) -> "List[_4091.CouplingHalfPowerFlow]":
        """List[mastapy.system_model.analyses_and_results.power_flows.CouplingHalfPowerFlow]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ComponentAnalysisCasesReady

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp)

        if value is None:
            return None

        return value

    @property
    def cast_to(
        self: Self,
    ) -> "CouplingHalfCompoundPowerFlow._Cast_CouplingHalfCompoundPowerFlow":
        return self._Cast_CouplingHalfCompoundPowerFlow(self)
