"""CylindricalGearMeshMisalignmentValue"""
from __future__ import annotations

from typing import TypeVar

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy import _0
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_CYLINDRICAL_GEAR_MESH_MISALIGNMENT_VALUE = python_net_import(
    "SMT.MastaAPI.SystemModel.AnalysesAndResults.SystemDeflections.Reporting",
    "CylindricalGearMeshMisalignmentValue",
)


__docformat__ = "restructuredtext en"
__all__ = ("CylindricalGearMeshMisalignmentValue",)


Self = TypeVar("Self", bound="CylindricalGearMeshMisalignmentValue")


class CylindricalGearMeshMisalignmentValue(_0.APIBase):
    """CylindricalGearMeshMisalignmentValue

    This is a mastapy class.
    """

    TYPE = _CYLINDRICAL_GEAR_MESH_MISALIGNMENT_VALUE
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_CylindricalGearMeshMisalignmentValue")

    class _Cast_CylindricalGearMeshMisalignmentValue:
        """Special nested class for casting CylindricalGearMeshMisalignmentValue to subclasses."""

        def __init__(
            self: "CylindricalGearMeshMisalignmentValue._Cast_CylindricalGearMeshMisalignmentValue",
            parent: "CylindricalGearMeshMisalignmentValue",
        ):
            self._parent = parent

        @property
        def cylindrical_gear_mesh_misalignment_value(
            self: "CylindricalGearMeshMisalignmentValue._Cast_CylindricalGearMeshMisalignmentValue",
        ) -> "CylindricalGearMeshMisalignmentValue":
            return self._parent

        def __getattr__(
            self: "CylindricalGearMeshMisalignmentValue._Cast_CylindricalGearMeshMisalignmentValue",
            name: str,
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(
        self: Self, instance_to_wrap: "CylindricalGearMeshMisalignmentValue.TYPE"
    ):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def gear_name(self: Self) -> "str":
        """str"""
        temp = self.wrapped.GearName

        if temp is None:
            return ""

        return temp

    @gear_name.setter
    @enforce_parameter_types
    def gear_name(self: Self, value: "str"):
        self.wrapped.GearName = str(value) if value is not None else ""

    @property
    def misalignment(self: Self) -> "float":
        """float"""
        temp = self.wrapped.Misalignment

        if temp is None:
            return 0.0

        return temp

    @misalignment.setter
    @enforce_parameter_types
    def misalignment(self: Self, value: "float"):
        self.wrapped.Misalignment = float(value) if value is not None else 0.0

    @property
    def misalignment_due_to_tilt(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MisalignmentDueToTilt

        if temp is None:
            return 0.0

        return temp

    @misalignment_due_to_tilt.setter
    @enforce_parameter_types
    def misalignment_due_to_tilt(self: Self, value: "float"):
        self.wrapped.MisalignmentDueToTilt = float(value) if value is not None else 0.0

    @property
    def misalignment_due_to_twist(self: Self) -> "float":
        """float"""
        temp = self.wrapped.MisalignmentDueToTwist

        if temp is None:
            return 0.0

        return temp

    @misalignment_due_to_twist.setter
    @enforce_parameter_types
    def misalignment_due_to_twist(self: Self, value: "float"):
        self.wrapped.MisalignmentDueToTwist = float(value) if value is not None else 0.0

    @property
    def tilt_x(self: Self) -> "float":
        """float"""
        temp = self.wrapped.TiltX

        if temp is None:
            return 0.0

        return temp

    @tilt_x.setter
    @enforce_parameter_types
    def tilt_x(self: Self, value: "float"):
        self.wrapped.TiltX = float(value) if value is not None else 0.0

    @property
    def tilt_y(self: Self) -> "float":
        """float"""
        temp = self.wrapped.TiltY

        if temp is None:
            return 0.0

        return temp

    @tilt_y.setter
    @enforce_parameter_types
    def tilt_y(self: Self, value: "float"):
        self.wrapped.TiltY = float(value) if value is not None else 0.0

    @property
    def cast_to(
        self: Self,
    ) -> "CylindricalGearMeshMisalignmentValue._Cast_CylindricalGearMeshMisalignmentValue":
        return self._Cast_CylindricalGearMeshMisalignmentValue(self)
