"""NodeComparisonResult"""
from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar, List

from mastapy._internal.type_enforcement import enforce_parameter_types
from mastapy._internal import constructor, conversion
from mastapy import _0
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_NODE_COMPARISON_RESULT = python_net_import(
    "SMT.MastaAPI.SystemModel.FE.VersionComparer", "NodeComparisonResult"
)

if TYPE_CHECKING:
    from mastapy.math_utility.measured_vectors import _1582, _1580


__docformat__ = "restructuredtext en"
__all__ = ("NodeComparisonResult",)


Self = TypeVar("Self", bound="NodeComparisonResult")


class NodeComparisonResult(_0.APIBase):
    """NodeComparisonResult

    This is a mastapy class.
    """

    TYPE = _NODE_COMPARISON_RESULT
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_NodeComparisonResult")

    class _Cast_NodeComparisonResult:
        """Special nested class for casting NodeComparisonResult to subclasses."""

        def __init__(
            self: "NodeComparisonResult._Cast_NodeComparisonResult",
            parent: "NodeComparisonResult",
        ):
            self._parent = parent

        @property
        def node_comparison_result(
            self: "NodeComparisonResult._Cast_NodeComparisonResult",
        ) -> "NodeComparisonResult":
            return self._parent

        def __getattr__(
            self: "NodeComparisonResult._Cast_NodeComparisonResult", name: str
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "NodeComparisonResult.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def angular_change(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.AngularChange

        if temp is None:
            return 0.0

        return temp

    @property
    def details(self: Self) -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Details

        if temp is None:
            return ""

        return temp

    @property
    def linear_change(self: Self) -> "float":
        """float

        Note:
            This property is readonly.
        """
        temp = self.wrapped.LinearChange

        if temp is None:
            return 0.0

        return temp

    @property
    def name(self: Self) -> "str":
        """str

        Note:
            This property is readonly.
        """
        temp = self.wrapped.Name

        if temp is None:
            return ""

        return temp

    @property
    def displacement_change(self: Self) -> "_1582.VectorWithLinearAndAngularComponents":
        """mastapy.math_utility.measured_vectors.VectorWithLinearAndAngularComponents

        Note:
            This property is readonly.
        """
        temp = self.wrapped.DisplacementChange

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def new_result(self: Self) -> "_1580.NodeResults":
        """mastapy.math_utility.measured_vectors.NodeResults

        Note:
            This property is readonly.
        """
        temp = self.wrapped.NewResult

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def original_result(self: Self) -> "_1580.NodeResults":
        """mastapy.math_utility.measured_vectors.NodeResults

        Note:
            This property is readonly.
        """
        temp = self.wrapped.OriginalResult

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def report_names(self: Self) -> "List[str]":
        """List[str]

        Note:
            This property is readonly.
        """
        temp = self.wrapped.ReportNames

        if temp is None:
            return None

        value = conversion.pn_to_mp_objects_in_list(temp, str)

        if value is None:
            return None

        return value

    @enforce_parameter_types
    def output_default_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputDefaultReportTo(file_path if file_path else "")

    def get_default_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetDefaultReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_active_report_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportTo(file_path if file_path else "")

    @enforce_parameter_types
    def output_active_report_as_text_to(self: Self, file_path: "str"):
        """Method does not return.

        Args:
            file_path (str)
        """
        file_path = str(file_path)
        self.wrapped.OutputActiveReportAsTextTo(file_path if file_path else "")

    def get_active_report_with_encoded_images(self: Self) -> "str":
        """str"""
        method_result = self.wrapped.GetActiveReportWithEncodedImages()
        return method_result

    @enforce_parameter_types
    def output_named_report_to(self: Self, report_name: "str", file_path: "str"):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_masta_report(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsMastaReport(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def output_named_report_as_text_to(
        self: Self, report_name: "str", file_path: "str"
    ):
        """Method does not return.

        Args:
            report_name (str)
            file_path (str)
        """
        report_name = str(report_name)
        file_path = str(file_path)
        self.wrapped.OutputNamedReportAsTextTo(
            report_name if report_name else "", file_path if file_path else ""
        )

    @enforce_parameter_types
    def get_named_report_with_encoded_images(self: Self, report_name: "str") -> "str":
        """str

        Args:
            report_name (str)
        """
        report_name = str(report_name)
        method_result = self.wrapped.GetNamedReportWithEncodedImages(
            report_name if report_name else ""
        )
        return method_result

    @property
    def cast_to(self: Self) -> "NodeComparisonResult._Cast_NodeComparisonResult":
        return self._Cast_NodeComparisonResult(self)
