"""PartToPartShearCoupling"""
from __future__ import annotations

from typing import TYPE_CHECKING, TypeVar

from mastapy._internal import constructor
from mastapy.system_model.part_model.couplings import _2604
from mastapy._internal.cast_exception import CastException
from mastapy._internal.python_net import python_net_import

_PART_TO_PART_SHEAR_COUPLING = python_net_import(
    "SMT.MastaAPI.SystemModel.PartModel.Couplings", "PartToPartShearCoupling"
)

if TYPE_CHECKING:
    from mastapy.system_model.connections_and_sockets.couplings import _2368
    from mastapy.system_model.part_model import _2496, _2454, _2488
    from mastapy.system_model import _2223


__docformat__ = "restructuredtext en"
__all__ = ("PartToPartShearCoupling",)


Self = TypeVar("Self", bound="PartToPartShearCoupling")


class PartToPartShearCoupling(_2604.Coupling):
    """PartToPartShearCoupling

    This is a mastapy class.
    """

    TYPE = _PART_TO_PART_SHEAR_COUPLING
    _CastSelf = TypeVar("_CastSelf", bound="_Cast_PartToPartShearCoupling")

    class _Cast_PartToPartShearCoupling:
        """Special nested class for casting PartToPartShearCoupling to subclasses."""

        def __init__(
            self: "PartToPartShearCoupling._Cast_PartToPartShearCoupling",
            parent: "PartToPartShearCoupling",
        ):
            self._parent = parent

        @property
        def coupling(
            self: "PartToPartShearCoupling._Cast_PartToPartShearCoupling",
        ) -> "_2604.Coupling":
            return self._parent._cast(_2604.Coupling)

        @property
        def specialised_assembly(
            self: "PartToPartShearCoupling._Cast_PartToPartShearCoupling",
        ) -> "_2496.SpecialisedAssembly":
            from mastapy.system_model.part_model import _2496

            return self._parent._cast(_2496.SpecialisedAssembly)

        @property
        def abstract_assembly(
            self: "PartToPartShearCoupling._Cast_PartToPartShearCoupling",
        ) -> "_2454.AbstractAssembly":
            from mastapy.system_model.part_model import _2454

            return self._parent._cast(_2454.AbstractAssembly)

        @property
        def part(
            self: "PartToPartShearCoupling._Cast_PartToPartShearCoupling",
        ) -> "_2488.Part":
            from mastapy.system_model.part_model import _2488

            return self._parent._cast(_2488.Part)

        @property
        def design_entity(
            self: "PartToPartShearCoupling._Cast_PartToPartShearCoupling",
        ) -> "_2223.DesignEntity":
            from mastapy.system_model import _2223

            return self._parent._cast(_2223.DesignEntity)

        @property
        def part_to_part_shear_coupling(
            self: "PartToPartShearCoupling._Cast_PartToPartShearCoupling",
        ) -> "PartToPartShearCoupling":
            return self._parent

        def __getattr__(
            self: "PartToPartShearCoupling._Cast_PartToPartShearCoupling", name: str
        ):
            try:
                return self.__dict__[name]
            except KeyError:
                class_name = "".join(n.capitalize() for n in name.split("_"))
                raise CastException(
                    f'Detected an invalid cast. Cannot cast to type "{class_name}"'
                ) from None

    def __init__(self: Self, instance_to_wrap: "PartToPartShearCoupling.TYPE"):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def part_to_part_shear_coupling_connection(
        self: Self,
    ) -> "_2368.PartToPartShearCouplingConnection":
        """mastapy.system_model.connections_and_sockets.couplings.PartToPartShearCouplingConnection

        Note:
            This property is readonly.
        """
        temp = self.wrapped.PartToPartShearCouplingConnection

        if temp is None:
            return None

        type_ = temp.GetType()
        return constructor.new(type_.Namespace, type_.Name)(temp)

    @property
    def cast_to(self: Self) -> "PartToPartShearCoupling._Cast_PartToPartShearCoupling":
        return self._Cast_PartToPartShearCoupling(self)
