"""HousedOrMounted"""
from __future__ import annotations

from typing import TypeVar, Any
from enum import Enum

from mastapy._internal.python_net import python_net_import

_HOUSED_OR_MOUNTED = python_net_import(
    "SMT.MastaAPI.SystemModel.PartModel.ImportFromCAD", "HousedOrMounted"
)


__docformat__ = "restructuredtext en"
__all__ = ("HousedOrMounted",)


Self = TypeVar("Self", bound="HousedOrMounted")


class HousedOrMounted(Enum):
    """HousedOrMounted

    This is a mastapy class.

    Note:
        This class is an Enum.
    """

    @classmethod
    def type_(cls):
        return _HOUSED_OR_MOUNTED

    HOUSED = 0
    MOUNTED = 1


def __enum_setattr(self: Self, attr: str, value: Any):
    raise AttributeError("Cannot set the attributes of an Enum.") from None


def __enum_delattr(self: Self, attr: str):
    raise AttributeError("Cannot delete the attributes of an Enum.") from None


HousedOrMounted.__setattr__ = __enum_setattr
HousedOrMounted.__delattr__ = __enum_delattr
