# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCaptureFilterResult',
    'AwaitableGetCaptureFilterResult',
    'get_capture_filter',
    'get_capture_filter_output',
]

@pulumi.output_type
class GetCaptureFilterResult:
    """
    A collection of values returned by getCaptureFilter.
    """
    def __init__(__self__, capture_filter_id=None, compartment_id=None, defined_tags=None, display_name=None, filter_type=None, freeform_tags=None, id=None, state=None, time_created=None, vtap_capture_filter_rules=None):
        if capture_filter_id and not isinstance(capture_filter_id, str):
            raise TypeError("Expected argument 'capture_filter_id' to be a str")
        pulumi.set(__self__, "capture_filter_id", capture_filter_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filter_type and not isinstance(filter_type, str):
            raise TypeError("Expected argument 'filter_type' to be a str")
        pulumi.set(__self__, "filter_type", filter_type)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if vtap_capture_filter_rules and not isinstance(vtap_capture_filter_rules, list):
            raise TypeError("Expected argument 'vtap_capture_filter_rules' to be a list")
        pulumi.set(__self__, "vtap_capture_filter_rules", vtap_capture_filter_rules)

    @property
    @pulumi.getter(name="captureFilterId")
    def capture_filter_id(self) -> str:
        return pulumi.get(self, "capture_filter_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the capture filter.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="filterType")
    def filter_type(self) -> str:
        """
        Indicates which service will use this capture filter
        """
        return pulumi.get(self, "filter_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The capture filter's Oracle ID ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The capture filter's current administrative state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the capture filter was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2021-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vtapCaptureFilterRules")
    def vtap_capture_filter_rules(self) -> Sequence['outputs.GetCaptureFilterVtapCaptureFilterRuleResult']:
        """
        The set of rules governing what traffic a VTAP mirrors.
        """
        return pulumi.get(self, "vtap_capture_filter_rules")


class AwaitableGetCaptureFilterResult(GetCaptureFilterResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCaptureFilterResult(
            capture_filter_id=self.capture_filter_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            filter_type=self.filter_type,
            freeform_tags=self.freeform_tags,
            id=self.id,
            state=self.state,
            time_created=self.time_created,
            vtap_capture_filter_rules=self.vtap_capture_filter_rules)


def get_capture_filter(capture_filter_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCaptureFilterResult:
    """
    This data source provides details about a specific Capture Filter resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified VTAP capture filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_capture_filter = oci.Core.get_capture_filter(capture_filter_id=oci_core_capture_filter["test_capture_filter"]["id"])
    ```


    :param str capture_filter_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the capture filter.
    """
    __args__ = dict()
    __args__['captureFilterId'] = capture_filter_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getCaptureFilter:getCaptureFilter', __args__, opts=opts, typ=GetCaptureFilterResult).value

    return AwaitableGetCaptureFilterResult(
        capture_filter_id=pulumi.get(__ret__, 'capture_filter_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filter_type=pulumi.get(__ret__, 'filter_type'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        vtap_capture_filter_rules=pulumi.get(__ret__, 'vtap_capture_filter_rules'))


@_utilities.lift_output_func(get_capture_filter)
def get_capture_filter_output(capture_filter_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCaptureFilterResult]:
    """
    This data source provides details about a specific Capture Filter resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified VTAP capture filter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_capture_filter = oci.Core.get_capture_filter(capture_filter_id=oci_core_capture_filter["test_capture_filter"]["id"])
    ```


    :param str capture_filter_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the capture filter.
    """
    ...
