# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DiscoveryJobDiscoveryDetails',
    'DiscoveryJobDiscoveryDetailsCredentials',
    'DiscoveryJobDiscoveryDetailsCredentialsItem',
    'DiscoveryJobDiscoveryDetailsCredentialsItemProperties',
    'DiscoveryJobDiscoveryDetailsProperties',
    'DiscoveryJobDiscoveryDetailsTags',
    'MonitoredResourceAdditionalAlias',
    'MonitoredResourceAdditionalAliasCredential',
    'MonitoredResourceAdditionalCredential',
    'MonitoredResourceAdditionalCredentialProperty',
    'MonitoredResourceAliases',
    'MonitoredResourceAliasesCredential',
    'MonitoredResourceCredentials',
    'MonitoredResourceCredentialsProperty',
    'MonitoredResourceDatabaseConnectionDetails',
    'MonitoredResourceProperty',
    'MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetail',
    'MonitoredResourcesAssociateMonitoredResourceSourceResourceDetail',
    'MonitoredResourcesListMemberItem',
    'MonitoredResourcesSearchAssociationItem',
    'MonitoredResourcesSearchAssociationItemDestinationResourceDetail',
    'MonitoredResourcesSearchAssociationItemSourceResourceDetail',
    'MonitoredResourcesSearchItem',
    'MonitoredResourcesSearchItemProperty',
    'GetDiscoveryJobDiscoveryDetailResult',
    'GetDiscoveryJobDiscoveryDetailCredentialResult',
    'GetDiscoveryJobDiscoveryDetailCredentialItemResult',
    'GetDiscoveryJobDiscoveryDetailCredentialItemPropertyResult',
    'GetDiscoveryJobDiscoveryDetailPropertyResult',
    'GetDiscoveryJobDiscoveryDetailTagResult',
    'GetDiscoveryJobLogsDiscoveryJobLogCollectionResult',
    'GetDiscoveryJobLogsDiscoveryJobLogCollectionItemResult',
    'GetDiscoveryJobLogsFilterResult',
    'GetDiscoveryJobsDiscoveryJobCollectionResult',
    'GetDiscoveryJobsDiscoveryJobCollectionItemResult',
    'GetDiscoveryJobsFilterResult',
    'GetMonitoredResourceAdditionalAliasResult',
    'GetMonitoredResourceAdditionalAliasCredentialResult',
    'GetMonitoredResourceAdditionalCredentialResult',
    'GetMonitoredResourceAdditionalCredentialPropertyResult',
    'GetMonitoredResourceAliasResult',
    'GetMonitoredResourceAliasCredentialResult',
    'GetMonitoredResourceCredentialResult',
    'GetMonitoredResourceCredentialPropertyResult',
    'GetMonitoredResourceDatabaseConnectionDetailResult',
    'GetMonitoredResourcePropertyResult',
]

@pulumi.output_type
class DiscoveryJobDiscoveryDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentId":
            suggest = "agent_id"
        elif key == "resourceName":
            suggest = "resource_name"
        elif key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryJobDiscoveryDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryJobDiscoveryDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryJobDiscoveryDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 agent_id: str,
                 properties: 'outputs.DiscoveryJobDiscoveryDetailsProperties',
                 resource_name: str,
                 resource_type: str,
                 credentials: Optional['outputs.DiscoveryJobDiscoveryDetailsCredentials'] = None,
                 tags: Optional['outputs.DiscoveryJobDiscoveryDetailsTags'] = None):
        """
        :param str agent_id: The OCID of Management Agent
        :param 'DiscoveryJobDiscoveryDetailsPropertiesArgs' properties: Property Details
        :param str resource_name: The Name of resource type
        :param str resource_type: Resource Type.
        :param 'DiscoveryJobDiscoveryDetailsCredentialsArgs' credentials: List of DiscoveryJob Credential Details.
        :param 'DiscoveryJobDiscoveryDetailsTagsArgs' tags: Property Details
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        """
        The OCID of Management Agent
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.DiscoveryJobDiscoveryDetailsProperties':
        """
        Property Details
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The Name of resource type
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Resource Type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def credentials(self) -> Optional['outputs.DiscoveryJobDiscoveryDetailsCredentials']:
        """
        List of DiscoveryJob Credential Details.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def tags(self) -> Optional['outputs.DiscoveryJobDiscoveryDetailsTags']:
        """
        Property Details
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class DiscoveryJobDiscoveryDetailsCredentials(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.DiscoveryJobDiscoveryDetailsCredentialsItem']):
        """
        :param Sequence['DiscoveryJobDiscoveryDetailsCredentialsItemArgs'] items: List of DiscoveryJob credentials.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.DiscoveryJobDiscoveryDetailsCredentialsItem']:
        """
        List of DiscoveryJob credentials.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class DiscoveryJobDiscoveryDetailsCredentialsItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialName":
            suggest = "credential_name"
        elif key == "credentialType":
            suggest = "credential_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryJobDiscoveryDetailsCredentialsItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryJobDiscoveryDetailsCredentialsItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryJobDiscoveryDetailsCredentialsItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_name: str,
                 credential_type: str,
                 properties: 'outputs.DiscoveryJobDiscoveryDetailsCredentialsItemProperties'):
        """
        :param str credential_name: Name of Credential
        :param str credential_type: Name of Credential Type
        :param 'DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs' properties: Property Details
        """
        pulumi.set(__self__, "credential_name", credential_name)
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> str:
        """
        Name of Credential
        """
        return pulumi.get(self, "credential_name")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        Name of Credential Type
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter
    def properties(self) -> 'outputs.DiscoveryJobDiscoveryDetailsCredentialsItemProperties':
        """
        Property Details
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class DiscoveryJobDiscoveryDetailsCredentialsItemProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertiesMap":
            suggest = "properties_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryJobDiscoveryDetailsCredentialsItemProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryJobDiscoveryDetailsCredentialsItemProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryJobDiscoveryDetailsCredentialsItemProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 properties_map: Optional[Mapping[str, Any]] = None):
        """
        :param Mapping[str, Any] properties_map: Key/Value pair of Property
        """
        if properties_map is not None:
            pulumi.set(__self__, "properties_map", properties_map)

    @property
    @pulumi.getter(name="propertiesMap")
    def properties_map(self) -> Optional[Mapping[str, Any]]:
        """
        Key/Value pair of Property
        """
        return pulumi.get(self, "properties_map")


@pulumi.output_type
class DiscoveryJobDiscoveryDetailsProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertiesMap":
            suggest = "properties_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryJobDiscoveryDetailsProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryJobDiscoveryDetailsProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryJobDiscoveryDetailsProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 properties_map: Optional[Mapping[str, Any]] = None):
        """
        :param Mapping[str, Any] properties_map: Key/Value pair of Property
        """
        if properties_map is not None:
            pulumi.set(__self__, "properties_map", properties_map)

    @property
    @pulumi.getter(name="propertiesMap")
    def properties_map(self) -> Optional[Mapping[str, Any]]:
        """
        Key/Value pair of Property
        """
        return pulumi.get(self, "properties_map")


@pulumi.output_type
class DiscoveryJobDiscoveryDetailsTags(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propertiesMap":
            suggest = "properties_map"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryJobDiscoveryDetailsTags. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryJobDiscoveryDetailsTags.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryJobDiscoveryDetailsTags.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 properties_map: Optional[Mapping[str, Any]] = None):
        """
        :param Mapping[str, Any] properties_map: Key/Value pair of Property
        """
        if properties_map is not None:
            pulumi.set(__self__, "properties_map", properties_map)

    @property
    @pulumi.getter(name="propertiesMap")
    def properties_map(self) -> Optional[Mapping[str, Any]]:
        """
        Key/Value pair of Property
        """
        return pulumi.get(self, "properties_map")


@pulumi.output_type
class MonitoredResourceAdditionalAlias(dict):
    def __init__(__self__, *,
                 credential: 'outputs.MonitoredResourceAdditionalAliasCredential',
                 name: str,
                 source: str):
        """
        :param 'MonitoredResourceAdditionalAliasCredentialArgs' credential: (Updatable) Monitored Resource Alias Reference Source Credential.
        :param str name: (Updatable) Property Name.
        :param str source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def credential(self) -> 'outputs.MonitoredResourceAdditionalAliasCredential':
        """
        (Updatable) Monitored Resource Alias Reference Source Credential.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class MonitoredResourceAdditionalAliasCredential(dict):
    def __init__(__self__, *,
                 name: str,
                 service: str,
                 source: str):
        """
        :param str name: (Updatable) Property Name.
        :param str service: (Updatable) The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        :param str source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        (Updatable) The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class MonitoredResourceAdditionalCredential(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialType":
            suggest = "credential_type"
        elif key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourceAdditionalCredential. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourceAdditionalCredential.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourceAdditionalCredential.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_type: Optional[str] = None,
                 description: Optional[str] = None,
                 key_id: Optional[str] = None,
                 name: Optional[str] = None,
                 properties: Optional[Sequence['outputs.MonitoredResourceAdditionalCredentialProperty']] = None,
                 source: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str credential_type: (Updatable) Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
               * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
               * PLAINTEXT - The credential properties will have credentials in plain text format.
               * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        :param str description: (Updatable) The user-specified textual description of the credential.
        :param str key_id: (Updatable) The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        :param str name: (Updatable) Property Name.
        :param Sequence['MonitoredResourceAdditionalCredentialPropertyArgs'] properties: (Updatable) List of monitored resource properties.
        :param str source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        :param str type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[str]:
        """
        (Updatable) Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
        * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
        * PLAINTEXT - The credential properties will have credentials in plain text format.
        * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        (Updatable) The user-specified textual description of the credential.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        """
        (Updatable) The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence['outputs.MonitoredResourceAdditionalCredentialProperty']]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitoredResourceAdditionalCredentialProperty(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: (Updatable) Property Name.
        :param str value: (Updatable) Property Value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) Property Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MonitoredResourceAliases(dict):
    def __init__(__self__, *,
                 credential: 'outputs.MonitoredResourceAliasesCredential',
                 name: str,
                 source: str):
        """
        :param 'MonitoredResourceAliasesCredentialArgs' credential: (Updatable) Monitored Resource Alias Reference Source Credential.
        :param str name: (Updatable) Property Name.
        :param str source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def credential(self) -> 'outputs.MonitoredResourceAliasesCredential':
        """
        (Updatable) Monitored Resource Alias Reference Source Credential.
        """
        return pulumi.get(self, "credential")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class MonitoredResourceAliasesCredential(dict):
    def __init__(__self__, *,
                 name: str,
                 service: str,
                 source: str):
        """
        :param str name: (Updatable) Property Name.
        :param str service: (Updatable) The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        :param str source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        (Updatable) The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class MonitoredResourceCredentials(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "credentialType":
            suggest = "credential_type"
        elif key == "keyId":
            suggest = "key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourceCredentials. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourceCredentials.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourceCredentials.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 credential_type: Optional[str] = None,
                 description: Optional[str] = None,
                 key_id: Optional[str] = None,
                 name: Optional[str] = None,
                 properties: Optional[Sequence['outputs.MonitoredResourceCredentialsProperty']] = None,
                 source: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str credential_type: (Updatable) Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
               * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
               * PLAINTEXT - The credential properties will have credentials in plain text format.
               * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        :param str description: (Updatable) The user-specified textual description of the credential.
        :param str key_id: (Updatable) The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        :param str name: (Updatable) Property Name.
        :param Sequence['MonitoredResourceCredentialsPropertyArgs'] properties: (Updatable) List of monitored resource properties.
        :param str source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        :param str type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[str]:
        """
        (Updatable) Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
        * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
        * PLAINTEXT - The credential properties will have credentials in plain text format.
        * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        (Updatable) The user-specified textual description of the credential.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[str]:
        """
        (Updatable) The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence['outputs.MonitoredResourceCredentialsProperty']]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitoredResourceCredentialsProperty(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: (Updatable) Property Name.
        :param str value: (Updatable) Property Value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) Property Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MonitoredResourceDatabaseConnectionDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceName":
            suggest = "service_name"
        elif key == "connectorId":
            suggest = "connector_id"
        elif key == "dbId":
            suggest = "db_id"
        elif key == "dbUniqueName":
            suggest = "db_unique_name"
        elif key == "sslSecretId":
            suggest = "ssl_secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourceDatabaseConnectionDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourceDatabaseConnectionDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourceDatabaseConnectionDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 protocol: str,
                 service_name: str,
                 connector_id: Optional[str] = None,
                 db_id: Optional[str] = None,
                 db_unique_name: Optional[str] = None,
                 ssl_secret_id: Optional[str] = None):
        """
        :param int port: (Updatable) Listener Port number used for connection requests.
        :param str protocol: (Updatable) Protocol used in DB connection string when connecting to external database service.
        :param str service_name: (Updatable) Service name used for connection requests.
        :param str connector_id: (Updatable) Database connector Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str db_id: (Updatable) dbId of the database.
        :param str db_unique_name: (Updatable) UniqueName used for database connection requests.
        :param str ssl_secret_id: (Updatable) SSL Secret Identifier for TCPS connector in Oracle Cloud Infrastructure Vault[OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "service_name", service_name)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if db_id is not None:
            pulumi.set(__self__, "db_id", db_id)
        if db_unique_name is not None:
            pulumi.set(__self__, "db_unique_name", db_unique_name)
        if ssl_secret_id is not None:
            pulumi.set(__self__, "ssl_secret_id", ssl_secret_id)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        (Updatable) Listener Port number used for connection requests.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        (Updatable) Protocol used in DB connection string when connecting to external database service.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        (Updatable) Service name used for connection requests.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[str]:
        """
        (Updatable) Database connector Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter(name="dbId")
    def db_id(self) -> Optional[str]:
        """
        (Updatable) dbId of the database.
        """
        return pulumi.get(self, "db_id")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> Optional[str]:
        """
        (Updatable) UniqueName used for database connection requests.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> Optional[str]:
        """
        (Updatable) SSL Secret Identifier for TCPS connector in Oracle Cloud Infrastructure Vault[OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "ssl_secret_id")


@pulumi.output_type
class MonitoredResourceProperty(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: (Updatable) Property Name.
        :param str value: (Updatable) Property Value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) Property Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str name: Monitored Resource Name.
        :param str type: Monitored Resource Type.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitoredResourcesAssociateMonitoredResourceSourceResourceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourcesAssociateMonitoredResourceSourceResourceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourcesAssociateMonitoredResourceSourceResourceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourcesAssociateMonitoredResourceSourceResourceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str name: Monitored Resource Name.
        :param str type: Monitored Resource Type.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitoredResourcesListMemberItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "parentId":
            suggest = "parent_id"
        elif key == "resourceDisplayName":
            suggest = "resource_display_name"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceName":
            suggest = "resource_name"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "systemTags":
            suggest = "system_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourcesListMemberItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourcesListMemberItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourcesListMemberItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[str] = None,
                 defined_tags: Optional[Mapping[str, Any]] = None,
                 external_id: Optional[str] = None,
                 freeform_tags: Optional[Mapping[str, Any]] = None,
                 host_name: Optional[str] = None,
                 parent_id: Optional[str] = None,
                 resource_display_name: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 resource_name: Optional[str] = None,
                 resource_type: Optional[str] = None,
                 state: Optional[str] = None,
                 system_tags: Optional[Mapping[str, Any]] = None):
        """
        :param str compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str host_name: Monitored Resource Host Name.
        :param str parent_id: Parent monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str resource_display_name: Monitored resource display name.
        :param str resource_id: Monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str resource_name: Monitored Resource Name.
        :param str resource_type: Monitored Resource Type.
        :param str state: The current state of the Resource.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if resource_display_name is not None:
            pulumi.set(__self__, "resource_display_name", resource_display_name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        Monitored Resource Host Name.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[str]:
        """
        Parent monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="resourceDisplayName")
    def resource_display_name(self) -> Optional[str]:
        """
        Monitored resource display name.
        """
        return pulumi.get(self, "resource_display_name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        Monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[str]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")


@pulumi.output_type
class MonitoredResourcesSearchAssociationItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "associationType":
            suggest = "association_type"
        elif key == "destinationResourceDetails":
            suggest = "destination_resource_details"
        elif key == "destinationResourceId":
            suggest = "destination_resource_id"
        elif key == "sourceResourceDetails":
            suggest = "source_resource_details"
        elif key == "sourceResourceId":
            suggest = "source_resource_id"
        elif key == "timeCreated":
            suggest = "time_created"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourcesSearchAssociationItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourcesSearchAssociationItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourcesSearchAssociationItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 association_type: Optional[str] = None,
                 destination_resource_details: Optional[Sequence['outputs.MonitoredResourcesSearchAssociationItemDestinationResourceDetail']] = None,
                 destination_resource_id: Optional[str] = None,
                 source_resource_details: Optional[Sequence['outputs.MonitoredResourcesSearchAssociationItemSourceResourceDetail']] = None,
                 source_resource_id: Optional[str] = None,
                 time_created: Optional[str] = None):
        """
        :param str association_type: Association type filter to search associated resources.
        :param Sequence['MonitoredResourcesSearchAssociationItemDestinationResourceDetailArgs'] destination_resource_details: Association Resource Details.
        :param str destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param Sequence['MonitoredResourcesSearchAssociationItemSourceResourceDetailArgs'] source_resource_details: Association Resource Details.
        :param str source_resource_id: Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str time_created: The association creation time. An RFC3339 formatted datetime string.
        """
        if association_type is not None:
            pulumi.set(__self__, "association_type", association_type)
        if destination_resource_details is not None:
            pulumi.set(__self__, "destination_resource_details", destination_resource_details)
        if destination_resource_id is not None:
            pulumi.set(__self__, "destination_resource_id", destination_resource_id)
        if source_resource_details is not None:
            pulumi.set(__self__, "source_resource_details", source_resource_details)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> Optional[str]:
        """
        Association type filter to search associated resources.
        """
        return pulumi.get(self, "association_type")

    @property
    @pulumi.getter(name="destinationResourceDetails")
    def destination_resource_details(self) -> Optional[Sequence['outputs.MonitoredResourcesSearchAssociationItemDestinationResourceDetail']]:
        """
        Association Resource Details.
        """
        return pulumi.get(self, "destination_resource_details")

    @property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> Optional[str]:
        """
        Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "destination_resource_id")

    @property
    @pulumi.getter(name="sourceResourceDetails")
    def source_resource_details(self) -> Optional[Sequence['outputs.MonitoredResourcesSearchAssociationItemSourceResourceDetail']]:
        """
        Association Resource Details.
        """
        return pulumi.get(self, "source_resource_details")

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[str]:
        """
        Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "source_resource_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        The association creation time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class MonitoredResourcesSearchAssociationItemDestinationResourceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourcesSearchAssociationItemDestinationResourceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourcesSearchAssociationItemDestinationResourceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourcesSearchAssociationItemDestinationResourceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str name: Monitored Resource Name.
        :param str type: Monitored Resource Type.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitoredResourcesSearchAssociationItemSourceResourceDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compartmentId":
            suggest = "compartment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourcesSearchAssociationItemSourceResourceDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourcesSearchAssociationItemSourceResourceDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourcesSearchAssociationItemSourceResourceDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compartment_id: Optional[str] = None,
                 name: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str name: Monitored Resource Name.
        :param str type: Monitored Resource Type.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitoredResourcesSearchItem(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedTags":
            suggest = "defined_tags"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "externalId":
            suggest = "external_id"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "hostName":
            suggest = "host_name"
        elif key == "managementAgentId":
            suggest = "management_agent_id"
        elif key == "systemTags":
            suggest = "system_tags"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeUpdated":
            suggest = "time_updated"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MonitoredResourcesSearchItem. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MonitoredResourcesSearchItem.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MonitoredResourcesSearchItem.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 defined_tags: Optional[Mapping[str, Any]] = None,
                 display_name: Optional[str] = None,
                 external_id: Optional[str] = None,
                 freeform_tags: Optional[Mapping[str, Any]] = None,
                 host_name: Optional[str] = None,
                 id: Optional[str] = None,
                 management_agent_id: Optional[str] = None,
                 name: Optional[str] = None,
                 properties: Optional[Sequence['outputs.MonitoredResourcesSearchItemProperty']] = None,
                 state: Optional[str] = None,
                 system_tags: Optional[Mapping[str, Any]] = None,
                 time_created: Optional[str] = None,
                 time_updated: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str display_name: Monitored resource display name.
        :param str external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str host_name: A filter to return resources with host name match.
        :param str id: Monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str management_agent_id: A filter to return resources with matching management agent id.
        :param str name: A filter to return resources that match exact resource name.
        :param Sequence['MonitoredResourcesSearchItemPropertyArgs'] properties: List of monitored resource properties.
        :param str state: A filter to return resources with matching lifecycle state.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: Monitored resource creation time. An RFC3339 formatted datetime string.
        :param str time_updated: Monitored resource update time. An RFC3339 formatted datetime string.
        :param str type: A filter to return resources that match resource type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Monitored resource display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[str]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[str]:
        """
        A filter to return resources with host name match.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[str]:
        """
        A filter to return resources with matching management agent id.
        """
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A filter to return resources that match exact resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Optional[Sequence['outputs.MonitoredResourcesSearchItemProperty']]:
        """
        List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        A filter to return resources with matching lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        Monitored resource creation time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[str]:
        """
        Monitored resource update time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        A filter to return resources that match resource type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class MonitoredResourcesSearchItemProperty(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: A filter to return resources that match exact resource name.
        :param str value: Property Value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A filter to return resources that match exact resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Property Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDiscoveryJobDiscoveryDetailResult(dict):
    def __init__(__self__, *,
                 agent_id: str,
                 credentials: Sequence['outputs.GetDiscoveryJobDiscoveryDetailCredentialResult'],
                 properties: Sequence['outputs.GetDiscoveryJobDiscoveryDetailPropertyResult'],
                 resource_name: str,
                 resource_type: str,
                 tags: Sequence['outputs.GetDiscoveryJobDiscoveryDetailTagResult']):
        """
        :param str agent_id: The OCID of Management Agent
        :param Sequence['GetDiscoveryJobDiscoveryDetailCredentialArgs'] credentials: List of DiscoveryJOb Credential Details.
        :param Sequence['GetDiscoveryJobDiscoveryDetailPropertyArgs'] properties: Property Details
        :param str resource_name: The Name of resource type
        :param str resource_type: Resource Type.
        :param Sequence['GetDiscoveryJobDiscoveryDetailTagArgs'] tags: Property Details
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> str:
        """
        The OCID of Management Agent
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter
    def credentials(self) -> Sequence['outputs.GetDiscoveryJobDiscoveryDetailCredentialResult']:
        """
        List of DiscoveryJOb Credential Details.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetDiscoveryJobDiscoveryDetailPropertyResult']:
        """
        Property Details
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The Name of resource type
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Resource Type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetDiscoveryJobDiscoveryDetailTagResult']:
        """
        Property Details
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetDiscoveryJobDiscoveryDetailCredentialResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDiscoveryJobDiscoveryDetailCredentialItemResult']):
        """
        :param Sequence['GetDiscoveryJobDiscoveryDetailCredentialItemArgs'] items: List of DiscoveryJob credentials.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDiscoveryJobDiscoveryDetailCredentialItemResult']:
        """
        List of DiscoveryJob credentials.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDiscoveryJobDiscoveryDetailCredentialItemResult(dict):
    def __init__(__self__, *,
                 credential_name: str,
                 credential_type: str,
                 properties: Sequence['outputs.GetDiscoveryJobDiscoveryDetailCredentialItemPropertyResult']):
        """
        :param str credential_name: Name of Credential
        :param str credential_type: Name of Credential Type
        :param Sequence['GetDiscoveryJobDiscoveryDetailCredentialItemPropertyArgs'] properties: Property Details
        """
        pulumi.set(__self__, "credential_name", credential_name)
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> str:
        """
        Name of Credential
        """
        return pulumi.get(self, "credential_name")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        Name of Credential Type
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetDiscoveryJobDiscoveryDetailCredentialItemPropertyResult']:
        """
        Property Details
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class GetDiscoveryJobDiscoveryDetailCredentialItemPropertyResult(dict):
    def __init__(__self__, *,
                 properties_map: Mapping[str, Any]):
        """
        :param Mapping[str, Any] properties_map: Key/Value pair of Property
        """
        pulumi.set(__self__, "properties_map", properties_map)

    @property
    @pulumi.getter(name="propertiesMap")
    def properties_map(self) -> Mapping[str, Any]:
        """
        Key/Value pair of Property
        """
        return pulumi.get(self, "properties_map")


@pulumi.output_type
class GetDiscoveryJobDiscoveryDetailPropertyResult(dict):
    def __init__(__self__, *,
                 properties_map: Mapping[str, Any]):
        """
        :param Mapping[str, Any] properties_map: Key/Value pair of Property
        """
        pulumi.set(__self__, "properties_map", properties_map)

    @property
    @pulumi.getter(name="propertiesMap")
    def properties_map(self) -> Mapping[str, Any]:
        """
        Key/Value pair of Property
        """
        return pulumi.get(self, "properties_map")


@pulumi.output_type
class GetDiscoveryJobDiscoveryDetailTagResult(dict):
    def __init__(__self__, *,
                 properties_map: Mapping[str, Any]):
        """
        :param Mapping[str, Any] properties_map: Key/Value pair of Property
        """
        pulumi.set(__self__, "properties_map", properties_map)

    @property
    @pulumi.getter(name="propertiesMap")
    def properties_map(self) -> Mapping[str, Any]:
        """
        Key/Value pair of Property
        """
        return pulumi.get(self, "properties_map")


@pulumi.output_type
class GetDiscoveryJobLogsDiscoveryJobLogCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDiscoveryJobLogsDiscoveryJobLogCollectionItemResult']):
        """
        :param Sequence['GetDiscoveryJobLogsDiscoveryJobLogCollectionItemArgs'] items: List of logs
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDiscoveryJobLogsDiscoveryJobLogCollectionItemResult']:
        """
        List of logs
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDiscoveryJobLogsDiscoveryJobLogCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: str,
                 log_message: str,
                 log_type: str,
                 time_created: str):
        """
        :param str id: The OCID of Discovery job
        :param str log_message: Log message
        :param str log_type: The log type like INFO, WARNING, ERROR, SUCCESS
        :param str time_created: Time the Job log was created
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "log_message", log_message)
        pulumi.set(__self__, "log_type", log_type)
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of Discovery job
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="logMessage")
    def log_message(self) -> str:
        """
        Log message
        """
        return pulumi.get(self, "log_message")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type like INFO, WARNING, ERROR, SUCCESS
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Time the Job log was created
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetDiscoveryJobLogsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDiscoveryJobsDiscoveryJobCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDiscoveryJobsDiscoveryJobCollectionItemResult']):
        """
        :param Sequence['GetDiscoveryJobsDiscoveryJobCollectionItemArgs'] items: List of DiscoveryJob credentials.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDiscoveryJobsDiscoveryJobCollectionItemResult']:
        """
        List of DiscoveryJob credentials.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDiscoveryJobsDiscoveryJobCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 discovery_type: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 resource_name: str,
                 resource_type: str,
                 state: str,
                 status: str,
                 status_message: str,
                 system_tags: Mapping[str, Any],
                 tenant_id: str,
                 time_updated: str,
                 user_id: str):
        """
        :param str compartment_id: The ID of the compartment in which data is listed.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param str discovery_type: Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str id: The OCID of Discovery job
        :param str resource_name: The Name of resource type
        :param str resource_type: Resource Type.
        :param str state: The current state of the DiscoveryJob Resource.
        :param str status: Specifies the status of the discovery job
        :param str status_message: The short summary of the status of the discovery job
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str tenant_id: The OCID of Tenant
        :param str time_updated: The time the discovery Job was updated.
        :param str user_id: The OCID of user in which the job is submitted
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "discovery_type", discovery_type)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_message", status_message)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The ID of the compartment in which data is listed.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="discoveryType")
    def discovery_type(self) -> str:
        """
        Add option submits new discovery Job. Add with retry option to re-submit failed discovery job. Refresh option refreshes the existing discovered resources.
        """
        return pulumi.get(self, "discovery_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of Discovery job
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The Name of resource type
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        Resource Type.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the DiscoveryJob Resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Specifies the status of the discovery job
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> str:
        """
        The short summary of the status of the discovery job
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> str:
        """
        The OCID of Tenant
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the discovery Job was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        The OCID of user in which the job is submitted
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetDiscoveryJobsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only discovery jobs that match the entire resource name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only discovery jobs that match the entire resource name given.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMonitoredResourceAdditionalAliasResult(dict):
    def __init__(__self__, *,
                 credentials: Sequence['outputs.GetMonitoredResourceAdditionalAliasCredentialResult'],
                 name: str,
                 source: str):
        """
        :param Sequence['GetMonitoredResourceAdditionalAliasCredentialArgs'] credentials: Monitored Resource Alias Reference Source Credential.
        :param str name: Property Name.
        :param str source: The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def credentials(self) -> Sequence['outputs.GetMonitoredResourceAdditionalAliasCredentialResult']:
        """
        Monitored Resource Alias Reference Source Credential.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetMonitoredResourceAdditionalAliasCredentialResult(dict):
    def __init__(__self__, *,
                 name: str,
                 service: str,
                 source: str):
        """
        :param str name: Property Name.
        :param str service: The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        :param str source: The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetMonitoredResourceAdditionalCredentialResult(dict):
    def __init__(__self__, *,
                 credential_type: str,
                 description: str,
                 key_id: str,
                 name: str,
                 properties: Sequence['outputs.GetMonitoredResourceAdditionalCredentialPropertyResult'],
                 source: str,
                 type: str):
        """
        :param str credential_type: Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
               * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
               * PLAINTEXT - The credential properties will have credentials in plain text format.
               * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        :param str description: The user-specified textual description of the credential.
        :param str key_id: The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        :param str name: Property Name.
        :param Sequence['GetMonitoredResourceAdditionalCredentialPropertyArgs'] properties: List of monitored resource properties.
        :param str source: The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        :param str type: Monitored Resource Type.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
        * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
        * PLAINTEXT - The credential properties will have credentials in plain text format.
        * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The user-specified textual description of the credential.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetMonitoredResourceAdditionalCredentialPropertyResult']:
        """
        List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMonitoredResourceAdditionalCredentialPropertyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Property Name.
        :param str value: Property Value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Property Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetMonitoredResourceAliasResult(dict):
    def __init__(__self__, *,
                 credentials: Sequence['outputs.GetMonitoredResourceAliasCredentialResult'],
                 name: str,
                 source: str):
        """
        :param Sequence['GetMonitoredResourceAliasCredentialArgs'] credentials: Monitored Resource Alias Reference Source Credential.
        :param str name: Property Name.
        :param str source: The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        pulumi.set(__self__, "credentials", credentials)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def credentials(self) -> Sequence['outputs.GetMonitoredResourceAliasCredentialResult']:
        """
        Monitored Resource Alias Reference Source Credential.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetMonitoredResourceAliasCredentialResult(dict):
    def __init__(__self__, *,
                 name: str,
                 service: str,
                 source: str):
        """
        :param str name: Property Name.
        :param str service: The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        :param str source: The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class GetMonitoredResourceCredentialResult(dict):
    def __init__(__self__, *,
                 credential_type: str,
                 description: str,
                 key_id: str,
                 name: str,
                 properties: Sequence['outputs.GetMonitoredResourceCredentialPropertyResult'],
                 source: str,
                 type: str):
        """
        :param str credential_type: Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
               * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
               * PLAINTEXT - The credential properties will have credentials in plain text format.
               * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        :param str description: The user-specified textual description of the credential.
        :param str key_id: The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        :param str name: Property Name.
        :param Sequence['GetMonitoredResourceCredentialPropertyArgs'] properties: List of monitored resource properties.
        :param str source: The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        :param str type: Monitored Resource Type.
        """
        pulumi.set(__self__, "credential_type", credential_type)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> str:
        """
        Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
        * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
        * PLAINTEXT - The credential properties will have credentials in plain text format.
        * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The user-specified textual description of the credential.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetMonitoredResourceCredentialPropertyResult']:
        """
        List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMonitoredResourceCredentialPropertyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Property Name.
        :param str value: Property Value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Property Value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetMonitoredResourceDatabaseConnectionDetailResult(dict):
    def __init__(__self__, *,
                 connector_id: str,
                 db_id: str,
                 db_unique_name: str,
                 port: int,
                 protocol: str,
                 service_name: str,
                 ssl_secret_id: str):
        """
        :param str connector_id: Database connector Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param str db_id: dbId of the database.
        :param str db_unique_name: UniqueName used for database connection requests.
        :param int port: Listener Port number used for connection requests.
        :param str protocol: Protocol used in DB connection string when connecting to external database service.
        :param str service_name: Service name used for connection requests.
        :param str ssl_secret_id: SSL Secret Identifier for TCPS connector in Oracle Cloud Infrastructure Vault[OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        pulumi.set(__self__, "connector_id", connector_id)
        pulumi.set(__self__, "db_id", db_id)
        pulumi.set(__self__, "db_unique_name", db_unique_name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "ssl_secret_id", ssl_secret_id)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> str:
        """
        Database connector Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "connector_id")

    @property
    @pulumi.getter(name="dbId")
    def db_id(self) -> str:
        """
        dbId of the database.
        """
        return pulumi.get(self, "db_id")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> str:
        """
        UniqueName used for database connection requests.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Listener Port number used for connection requests.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol used in DB connection string when connecting to external database service.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Service name used for connection requests.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> str:
        """
        SSL Secret Identifier for TCPS connector in Oracle Cloud Infrastructure Vault[OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "ssl_secret_id")


@pulumi.output_type
class GetMonitoredResourcePropertyResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: Property Name.
        :param str value: Property Value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Property Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Property Value.
        """
        return pulumi.get(self, "value")


