/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.forge.platform;

import com.google.common.base.Strings;
import customskinloader.forge.ForgePlugin;
import customskinloader.forge.platform.IFMLPlatform;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.objectweb.asm.commons.Remapper;

public class DefaultFMLPlatform
implements IFMLPlatform {
    private static final String FML_PLUGIN_WRAPPER = "net.minecraftforge.fml.relauncher.CoreModManager$FMLPluginWrapper";

    @Override
    public IFMLPlatform.Result init(Set<IFMLPlatform> otherPlatforms) {
        return otherPlatforms.size() == 0 ? IFMLPlatform.Result.ACCEPT : IFMLPlatform.Result.REJECT;
    }

    @Override
    public String getSide() {
        return FMLLaunchHandler.side().name();
    }

    @Override
    public List<String> getIgnoredMods() {
        try {
            return (List)CoreModManager.class.getMethod("getLoadedCoremods", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return CoreModManager.getIgnoredMods();
        }
    }

    @Override
    public String getName() {
        Annotation name = this.getNameAnnotation();
        if (name != null && !Strings.isNullOrEmpty((String)this.getNameValue(name))) {
            return this.getNameValue(name);
        }
        return this.getFMLLoadingPluginClass().getSimpleName();
    }

    @Override
    public int getSortingIndex() {
        Annotation index = this.getSortingIndexAnnotation();
        return index != null ? this.getSortingIndexValue(index) : 0;
    }

    @Override
    public ITweaker createFMLPluginWrapper(String name, File location, int sortIndex) throws Exception {
        Constructor<?> constructor = Class.forName(FML_PLUGIN_WRAPPER).getDeclaredConstructor(String.class, IFMLLoadingPlugin.class, File.class, Integer.TYPE, String[].class);
        constructor.setAccessible(true);
        return (ITweaker)constructor.newInstance(name, this.getFMLLoadingPluginClass().newInstance(), location, sortIndex, new String[0]);
    }

    @Override
    public void addLoadPlugins(ITweaker tweaker) throws Exception {
        Field field = CoreModManager.class.getDeclaredField("loadPlugins");
        field.setAccessible(true);
        ((List)field.get(null)).add(tweaker);
    }

    @Override
    public Remapper getRemapper() {
        return new Supplier<Remapper>(){

            @Override
            public Remapper get() {
                return FMLDeobfuscatingRemapper.INSTANCE;
            }
        }.get();
    }

    protected Class<?> getFMLLoadingPluginClass() {
        return ForgePlugin.class;
    }

    protected Annotation getNameAnnotation() {
        return this.getFMLLoadingPluginClass().getAnnotation(IFMLLoadingPlugin.Name.class);
    }

    protected String getNameValue(Annotation annotationIn) {
        return ((IFMLLoadingPlugin.Name)annotationIn).value();
    }

    protected Annotation getSortingIndexAnnotation() {
        return this.getFMLLoadingPluginClass().getAnnotation(IFMLLoadingPlugin.SortingIndex.class);
    }

    protected int getSortingIndexValue(Annotation annotationIn) {
        return ((IFMLLoadingPlugin.SortingIndex)annotationIn).value();
    }
}

