import sys
import os
import time

import requests
import typer


class Audio:
    bvid = ""
    title = ""
    playUrl = "http://api.bilibili.com/x/player/wbi/playurl"
    part_list = []

    def __init__(self, bvid: str) -> None:
        if bvid is None:
            raise ValueError("bvid is None")

        self.bvid = bvid

        # 获取cid和title
        if len(bvid) == 12:
            # BV号
            self.__get_cid_title(bvid)
        else:
            # AV号
            self.__get_cid_title(bvid[:12])


    def download(self):
        headers = {
            "User-Agent": "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.13; rv:56.0) Gecko/20100101 Firefox/56.0",
            "Accept": "*/*",
            "Accept-Language": "en-US,en;q=0.5",
            "Accept-Encoding": "gzip, deflate, br",
            "Range": "bytes=0-",
            "Origin": "https://www.bilibili.com",
            "Connection": "keep-alive",
            "Referer": "https://www.bilibili.com/video/{bvid}".format(bvid=self.bvid),
        }

        start_time = time.time()
        try:
            for cid, part in zip(self.cid_list, self.part_list):
                baseUrl = requests.get(
                    self.playUrl,
                    params={
                        "fnval": 16,
                        "bvid": self.bvid,
                        "cid": cid,
                    },
                ).json()["data"]["dash"]["audio"][0]["baseUrl"]

                response = requests.get(url=baseUrl, headers=headers, stream=True)

                total_size = int(response.headers.get("content-length", 0))
                temp_size = 0

                # 如果文件已存在，则跳过下载
                file_path = f"{self.title}-{part}.mp3"
                if os.path.exists(file_path):
                    typer.echo(f"{self.title} already exists, skip for now")
                    return

                with open(file_path, "wb") as f:
                    for chunk in response.iter_content(chunk_size=1024):
                        if chunk:
                            f.write(chunk)
                            f.flush()

                            temp_size += len(chunk)
                            done = int(50 * temp_size / total_size)
                            sys.stdout.write(
                                "\r[%s%s] %s/%s %s"
                                % (
                                    "#" * done,
                                    "-" * (50 - done),
                                    temp_size,
                                    total_size,
                                    self.title,
                                )
                            )
                            sys.stdout.flush()

        except Exception as e:
            typer.echo("Download failed")
            typer.echo("Error: " + str(e))
            pass

        end_time = time.time()

        sys.stdout.write(
            " " + str(round(end_time - start_time, 2)) + " seconds download finish\n"
        )

    def __get_cid_title(self, bvid: str):
        url = "https://api.bilibili.com/x/web-interface/view?bvid={bvid}".format(
            bvid=bvid
        )
        try:
            response = requests.get(url)
            data = response.json().get("data")
            self.title = self.__title_process(data.get("title"))

            # 这里是否也应该也使用get方法？
            self.cid_list = [str(page["cid"]) for page in data["pages"]]
            self.part_list = [self.__title_process(str(page["part"])) for page in data["pages"]]

        except ValueError as e:
            raise e

        except Exception as e:
            raise e


    def __title_process(self, title: str):
        replaceList = ["?", "\\", "*", "|", "<", ">", ":", "/", " "]
        for ch in replaceList:
            title = title.replace(ch, "-")

        return title