/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.sqlbuilder;

import com.healthmarketscience.common.util.AppendableExt;
import com.healthmarketscience.sqlbuilder.Converter;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.Query;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.SqlObjectList;
import com.healthmarketscience.sqlbuilder.TableObject;
import com.healthmarketscience.sqlbuilder.ValidationContext;
import com.healthmarketscience.sqlbuilder.ValidationException;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseGrantQuery<ThisType extends BaseGrantQuery<ThisType>>
extends Query<ThisType> {
    public static final SqlObject PUBLIC_GRANTEE = new CustomSql("PUBLIC");
    private static final Privilege PRIVILEGE_ALL = new Privilege(Privilege.Type.ALL, new Column[0]);
    private static final Privilege PRIVILEGE_SELECT = new Privilege(Privilege.Type.SELECT, new Column[0]);
    private static final Privilege PRIVILEGE_DELETE = new Privilege(Privilege.Type.DELETE, new Column[0]);
    private static final Privilege PRIVILEGE_USAGE = new Privilege(Privilege.Type.USAGE, new Column[0]);
    protected SqlObjectList<SqlObject> _grantees = SqlObjectList.create();
    protected SqlObjectList<SqlObject> _privileges = SqlObjectList.create();
    protected SqlObject _targetObj;

    protected BaseGrantQuery() {
    }

    public ThisType addCustomGrantees(Object ... grantees) {
        this._grantees.addObjects(Converter.CUSTOM_TO_OBJ, grantees);
        return (ThisType)((BaseGrantQuery)this.getThisType());
    }

    public ThisType addGrantees(String ... grantees) {
        return this.addCustomGrantees(grantees);
    }

    public ThisType addCustomPrivileges(Object ... privileges) {
        this._privileges.addObjects(Converter.CUSTOM_TO_OBJ, privileges);
        return (ThisType)((BaseGrantQuery)this.getThisType());
    }

    public ThisType addPrivileges(Privilege ... privileges) {
        return this.addCustomPrivileges(privileges);
    }

    public ThisType setCustomTarget(Object target) {
        this._targetObj = Converter.toCustomSqlObject(target);
        return (ThisType)((BaseGrantQuery)this.getThisType());
    }

    public ThisType setTarget(TargetObject target) {
        return this.setCustomTarget(target);
    }

    public static Privilege privilegeAll() {
        return PRIVILEGE_ALL;
    }

    public static Privilege privilegeSelect() {
        return PRIVILEGE_SELECT;
    }

    public static Privilege privilegeDelete() {
        return PRIVILEGE_DELETE;
    }

    public static Privilege privilegeInsert(Column ... columns) {
        return new Privilege(Privilege.Type.INSERT, columns);
    }

    public static Privilege privilegeUpdate(Column ... columns) {
        return new Privilege(Privilege.Type.UPDATE, columns);
    }

    public static Privilege privilegeReferences(Column ... columns) {
        return new Privilege(Privilege.Type.REFERENCES, columns);
    }

    public static Privilege privilegeUsage() {
        return PRIVILEGE_USAGE;
    }

    public static TargetObject targetTable(Table table) {
        return new TargetObject(TargetObject.Type.TABLE, new TableObject(table));
    }

    @Override
    protected void collectSchemaObjects(ValidationContext vContext) {
        super.collectSchemaObjects(vContext);
        this._grantees.collectSchemaObjects(vContext);
        this._privileges.collectSchemaObjects(vContext);
        this._targetObj.collectSchemaObjects(vContext);
    }

    @Override
    public void validate(ValidationContext vContext) throws ValidationException {
        super.validate(vContext);
        if (this._privileges.isEmpty()) {
            throw new ValidationException("Must specify privileges");
        }
        if (this._grantees.isEmpty()) {
            throw new ValidationException("Must specify grantees");
        }
        boolean hasAll = false;
        for (SqlObject privilege : this._privileges) {
            if (!(privilege instanceof Privilege) || ((Privilege)privilege)._type != Privilege.Type.ALL) continue;
            hasAll = true;
            break;
        }
        if (hasAll && this._privileges.size() > 1) {
            throw new ValidationException("May not have other privileges with ALL");
        }
    }

    public static class TargetObject
    extends SqlObject {
        private Type _type;
        private SqlObject _name;

        public TargetObject(Type type, SqlObject name) {
            this._type = type;
            this._name = name;
        }

        protected void collectSchemaObjects(ValidationContext vContext) {
            this._name.collectSchemaObjects(vContext);
        }

        public void appendTo(AppendableExt app) throws IOException {
            app.append((Object)this._type).append(this._name);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            TABLE("TABLE "),
            DOMAIN("DOMAIN "),
            COLLATION("COLLATION "),
            CHARACTER_SET("CHARACTER SET "),
            TRANSLATION("TRANSLATION ");

            private final String _typeStr;

            private Type(String typeStr) {
                this._typeStr = typeStr;
            }

            public String toString() {
                return this._typeStr;
            }
        }
    }

    public static class Privilege
    extends SqlObject {
        private Type _type;
        private SqlObjectList<SqlObject> _columns = SqlObjectList.create();

        public Privilege(Type type, Column ... columns) {
            this._type = type;
            if (this._type.maySpecifyColumns()) {
                this._columns.addObjects(Converter.COLUMN_TO_OBJ, (SrcType[])columns);
            }
        }

        public Privilege addCustomColumns(Object ... columnStrs) {
            if (this._type.maySpecifyColumns()) {
                this._columns.addObjects(Converter.CUSTOM_COLUMN_TO_OBJ, columnStrs);
            }
            return this;
        }

        public Privilege addColumns(Column ... columns) {
            return this.addCustomColumns(columns);
        }

        protected void collectSchemaObjects(ValidationContext vContext) {
            this._columns.collectSchemaObjects(vContext);
        }

        public void appendTo(AppendableExt app) throws IOException {
            app.append((Object)this._type);
            if (!this._columns.isEmpty()) {
                app.append("(").append(this._columns).append(")");
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Type {
            ALL("ALL PRIVILEGES", false),
            SELECT("SELECT", false),
            DELETE("DELETE", false),
            INSERT("INSERT", true),
            UPDATE("UPDATE", true),
            REFERENCES("REFERENCES", true),
            USAGE("USAGE", false);

            private final String _typeStr;
            private final boolean _maySpecifyColumns;

            private Type(String typeStr, boolean maySpecifyColumns) {
                this._typeStr = typeStr;
                this._maySpecifyColumns = maySpecifyColumns;
            }

            public boolean maySpecifyColumns() {
                return this._maySpecifyColumns;
            }

            public String toString() {
                return this._typeStr;
            }
        }
    }
}

