/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.application.inference.online.messages.actions.model;

import org.linqs.psl.application.inference.online.messages.actions.model.AtomAction;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.util.MathUtils;
import org.linqs.psl.util.RandUtils;
import org.linqs.psl.util.StringUtils;

public class AddAtom
extends AtomAction {
    private float value;
    private String partition;

    public AddAtom(String partition, StandardPredicate predicate, Constant[] arguments) {
        super(predicate, arguments);
        this.init(partition, -1.0f);
    }

    public AddAtom(String partition, StandardPredicate predicate, Constant[] arguments, float value) {
        super(predicate, arguments);
        this.init(partition, value);
    }

    private void init(String partition, float value) {
        this.partition = partition.toUpperCase();
        this.value = value;
    }

    public float getValue() {
        if (MathUtils.equals(this.value, -1.0f)) {
            return RandUtils.nextFloat();
        }
        return this.value;
    }

    public String getPartitionName() {
        return this.partition;
    }

    public String toString() {
        if (this.value == -1.0f) {
            return String.format("ADDATOM\t%s\t%s\t%s", this.partition, this.predicate.getName(), StringUtils.join("\t", (Object[])this.arguments));
        }
        return String.format("ADDATOM\t%s\t%s\t%s\t%.2f", this.partition, this.predicate.getName(), StringUtils.join("\t", (Object[])this.arguments), Float.valueOf(this.value));
    }
}

