/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.streaming;

import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.linqs.psl.config.Options;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.reasoner.term.Hyperplane;
import org.linqs.psl.reasoner.term.HyperplaneTermGenerator;
import org.linqs.psl.reasoner.term.ReasonerTerm;
import org.linqs.psl.reasoner.term.VariableTermStore;
import org.linqs.psl.reasoner.term.streaming.StreamingIterator;
import org.linqs.psl.util.FileUtils;
import org.linqs.psl.util.Logger;

public abstract class StreamingTermStore<T extends ReasonerTerm>
implements VariableTermStore<T, GroundAtom> {
    private static final Logger log = Logger.getLogger(StreamingTermStore.class);
    public static final int INITIAL_PATH_CACHE_SIZE = 100;
    protected List<Rule> rules;
    protected AtomManager atomManager;
    protected Map<GroundAtom, Integer> variables;
    protected int totalVariableCount;
    protected float[] variableValues;
    protected GroundAtom[] variableAtoms;
    protected int numRandomVariableAtoms;
    protected int numObservedAtoms;
    protected List<String> termPagePaths;
    protected List<String> volatilePagePaths;
    protected boolean initialRound;
    protected StreamingIterator<T> activeIterator;
    protected long termCount;
    protected int numPages;
    protected HyperplaneTermGenerator<T, GroundAtom> termGenerator;
    protected int pageSize = Options.STREAMING_TS_PAGE_SIZE.getInt();
    protected String pageDir = Options.STREAMING_TS_PAGE_LOCATION.getString();
    protected boolean shufflePage = Options.STREAMING_TS_SHUFFLE_PAGE.getBoolean();
    protected boolean randomizePageAccess = Options.STREAMING_TS_RANDOMIZE_PAGE_ACCESS.getBoolean();
    protected boolean warnRules = Options.STREAMING_TS_WARN_RULES.getBoolean();
    protected ByteBuffer termBuffer;
    protected ByteBuffer volatileBuffer;
    protected List<T> termCache;
    protected List<T> termPool;
    protected int[] shuffleMap;

    public StreamingTermStore(List<Rule> rules, AtomManager atomManager, HyperplaneTermGenerator<T, GroundAtom> termGenerator) {
        this.rules = new ArrayList<Rule>();
        for (Rule rule : rules) {
            if (!this.supportsRule(rule, this.warnRules)) continue;
            this.rules.add(rule);
        }
        if (rules.size() == 0) {
            throw new IllegalArgumentException("Found no valid rules for a streaming term store.");
        }
        this.atomManager = atomManager;
        this.termGenerator = termGenerator;
        this.ensureVariableCapacity(this.estimateVariableCapacity());
        this.numRandomVariableAtoms = 0;
        this.numObservedAtoms = 0;
        this.termPagePaths = new ArrayList<String>(100);
        this.volatilePagePaths = new ArrayList<String>(100);
        this.initialRound = true;
        this.activeIterator = null;
        this.termCount = 0L;
        this.numPages = 0;
        this.termBuffer = null;
        this.volatileBuffer = null;
        FileUtils.recursiveDelete(this.pageDir);
        if (this.pageSize <= 1) {
            throw new IllegalArgumentException("Page size is too small.");
        }
        this.termCache = new ArrayList<T>(this.pageSize);
        this.termPool = new ArrayList<T>(this.pageSize);
        this.shuffleMap = new int[this.pageSize];
        FileUtils.mkdir(this.pageDir);
    }

    public boolean isInitialRound() {
        return this.initialRound;
    }

    @Override
    public boolean isLoaded() {
        return !this.initialRound;
    }

    @Override
    public int getNumVariables() {
        return this.totalVariableCount;
    }

    @Override
    public int getNumRandomVariables() {
        return this.numRandomVariableAtoms;
    }

    @Override
    public int getNumObservedVariables() {
        return this.numObservedAtoms;
    }

    @Override
    public Iterable<GroundAtom> getVariables() {
        return this.variables.keySet();
    }

    @Override
    public float[] getVariableValues() {
        return this.variableValues;
    }

    @Override
    public float getVariableValue(int index) {
        return this.variableValues[index];
    }

    @Override
    public int getVariableIndex(GroundAtom variable) {
        Integer index = this.variables.get(variable);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public GroundAtom[] getVariableAtoms() {
        return this.variableAtoms;
    }

    @Override
    public double syncAtoms() {
        double movement = 0.0;
        for (int i = 0; i < this.totalVariableCount; ++i) {
            if (this.variableAtoms[i] == null || !(this.variableAtoms[i] instanceof RandomVariableAtom)) continue;
            movement += Math.pow(this.variableAtoms[i].getValue() - this.variableValues[i], 2.0);
            ((RandomVariableAtom)this.variableAtoms[i]).setValue(this.variableValues[i]);
        }
        return Math.sqrt(movement);
    }

    @Override
    public synchronized GroundAtom createLocalVariable(GroundAtom atom) {
        if (this.variables.containsKey(atom)) {
            return atom;
        }
        if (this.totalVariableCount >= this.variableAtoms.length) {
            this.ensureVariableCapacity(this.totalVariableCount * 2);
        }
        this.variables.put(atom, this.totalVariableCount);
        this.variableValues[this.totalVariableCount] = atom.getValue();
        this.variableAtoms[this.totalVariableCount] = atom;
        ++this.totalVariableCount;
        if (atom instanceof RandomVariableAtom) {
            ++this.numRandomVariableAtoms;
        } else {
            ++this.numObservedAtoms;
        }
        return atom;
    }

    protected int estimateVariableCapacity() {
        return this.atomManager.getCachedRVACount();
    }

    @Override
    public void ensureVariableCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Variable capacity must be non-negative. Got: " + capacity);
        }
        if (this.variables == null || this.totalVariableCount == 0) {
            this.variables = new HashMap<GroundAtom, Integer>((int)Math.ceil((double)capacity / 0.75));
            this.totalVariableCount = 0;
            this.variableValues = new float[capacity];
            this.variableAtoms = new GroundAtom[capacity];
        } else if (this.totalVariableCount < capacity) {
            if (capacity < this.totalVariableCount * 2) {
                capacity = this.totalVariableCount * 2;
            }
            HashMap<GroundAtom, Integer> newVariables = new HashMap<GroundAtom, Integer>((int)Math.ceil((double)capacity / 0.75));
            newVariables.putAll(this.variables);
            this.variables = newVariables;
            this.variableValues = Arrays.copyOf(this.variableValues, capacity);
            this.variableAtoms = Arrays.copyOf(this.variableAtoms, capacity);
        }
    }

    @Override
    public long size() {
        return this.termCount;
    }

    @Override
    public void add(GroundRule rule, T term, Hyperplane hyperplane) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T get(long index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureCapacity(long capacity) {
        throw new UnsupportedOperationException();
    }

    public String getTermPagePath(int index) {
        for (int i = this.termPagePaths.size(); i <= index; ++i) {
            this.termPagePaths.add(Paths.get(this.pageDir, String.format("%08d_term.page", i)).toString());
        }
        return this.termPagePaths.get(index);
    }

    public String getVolatilePagePath(int index) {
        for (int i = this.volatilePagePaths.size(); i <= index; ++i) {
            this.volatilePagePaths.add(Paths.get(this.pageDir, String.format("%08d_volatile.page", i)).toString());
        }
        return this.volatilePagePaths.get(index);
    }

    public void groundingIterationComplete(long termCount, int numPages, ByteBuffer termBuffer, ByteBuffer volatileBuffer) {
        this.termCount += termCount;
        this.numPages = numPages;
        this.termBuffer = termBuffer;
        this.volatileBuffer = volatileBuffer;
        this.initialRound = false;
        this.activeIterator = null;
    }

    public void cacheIterationComplete(long termCount) {
        this.termCount = termCount;
        this.activeIterator = null;
    }

    @Override
    public Iterator<T> noWriteIterator() {
        if (this.activeIterator != null) {
            throw new IllegalStateException("Iterator already exists for this StreamingTermStore. Exhaust the iterator first.");
        }
        if (this.initialRound) {
            throw new IllegalStateException("A full iteration must have already been completed before asking for a read-only iterator.");
        }
        this.activeIterator = this.getNoWriteIterator();
        return this.activeIterator;
    }

    protected StreamingIterator<T> streamingIterator() {
        if (this.activeIterator != null) {
            throw new IllegalStateException("Iterator already exists for this StreamingTermStore. Exhaust the iterator first.");
        }
        this.activeIterator = this.initialRound ? this.getGroundingIterator() : this.getCacheIterator();
        return this.activeIterator;
    }

    @Override
    public Iterator<T> iterator() {
        return this.streamingIterator();
    }

    @Override
    public void clear() {
        this.initialRound = true;
        this.termCount = 0L;
        this.numPages = 0;
        this.numRandomVariableAtoms = 0;
        this.numObservedAtoms = 0;
        if (this.activeIterator != null) {
            this.activeIterator.close();
            this.activeIterator = null;
        }
        if (this.variables != null) {
            this.variables.clear();
            this.totalVariableCount = 0;
        }
        if (this.termCache != null) {
            this.termCache.clear();
        }
        if (this.termPool != null) {
            this.termPool.clear();
        }
        FileUtils.recursiveDelete(this.pageDir);
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.totalVariableCount; ++i) {
            if (this.variableAtoms[i] == null) continue;
            this.variableValues[i] = this.variableAtoms[i].getValue();
        }
    }

    @Override
    public void close() {
        this.clear();
        if (this.variables != null) {
            this.variables = null;
        }
        if (this.termBuffer != null) {
            this.termBuffer.clear();
            this.termBuffer = null;
        }
        if (this.volatileBuffer != null) {
            this.volatileBuffer.clear();
            this.volatileBuffer = null;
        }
        if (this.termCache != null) {
            this.termCache = null;
        }
        if (this.termPool != null) {
            this.termPool = null;
        }
    }

    @Override
    public void initForOptimization() {
    }

    @Override
    public void iterationComplete() {
    }

    @Override
    public void variablesExternallyUpdated() {
    }

    protected boolean supportsRule(Rule rule, boolean warnRules) {
        if (!rule.isWeighted()) {
            if (warnRules) {
                log.warn("Streaming term stores do not support hard constraints: " + rule);
            }
            return false;
        }
        if ((double)((WeightedRule)rule).getWeight() < 0.0) {
            if (warnRules) {
                log.warn("Streaming term stores do not support negative weights: " + rule);
            }
            return false;
        }
        if (!rule.supportsIndividualGrounding()) {
            if (warnRules) {
                log.warn("Streaming term stores do not support rules that cannot individually ground (arithmetic rules with summations): " + rule);
            }
            return false;
        }
        return true;
    }

    public boolean rejectCacheTerm(T term) {
        return false;
    }

    protected abstract StreamingIterator<T> getGroundingIterator();

    protected abstract StreamingIterator<T> getCacheIterator();

    protected abstract StreamingIterator<T> getNoWriteIterator();
}

