/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import org.linqs.psl.util.Logger;

public class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static BufferedReader getBufferedReader(String path) {
        return FileUtils.getBufferedReader(new File(path));
    }

    public static BufferedReader getBufferedReader(File file) {
        return new BufferedReader(FileUtils.getInputStreamReader(file));
    }

    public static BufferedReader getBufferedReader(InputStream stream) {
        return new BufferedReader(FileUtils.getInputStreamReader(stream));
    }

    public static BufferedWriter getBufferedWriter(String path) {
        return FileUtils.getBufferedWriter(new File(path));
    }

    public static BufferedWriter getBufferedWriter(File file) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static InputStreamReader getInputStreamReader(String path) {
        return FileUtils.getInputStreamReader(new File(path));
    }

    public static InputStreamReader getInputStreamReader(File file) {
        try {
            return FileUtils.getInputStreamReader(new FileInputStream(file));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static InputStreamReader getInputStreamReader(InputStream stream) {
        return new InputStreamReader(stream, StandardCharsets.UTF_8);
    }

    public static boolean exists(String path) {
        return new File(path).exists();
    }

    public static boolean isFile(String path) {
        return new File(path).isFile();
    }

    public static boolean isDir(String path) {
        return new File(path).isDirectory();
    }

    public static void mkdir(String path) {
        FileUtils.mkdir(new File(path));
    }

    public static void mkdir(File file) {
        if (file.mkdirs()) {
            return;
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new RuntimeException("Failed to mkdirs(\"" + file.getPath() + "\").");
        }
    }

    public static void delete(String path) {
        FileUtils.delete(new File(path));
    }

    public static void delete(File file) {
        if (file.delete()) {
            return;
        }
        if (file.exists()) {
            throw new RuntimeException("Failed to delete(\"" + file.getPath() + "\").");
        }
    }

    public static void recursiveDelete(String path) {
        FileUtils.recursiveDelete(new File(path));
    }

    public static void recursiveDelete(File target) {
        if (!target.exists()) {
            return;
        }
        if (!target.isDirectory()) {
            FileUtils.delete(target);
            return;
        }
        File[] dirents = target.listFiles();
        if (dirents != null) {
            for (File dirent : dirents) {
                FileUtils.recursiveDelete(dirent);
            }
        }
        FileUtils.delete(target);
    }

    public static String makePath(String relativeDir, String basePath) {
        if (basePath == null) {
            return null;
        }
        if (Paths.get(basePath, new String[0]).isAbsolute()) {
            return basePath;
        }
        return Paths.get(relativeDir, basePath).toString();
    }
}

