# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/nifiConnection.json
#   timestamp: 2022-10-20T10:29:52+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, SecretStr

from .. import connectionBasicType


class NifiType(Enum):
    Nifi = 'Nifi'


class NifiConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[NifiType] = Field(
        NifiType.Nifi, description='Service Type', title='Service Type'
    )
    hostPort: AnyUrl = Field(
        ..., description='Pipeline Service Management/UI URI.', title='Host And Port'
    )
    username: str = Field(
        ..., description='Nifi user to authenticate to the API.', title='Username'
    )
    password: SecretStr = Field(
        ..., description='Nifi password to authenticate to the API.', title='Password'
    )
    verifySSL: Optional[bool] = Field(
        False,
        description='Boolean marking if we need to verify the SSL certs for Nifi. False by default.',
        title='Verify SSL',
    )
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = Field(None, title='Supports Metadata Extraction')
