# generated by datamodel-codegen:
#   filename:  tests/basic.json
#   timestamp: 2022-10-20T10:29:52+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic


class Basic(BaseModel):
    __root__: Any = Field(
        ...,
        description='This schema defines basic types that are used by other test schemas.',
        title='Basic',
    )


class TestResultValue(BaseModel):
    name: Optional[str] = Field(None, description='name of the value')
    value: Optional[str] = Field(None, description='test result value')


class TestCaseStatus(Enum):
    Success = 'Success'
    Failed = 'Failed'
    Aborted = 'Aborted'


class TestCaseResult(BaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: Optional[basic.Timestamp] = Field(
        None, description='Data one which test case result is taken.'
    )
    testCaseStatus: Optional[TestCaseStatus] = Field(
        None, description='Status of Test Case run.'
    )
    result: Optional[str] = Field(None, description='Details of test case results.')
    sampleData: Optional[str] = Field(
        None,
        description="sample data to capture rows/columns that didn't match the expressed testcase.",
    )
    testResultValue: Optional[List[TestResultValue]] = None


class TestSuiteExecutionFrequency(Enum):
    Hourly = 'Hourly'
    Daily = 'Daily'
    Weekly = 'Weekly'
