##################### generated by xml-casa (v2) from imview.xml ####################
##################### f059b4ff4ce443b0d6c870702d6fbfeb ##############################
from __future__ import absolute_import
from casashell.private.stack_manip import find_local as __sf__
from casashell.private.stack_manip import find_frame as _find_frame
from casatools.typecheck import validator as _pc
from casatools.coercetype import coerce as _coerce
from casatools.errors import create_error_string
from casaviewer.private.task_imview import imview as _imview_t
from casatasks.private.task_logging import start_log as _start_log
from casatasks.private.task_logging import end_log as _end_log
from collections import OrderedDict
import numpy
import sys
import os

import shutil

def static_var(varname, value):
    def decorate(func):
        setattr(func, varname, value)
        return func
    return decorate

class _imview:
    """
    imview ---- View an image

    
    The imview task will display images in raster, contour, vector or
    marker form.  Images can be blinked, and movies are available
    for spectral-line image cubes.
    
    Executing the imview task will bring up a display panel
    window, which can be resized.  If no data file was specified,
    a Load Data window will also appear. Click on the desired data
    file and choose the display type; the rendered data should appear
    on the display panel.
    
    A Data Display Options window will also appear.  It has drop-down
    subsections for related options, most of which are self-explanatory.
    
    The state of the imview task -- loaded data and related display
    options -- can be saved in a 'restore' file for later use.
    You can provide the restore filename on the command line or
    select it from the Load Data window.
    
    It is possible to use the viewer GUI tool to perform image manipulation
    and analysis tasks that are not available from the command-line start.
    

    --------- parameter descriptions ---------------------------------------------

    raster  (Optional)  Raster filename (string) or complete raster config dictionary. The allowed dictionary keys are file (string), scaling (numeric), range (2 element numeric vector), colormap (string), and colorwedge (bool).
    contour (Optional)  Contour filename (string) or complete contour config dictionary. The allowed dictionary keys are file (string), levels (numeric vector), unit (float), and base (float).
    zoom    (Optional)  zoom can specify intermental zoom (integer), zoom region read from a file (string) or dictionary specifying the zoom region. The dictionary can have two forms. It can be either a simple region specified with blc (2 element vector) and trc (2 element vector) [along with an optional coord key ("pixel" or "world"; pixel is the default) or a complete region rectangle e.g. loaded with "rg.fromfiletorecord( )". The dictionary can also contain a channel (integer) field which indicates which channel should be displayed.
    axes    (Optional)  this can either be a three element vector (string) where each element describes what should be found on each of the x, y, and z axes or a dictionary containing fields "x", "y" and "z" (string).
    out     (Optional)  Output filename or complete output config dictionary. If a string is passed, the file extension is used to determine the output type (jpg, pdf, eps, ps, png, xbm, xpm, or ppm). If a dictionary is passed, it can contain the fields, file (string), scale (float), dpi (int), or orient (landscape or portrait). The scale field is used for the bitmap formats (i.e. not ps or pdf) and the dpi parameter is used for scalable formats (pdf or ps).
    [1;42mRETURNS[1;m    void

    --------- examples -----------------------------------------------------------

    
    The imview task provides access to a subset of all of the configuration
    options for loading and configuring the display of images in the casaviewer.
    This interface will evolve and eventually provide access to nearly all of
    the image options available in the casaviewer.
    
    To simply create a casaviewer to set up interactively, you can use:
    
    imview
    
    To open a particular image:
    
    imview "ngc5921.clean.image"
    
    to open an image and overlay a contour:
    
    imview "ngc5921.clean.image", "ngc5921.clean.image"
    
    or equivalently:
    
    imview( raster="ngc5921.clean.image", contour="ngc5921.clean.image" )
    
    to output an image:
    
    imview( raster="ngc5921.clean.image", out="ngc5921-01.png" )
    
    
    There are five optional parameters for imview -- raster, contour, zoom,
    axes, and out. Each of these parameters can take a few different forms and
    are treated as python dictionaries:
    
    raster  -- (string) image file to open
    (dict)   file (string)     => image file to open
    scaling (float)   => scaling power cycles
    range (float*2)   => data range
    colormap (string) => name of colormap
    colorwedge (bool) => show color wedge?
    contour -- (string) file to load as a contour
    (dict)   file (string)     => file to load
    levels (float*N)  => relative levels
    base (numeric)    => zero in relative levels
    unit (numeric)    => one in the relative levels
    zoom    -- (int)    integral zoom level
    (string) region file to load as the zoom region
    (dict)   blc (numeric*2)   => bottom left corner
    trc (numeric*2)   => top right corner
    coord (string)    => pixel or world
    channel (int)     => chanel to display
    (dict)   <region record>   => record loaded
    e.g. rg.fromfiletorecord( )
    axes    -- (string*3) demension to display on the x, y, and z axes
    (dict)     x               => dimension for x-axes
    y               => dimension for y-axes
    z               => dimension for z-axes
    out     -- (string) file with a supported extension
    [jpg, pdf, eps, ps, png, xbm, xpm, ppm]
    (dict)    file (string)   => filename
    format (string) => valid ext (filename ext overrides)
    scale (numeric) => scale for non-eps, non-ps output
    dpi (numeric)   => dpi for eps or ps output
    orient (string) => portrait or landscape
    
    Examples:
    
    1)  A subset (zoom) of a raster image. Note the notation of curly brackets:
    
    imview(raster="ngc5921.clean.image", out="ngc5921-02.png",
    zoom={'channel': 10, 'blc': [113,109], 'trc': [141,136]} )
    
    
    2) An overlay of a raster image, ngc5921.clean.image, with a
    contour map of the same image ngc5921.clean.image. Data ranges
    are selected, as well as the colormap and the scaling cycles
    of the raster image. Contours are autogenerated and The x-axis
    will be Declination. The image is written out to a file named
    myout.png in the png format.
    
    imview(raster={'file': 'ngc5921.clean.image',
    'range': [-0.01,0.03],
    'colormap': 'Hot Metal 2',
    'scaling': -1},
    contour={'file': 'ngc5921.clean.image'},
    axes={'x':'Declination'} ,
    zoom={'channel': 7, 'blc': [75,75], 'trc': [175,175],
    'coord': 'pixel'},
    out='myout.png')
    
    3) As example (2) but with an integral zoom level and no output to a file
    
    imview(raster={'file': 'ngc5921.clean.image',
    'range': [-0.01,0.03],
    'colormap': 'Hot Metal 2'},
    contour={'file': 'ngc5921.clean.image'},
    axes={'x':'Declination'} ,
    zoom=2)
    
    4) Now, the contour levels are explicitely given, a region file is used
    to define the zoom area
    
    imview(raster={'file': 'ngc5921.clean.image',
    'range': [-0.01,0.03],
    'colormap': 'Hot Metal 2'},
    contour={'file': 'ngc5921.clean.image',
    'levels': [-0.2, 0.2, 0.25, 0.3, 0.35, 0.4, 0.6, 0.8] },
    zoom='myregion.rgn')
    
    specifying "zoom={'file': 'myregion.rgn', 'channel': 10}" would result
    in the same level of zoom and would display channel number 10 from
    the cube.
    
    
    


    """

    _info_group_ = """visualization"""
    _info_desc_ = """View an image"""

    __schema = {'raster': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'contour': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'zoom': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'axes': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}, 'out': {'type': 'cVariant', 'coerce': [_coerce.to_variant]}}

    def __init__(self):
        self.__stdout = None
        self.__stderr = None
        self.__root_frame_ = None

    def __globals_(self):
        if self.__root_frame_ is None:
            self.__root_frame_ = _find_frame( )
            assert self.__root_frame_ is not None, "could not find CASAshell global frame"
        return self.__root_frame_

    def __to_string_(self,value):
        if type(value) is str:
            return "'%s'" % value
        else:
            return str(value)

    def __validate_(self,doc,schema):
        return _pc.validate(doc,schema)

    def __do_inp_output(self,param_prefix,description_str,formatting_chars):
        out = self.__stdout or sys.stdout
        description = description_str.split( )
        prefix_width = 23 + 7 + 4
        output = [ ]
        addon = ''
        first_addon = True
        if len(description) == 0:
            out.write(param_prefix + " #\n")
            return
        while len(description) > 0:
            ## starting a new line.....................................................................
            if len(output) == 0:
                ## for first line add parameter information............................................
                if len(param_prefix)-formatting_chars > prefix_width - 1:
                    output.append(param_prefix)
                    continue
                addon = param_prefix + ' #'
                first_addon = True
                addon_formatting = formatting_chars
            else:
                ## for subsequent lines space over prefix width........................................
                addon = (' ' * prefix_width) + '#'
                first_addon = False
                addon_formatting = 0
            ## if first word of description puts us over the screen width, bail........................
            if len(addon + description[0]) - addon_formatting + 1 > self.term_width:
                ## if we're doing the first line make sure it's output.................................
                if first_addon: output.append(addon)
                break
            while len(description) > 0:
                ## if the next description word puts us over break for the next line...................
                if len(addon + description[0]) - addon_formatting + 1 > self.term_width: break
                addon = addon + ' ' + description[0]
                description.pop(0)
            output.append(addon)
        out.write('\n'.join(output) + '\n')

    #--------- return nonsubparam values ----------------------------------------------

    def __contour_dflt( self, glb ):
        return { }

    def __contour( self, glb ):
        if 'contour' in glb: return glb['contour']
        return { }

    def __raster_dflt( self, glb ):
        return { }

    def __raster( self, glb ):
        if 'raster' in glb: return glb['raster']
        return { }

    def __out_dflt( self, glb ):
        return ''

    def __out( self, glb ):
        if 'out' in glb: return glb['out']
        return ''

    def __zoom_dflt( self, glb ):
        return int(1)

    def __zoom( self, glb ):
        if 'zoom' in glb: return glb['zoom']
        return int(1)

    def __axes_dflt( self, glb ):
        return { }

    def __axes( self, glb ):
        if 'axes' in glb: return glb['axes']
        return { }



    #--------- return inp/go default --------------------------------------------------


    #--------- return subparam values -------------------------------------------------


    #--------- subparam inp output ----------------------------------------------------
    def __raster_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__raster_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return { }
        description = ''
        value = self.__raster( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'raster': value},{'raster': self.__schema['raster']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-7.7s = %s%-23s%s' % ('raster',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __contour_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__contour_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return { }
        description = ''
        value = self.__contour( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'contour': value},{'contour': self.__schema['contour']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-7.7s = %s%-23s%s' % ('contour',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __zoom_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__zoom_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(1)
        description = ''
        value = self.__zoom( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'zoom': value},{'zoom': self.__schema['zoom']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-7.7s = %s%-23s%s' % ('zoom',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __axes_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__axes_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return { }
        description = ''
        value = self.__axes( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'axes': value},{'axes': self.__schema['axes']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-7.7s = %s%-23s%s' % ('axes',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __out_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__out_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        description = ''
        value = self.__out( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'out': value},{'out': self.__schema['out']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-7.7s = %s%-23s%s' % ('out',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    #--------- global default implementation-------------------------------------------
    @static_var('state', __sf__('casa_inp_go_state'))
    def set_global_defaults(self):
        self.set_global_defaults.state['last'] = self
        glb = self.__globals_( )
        if 'raster' in glb: del glb['raster']
        if 'out' in glb: del glb['out']
        if 'axes' in glb: del glb['axes']
        if 'contour' in glb: del glb['contour']
        if 'zoom' in glb: del glb['zoom']


    #--------- inp function -----------------------------------------------------------
    def inp(self):
        print("# imview -- %s" % self._info_desc_)
        self.term_width, self.term_height = shutil.get_terminal_size(fallback=(80, 24))
        self.__raster_inp( )
        self.__contour_inp( )
        self.__zoom_inp( )
        self.__axes_inp( )
        self.__out_inp( )

    #--------- tget function ----------------------------------------------------------
    @static_var('state', __sf__('casa_inp_go_state'))
    def tget(self,savefile=None):
        from casashell.private.stack_manip import find_frame
        from runpy import run_path
        filename = savefile
        if filename is None:
            filename = "imview.last" if os.path.isfile("imview.last") else "imview.saved"
        if os.path.isfile(filename):
            glob = find_frame( )
            newglob = run_path( filename, init_globals={ } )
            for i in newglob:
                glob[i] = newglob[i]
            self.tget.state['last'] = self
        else:
            print("could not find last file: %s\nsetting defaults instead..." % filename)
            self.set_global_defaults( )

    #--------- tput function ----------------------------------------------------------
    def tput(self,outfile=None):
        def noobj(s):
           if s.startswith('<') and s.endswith('>'):
               return "None"
           else:
               return s

        _postfile = outfile if outfile is not None else os.path.realpath('imview.last')

        _invocation_parameters = OrderedDict( )
        _invocation_parameters['raster'] = self.__raster( self.__globals_( ) )
        _invocation_parameters['contour'] = self.__contour( self.__globals_( ) )
        _invocation_parameters['zoom'] = self.__zoom( self.__globals_( ) )
        _invocation_parameters['axes'] = self.__axes( self.__globals_( ) )
        _invocation_parameters['out'] = self.__out( self.__globals_( ) )

        try:
            with open(_postfile,'w') as _f:
                for _i in _invocation_parameters:
                    _f.write("%-7s = %s\n" % (_i,noobj(repr(_invocation_parameters[_i]))))
                _f.write("#imview( ")
                count = 0
                for _i in _invocation_parameters:
                    _f.write("%s=%s" % (_i,noobj(repr(_invocation_parameters[_i]))))
                    count += 1
                    if count < len(_invocation_parameters): _f.write(",")
                _f.write(" )\n")
        except: return False
        return True

    def __call__( self, raster=None, contour=None, zoom=None, axes=None, out=None ):
        def noobj(s):
           if s.startswith('<') and s.endswith('>'):
               return "None"
           else:
               return s
        _prefile = os.path.realpath('imview.pre')
        _postfile = os.path.realpath('imview.last')
        task_result = None
        _arguments = [raster,contour,zoom,axes,out]
        _invocation_parameters = OrderedDict( )
        if any(map(lambda x: x is not None,_arguments)):
            # invoke python style
            # set the non sub-parameters that are not None
            local_global = { }
            if raster is not None: local_global['raster'] = raster
            if contour is not None: local_global['contour'] = contour
            if zoom is not None: local_global['zoom'] = zoom
            if axes is not None: local_global['axes'] = axes
            if out is not None: local_global['out'] = out

            # the invocation parameters for the non-subparameters can now be set - this picks up those defaults
            _invocation_parameters['raster'] = self.__raster( local_global )
            _invocation_parameters['contour'] = self.__contour( local_global )
            _invocation_parameters['zoom'] = self.__zoom( local_global )
            _invocation_parameters['axes'] = self.__axes( local_global )
            _invocation_parameters['out'] = self.__out( local_global )

            # the sub-parameters can then be set. Use the supplied value if not None, else the function, which gets the appropriate default
            

        else:
            # invoke with inp/go semantics
            _invocation_parameters['raster'] = self.__raster( self.__globals_( ) )
            _invocation_parameters['contour'] = self.__contour( self.__globals_( ) )
            _invocation_parameters['zoom'] = self.__zoom( self.__globals_( ) )
            _invocation_parameters['axes'] = self.__axes( self.__globals_( ) )
            _invocation_parameters['out'] = self.__out( self.__globals_( ) )
        try:
            with open(_prefile,'w') as _f:
                for _i in _invocation_parameters:
                    _f.write("%-7s = %s\n" % (_i,noobj(repr(_invocation_parameters[_i]))))
                _f.write("#imview( ")
                count = 0
                for _i in _invocation_parameters:
                    _f.write("%s=%s" % (_i,noobj(repr(_invocation_parameters[_i]))))
                    count += 1
                    if count < len(_invocation_parameters): _f.write(",")
                _f.write(" )\n")
        except: pass
        try:
            _logging_state_ = None
            assert _pc.validate(_invocation_parameters,self.__schema), create_error_string(_pc.errors)
            _logging_state_ = _start_log( 'imview', [ 'raster=' + repr(_pc.document['raster']), 'contour=' + repr(_pc.document['contour']), 'zoom=' + repr(_pc.document['zoom']), 'axes=' + repr(_pc.document['axes']), 'out=' + repr(_pc.document['out']) ] )
            task_result = _imview_t( _pc.document['raster'],_pc.document['contour'],_pc.document['zoom'],_pc.document['axes'],_pc.document['out'] )
        except Exception as e:
            from traceback import format_exc
            from casatasks import casalog
            casalog.origin('imview')
            casalog.post("Exception Reported: Error in imview: %s" % str(e),'SEVERE')
            casalog.post(format_exc( ))
            raise #exception is now raised
            #task_result = False
        finally:
            try:
                os.rename(_prefile,_postfile)
            except: pass
            if _logging_state_:
                task_result = _end_log( _logging_state_, 'imview', task_result )

        #Added if _imview_t returns False and does not raise an exception.
        if task_result is False:
            raise

        return task_result #Still needed

imview = _imview( )

