##################### generated by xml-casa (v2) from msview.xml ####################
##################### 82d2ad52723c656060c37464e8d6e91d ##############################
from __future__ import absolute_import
from casashell.private.stack_manip import find_local as __sf__
from casashell.private.stack_manip import find_frame as _find_frame
from casatools.typecheck import validator as _pc
from casatools.coercetype import coerce as _coerce
from casatools.errors import create_error_string
from casaviewer.private.task_msview import msview as _msview_t
from casatasks.private.task_logging import start_log as _start_log
from casatasks.private.task_logging import end_log as _end_log
from collections import OrderedDict
import numpy
import sys
import os

import shutil

def static_var(varname, value):
    def decorate(func):
        setattr(func, varname, value)
        return func
    return decorate

class _msview:
    """
    msview ---- View a visibility data set

    
    The msview task will display measurements in raster form.
    Many display and editing options are available.
    
    Executing the msview task will bring up a display panel
    window, which can be resized.  If no data file was specified,
    a Load Data window will also appear. Click on the desired measurement
    set,and the rendered data should appear on the display panel.
    
    A Data Display Options window will also appear.  It has drop-down
    subsections for related options, most of which are self-explanatory.
    
    The state of the msview task -- loaded data and related display
    options -- can be saved in a 'restore' file for later use.
    You can provide the restore filename on the command line or
    select it from the Load Data window.
    
    See the cookbook for more details on using the msview task.
    
    

    --------- parameter descriptions ---------------------------------------------

    infile       (Optional)  Name of file to visualize.
    displaytype  (Optional)  Type of visual rendering (raster, contour, vector or marker).  lel  if an lel expression is given for infile  (advanced).
    channel      (Optional)  access a specific channel in the image cube
    zoom         (Optional)  zoom in/out by increments
    outfile      (Optional)  name of the output file to generate
    outscale     (Optional)  amount to scale output bitmap formats (non-PS, non-PDF)
    outdpi       (Optional)  output DPI for PS/PDF
    outformat    (Optional)  format of the output e.g. jpg or pdf (this is overridden by the output files extension
    outlandscape (Optional)  should the output mode be landscape (PS or PDF)
    gui          (Optional)  Display the panel in a GUI.
    [1;42mRETURNS[1;m         void

    --------- examples -----------------------------------------------------------

    
    
    examples of usage:
    
    msview
    msview "mymeasurementset.ms"
    msview "myrestorefile.rstr"
    
    Keyword arguments:
    infile -- Name of file to visualize
    default: ''
    example: infile='my.ms'
    If no infile is specified the Load Data window
    will appear for selecting data.
    displaytype -- (optional): method of rendering data
    visually (raster, contour, vector or marker).
    You can also set this parameter to 'lel' and
    provide an lel expression for infile (advanced).
    default: 'raster'
    
    Note: there is no longer a filetype parameter; typing of
    data files is now done automatically.
    example:  msview infile='my.ms'
    obsolete: msview infile='my.ms', filetype='ms'
    
    


    """

    _info_group_ = """visualization, editing"""
    _info_desc_ = """View a visibility data set"""

    __schema = {'infile': {'type': 'cStr', 'coerce': _coerce.to_str}, 'displaytype': {'type': 'cStr', 'coerce': _coerce.to_str}, 'channel': {'type': 'cInt'}, 'zoom': {'type': 'cInt'}, 'outfile': {'type': 'cStr', 'coerce': _coerce.to_str}, 'outscale': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'outdpi': {'type': 'cInt'}, 'outformat': {'type': 'cStr', 'coerce': _coerce.to_str}, 'outlandscape': {'type': 'cBool'}, 'gui': {'type': 'cBool'}}

    def __init__(self):
        self.__stdout = None
        self.__stderr = None
        self.__root_frame_ = None

    def __globals_(self):
        if self.__root_frame_ is None:
            self.__root_frame_ = _find_frame( )
            assert self.__root_frame_ is not None, "could not find CASAshell global frame"
        return self.__root_frame_

    def __to_string_(self,value):
        if type(value) is str:
            return "'%s'" % value
        else:
            return str(value)

    def __validate_(self,doc,schema):
        return _pc.validate(doc,schema)

    def __do_inp_output(self,param_prefix,description_str,formatting_chars):
        out = self.__stdout or sys.stdout
        description = description_str.split( )
        prefix_width = 23 + 12 + 4
        output = [ ]
        addon = ''
        first_addon = True
        if len(description) == 0:
            out.write(param_prefix + " #\n")
            return
        while len(description) > 0:
            ## starting a new line.....................................................................
            if len(output) == 0:
                ## for first line add parameter information............................................
                if len(param_prefix)-formatting_chars > prefix_width - 1:
                    output.append(param_prefix)
                    continue
                addon = param_prefix + ' #'
                first_addon = True
                addon_formatting = formatting_chars
            else:
                ## for subsequent lines space over prefix width........................................
                addon = (' ' * prefix_width) + '#'
                first_addon = False
                addon_formatting = 0
            ## if first word of description puts us over the screen width, bail........................
            if len(addon + description[0]) - addon_formatting + 1 > self.term_width:
                ## if we're doing the first line make sure it's output.................................
                if first_addon: output.append(addon)
                break
            while len(description) > 0:
                ## if the next description word puts us over break for the next line...................
                if len(addon + description[0]) - addon_formatting + 1 > self.term_width: break
                addon = addon + ' ' + description[0]
                description.pop(0)
            output.append(addon)
        out.write('\n'.join(output) + '\n')

    #--------- return nonsubparam values ----------------------------------------------

    def __outformat_dflt( self, glb ):
        return 'jpg'

    def __outformat( self, glb ):
        if 'outformat' in glb: return glb['outformat']
        return 'jpg'

    def __outdpi_dflt( self, glb ):
        return int(300)

    def __outdpi( self, glb ):
        if 'outdpi' in glb: return glb['outdpi']
        return int(300)

    def __outscale_dflt( self, glb ):
        return float(1.0)

    def __outscale( self, glb ):
        if 'outscale' in glb: return glb['outscale']
        return float(1.0)

    def __channel_dflt( self, glb ):
        return int(0)

    def __channel( self, glb ):
        if 'channel' in glb: return glb['channel']
        return int(0)

    def __displaytype_dflt( self, glb ):
        return 'raster'

    def __displaytype( self, glb ):
        if 'displaytype' in glb: return glb['displaytype']
        return 'raster'

    def __outfile_dflt( self, glb ):
        return ''

    def __outfile( self, glb ):
        if 'outfile' in glb: return glb['outfile']
        return ''

    def __outlandscape_dflt( self, glb ):
        return False

    def __outlandscape( self, glb ):
        if 'outlandscape' in glb: return glb['outlandscape']
        return False

    def __zoom_dflt( self, glb ):
        return int(1)

    def __zoom( self, glb ):
        if 'zoom' in glb: return glb['zoom']
        return int(1)

    def __infile_dflt( self, glb ):
        return ''

    def __infile( self, glb ):
        if 'infile' in glb: return glb['infile']
        return ''

    def __gui_dflt( self, glb ):
        return True

    def __gui( self, glb ):
        if 'gui' in glb: return glb['gui']
        return True



    #--------- return inp/go default --------------------------------------------------


    #--------- return subparam values -------------------------------------------------


    #--------- subparam inp output ----------------------------------------------------
    def __infile_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__infile_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        description = ''
        value = self.__infile( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'infile': value},{'infile': self.__schema['infile']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('infile',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __displaytype_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__displaytype_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'raster'
        description = ''
        value = self.__displaytype( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'displaytype': value},{'displaytype': self.__schema['displaytype']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('displaytype',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __channel_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__channel_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(0)
        description = ''
        value = self.__channel( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'channel': value},{'channel': self.__schema['channel']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('channel',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __zoom_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__zoom_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(1)
        description = ''
        value = self.__zoom( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'zoom': value},{'zoom': self.__schema['zoom']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('zoom',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __outfile_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__outfile_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return ''
        description = ''
        value = self.__outfile( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'outfile': value},{'outfile': self.__schema['outfile']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('outfile',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __outscale_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__outscale_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return float(1.0)
        description = ''
        value = self.__outscale( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'outscale': value},{'outscale': self.__schema['outscale']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('outscale',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __outdpi_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__outdpi_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return int(300)
        description = ''
        value = self.__outdpi( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'outdpi': value},{'outdpi': self.__schema['outdpi']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('outdpi',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __outformat_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__outformat_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return 'jpg'
        description = ''
        value = self.__outformat( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'outformat': value},{'outformat': self.__schema['outformat']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('outformat',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __outlandscape_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__outlandscape_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return False
        description = ''
        value = self.__outlandscape( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'outlandscape': value},{'outlandscape': self.__schema['outlandscape']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('outlandscape',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))
    def __gui_inp(self):
        def xml_default( ):
            ## play the crazy subparameter shell game
            dflt = self.__gui_dflt( self.__globals_( ) )
            if dflt is not None: return dflt
            return True
        description = ''
        value = self.__gui( self.__globals_( ) )
        (pre,post) = (('','') if value == xml_default( ) else ('\x1B[34m','\x1B[0m')) if self.__validate_({'gui': value},{'gui': self.__schema['gui']}) else ('\x1B[91m','\x1B[0m')
        self.__do_inp_output('%-12.12s = %s%-23s%s' % ('gui',pre,self.__to_string_(value),post),description,0+len(pre)+len(post))

    #--------- global default implementation-------------------------------------------
    @static_var('state', __sf__('casa_inp_go_state'))
    def set_global_defaults(self):
        self.set_global_defaults.state['last'] = self
        glb = self.__globals_( )
        if 'infile' in glb: del glb['infile']
        if 'outfile' in glb: del glb['outfile']
        if 'displaytype' in glb: del glb['displaytype']
        if 'channel' in glb: del glb['channel']
        if 'outformat' in glb: del glb['outformat']
        if 'outscale' in glb: del glb['outscale']
        if 'outlandscape' in glb: del glb['outlandscape']
        if 'zoom' in glb: del glb['zoom']
        if 'gui' in glb: del glb['gui']
        if 'outdpi' in glb: del glb['outdpi']


    #--------- inp function -----------------------------------------------------------
    def inp(self):
        print("# msview -- %s" % self._info_desc_)
        self.term_width, self.term_height = shutil.get_terminal_size(fallback=(80, 24))
        self.__infile_inp( )
        self.__displaytype_inp( )
        self.__channel_inp( )
        self.__zoom_inp( )
        self.__outfile_inp( )
        self.__outscale_inp( )
        self.__outdpi_inp( )
        self.__outformat_inp( )
        self.__outlandscape_inp( )
        self.__gui_inp( )

    #--------- tget function ----------------------------------------------------------
    @static_var('state', __sf__('casa_inp_go_state'))
    def tget(self,savefile=None):
        from casashell.private.stack_manip import find_frame
        from runpy import run_path
        filename = savefile
        if filename is None:
            filename = "msview.last" if os.path.isfile("msview.last") else "msview.saved"
        if os.path.isfile(filename):
            glob = find_frame( )
            newglob = run_path( filename, init_globals={ } )
            for i in newglob:
                glob[i] = newglob[i]
            self.tget.state['last'] = self
        else:
            print("could not find last file: %s\nsetting defaults instead..." % filename)
            self.set_global_defaults( )

    #--------- tput function ----------------------------------------------------------
    def tput(self,outfile=None):
        def noobj(s):
           if s.startswith('<') and s.endswith('>'):
               return "None"
           else:
               return s

        _postfile = outfile if outfile is not None else os.path.realpath('msview.last')

        _invocation_parameters = OrderedDict( )
        _invocation_parameters['infile'] = self.__infile( self.__globals_( ) )
        _invocation_parameters['displaytype'] = self.__displaytype( self.__globals_( ) )
        _invocation_parameters['channel'] = self.__channel( self.__globals_( ) )
        _invocation_parameters['zoom'] = self.__zoom( self.__globals_( ) )
        _invocation_parameters['outfile'] = self.__outfile( self.__globals_( ) )
        _invocation_parameters['outscale'] = self.__outscale( self.__globals_( ) )
        _invocation_parameters['outdpi'] = self.__outdpi( self.__globals_( ) )
        _invocation_parameters['outformat'] = self.__outformat( self.__globals_( ) )
        _invocation_parameters['outlandscape'] = self.__outlandscape( self.__globals_( ) )
        _invocation_parameters['gui'] = self.__gui( self.__globals_( ) )

        try:
            with open(_postfile,'w') as _f:
                for _i in _invocation_parameters:
                    _f.write("%-12s = %s\n" % (_i,noobj(repr(_invocation_parameters[_i]))))
                _f.write("#msview( ")
                count = 0
                for _i in _invocation_parameters:
                    _f.write("%s=%s" % (_i,noobj(repr(_invocation_parameters[_i]))))
                    count += 1
                    if count < len(_invocation_parameters): _f.write(",")
                _f.write(" )\n")
        except: return False
        return True

    def __call__( self, infile=None, displaytype=None, channel=None, zoom=None, outfile=None, outscale=None, outdpi=None, outformat=None, outlandscape=None, gui=None ):
        def noobj(s):
           if s.startswith('<') and s.endswith('>'):
               return "None"
           else:
               return s
        _prefile = os.path.realpath('msview.pre')
        _postfile = os.path.realpath('msview.last')
        task_result = None
        _arguments = [infile,displaytype,channel,zoom,outfile,outscale,outdpi,outformat,outlandscape,gui]
        _invocation_parameters = OrderedDict( )
        if any(map(lambda x: x is not None,_arguments)):
            # invoke python style
            # set the non sub-parameters that are not None
            local_global = { }
            if infile is not None: local_global['infile'] = infile
            if displaytype is not None: local_global['displaytype'] = displaytype
            if channel is not None: local_global['channel'] = channel
            if zoom is not None: local_global['zoom'] = zoom
            if outfile is not None: local_global['outfile'] = outfile
            if outscale is not None: local_global['outscale'] = outscale
            if outdpi is not None: local_global['outdpi'] = outdpi
            if outformat is not None: local_global['outformat'] = outformat
            if outlandscape is not None: local_global['outlandscape'] = outlandscape
            if gui is not None: local_global['gui'] = gui

            # the invocation parameters for the non-subparameters can now be set - this picks up those defaults
            _invocation_parameters['infile'] = self.__infile( local_global )
            _invocation_parameters['displaytype'] = self.__displaytype( local_global )
            _invocation_parameters['channel'] = self.__channel( local_global )
            _invocation_parameters['zoom'] = self.__zoom( local_global )
            _invocation_parameters['outfile'] = self.__outfile( local_global )
            _invocation_parameters['outscale'] = self.__outscale( local_global )
            _invocation_parameters['outdpi'] = self.__outdpi( local_global )
            _invocation_parameters['outformat'] = self.__outformat( local_global )
            _invocation_parameters['outlandscape'] = self.__outlandscape( local_global )
            _invocation_parameters['gui'] = self.__gui( local_global )

            # the sub-parameters can then be set. Use the supplied value if not None, else the function, which gets the appropriate default
            

        else:
            # invoke with inp/go semantics
            _invocation_parameters['infile'] = self.__infile( self.__globals_( ) )
            _invocation_parameters['displaytype'] = self.__displaytype( self.__globals_( ) )
            _invocation_parameters['channel'] = self.__channel( self.__globals_( ) )
            _invocation_parameters['zoom'] = self.__zoom( self.__globals_( ) )
            _invocation_parameters['outfile'] = self.__outfile( self.__globals_( ) )
            _invocation_parameters['outscale'] = self.__outscale( self.__globals_( ) )
            _invocation_parameters['outdpi'] = self.__outdpi( self.__globals_( ) )
            _invocation_parameters['outformat'] = self.__outformat( self.__globals_( ) )
            _invocation_parameters['outlandscape'] = self.__outlandscape( self.__globals_( ) )
            _invocation_parameters['gui'] = self.__gui( self.__globals_( ) )
        try:
            with open(_prefile,'w') as _f:
                for _i in _invocation_parameters:
                    _f.write("%-12s = %s\n" % (_i,noobj(repr(_invocation_parameters[_i]))))
                _f.write("#msview( ")
                count = 0
                for _i in _invocation_parameters:
                    _f.write("%s=%s" % (_i,noobj(repr(_invocation_parameters[_i]))))
                    count += 1
                    if count < len(_invocation_parameters): _f.write(",")
                _f.write(" )\n")
        except: pass
        try:
            _logging_state_ = None
            assert _pc.validate(_invocation_parameters,self.__schema), create_error_string(_pc.errors)
            _logging_state_ = _start_log( 'msview', [ 'infile=' + repr(_pc.document['infile']), 'displaytype=' + repr(_pc.document['displaytype']), 'channel=' + repr(_pc.document['channel']), 'zoom=' + repr(_pc.document['zoom']), 'outfile=' + repr(_pc.document['outfile']), 'outscale=' + repr(_pc.document['outscale']), 'outdpi=' + repr(_pc.document['outdpi']), 'outformat=' + repr(_pc.document['outformat']), 'outlandscape=' + repr(_pc.document['outlandscape']), 'gui=' + repr(_pc.document['gui']) ] )
            task_result = _msview_t( _pc.document['infile'],_pc.document['displaytype'],_pc.document['channel'],_pc.document['zoom'],_pc.document['outfile'],_pc.document['outscale'],_pc.document['outdpi'],_pc.document['outformat'],_pc.document['outlandscape'],_pc.document['gui'] )
        except Exception as e:
            from traceback import format_exc
            from casatasks import casalog
            casalog.origin('msview')
            casalog.post("Exception Reported: Error in msview: %s" % str(e),'SEVERE')
            casalog.post(format_exc( ))
            raise #exception is now raised
            #task_result = False
        finally:
            try:
                os.rename(_prefile,_postfile)
            except: pass
            if _logging_state_:
                task_result = _end_log( _logging_state_, 'msview', task_result )

        #Added if _msview_t returns False and does not raise an exception.
        if task_result is False:
            raise

        return task_result #Still needed

msview = _msview( )

