##################### generated by xml-casa (v2) from msview.xml
##################### 82d2ad52723c656060c37464e8d6e91d
from __future__ import absolute_import
import numpy
_pc = None

class _msview:
    """
    msview ---- View a visibility data set

    
    The msview task will display measurements in raster form.
    Many display and editing options are available.
    
    Executing the msview task will bring up a display panel
    window, which can be resized.  If no data file was specified,
    a Load Data window will also appear. Click on the desired measurement
    set,and the rendered data should appear on the display panel.
    
    A Data Display Options window will also appear.  It has drop-down
    subsections for related options, most of which are self-explanatory.
    
    The state of the msview task -- loaded data and related display
    options -- can be saved in a 'restore' file for later use.
    You can provide the restore filename on the command line or
    select it from the Load Data window.
    
    See the cookbook for more details on using the msview task.
    
    

    --------- parameter descriptions ---------------------------------------------

    infile       (Optional)  Name of file to visualize.
    displaytype  (Optional)  Type of visual rendering (raster, contour, vector or marker).  lel  if an lel expression is given for infile  (advanced).
    channel      (Optional)  access a specific channel in the image cube
    zoom         (Optional)  zoom in/out by increments
    outfile      (Optional)  name of the output file to generate
    outscale     (Optional)  amount to scale output bitmap formats (non-PS, non-PDF)
    outdpi       (Optional)  output DPI for PS/PDF
    outformat    (Optional)  format of the output e.g. jpg or pdf (this is overridden by the output files extension
    outlandscape (Optional)  should the output mode be landscape (PS or PDF)
    gui          (Optional)  Display the panel in a GUI.
    [1;42mRETURNS[1;m         void

    --------- examples -----------------------------------------------------------

    
    
    examples of usage:
    
    msview
    msview "mymeasurementset.ms"
    msview "myrestorefile.rstr"
    
    Keyword arguments:
    infile -- Name of file to visualize
    default: ''
    example: infile='my.ms'
    If no infile is specified the Load Data window
    will appear for selecting data.
    displaytype -- (optional): method of rendering data
    visually (raster, contour, vector or marker).
    You can also set this parameter to 'lel' and
    provide an lel expression for infile (advanced).
    default: 'raster'
    
    Note: there is no longer a filetype parameter; typing of
    data files is now done automatically.
    example:  msview infile='my.ms'
    obsolete: msview infile='my.ms', filetype='ms'
    
    


    """

    _info_group_ = """visualization, editing"""
    _info_desc_ = """View a visibility data set"""

    def __call__( self, infile='', displaytype='raster', channel=int(0), zoom=int(1), outfile='', outscale=float(1.0), outdpi=int(300), outformat='jpg', outlandscape=False, gui=True ):
        from casatools.typecheck import CasaValidator as _val_ctor
        global _pc
        if not _pc: _pc = _val_ctor( )
        from casatools.coercetype import coerce as _coerce
        from casatools.errors import create_error_string
        from .private.task_msview import msview as _msview_t
        from casatasks.private.task_logging import start_log as _start_log
        from casatasks.private.task_logging import end_log as _end_log
        from casatasks.private.task_logging import except_log as _except_log
        schema = { 'infile': {'type': 'cStr', 'coerce': _coerce.to_str}, 'displaytype': {'type': 'cStr', 'coerce': _coerce.to_str}, 'channel': {'type': 'cInt'}, 'zoom': {'type': 'cInt'}, 'outfile': {'type': 'cStr', 'coerce': _coerce.to_str}, 'outscale': {'type': 'cFloat', 'coerce': _coerce.to_float}, 'outdpi': {'type': 'cInt'}, 'outformat': {'type': 'cStr', 'coerce': _coerce.to_str}, 'outlandscape': {'type': 'cBool'}, 'gui': {'type': 'cBool'},  }
        doc = { 'infile': infile, 'displaytype': displaytype, 'channel': channel, 'zoom': zoom, 'outfile': outfile, 'outscale': outscale, 'outdpi': outdpi, 'outformat': outformat, 'outlandscape': outlandscape, 'gui': gui,  }
        assert _pc.validate(doc,schema), create_error_string(_pc.errors)
        _logging_state_ = _start_log( 'msview', [ 'infile=' + repr(_pc.document['infile']), 'displaytype=' + repr(_pc.document['displaytype']), 'channel=' + repr(_pc.document['channel']), 'zoom=' + repr(_pc.document['zoom']), 'outfile=' + repr(_pc.document['outfile']), 'outscale=' + repr(_pc.document['outscale']), 'outdpi=' + repr(_pc.document['outdpi']), 'outformat=' + repr(_pc.document['outformat']), 'outlandscape=' + repr(_pc.document['outlandscape']), 'gui=' + repr(_pc.document['gui']),  ] )
        task_result = None
        try:
            task_result = _msview_t( _pc.document['infile'], _pc.document['displaytype'], _pc.document['channel'], _pc.document['zoom'], _pc.document['outfile'], _pc.document['outscale'], _pc.document['outdpi'], _pc.document['outformat'], _pc.document['outlandscape'], _pc.document['gui'],  )
        except Exception as exc:
            _except_log('msview', exc)
            raise
        finally:
            task_result = _end_log( _logging_state_, 'msview', task_result )
        return task_result

msview = _msview( )

