

# This file was autogenerated by some hot garbage in the `uniffi` crate.
# Trust me, you don't want to mess with it!

# Common helper code.
#
# Ideally this would live in a separate .py file where it can be unittested etc
# in isolation, and perhaps even published as a re-useable package.
#
# However, it's important that the details of how this helper code works (e.g. the
# way that different builtin types are passed across the FFI) exactly match what's
# expected by the rust code on the other side of the interface. In practice right
# now that means coming from the exact some version of `uniffi` that was used to
# compile the rust component. The easiest way to ensure this is to bundle the Python
# helpers directly inline like we're doing here.

from __future__ import annotations
import os
import sys
import ctypes
import enum
import struct
import contextlib
import datetime
import threading
import itertools
import traceback
import typing
import platform

# Used for default argument values
_DEFAULT = object() # type: typing.Any


class _UniffiRustBuffer(ctypes.Structure):
    _fields_ = [
        ("capacity", ctypes.c_uint64),
        ("len", ctypes.c_uint64),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    @staticmethod
    def default():
        return _UniffiRustBuffer(0, 0, None)

    @staticmethod
    def alloc(size):
        return _uniffi_rust_call(_UniffiLib.ffi_rusaint_rustbuffer_alloc, size)

    @staticmethod
    def reserve(rbuf, additional):
        return _uniffi_rust_call(_UniffiLib.ffi_rusaint_rustbuffer_reserve, rbuf, additional)

    def free(self):
        return _uniffi_rust_call(_UniffiLib.ffi_rusaint_rustbuffer_free, self)

    def __str__(self):
        return "_UniffiRustBuffer(capacity={}, len={}, data={})".format(
            self.capacity,
            self.len,
            self.data[0:self.len]
        )

    @contextlib.contextmanager
    def alloc_with_builder(*args):
        """Context-manger to allocate a buffer using a _UniffiRustBufferBuilder.

        The allocated buffer will be automatically freed if an error occurs, ensuring that
        we don't accidentally leak it.
        """
        builder = _UniffiRustBufferBuilder()
        try:
            yield builder
        except:
            builder.discard()
            raise

    @contextlib.contextmanager
    def consume_with_stream(self):
        """Context-manager to consume a buffer using a _UniffiRustBufferStream.

        The _UniffiRustBuffer will be freed once the context-manager exits, ensuring that we don't
        leak it even if an error occurs.
        """
        try:
            s = _UniffiRustBufferStream.from_rust_buffer(self)
            yield s
            if s.remaining() != 0:
                raise RuntimeError("junk data left in buffer at end of consume_with_stream")
        finally:
            self.free()

    @contextlib.contextmanager
    def read_with_stream(self):
        """Context-manager to read a buffer using a _UniffiRustBufferStream.

        This is like consume_with_stream, but doesn't free the buffer afterwards.
        It should only be used with borrowed `_UniffiRustBuffer` data.
        """
        s = _UniffiRustBufferStream.from_rust_buffer(self)
        yield s
        if s.remaining() != 0:
            raise RuntimeError("junk data left in buffer at end of read_with_stream")

class _UniffiForeignBytes(ctypes.Structure):
    _fields_ = [
        ("len", ctypes.c_int32),
        ("data", ctypes.POINTER(ctypes.c_char)),
    ]

    def __str__(self):
        return "_UniffiForeignBytes(len={}, data={})".format(self.len, self.data[0:self.len])


class _UniffiRustBufferStream:
    """
    Helper for structured reading of bytes from a _UniffiRustBuffer
    """

    def __init__(self, data, len):
        self.data = data
        self.len = len
        self.offset = 0

    @classmethod
    def from_rust_buffer(cls, buf):
        return cls(buf.data, buf.len)

    def remaining(self):
        return self.len - self.offset

    def _unpack_from(self, size, format):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        value = struct.unpack(format, self.data[self.offset:self.offset+size])[0]
        self.offset += size
        return value

    def read(self, size):
        if self.offset + size > self.len:
            raise InternalError("read past end of rust buffer")
        data = self.data[self.offset:self.offset+size]
        self.offset += size
        return data

    def read_i8(self):
        return self._unpack_from(1, ">b")

    def read_u8(self):
        return self._unpack_from(1, ">B")

    def read_i16(self):
        return self._unpack_from(2, ">h")

    def read_u16(self):
        return self._unpack_from(2, ">H")

    def read_i32(self):
        return self._unpack_from(4, ">i")

    def read_u32(self):
        return self._unpack_from(4, ">I")

    def read_i64(self):
        return self._unpack_from(8, ">q")

    def read_u64(self):
        return self._unpack_from(8, ">Q")

    def read_float(self):
        v = self._unpack_from(4, ">f")
        return v

    def read_double(self):
        return self._unpack_from(8, ">d")

class _UniffiRustBufferBuilder:
    """
    Helper for structured writing of bytes into a _UniffiRustBuffer.
    """

    def __init__(self):
        self.rbuf = _UniffiRustBuffer.alloc(16)
        self.rbuf.len = 0

    def finalize(self):
        rbuf = self.rbuf
        self.rbuf = None
        return rbuf

    def discard(self):
        if self.rbuf is not None:
            rbuf = self.finalize()
            rbuf.free()

    @contextlib.contextmanager
    def _reserve(self, num_bytes):
        if self.rbuf.len + num_bytes > self.rbuf.capacity:
            self.rbuf = _UniffiRustBuffer.reserve(self.rbuf, num_bytes)
        yield None
        self.rbuf.len += num_bytes

    def _pack_into(self, size, format, value):
        with self._reserve(size):
            # XXX TODO: I feel like I should be able to use `struct.pack_into` here but can't figure it out.
            for i, byte in enumerate(struct.pack(format, value)):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write(self, value):
        with self._reserve(len(value)):
            for i, byte in enumerate(value):
                self.rbuf.data[self.rbuf.len + i] = byte

    def write_i8(self, v):
        self._pack_into(1, ">b", v)

    def write_u8(self, v):
        self._pack_into(1, ">B", v)

    def write_i16(self, v):
        self._pack_into(2, ">h", v)

    def write_u16(self, v):
        self._pack_into(2, ">H", v)

    def write_i32(self, v):
        self._pack_into(4, ">i", v)

    def write_u32(self, v):
        self._pack_into(4, ">I", v)

    def write_i64(self, v):
        self._pack_into(8, ">q", v)

    def write_u64(self, v):
        self._pack_into(8, ">Q", v)

    def write_float(self, v):
        self._pack_into(4, ">f", v)

    def write_double(self, v):
        self._pack_into(8, ">d", v)

    def write_c_size_t(self, v):
        self._pack_into(ctypes.sizeof(ctypes.c_size_t) , "@N", v)
# A handful of classes and functions to support the generated data structures.
# This would be a good candidate for isolating in its own ffi-support lib.

class InternalError(Exception):
    pass

class _UniffiRustCallStatus(ctypes.Structure):
    """
    Error runtime.
    """
    _fields_ = [
        ("code", ctypes.c_int8),
        ("error_buf", _UniffiRustBuffer),
    ]

    # These match the values from the uniffi::rustcalls module
    CALL_SUCCESS = 0
    CALL_ERROR = 1
    CALL_UNEXPECTED_ERROR = 2

    @staticmethod
    def default():
        return _UniffiRustCallStatus(code=_UniffiRustCallStatus.CALL_SUCCESS, error_buf=_UniffiRustBuffer.default())

    def __str__(self):
        if self.code == _UniffiRustCallStatus.CALL_SUCCESS:
            return "_UniffiRustCallStatus(CALL_SUCCESS)"
        elif self.code == _UniffiRustCallStatus.CALL_ERROR:
            return "_UniffiRustCallStatus(CALL_ERROR)"
        elif self.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
            return "_UniffiRustCallStatus(CALL_UNEXPECTED_ERROR)"
        else:
            return "_UniffiRustCallStatus(<invalid code>)"

def _uniffi_rust_call(fn, *args):
    # Call a rust function
    return _uniffi_rust_call_with_error(None, fn, *args)

def _uniffi_rust_call_with_error(error_ffi_converter, fn, *args):
    # Call a rust function and handle any errors
    #
    # This function is used for rust calls that return Result<> and therefore can set the CALL_ERROR status code.
    # error_ffi_converter must be set to the _UniffiConverter for the error class that corresponds to the result.
    call_status = _UniffiRustCallStatus.default()

    args_with_error = args + (ctypes.byref(call_status),)
    result = fn(*args_with_error)
    _uniffi_check_call_status(error_ffi_converter, call_status)
    return result

def _uniffi_check_call_status(error_ffi_converter, call_status):
    if call_status.code == _UniffiRustCallStatus.CALL_SUCCESS:
        pass
    elif call_status.code == _UniffiRustCallStatus.CALL_ERROR:
        if error_ffi_converter is None:
            call_status.error_buf.free()
            raise InternalError("_uniffi_rust_call_with_error: CALL_ERROR, but error_ffi_converter is None")
        else:
            raise error_ffi_converter.lift(call_status.error_buf)
    elif call_status.code == _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR:
        # When the rust code sees a panic, it tries to construct a _UniffiRustBuffer
        # with the message.  But if that code panics, then it just sends back
        # an empty buffer.
        if call_status.error_buf.len > 0:
            msg = _UniffiConverterString.lift(call_status.error_buf)
        else:
            msg = "Unknown rust panic"
        raise InternalError(msg)
    else:
        raise InternalError("Invalid _UniffiRustCallStatus code: {}".format(
            call_status.code))

def _uniffi_trait_interface_call(call_status, make_call, write_return_value):
    try:
        return write_return_value(make_call())
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))

def _uniffi_trait_interface_call_with_error(call_status, make_call, write_return_value, error_type, lower_error):
    try:
        try:
            return write_return_value(make_call())
        except error_type as e:
            call_status.code = _UniffiRustCallStatus.CALL_ERROR
            call_status.error_buf = lower_error(e)
    except Exception as e:
        call_status.code = _UniffiRustCallStatus.CALL_UNEXPECTED_ERROR
        call_status.error_buf = _UniffiConverterString.lower(repr(e))
class _UniffiHandleMap:
    """
    A map where inserting, getting and removing data is synchronized with a lock.
    """

    def __init__(self):
        # type Handle = int
        self._map = {}  # type: Dict[Handle, Any]
        self._lock = threading.Lock()
        self._counter = itertools.count()

    def insert(self, obj):
        with self._lock:
            handle = next(self._counter)
            self._map[handle] = obj
            return handle

    def get(self, handle):
        try:
            with self._lock:
                return self._map[handle]
        except KeyError:
            raise InternalError("_UniffiHandleMap.get: Invalid handle")

    def remove(self, handle):
        try:
            with self._lock:
                return self._map.pop(handle)
        except KeyError:
            raise InternalError("_UniffiHandleMap.remove: Invalid handle")

    def __len__(self):
        return len(self._map)
# Types conforming to `_UniffiConverterPrimitive` pass themselves directly over the FFI.
class _UniffiConverterPrimitive:
    @classmethod
    def lift(cls, value):
        return value

    @classmethod
    def lower(cls, value):
        return value

class _UniffiConverterPrimitiveInt(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__index__()
        except Exception:
            raise TypeError("'{}' object cannot be interpreted as an integer".format(type(value).__name__))
        if not isinstance(value, int):
            raise TypeError("__index__ returned non-int (type {})".format(type(value).__name__))
        if not cls.VALUE_MIN <= value < cls.VALUE_MAX:
            raise ValueError("{} requires {} <= value < {}".format(cls.CLASS_NAME, cls.VALUE_MIN, cls.VALUE_MAX))

class _UniffiConverterPrimitiveFloat(_UniffiConverterPrimitive):
    @classmethod
    def check_lower(cls, value):
        try:
            value = value.__float__()
        except Exception:
            raise TypeError("must be real number, not {}".format(type(value).__name__))
        if not isinstance(value, float):
            raise TypeError("__float__ returned non-float (type {})".format(type(value).__name__))

# Helper class for wrapper types that will always go through a _UniffiRustBuffer.
# Classes should inherit from this and implement the `read` and `write` static methods.
class _UniffiConverterRustBuffer:
    @classmethod
    def lift(cls, rbuf):
        with rbuf.consume_with_stream() as stream:
            return cls.read(stream)

    @classmethod
    def lower(cls, value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            cls.write(value, builder)
            return builder.finalize()

# Contains loading, initialization code, and the FFI Function declarations.
# Define some ctypes FFI types that we use in the library

"""
Function pointer for a Rust task, which a callback function that takes a opaque pointer
"""
_UNIFFI_RUST_TASK = ctypes.CFUNCTYPE(None, ctypes.c_void_p, ctypes.c_int8)

def _uniffi_future_callback_t(return_type):
    """
    Factory function to create callback function types for async functions
    """
    return ctypes.CFUNCTYPE(None, ctypes.c_uint64, return_type, _UniffiRustCallStatus)

def _uniffi_load_indirect():
    """
    This is how we find and load the dynamic library provided by the component.
    For now we just look it up by name.
    """
    if sys.platform == "darwin":
        libname = "lib{}.dylib"
    elif sys.platform.startswith("win"):
        # As of python3.8, ctypes does not seem to search $PATH when loading DLLs.
        # We could use `os.add_dll_directory` to configure the search path, but
        # it doesn't feel right to mess with application-wide settings. Let's
        # assume that the `.dll` is next to the `.py` file and load by full path.
        libname = os.path.join(
            os.path.dirname(__file__),
            "{}.dll",
        )
    else:
        # Anything else must be an ELF platform - Linux, *BSD, Solaris/illumos
        libname = "lib{}.so"

    libname = libname.format("rusaint_ffi")
    path = os.path.join(os.path.dirname(__file__), libname)
    lib = ctypes.cdll.LoadLibrary(path)
    return lib

def _uniffi_check_contract_api_version(lib):
    # Get the bindings contract version from our ComponentInterface
    bindings_contract_version = 29
    # Get the scaffolding contract version by calling the into the dylib
    scaffolding_contract_version = lib.ffi_rusaint_uniffi_contract_version()
    if bindings_contract_version != scaffolding_contract_version:
        raise InternalError("UniFFI contract version mismatch: try cleaning and rebuilding your project")

def _uniffi_check_api_checksums(lib):
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_chapel() != 36146:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_connected_major() != 23575:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_cyber() != 62603:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_education() != 26923:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_lecture() != 60430:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_professor() != 34168:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_graduated() != 33032:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_major() != 62920:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_optional_elective() != 18560:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_recognized_other_major() != 31169:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_required_elective() != 31001:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_method_lecturecategorybuilder_united_major() != 40110:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    if lib.uniffi_rusaint_checksum_constructor_lecturecategorybuilder_new() != 19652:
        raise InternalError("UniFFI API checksum mismatch: try cleaning and rebuilding your project")

# A ctypes library to expose the extern-C FFI definitions.
# This is an implementation detail which will be called internally by the public API.

_UniffiLib = _uniffi_load_indirect()
_UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK = ctypes.CFUNCTYPE(None,ctypes.c_uint64,ctypes.c_int8,
)
_UNIFFI_FOREIGN_FUTURE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
_UNIFFI_CALLBACK_INTERFACE_FREE = ctypes.CFUNCTYPE(None,ctypes.c_uint64,
)
class _UniffiForeignFuture(ctypes.Structure):
    _fields_ = [
        ("handle", ctypes.c_uint64),
        ("free", _UNIFFI_FOREIGN_FUTURE_FREE),
    ]
class _UniffiForeignFutureStructU8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU8,
)
class _UniffiForeignFutureStructI8(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int8),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I8 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI8,
)
class _UniffiForeignFutureStructU16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU16,
)
class _UniffiForeignFutureStructI16(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int16),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I16 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI16,
)
class _UniffiForeignFutureStructU32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU32,
)
class _UniffiForeignFutureStructI32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int32),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI32,
)
class _UniffiForeignFutureStructU64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_uint64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_U64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructU64,
)
class _UniffiForeignFutureStructI64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_int64),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_I64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructI64,
)
class _UniffiForeignFutureStructF32(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_float),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F32 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF32,
)
class _UniffiForeignFutureStructF64(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_double),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_F64 = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructF64,
)
class _UniffiForeignFutureStructPointer(ctypes.Structure):
    _fields_ = [
        ("return_value", ctypes.c_void_p),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_POINTER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructPointer,
)
class _UniffiForeignFutureStructRustBuffer(ctypes.Structure):
    _fields_ = [
        ("return_value", _UniffiRustBuffer),
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_RUST_BUFFER = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructRustBuffer,
)
class _UniffiForeignFutureStructVoid(ctypes.Structure):
    _fields_ = [
        ("call_status", _UniffiRustCallStatus),
    ]
_UNIFFI_FOREIGN_FUTURE_COMPLETE_VOID = ctypes.CFUNCTYPE(None,ctypes.c_uint64,_UniffiForeignFutureStructVoid,
)
_UniffiLib.uniffi_rusaint_fn_clone_lecturecategorybuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_clone_lecturecategorybuilder.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_fn_free_lecturecategorybuilder.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_free_lecturecategorybuilder.restype = None
_UniffiLib.uniffi_rusaint_fn_constructor_lecturecategorybuilder_new.argtypes = (
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_constructor_lecturecategorybuilder_new.restype = ctypes.c_void_p
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_chapel.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_chapel.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_connected_major.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_connected_major.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_cyber.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_cyber.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_education.argtypes = (
    ctypes.c_void_p,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_education.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_lecture.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_lecture.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_professor.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_professor.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_graduated.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_graduated.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_major.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_major.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_optional_elective.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_optional_elective.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_recognized_other_major.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_recognized_other_major.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_required_elective.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_required_elective.restype = _UniffiRustBuffer
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_united_major.argtypes = (
    ctypes.c_void_p,
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_united_major.restype = _UniffiRustBuffer
_UniffiLib.ffi_rusaint_rustbuffer_alloc.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rustbuffer_alloc.restype = _UniffiRustBuffer
_UniffiLib.ffi_rusaint_rustbuffer_from_bytes.argtypes = (
    _UniffiForeignBytes,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rustbuffer_from_bytes.restype = _UniffiRustBuffer
_UniffiLib.ffi_rusaint_rustbuffer_free.argtypes = (
    _UniffiRustBuffer,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rustbuffer_free.restype = None
_UniffiLib.ffi_rusaint_rustbuffer_reserve.argtypes = (
    _UniffiRustBuffer,
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rustbuffer_reserve.restype = _UniffiRustBuffer
_UniffiLib.ffi_rusaint_rust_future_poll_u8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_u8.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_u8.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_u8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_u8.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_u8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_u8.restype = ctypes.c_uint8
_UniffiLib.ffi_rusaint_rust_future_poll_i8.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_i8.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_i8.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_i8.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_i8.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_i8.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_i8.restype = ctypes.c_int8
_UniffiLib.ffi_rusaint_rust_future_poll_u16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_u16.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_u16.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_u16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_u16.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_u16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_u16.restype = ctypes.c_uint16
_UniffiLib.ffi_rusaint_rust_future_poll_i16.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_i16.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_i16.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_i16.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_i16.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_i16.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_i16.restype = ctypes.c_int16
_UniffiLib.ffi_rusaint_rust_future_poll_u32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_u32.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_u32.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_u32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_u32.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_u32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_u32.restype = ctypes.c_uint32
_UniffiLib.ffi_rusaint_rust_future_poll_i32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_i32.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_i32.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_i32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_i32.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_i32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_i32.restype = ctypes.c_int32
_UniffiLib.ffi_rusaint_rust_future_poll_u64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_u64.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_u64.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_u64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_u64.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_u64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_u64.restype = ctypes.c_uint64
_UniffiLib.ffi_rusaint_rust_future_poll_i64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_i64.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_i64.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_i64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_i64.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_i64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_i64.restype = ctypes.c_int64
_UniffiLib.ffi_rusaint_rust_future_poll_f32.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_f32.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_f32.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_f32.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_f32.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_f32.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_f32.restype = ctypes.c_float
_UniffiLib.ffi_rusaint_rust_future_poll_f64.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_f64.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_f64.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_f64.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_f64.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_f64.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_f64.restype = ctypes.c_double
_UniffiLib.ffi_rusaint_rust_future_poll_pointer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_pointer.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_pointer.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_pointer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_pointer.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_pointer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_pointer.restype = ctypes.c_void_p
_UniffiLib.ffi_rusaint_rust_future_poll_rust_buffer.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_rust_buffer.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_rust_buffer.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_rust_buffer.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_rust_buffer.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_rust_buffer.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_rust_buffer.restype = _UniffiRustBuffer
_UniffiLib.ffi_rusaint_rust_future_poll_void.argtypes = (
    ctypes.c_uint64,
    _UNIFFI_RUST_FUTURE_CONTINUATION_CALLBACK,
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_poll_void.restype = None
_UniffiLib.ffi_rusaint_rust_future_cancel_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_cancel_void.restype = None
_UniffiLib.ffi_rusaint_rust_future_free_void.argtypes = (
    ctypes.c_uint64,
)
_UniffiLib.ffi_rusaint_rust_future_free_void.restype = None
_UniffiLib.ffi_rusaint_rust_future_complete_void.argtypes = (
    ctypes.c_uint64,
    ctypes.POINTER(_UniffiRustCallStatus),
)
_UniffiLib.ffi_rusaint_rust_future_complete_void.restype = None
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_chapel.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_chapel.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_connected_major.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_connected_major.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_cyber.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_cyber.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_education.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_education.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_lecture.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_lecture.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_professor.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_find_by_professor.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_graduated.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_graduated.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_major.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_major.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_optional_elective.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_optional_elective.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_recognized_other_major.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_recognized_other_major.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_required_elective.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_required_elective.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_united_major.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_method_lecturecategorybuilder_united_major.restype = ctypes.c_uint16
_UniffiLib.uniffi_rusaint_checksum_constructor_lecturecategorybuilder_new.argtypes = (
)
_UniffiLib.uniffi_rusaint_checksum_constructor_lecturecategorybuilder_new.restype = ctypes.c_uint16
_UniffiLib.ffi_rusaint_uniffi_contract_version.argtypes = (
)
_UniffiLib.ffi_rusaint_uniffi_contract_version.restype = ctypes.c_uint32

_uniffi_check_contract_api_version(_UniffiLib)
# _uniffi_check_api_checksums(_UniffiLib)

# Public interface members begin here.


class _UniffiConverterUInt32(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u32"
    VALUE_MIN = 0
    VALUE_MAX = 2**32

    @staticmethod
    def read(buf):
        return buf.read_u32()

    @staticmethod
    def write(value, buf):
        buf.write_u32(value)

class _UniffiConverterUInt64(_UniffiConverterPrimitiveInt):
    CLASS_NAME = "u64"
    VALUE_MIN = 0
    VALUE_MAX = 2**64

    @staticmethod
    def read(buf):
        return buf.read_u64()

    @staticmethod
    def write(value, buf):
        buf.write_u64(value)

class _UniffiConverterFloat(_UniffiConverterPrimitiveFloat):
    @staticmethod
    def read(buf):
        return buf.read_float()

    @staticmethod
    def write(value, buf):
        buf.write_float(value)

class _UniffiConverterBool:
    @classmethod
    def check_lower(cls, value):
        return not not value

    @classmethod
    def lower(cls, value):
        return 1 if value else 0

    @staticmethod
    def lift(value):
        return value != 0

    @classmethod
    def read(cls, buf):
        return cls.lift(buf.read_u8())

    @classmethod
    def write(cls, value, buf):
        buf.write_u8(value)

class _UniffiConverterString:
    @staticmethod
    def check_lower(value):
        if not isinstance(value, str):
            raise TypeError("argument must be str, not {}".format(type(value).__name__))
        return value

    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative string length")
        utf8_bytes = buf.read(size)
        return utf8_bytes.decode("utf-8")

    @staticmethod
    def write(value, buf):
        utf8_bytes = value.encode("utf-8")
        buf.write_i32(len(utf8_bytes))
        buf.write(utf8_bytes)

    @staticmethod
    def lift(buf):
        with buf.consume_with_stream() as stream:
            return stream.read(stream.remaining()).decode("utf-8")

    @staticmethod
    def lower(value):
        with _UniffiRustBuffer.alloc_with_builder() as builder:
            builder.write(value.encode("utf-8"))
            return builder.finalize()

class _UniffiConverterBytes(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        size = buf.read_i32()
        if size < 0:
            raise InternalError("Unexpected negative byte string length")
        return buf.read(size)

    @staticmethod
    def check_lower(value):
        try:
            memoryview(value)
        except TypeError:
            raise TypeError("a bytes-like object is required, not {!r}".format(type(value).__name__))

    @staticmethod
    def write(value, buf):
        buf.write_i32(len(value))
        buf.write(value)




class ChapelAbsenceRequest:
    """
    채플 결석신청 정보
    """

    year: "int"
    semester: "SemesterType"
    absence_detail: "str"
    absence_start: "str"
    absence_end: "str"
    absence_reason_kr: "str"
    absence_reason_en: "str"
    application_date: "str"
    approval_date: "str"
    denial_reason: "str"
    status: "str"
    def __init__(self, *, year: "int", semester: "SemesterType", absence_detail: "str", absence_start: "str", absence_end: "str", absence_reason_kr: "str", absence_reason_en: "str", application_date: "str", approval_date: "str", denial_reason: "str", status: "str"):
        self.year = year
        self.semester = semester
        self.absence_detail = absence_detail
        self.absence_start = absence_start
        self.absence_end = absence_end
        self.absence_reason_kr = absence_reason_kr
        self.absence_reason_en = absence_reason_en
        self.application_date = application_date
        self.approval_date = approval_date
        self.denial_reason = denial_reason
        self.status = status

    def __str__(self):
        return "ChapelAbsenceRequest(year={}, semester={}, absence_detail={}, absence_start={}, absence_end={}, absence_reason_kr={}, absence_reason_en={}, application_date={}, approval_date={}, denial_reason={}, status={})".format(self.year, self.semester, self.absence_detail, self.absence_start, self.absence_end, self.absence_reason_kr, self.absence_reason_en, self.application_date, self.approval_date, self.denial_reason, self.status)

    def __eq__(self, other):
        if self.year != other.year:
            return False
        if self.semester != other.semester:
            return False
        if self.absence_detail != other.absence_detail:
            return False
        if self.absence_start != other.absence_start:
            return False
        if self.absence_end != other.absence_end:
            return False
        if self.absence_reason_kr != other.absence_reason_kr:
            return False
        if self.absence_reason_en != other.absence_reason_en:
            return False
        if self.application_date != other.application_date:
            return False
        if self.approval_date != other.approval_date:
            return False
        if self.denial_reason != other.denial_reason:
            return False
        if self.status != other.status:
            return False
        return True

class _UniffiConverterTypeChapelAbsenceRequest(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ChapelAbsenceRequest(
            year=_UniffiConverterUInt32.read(buf),
            semester=_UniffiConverterTypeSemesterType.read(buf),
            absence_detail=_UniffiConverterString.read(buf),
            absence_start=_UniffiConverterString.read(buf),
            absence_end=_UniffiConverterString.read(buf),
            absence_reason_kr=_UniffiConverterString.read(buf),
            absence_reason_en=_UniffiConverterString.read(buf),
            application_date=_UniffiConverterString.read(buf),
            approval_date=_UniffiConverterString.read(buf),
            denial_reason=_UniffiConverterString.read(buf),
            status=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.year)
        _UniffiConverterTypeSemesterType.check_lower(value.semester)
        _UniffiConverterString.check_lower(value.absence_detail)
        _UniffiConverterString.check_lower(value.absence_start)
        _UniffiConverterString.check_lower(value.absence_end)
        _UniffiConverterString.check_lower(value.absence_reason_kr)
        _UniffiConverterString.check_lower(value.absence_reason_en)
        _UniffiConverterString.check_lower(value.application_date)
        _UniffiConverterString.check_lower(value.approval_date)
        _UniffiConverterString.check_lower(value.denial_reason)
        _UniffiConverterString.check_lower(value.status)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.year, buf)
        _UniffiConverterTypeSemesterType.write(value.semester, buf)
        _UniffiConverterString.write(value.absence_detail, buf)
        _UniffiConverterString.write(value.absence_start, buf)
        _UniffiConverterString.write(value.absence_end, buf)
        _UniffiConverterString.write(value.absence_reason_kr, buf)
        _UniffiConverterString.write(value.absence_reason_en, buf)
        _UniffiConverterString.write(value.application_date, buf)
        _UniffiConverterString.write(value.approval_date, buf)
        _UniffiConverterString.write(value.denial_reason, buf)
        _UniffiConverterString.write(value.status, buf)


class ChapelAttendance:
    """
    채플 수업별 출석정보
    """

    division: "int"
    class_date: "str"
    category: "str"
    instructor: "str"
    instructor_department: "str"
    title: "str"
    attendance: "str"
    result: "str"
    note: "str"
    def __init__(self, *, division: "int", class_date: "str", category: "str", instructor: "str", instructor_department: "str", title: "str", attendance: "str", result: "str", note: "str"):
        self.division = division
        self.class_date = class_date
        self.category = category
        self.instructor = instructor
        self.instructor_department = instructor_department
        self.title = title
        self.attendance = attendance
        self.result = result
        self.note = note

    def __str__(self):
        return "ChapelAttendance(division={}, class_date={}, category={}, instructor={}, instructor_department={}, title={}, attendance={}, result={}, note={})".format(self.division, self.class_date, self.category, self.instructor, self.instructor_department, self.title, self.attendance, self.result, self.note)

    def __eq__(self, other):
        if self.division != other.division:
            return False
        if self.class_date != other.class_date:
            return False
        if self.category != other.category:
            return False
        if self.instructor != other.instructor:
            return False
        if self.instructor_department != other.instructor_department:
            return False
        if self.title != other.title:
            return False
        if self.attendance != other.attendance:
            return False
        if self.result != other.result:
            return False
        if self.note != other.note:
            return False
        return True

class _UniffiConverterTypeChapelAttendance(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ChapelAttendance(
            division=_UniffiConverterUInt32.read(buf),
            class_date=_UniffiConverterString.read(buf),
            category=_UniffiConverterString.read(buf),
            instructor=_UniffiConverterString.read(buf),
            instructor_department=_UniffiConverterString.read(buf),
            title=_UniffiConverterString.read(buf),
            attendance=_UniffiConverterString.read(buf),
            result=_UniffiConverterString.read(buf),
            note=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.division)
        _UniffiConverterString.check_lower(value.class_date)
        _UniffiConverterString.check_lower(value.category)
        _UniffiConverterString.check_lower(value.instructor)
        _UniffiConverterString.check_lower(value.instructor_department)
        _UniffiConverterString.check_lower(value.title)
        _UniffiConverterString.check_lower(value.attendance)
        _UniffiConverterString.check_lower(value.result)
        _UniffiConverterString.check_lower(value.note)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.division, buf)
        _UniffiConverterString.write(value.class_date, buf)
        _UniffiConverterString.write(value.category, buf)
        _UniffiConverterString.write(value.instructor, buf)
        _UniffiConverterString.write(value.instructor_department, buf)
        _UniffiConverterString.write(value.title, buf)
        _UniffiConverterString.write(value.attendance, buf)
        _UniffiConverterString.write(value.result, buf)
        _UniffiConverterString.write(value.note, buf)


class ChapelInformation:
    """
    학기별 채플 정보
    """

    year: "int"
    semester: "SemesterType"
    general_information: "GeneralChapelInformation"
    attendances: "typing.List[ChapelAttendance]"
    absence_requests: "typing.List[ChapelAbsenceRequest]"
    def __init__(self, *, year: "int", semester: "SemesterType", general_information: "GeneralChapelInformation", attendances: "typing.List[ChapelAttendance]", absence_requests: "typing.List[ChapelAbsenceRequest]"):
        self.year = year
        self.semester = semester
        self.general_information = general_information
        self.attendances = attendances
        self.absence_requests = absence_requests

    def __str__(self):
        return "ChapelInformation(year={}, semester={}, general_information={}, attendances={}, absence_requests={})".format(self.year, self.semester, self.general_information, self.attendances, self.absence_requests)

    def __eq__(self, other):
        if self.year != other.year:
            return False
        if self.semester != other.semester:
            return False
        if self.general_information != other.general_information:
            return False
        if self.attendances != other.attendances:
            return False
        if self.absence_requests != other.absence_requests:
            return False
        return True

class _UniffiConverterTypeChapelInformation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ChapelInformation(
            year=_UniffiConverterUInt32.read(buf),
            semester=_UniffiConverterTypeSemesterType.read(buf),
            general_information=_UniffiConverterTypeGeneralChapelInformation.read(buf),
            attendances=_UniffiConverterSequenceTypeChapelAttendance.read(buf),
            absence_requests=_UniffiConverterSequenceTypeChapelAbsenceRequest.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.year)
        _UniffiConverterTypeSemesterType.check_lower(value.semester)
        _UniffiConverterTypeGeneralChapelInformation.check_lower(value.general_information)
        _UniffiConverterSequenceTypeChapelAttendance.check_lower(value.attendances)
        _UniffiConverterSequenceTypeChapelAbsenceRequest.check_lower(value.absence_requests)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.year, buf)
        _UniffiConverterTypeSemesterType.write(value.semester, buf)
        _UniffiConverterTypeGeneralChapelInformation.write(value.general_information, buf)
        _UniffiConverterSequenceTypeChapelAttendance.write(value.attendances, buf)
        _UniffiConverterSequenceTypeChapelAbsenceRequest.write(value.absence_requests, buf)


class ClassGrade:
    """
    과목별 성적
    """

    year: "int"
    """
    이수학년도
    """

    semester: "SemesterType"
    """
    이수학기
    """

    code: "str"
    """
    과목코드
    """

    class_name: "str"
    """
    과목명
    """

    grade_points: "float"
    """
    과목학점
    """

    score: "ClassScore"
    """
    성적
    """

    rank: "str"
    """
    등급
    """

    professor: "str"
    """
    교수명
    """

    detail: "typing.Optional[dict[str, float]]"
    """
    상세성적
    """

    def __init__(self, *, year: "int", semester: "SemesterType", code: "str", class_name: "str", grade_points: "float", score: "ClassScore", rank: "str", professor: "str", detail: "typing.Optional[dict[str, float]]"):
        self.year = year
        self.semester = semester
        self.code = code
        self.class_name = class_name
        self.grade_points = grade_points
        self.score = score
        self.rank = rank
        self.professor = professor
        self.detail = detail

    def __str__(self):
        return "ClassGrade(year={}, semester={}, code={}, class_name={}, grade_points={}, score={}, rank={}, professor={}, detail={})".format(self.year, self.semester, self.code, self.class_name, self.grade_points, self.score, self.rank, self.professor, self.detail)

    def __eq__(self, other):
        if self.year != other.year:
            return False
        if self.semester != other.semester:
            return False
        if self.code != other.code:
            return False
        if self.class_name != other.class_name:
            return False
        if self.grade_points != other.grade_points:
            return False
        if self.score != other.score:
            return False
        if self.rank != other.rank:
            return False
        if self.professor != other.professor:
            return False
        if self.detail != other.detail:
            return False
        return True

class _UniffiConverterTypeClassGrade(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return ClassGrade(
            year=_UniffiConverterUInt32.read(buf),
            semester=_UniffiConverterTypeSemesterType.read(buf),
            code=_UniffiConverterString.read(buf),
            class_name=_UniffiConverterString.read(buf),
            grade_points=_UniffiConverterFloat.read(buf),
            score=_UniffiConverterTypeClassScore.read(buf),
            rank=_UniffiConverterString.read(buf),
            professor=_UniffiConverterString.read(buf),
            detail=_UniffiConverterOptionalMapStringFloat.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.year)
        _UniffiConverterTypeSemesterType.check_lower(value.semester)
        _UniffiConverterString.check_lower(value.code)
        _UniffiConverterString.check_lower(value.class_name)
        _UniffiConverterFloat.check_lower(value.grade_points)
        _UniffiConverterTypeClassScore.check_lower(value.score)
        _UniffiConverterString.check_lower(value.rank)
        _UniffiConverterString.check_lower(value.professor)
        _UniffiConverterOptionalMapStringFloat.check_lower(value.detail)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.year, buf)
        _UniffiConverterTypeSemesterType.write(value.semester, buf)
        _UniffiConverterString.write(value.code, buf)
        _UniffiConverterString.write(value.class_name, buf)
        _UniffiConverterFloat.write(value.grade_points, buf)
        _UniffiConverterTypeClassScore.write(value.score, buf)
        _UniffiConverterString.write(value.rank, buf)
        _UniffiConverterString.write(value.professor, buf)
        _UniffiConverterOptionalMapStringFloat.write(value.detail, buf)


class CourseScheduleInformation:
    """
    강의의 시간표 정보입니다.
    """

    name: "str"
    professor: "str"
    time: "str"
    classroom: "str"
    def __init__(self, *, name: "str", professor: "str", time: "str", classroom: "str"):
        self.name = name
        self.professor = professor
        self.time = time
        self.classroom = classroom

    def __str__(self):
        return "CourseScheduleInformation(name={}, professor={}, time={}, classroom={})".format(self.name, self.professor, self.time, self.classroom)

    def __eq__(self, other):
        if self.name != other.name:
            return False
        if self.professor != other.professor:
            return False
        if self.time != other.time:
            return False
        if self.classroom != other.classroom:
            return False
        return True

class _UniffiConverterTypeCourseScheduleInformation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return CourseScheduleInformation(
            name=_UniffiConverterString.read(buf),
            professor=_UniffiConverterString.read(buf),
            time=_UniffiConverterString.read(buf),
            classroom=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterString.check_lower(value.professor)
        _UniffiConverterString.check_lower(value.time)
        _UniffiConverterString.check_lower(value.classroom)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterString.write(value.professor, buf)
        _UniffiConverterString.write(value.time, buf)
        _UniffiConverterString.write(value.classroom, buf)


class GeneralChapelInformation:
    """
    채플 기본 정보(좌석번호, 결석현황, 성적결과)
    """

    division: "int"
    chapel_time: "str"
    chapel_room: "str"
    floor_level: "int"
    seat_number: "str"
    absence_time: "int"
    result: "str"
    note: "str"
    def __init__(self, *, division: "int", chapel_time: "str", chapel_room: "str", floor_level: "int", seat_number: "str", absence_time: "int", result: "str", note: "str"):
        self.division = division
        self.chapel_time = chapel_time
        self.chapel_room = chapel_room
        self.floor_level = floor_level
        self.seat_number = seat_number
        self.absence_time = absence_time
        self.result = result
        self.note = note

    def __str__(self):
        return "GeneralChapelInformation(division={}, chapel_time={}, chapel_room={}, floor_level={}, seat_number={}, absence_time={}, result={}, note={})".format(self.division, self.chapel_time, self.chapel_room, self.floor_level, self.seat_number, self.absence_time, self.result, self.note)

    def __eq__(self, other):
        if self.division != other.division:
            return False
        if self.chapel_time != other.chapel_time:
            return False
        if self.chapel_room != other.chapel_room:
            return False
        if self.floor_level != other.floor_level:
            return False
        if self.seat_number != other.seat_number:
            return False
        if self.absence_time != other.absence_time:
            return False
        if self.result != other.result:
            return False
        if self.note != other.note:
            return False
        return True

class _UniffiConverterTypeGeneralChapelInformation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GeneralChapelInformation(
            division=_UniffiConverterUInt32.read(buf),
            chapel_time=_UniffiConverterString.read(buf),
            chapel_room=_UniffiConverterString.read(buf),
            floor_level=_UniffiConverterUInt32.read(buf),
            seat_number=_UniffiConverterString.read(buf),
            absence_time=_UniffiConverterUInt32.read(buf),
            result=_UniffiConverterString.read(buf),
            note=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.division)
        _UniffiConverterString.check_lower(value.chapel_time)
        _UniffiConverterString.check_lower(value.chapel_room)
        _UniffiConverterUInt32.check_lower(value.floor_level)
        _UniffiConverterString.check_lower(value.seat_number)
        _UniffiConverterUInt32.check_lower(value.absence_time)
        _UniffiConverterString.check_lower(value.result)
        _UniffiConverterString.check_lower(value.note)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.division, buf)
        _UniffiConverterString.write(value.chapel_time, buf)
        _UniffiConverterString.write(value.chapel_room, buf)
        _UniffiConverterUInt32.write(value.floor_level, buf)
        _UniffiConverterString.write(value.seat_number, buf)
        _UniffiConverterUInt32.write(value.absence_time, buf)
        _UniffiConverterString.write(value.result, buf)
        _UniffiConverterString.write(value.note, buf)


class GradeSummary:
    """
    전체 성적(학적부, 증명)
    """

    attempted_credits: "float"
    """
    신청학점
    """

    earned_credits: "float"
    """
    취득학점
    """

    grade_points_sum: "float"
    """
    평점계
    """

    grade_points_average: "float"
    """
    평점평균
    """

    arithmetic_mean: "float"
    """
    산술평균
    """

    pf_earned_credits: "float"
    """
    P/F 학점계
    """

    def __init__(self, *, attempted_credits: "float", earned_credits: "float", grade_points_sum: "float", grade_points_average: "float", arithmetic_mean: "float", pf_earned_credits: "float"):
        self.attempted_credits = attempted_credits
        self.earned_credits = earned_credits
        self.grade_points_sum = grade_points_sum
        self.grade_points_average = grade_points_average
        self.arithmetic_mean = arithmetic_mean
        self.pf_earned_credits = pf_earned_credits

    def __str__(self):
        return "GradeSummary(attempted_credits={}, earned_credits={}, grade_points_sum={}, grade_points_average={}, arithmetic_mean={}, pf_earned_credits={})".format(self.attempted_credits, self.earned_credits, self.grade_points_sum, self.grade_points_average, self.arithmetic_mean, self.pf_earned_credits)

    def __eq__(self, other):
        if self.attempted_credits != other.attempted_credits:
            return False
        if self.earned_credits != other.earned_credits:
            return False
        if self.grade_points_sum != other.grade_points_sum:
            return False
        if self.grade_points_average != other.grade_points_average:
            return False
        if self.arithmetic_mean != other.arithmetic_mean:
            return False
        if self.pf_earned_credits != other.pf_earned_credits:
            return False
        return True

class _UniffiConverterTypeGradeSummary(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GradeSummary(
            attempted_credits=_UniffiConverterFloat.read(buf),
            earned_credits=_UniffiConverterFloat.read(buf),
            grade_points_sum=_UniffiConverterFloat.read(buf),
            grade_points_average=_UniffiConverterFloat.read(buf),
            arithmetic_mean=_UniffiConverterFloat.read(buf),
            pf_earned_credits=_UniffiConverterFloat.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterFloat.check_lower(value.attempted_credits)
        _UniffiConverterFloat.check_lower(value.earned_credits)
        _UniffiConverterFloat.check_lower(value.grade_points_sum)
        _UniffiConverterFloat.check_lower(value.grade_points_average)
        _UniffiConverterFloat.check_lower(value.arithmetic_mean)
        _UniffiConverterFloat.check_lower(value.pf_earned_credits)

    @staticmethod
    def write(value, buf):
        _UniffiConverterFloat.write(value.attempted_credits, buf)
        _UniffiConverterFloat.write(value.earned_credits, buf)
        _UniffiConverterFloat.write(value.grade_points_sum, buf)
        _UniffiConverterFloat.write(value.grade_points_average, buf)
        _UniffiConverterFloat.write(value.arithmetic_mean, buf)
        _UniffiConverterFloat.write(value.pf_earned_credits, buf)


class GraduationRequirement:
    """
    졸업 요건
    """

    name: "str"
    requirement: "typing.Optional[int]"
    calcuation: "typing.Optional[float]"
    difference: "typing.Optional[float]"
    result: "bool"
    category: "str"
    lectures: "typing.List[str]"
    def __init__(self, *, name: "str", requirement: "typing.Optional[int]", calcuation: "typing.Optional[float]", difference: "typing.Optional[float]", result: "bool", category: "str", lectures: "typing.List[str]"):
        self.name = name
        self.requirement = requirement
        self.calcuation = calcuation
        self.difference = difference
        self.result = result
        self.category = category
        self.lectures = lectures

    def __str__(self):
        return "GraduationRequirement(name={}, requirement={}, calcuation={}, difference={}, result={}, category={}, lectures={})".format(self.name, self.requirement, self.calcuation, self.difference, self.result, self.category, self.lectures)

    def __eq__(self, other):
        if self.name != other.name:
            return False
        if self.requirement != other.requirement:
            return False
        if self.calcuation != other.calcuation:
            return False
        if self.difference != other.difference:
            return False
        if self.result != other.result:
            return False
        if self.category != other.category:
            return False
        if self.lectures != other.lectures:
            return False
        return True

class _UniffiConverterTypeGraduationRequirement(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GraduationRequirement(
            name=_UniffiConverterString.read(buf),
            requirement=_UniffiConverterOptionalUInt32.read(buf),
            calcuation=_UniffiConverterOptionalFloat.read(buf),
            difference=_UniffiConverterOptionalFloat.read(buf),
            result=_UniffiConverterBool.read(buf),
            category=_UniffiConverterString.read(buf),
            lectures=_UniffiConverterSequenceString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterOptionalUInt32.check_lower(value.requirement)
        _UniffiConverterOptionalFloat.check_lower(value.calcuation)
        _UniffiConverterOptionalFloat.check_lower(value.difference)
        _UniffiConverterBool.check_lower(value.result)
        _UniffiConverterString.check_lower(value.category)
        _UniffiConverterSequenceString.check_lower(value.lectures)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterOptionalUInt32.write(value.requirement, buf)
        _UniffiConverterOptionalFloat.write(value.calcuation, buf)
        _UniffiConverterOptionalFloat.write(value.difference, buf)
        _UniffiConverterBool.write(value.result, buf)
        _UniffiConverterString.write(value.category, buf)
        _UniffiConverterSequenceString.write(value.lectures, buf)


class GraduationRequirements:
    """
    전체 졸업 요건 정보
    """

    is_graduatable: "bool"
    requirements: "dict[str, GraduationRequirement]"
    def __init__(self, *, is_graduatable: "bool", requirements: "dict[str, GraduationRequirement]"):
        self.is_graduatable = is_graduatable
        self.requirements = requirements

    def __str__(self):
        return "GraduationRequirements(is_graduatable={}, requirements={})".format(self.is_graduatable, self.requirements)

    def __eq__(self, other):
        if self.is_graduatable != other.is_graduatable:
            return False
        if self.requirements != other.requirements:
            return False
        return True

class _UniffiConverterTypeGraduationRequirements(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GraduationRequirements(
            is_graduatable=_UniffiConverterBool.read(buf),
            requirements=_UniffiConverterMapStringTypeGraduationRequirement.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterBool.check_lower(value.is_graduatable)
        _UniffiConverterMapStringTypeGraduationRequirement.check_lower(value.requirements)

    @staticmethod
    def write(value, buf):
        _UniffiConverterBool.write(value.is_graduatable, buf)
        _UniffiConverterMapStringTypeGraduationRequirement.write(value.requirements, buf)


class GraduationStudent:
    """
    졸업 학생 정보
    """

    number: "int"
    name: "str"
    grade: "int"
    semester: "int"
    status: "str"
    apply_year: "int"
    apply_type: "str"
    department: "str"
    majors: "typing.List[str]"
    audit_date: "str"
    graduation_points: "float"
    completed_points: "float"
    def __init__(self, *, number: "int", name: "str", grade: "int", semester: "int", status: "str", apply_year: "int", apply_type: "str", department: "str", majors: "typing.List[str]", audit_date: "str", graduation_points: "float", completed_points: "float"):
        self.number = number
        self.name = name
        self.grade = grade
        self.semester = semester
        self.status = status
        self.apply_year = apply_year
        self.apply_type = apply_type
        self.department = department
        self.majors = majors
        self.audit_date = audit_date
        self.graduation_points = graduation_points
        self.completed_points = completed_points

    def __str__(self):
        return "GraduationStudent(number={}, name={}, grade={}, semester={}, status={}, apply_year={}, apply_type={}, department={}, majors={}, audit_date={}, graduation_points={}, completed_points={})".format(self.number, self.name, self.grade, self.semester, self.status, self.apply_year, self.apply_type, self.department, self.majors, self.audit_date, self.graduation_points, self.completed_points)

    def __eq__(self, other):
        if self.number != other.number:
            return False
        if self.name != other.name:
            return False
        if self.grade != other.grade:
            return False
        if self.semester != other.semester:
            return False
        if self.status != other.status:
            return False
        if self.apply_year != other.apply_year:
            return False
        if self.apply_type != other.apply_type:
            return False
        if self.department != other.department:
            return False
        if self.majors != other.majors:
            return False
        if self.audit_date != other.audit_date:
            return False
        if self.graduation_points != other.graduation_points:
            return False
        if self.completed_points != other.completed_points:
            return False
        return True

class _UniffiConverterTypeGraduationStudent(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return GraduationStudent(
            number=_UniffiConverterUInt32.read(buf),
            name=_UniffiConverterString.read(buf),
            grade=_UniffiConverterUInt32.read(buf),
            semester=_UniffiConverterUInt32.read(buf),
            status=_UniffiConverterString.read(buf),
            apply_year=_UniffiConverterUInt32.read(buf),
            apply_type=_UniffiConverterString.read(buf),
            department=_UniffiConverterString.read(buf),
            majors=_UniffiConverterSequenceString.read(buf),
            audit_date=_UniffiConverterString.read(buf),
            graduation_points=_UniffiConverterFloat.read(buf),
            completed_points=_UniffiConverterFloat.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.number)
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterUInt32.check_lower(value.grade)
        _UniffiConverterUInt32.check_lower(value.semester)
        _UniffiConverterString.check_lower(value.status)
        _UniffiConverterUInt32.check_lower(value.apply_year)
        _UniffiConverterString.check_lower(value.apply_type)
        _UniffiConverterString.check_lower(value.department)
        _UniffiConverterSequenceString.check_lower(value.majors)
        _UniffiConverterString.check_lower(value.audit_date)
        _UniffiConverterFloat.check_lower(value.graduation_points)
        _UniffiConverterFloat.check_lower(value.completed_points)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.number, buf)
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterUInt32.write(value.grade, buf)
        _UniffiConverterUInt32.write(value.semester, buf)
        _UniffiConverterString.write(value.status, buf)
        _UniffiConverterUInt32.write(value.apply_year, buf)
        _UniffiConverterString.write(value.apply_type, buf)
        _UniffiConverterString.write(value.department, buf)
        _UniffiConverterSequenceString.write(value.majors, buf)
        _UniffiConverterString.write(value.audit_date, buf)
        _UniffiConverterFloat.write(value.graduation_points, buf)
        _UniffiConverterFloat.write(value.completed_points, buf)


class Lecture:
    """
    과목 정보
    """

    syllabus: "typing.Optional[str]"
    """
    계획
    """

    category: "str"
    """
    이수구분(주전공)
    """

    sub_category: "typing.Optional[str]"
    """
    이수구분(다전공)
    """

    abeek_info: "typing.Optional[str]"
    """
    공학인증
    """

    field: "typing.Optional[str]"
    """
    교과영역
    """

    code: "str"
    """
    과목번호
    """

    name: "str"
    """
    과목명
    """

    division: "typing.Optional[str]"
    """
    분반
    """

    professor: "str"
    """
    교수명
    """

    department: "str"
    """
    개설학과
    """

    time_points: "str"
    """
    시간/학점(설계)
    """

    personeel: "str"
    """
    수강인원
    """

    remaining_seats: "str"
    """
    여석
    """

    schedule_room: "str"
    """
    강의시간(강의실)
    """

    target: "str"
    """
    수강대상
    """

    def __init__(self, *, syllabus: "typing.Optional[str]", category: "str", sub_category: "typing.Optional[str]", abeek_info: "typing.Optional[str]", field: "typing.Optional[str]", code: "str", name: "str", division: "typing.Optional[str]", professor: "str", department: "str", time_points: "str", personeel: "str", remaining_seats: "str", schedule_room: "str", target: "str"):
        self.syllabus = syllabus
        self.category = category
        self.sub_category = sub_category
        self.abeek_info = abeek_info
        self.field = field
        self.code = code
        self.name = name
        self.division = division
        self.professor = professor
        self.department = department
        self.time_points = time_points
        self.personeel = personeel
        self.remaining_seats = remaining_seats
        self.schedule_room = schedule_room
        self.target = target

    def __str__(self):
        return "Lecture(syllabus={}, category={}, sub_category={}, abeek_info={}, field={}, code={}, name={}, division={}, professor={}, department={}, time_points={}, personeel={}, remaining_seats={}, schedule_room={}, target={})".format(self.syllabus, self.category, self.sub_category, self.abeek_info, self.field, self.code, self.name, self.division, self.professor, self.department, self.time_points, self.personeel, self.remaining_seats, self.schedule_room, self.target)

    def __eq__(self, other):
        if self.syllabus != other.syllabus:
            return False
        if self.category != other.category:
            return False
        if self.sub_category != other.sub_category:
            return False
        if self.abeek_info != other.abeek_info:
            return False
        if self.field != other.field:
            return False
        if self.code != other.code:
            return False
        if self.name != other.name:
            return False
        if self.division != other.division:
            return False
        if self.professor != other.professor:
            return False
        if self.department != other.department:
            return False
        if self.time_points != other.time_points:
            return False
        if self.personeel != other.personeel:
            return False
        if self.remaining_seats != other.remaining_seats:
            return False
        if self.schedule_room != other.schedule_room:
            return False
        if self.target != other.target:
            return False
        return True

class _UniffiConverterTypeLecture(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Lecture(
            syllabus=_UniffiConverterOptionalString.read(buf),
            category=_UniffiConverterString.read(buf),
            sub_category=_UniffiConverterOptionalString.read(buf),
            abeek_info=_UniffiConverterOptionalString.read(buf),
            field=_UniffiConverterOptionalString.read(buf),
            code=_UniffiConverterString.read(buf),
            name=_UniffiConverterString.read(buf),
            division=_UniffiConverterOptionalString.read(buf),
            professor=_UniffiConverterString.read(buf),
            department=_UniffiConverterString.read(buf),
            time_points=_UniffiConverterString.read(buf),
            personeel=_UniffiConverterString.read(buf),
            remaining_seats=_UniffiConverterString.read(buf),
            schedule_room=_UniffiConverterString.read(buf),
            target=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.syllabus)
        _UniffiConverterString.check_lower(value.category)
        _UniffiConverterOptionalString.check_lower(value.sub_category)
        _UniffiConverterOptionalString.check_lower(value.abeek_info)
        _UniffiConverterOptionalString.check_lower(value.field)
        _UniffiConverterString.check_lower(value.code)
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterOptionalString.check_lower(value.division)
        _UniffiConverterString.check_lower(value.professor)
        _UniffiConverterString.check_lower(value.department)
        _UniffiConverterString.check_lower(value.time_points)
        _UniffiConverterString.check_lower(value.personeel)
        _UniffiConverterString.check_lower(value.remaining_seats)
        _UniffiConverterString.check_lower(value.schedule_room)
        _UniffiConverterString.check_lower(value.target)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.syllabus, buf)
        _UniffiConverterString.write(value.category, buf)
        _UniffiConverterOptionalString.write(value.sub_category, buf)
        _UniffiConverterOptionalString.write(value.abeek_info, buf)
        _UniffiConverterOptionalString.write(value.field, buf)
        _UniffiConverterString.write(value.code, buf)
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterOptionalString.write(value.division, buf)
        _UniffiConverterString.write(value.professor, buf)
        _UniffiConverterString.write(value.department, buf)
        _UniffiConverterString.write(value.time_points, buf)
        _UniffiConverterString.write(value.personeel, buf)
        _UniffiConverterString.write(value.remaining_seats, buf)
        _UniffiConverterString.write(value.schedule_room, buf)
        _UniffiConverterString.write(value.target, buf)


class LectureAssessmentResult:
    """
    강의평가 결과
    """

    year: "str"
    semester: "SemesterType"
    lecture_code: "int"
    lecture_name: "str"
    points: "float"
    professor: "str"
    collage: "str"
    department: "str"
    position: "str"
    score: "float"
    def __init__(self, *, year: "str", semester: "SemesterType", lecture_code: "int", lecture_name: "str", points: "float", professor: "str", collage: "str", department: "str", position: "str", score: "float"):
        self.year = year
        self.semester = semester
        self.lecture_code = lecture_code
        self.lecture_name = lecture_name
        self.points = points
        self.professor = professor
        self.collage = collage
        self.department = department
        self.position = position
        self.score = score

    def __str__(self):
        return "LectureAssessmentResult(year={}, semester={}, lecture_code={}, lecture_name={}, points={}, professor={}, collage={}, department={}, position={}, score={})".format(self.year, self.semester, self.lecture_code, self.lecture_name, self.points, self.professor, self.collage, self.department, self.position, self.score)

    def __eq__(self, other):
        if self.year != other.year:
            return False
        if self.semester != other.semester:
            return False
        if self.lecture_code != other.lecture_code:
            return False
        if self.lecture_name != other.lecture_name:
            return False
        if self.points != other.points:
            return False
        if self.professor != other.professor:
            return False
        if self.collage != other.collage:
            return False
        if self.department != other.department:
            return False
        if self.position != other.position:
            return False
        if self.score != other.score:
            return False
        return True

class _UniffiConverterTypeLectureAssessmentResult(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return LectureAssessmentResult(
            year=_UniffiConverterString.read(buf),
            semester=_UniffiConverterTypeSemesterType.read(buf),
            lecture_code=_UniffiConverterUInt32.read(buf),
            lecture_name=_UniffiConverterString.read(buf),
            points=_UniffiConverterFloat.read(buf),
            professor=_UniffiConverterString.read(buf),
            collage=_UniffiConverterString.read(buf),
            department=_UniffiConverterString.read(buf),
            position=_UniffiConverterString.read(buf),
            score=_UniffiConverterFloat.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.year)
        _UniffiConverterTypeSemesterType.check_lower(value.semester)
        _UniffiConverterUInt32.check_lower(value.lecture_code)
        _UniffiConverterString.check_lower(value.lecture_name)
        _UniffiConverterFloat.check_lower(value.points)
        _UniffiConverterString.check_lower(value.professor)
        _UniffiConverterString.check_lower(value.collage)
        _UniffiConverterString.check_lower(value.department)
        _UniffiConverterString.check_lower(value.position)
        _UniffiConverterFloat.check_lower(value.score)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.year, buf)
        _UniffiConverterTypeSemesterType.write(value.semester, buf)
        _UniffiConverterUInt32.write(value.lecture_code, buf)
        _UniffiConverterString.write(value.lecture_name, buf)
        _UniffiConverterFloat.write(value.points, buf)
        _UniffiConverterString.write(value.professor, buf)
        _UniffiConverterString.write(value.collage, buf)
        _UniffiConverterString.write(value.department, buf)
        _UniffiConverterString.write(value.position, buf)
        _UniffiConverterFloat.write(value.score, buf)


class PersonalCourseSchedule:
    """
    개인의 수업 시간표 정보를 조회합니다.
    """

    schedule: "dict[Weekday, typing.List[CourseScheduleInformation]]"
    def __init__(self, *, schedule: "dict[Weekday, typing.List[CourseScheduleInformation]]"):
        self.schedule = schedule

    def __str__(self):
        return "PersonalCourseSchedule(schedule={})".format(self.schedule)

    def __eq__(self, other):
        if self.schedule != other.schedule:
            return False
        return True

class _UniffiConverterTypePersonalCourseSchedule(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return PersonalCourseSchedule(
            schedule=_UniffiConverterMapTypeWeekdaySequenceTypeCourseScheduleInformation.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterMapTypeWeekdaySequenceTypeCourseScheduleInformation.check_lower(value.schedule)

    @staticmethod
    def write(value, buf):
        _UniffiConverterMapTypeWeekdaySequenceTypeCourseScheduleInformation.write(value.schedule, buf)


class Scholarship:
    """
    수혜받은 장학금 정보
    """

    year: "int"
    semester: "SemesterType"
    name: "str"
    received_amount: "int"
    receive_type: "str"
    status: "str"
    processed_at: "str"
    selected_amount: "int"
    refunded_amount: "int"
    replaced_amount: "int"
    replaced_by: "str"
    drop_reason: "str"
    note: "str"
    worked_at: "str"
    def __init__(self, *, year: "int", semester: "SemesterType", name: "str", received_amount: "int", receive_type: "str", status: "str", processed_at: "str", selected_amount: "int", refunded_amount: "int", replaced_amount: "int", replaced_by: "str", drop_reason: "str", note: "str", worked_at: "str"):
        self.year = year
        self.semester = semester
        self.name = name
        self.received_amount = received_amount
        self.receive_type = receive_type
        self.status = status
        self.processed_at = processed_at
        self.selected_amount = selected_amount
        self.refunded_amount = refunded_amount
        self.replaced_amount = replaced_amount
        self.replaced_by = replaced_by
        self.drop_reason = drop_reason
        self.note = note
        self.worked_at = worked_at

    def __str__(self):
        return "Scholarship(year={}, semester={}, name={}, received_amount={}, receive_type={}, status={}, processed_at={}, selected_amount={}, refunded_amount={}, replaced_amount={}, replaced_by={}, drop_reason={}, note={}, worked_at={})".format(self.year, self.semester, self.name, self.received_amount, self.receive_type, self.status, self.processed_at, self.selected_amount, self.refunded_amount, self.replaced_amount, self.replaced_by, self.drop_reason, self.note, self.worked_at)

    def __eq__(self, other):
        if self.year != other.year:
            return False
        if self.semester != other.semester:
            return False
        if self.name != other.name:
            return False
        if self.received_amount != other.received_amount:
            return False
        if self.receive_type != other.receive_type:
            return False
        if self.status != other.status:
            return False
        if self.processed_at != other.processed_at:
            return False
        if self.selected_amount != other.selected_amount:
            return False
        if self.refunded_amount != other.refunded_amount:
            return False
        if self.replaced_amount != other.replaced_amount:
            return False
        if self.replaced_by != other.replaced_by:
            return False
        if self.drop_reason != other.drop_reason:
            return False
        if self.note != other.note:
            return False
        if self.worked_at != other.worked_at:
            return False
        return True

class _UniffiConverterTypeScholarship(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return Scholarship(
            year=_UniffiConverterUInt32.read(buf),
            semester=_UniffiConverterTypeSemesterType.read(buf),
            name=_UniffiConverterString.read(buf),
            received_amount=_UniffiConverterUInt64.read(buf),
            receive_type=_UniffiConverterString.read(buf),
            status=_UniffiConverterString.read(buf),
            processed_at=_UniffiConverterString.read(buf),
            selected_amount=_UniffiConverterUInt64.read(buf),
            refunded_amount=_UniffiConverterUInt64.read(buf),
            replaced_amount=_UniffiConverterUInt64.read(buf),
            replaced_by=_UniffiConverterString.read(buf),
            drop_reason=_UniffiConverterString.read(buf),
            note=_UniffiConverterString.read(buf),
            worked_at=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.year)
        _UniffiConverterTypeSemesterType.check_lower(value.semester)
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterUInt64.check_lower(value.received_amount)
        _UniffiConverterString.check_lower(value.receive_type)
        _UniffiConverterString.check_lower(value.status)
        _UniffiConverterString.check_lower(value.processed_at)
        _UniffiConverterUInt64.check_lower(value.selected_amount)
        _UniffiConverterUInt64.check_lower(value.refunded_amount)
        _UniffiConverterUInt64.check_lower(value.replaced_amount)
        _UniffiConverterString.check_lower(value.replaced_by)
        _UniffiConverterString.check_lower(value.drop_reason)
        _UniffiConverterString.check_lower(value.note)
        _UniffiConverterString.check_lower(value.worked_at)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.year, buf)
        _UniffiConverterTypeSemesterType.write(value.semester, buf)
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterUInt64.write(value.received_amount, buf)
        _UniffiConverterString.write(value.receive_type, buf)
        _UniffiConverterString.write(value.status, buf)
        _UniffiConverterString.write(value.processed_at, buf)
        _UniffiConverterUInt64.write(value.selected_amount, buf)
        _UniffiConverterUInt64.write(value.refunded_amount, buf)
        _UniffiConverterUInt64.write(value.replaced_amount, buf)
        _UniffiConverterString.write(value.replaced_by, buf)
        _UniffiConverterString.write(value.drop_reason, buf)
        _UniffiConverterString.write(value.note, buf)
        _UniffiConverterString.write(value.worked_at, buf)


class SemesterGrade:
    """
    학기별 성적
    """

    year: "int"
    """
    학년도
    """

    semester: "SemesterType"
    """
    학기
    """

    attempted_credits: "float"
    """
    신청학점
    """

    earned_credits: "float"
    """
    취득학점
    """

    pf_earned_credits: "float"
    """
    P/F학점
    """

    grade_points_average: "float"
    """
    평점평균
    """

    grade_points_sum: "float"
    """
    평점계
    """

    arithmetic_mean: "float"
    """
    산술평균
    """

    semester_rank: "U32Pair"
    """
    학기별석차
    """

    general_rank: "U32Pair"
    """
    전체석차
    """

    academic_probation: "bool"
    """
    학사경고
    """

    consult: "bool"
    """
    상담여부
    """

    flunked: "bool"
    """
    유급
    """

    def __init__(self, *, year: "int", semester: "SemesterType", attempted_credits: "float", earned_credits: "float", pf_earned_credits: "float", grade_points_average: "float", grade_points_sum: "float", arithmetic_mean: "float", semester_rank: "U32Pair", general_rank: "U32Pair", academic_probation: "bool", consult: "bool", flunked: "bool"):
        self.year = year
        self.semester = semester
        self.attempted_credits = attempted_credits
        self.earned_credits = earned_credits
        self.pf_earned_credits = pf_earned_credits
        self.grade_points_average = grade_points_average
        self.grade_points_sum = grade_points_sum
        self.arithmetic_mean = arithmetic_mean
        self.semester_rank = semester_rank
        self.general_rank = general_rank
        self.academic_probation = academic_probation
        self.consult = consult
        self.flunked = flunked

    def __str__(self):
        return "SemesterGrade(year={}, semester={}, attempted_credits={}, earned_credits={}, pf_earned_credits={}, grade_points_average={}, grade_points_sum={}, arithmetic_mean={}, semester_rank={}, general_rank={}, academic_probation={}, consult={}, flunked={})".format(self.year, self.semester, self.attempted_credits, self.earned_credits, self.pf_earned_credits, self.grade_points_average, self.grade_points_sum, self.arithmetic_mean, self.semester_rank, self.general_rank, self.academic_probation, self.consult, self.flunked)

    def __eq__(self, other):
        if self.year != other.year:
            return False
        if self.semester != other.semester:
            return False
        if self.attempted_credits != other.attempted_credits:
            return False
        if self.earned_credits != other.earned_credits:
            return False
        if self.pf_earned_credits != other.pf_earned_credits:
            return False
        if self.grade_points_average != other.grade_points_average:
            return False
        if self.grade_points_sum != other.grade_points_sum:
            return False
        if self.arithmetic_mean != other.arithmetic_mean:
            return False
        if self.semester_rank != other.semester_rank:
            return False
        if self.general_rank != other.general_rank:
            return False
        if self.academic_probation != other.academic_probation:
            return False
        if self.consult != other.consult:
            return False
        if self.flunked != other.flunked:
            return False
        return True

class _UniffiConverterTypeSemesterGrade(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return SemesterGrade(
            year=_UniffiConverterUInt32.read(buf),
            semester=_UniffiConverterTypeSemesterType.read(buf),
            attempted_credits=_UniffiConverterFloat.read(buf),
            earned_credits=_UniffiConverterFloat.read(buf),
            pf_earned_credits=_UniffiConverterFloat.read(buf),
            grade_points_average=_UniffiConverterFloat.read(buf),
            grade_points_sum=_UniffiConverterFloat.read(buf),
            arithmetic_mean=_UniffiConverterFloat.read(buf),
            semester_rank=_UniffiConverterTypeU32Pair.read(buf),
            general_rank=_UniffiConverterTypeU32Pair.read(buf),
            academic_probation=_UniffiConverterBool.read(buf),
            consult=_UniffiConverterBool.read(buf),
            flunked=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.year)
        _UniffiConverterTypeSemesterType.check_lower(value.semester)
        _UniffiConverterFloat.check_lower(value.attempted_credits)
        _UniffiConverterFloat.check_lower(value.earned_credits)
        _UniffiConverterFloat.check_lower(value.pf_earned_credits)
        _UniffiConverterFloat.check_lower(value.grade_points_average)
        _UniffiConverterFloat.check_lower(value.grade_points_sum)
        _UniffiConverterFloat.check_lower(value.arithmetic_mean)
        _UniffiConverterTypeU32Pair.check_lower(value.semester_rank)
        _UniffiConverterTypeU32Pair.check_lower(value.general_rank)
        _UniffiConverterBool.check_lower(value.academic_probation)
        _UniffiConverterBool.check_lower(value.consult)
        _UniffiConverterBool.check_lower(value.flunked)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.year, buf)
        _UniffiConverterTypeSemesterType.write(value.semester, buf)
        _UniffiConverterFloat.write(value.attempted_credits, buf)
        _UniffiConverterFloat.write(value.earned_credits, buf)
        _UniffiConverterFloat.write(value.pf_earned_credits, buf)
        _UniffiConverterFloat.write(value.grade_points_average, buf)
        _UniffiConverterFloat.write(value.grade_points_sum, buf)
        _UniffiConverterFloat.write(value.arithmetic_mean, buf)
        _UniffiConverterTypeU32Pair.write(value.semester_rank, buf)
        _UniffiConverterTypeU32Pair.write(value.general_rank, buf)
        _UniffiConverterBool.write(value.academic_probation, buf)
        _UniffiConverterBool.write(value.consult, buf)
        _UniffiConverterBool.write(value.flunked, buf)


class StudentAcademicRecord:
    """
    학생의 학적상태 기록
    """

    start_date: "str"
    end_date: "str"
    year: "str"
    term: "str"
    category: "str"
    reason: "str"
    process_date: "str"
    def __init__(self, *, start_date: "str", end_date: "str", year: "str", term: "str", category: "str", reason: "str", process_date: "str"):
        self.start_date = start_date
        self.end_date = end_date
        self.year = year
        self.term = term
        self.category = category
        self.reason = reason
        self.process_date = process_date

    def __str__(self):
        return "StudentAcademicRecord(start_date={}, end_date={}, year={}, term={}, category={}, reason={}, process_date={})".format(self.start_date, self.end_date, self.year, self.term, self.category, self.reason, self.process_date)

    def __eq__(self, other):
        if self.start_date != other.start_date:
            return False
        if self.end_date != other.end_date:
            return False
        if self.year != other.year:
            return False
        if self.term != other.term:
            return False
        if self.category != other.category:
            return False
        if self.reason != other.reason:
            return False
        if self.process_date != other.process_date:
            return False
        return True

class _UniffiConverterTypeStudentAcademicRecord(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentAcademicRecord(
            start_date=_UniffiConverterString.read(buf),
            end_date=_UniffiConverterString.read(buf),
            year=_UniffiConverterString.read(buf),
            term=_UniffiConverterString.read(buf),
            category=_UniffiConverterString.read(buf),
            reason=_UniffiConverterString.read(buf),
            process_date=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.start_date)
        _UniffiConverterString.check_lower(value.end_date)
        _UniffiConverterString.check_lower(value.year)
        _UniffiConverterString.check_lower(value.term)
        _UniffiConverterString.check_lower(value.category)
        _UniffiConverterString.check_lower(value.reason)
        _UniffiConverterString.check_lower(value.process_date)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.start_date, buf)
        _UniffiConverterString.write(value.end_date, buf)
        _UniffiConverterString.write(value.year, buf)
        _UniffiConverterString.write(value.term, buf)
        _UniffiConverterString.write(value.category, buf)
        _UniffiConverterString.write(value.reason, buf)
        _UniffiConverterString.write(value.process_date, buf)


class StudentAcademicRecords:
    """
    학생의 학적상태 정보
    """

    records: "typing.List[StudentAcademicRecord]"
    def __init__(self, *, records: "typing.List[StudentAcademicRecord]"):
        self.records = records

    def __str__(self):
        return "StudentAcademicRecords(records={})".format(self.records)

    def __eq__(self, other):
        if self.records != other.records:
            return False
        return True

class _UniffiConverterTypeStudentAcademicRecords(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentAcademicRecords(
            records=_UniffiConverterSequenceTypeStudentAcademicRecord.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceTypeStudentAcademicRecord.check_lower(value.records)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceTypeStudentAcademicRecord.write(value.records, buf)


class StudentBankAccount:
    """
    학생의 은행 계좌 정보
    """

    bank: "typing.Optional[str]"
    account_number: "typing.Optional[str]"
    holder: "typing.Optional[str]"
    def __init__(self, *, bank: "typing.Optional[str]", account_number: "typing.Optional[str]", holder: "typing.Optional[str]"):
        self.bank = bank
        self.account_number = account_number
        self.holder = holder

    def __str__(self):
        return "StudentBankAccount(bank={}, account_number={}, holder={})".format(self.bank, self.account_number, self.holder)

    def __eq__(self, other):
        if self.bank != other.bank:
            return False
        if self.account_number != other.account_number:
            return False
        if self.holder != other.holder:
            return False
        return True

class _UniffiConverterTypeStudentBankAccount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentBankAccount(
            bank=_UniffiConverterOptionalString.read(buf),
            account_number=_UniffiConverterOptionalString.read(buf),
            holder=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.bank)
        _UniffiConverterOptionalString.check_lower(value.account_number)
        _UniffiConverterOptionalString.check_lower(value.holder)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.bank, buf)
        _UniffiConverterOptionalString.write(value.account_number, buf)
        _UniffiConverterOptionalString.write(value.holder, buf)


class StudentFamily:
    """
    학생의 가족관계 정보
    """

    members: "typing.List[StudentFamilyMember]"
    def __init__(self, *, members: "typing.List[StudentFamilyMember]"):
        self.members = members

    def __str__(self):
        return "StudentFamily(members={})".format(self.members)

    def __eq__(self, other):
        if self.members != other.members:
            return False
        return True

class _UniffiConverterTypeStudentFamily(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentFamily(
            members=_UniffiConverterSequenceTypeStudentFamilyMember.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceTypeStudentFamilyMember.check_lower(value.members)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceTypeStudentFamilyMember.write(value.members, buf)


class StudentFamilyMember:
    """
    학생의 가족 구성원
    """

    relation_type: "typing.Optional[str]"
    tel_number: "typing.Optional[str]"
    name: "typing.Optional[str]"
    mobile_number: "typing.Optional[str]"
    office: "typing.Optional[str]"
    job: "typing.Optional[str]"
    position: "typing.Optional[str]"
    is_guardian: "bool"
    is_cohabit: "bool"
    def __init__(self, *, relation_type: "typing.Optional[str]", tel_number: "typing.Optional[str]", name: "typing.Optional[str]", mobile_number: "typing.Optional[str]", office: "typing.Optional[str]", job: "typing.Optional[str]", position: "typing.Optional[str]", is_guardian: "bool", is_cohabit: "bool"):
        self.relation_type = relation_type
        self.tel_number = tel_number
        self.name = name
        self.mobile_number = mobile_number
        self.office = office
        self.job = job
        self.position = position
        self.is_guardian = is_guardian
        self.is_cohabit = is_cohabit

    def __str__(self):
        return "StudentFamilyMember(relation_type={}, tel_number={}, name={}, mobile_number={}, office={}, job={}, position={}, is_guardian={}, is_cohabit={})".format(self.relation_type, self.tel_number, self.name, self.mobile_number, self.office, self.job, self.position, self.is_guardian, self.is_cohabit)

    def __eq__(self, other):
        if self.relation_type != other.relation_type:
            return False
        if self.tel_number != other.tel_number:
            return False
        if self.name != other.name:
            return False
        if self.mobile_number != other.mobile_number:
            return False
        if self.office != other.office:
            return False
        if self.job != other.job:
            return False
        if self.position != other.position:
            return False
        if self.is_guardian != other.is_guardian:
            return False
        if self.is_cohabit != other.is_cohabit:
            return False
        return True

class _UniffiConverterTypeStudentFamilyMember(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentFamilyMember(
            relation_type=_UniffiConverterOptionalString.read(buf),
            tel_number=_UniffiConverterOptionalString.read(buf),
            name=_UniffiConverterOptionalString.read(buf),
            mobile_number=_UniffiConverterOptionalString.read(buf),
            office=_UniffiConverterOptionalString.read(buf),
            job=_UniffiConverterOptionalString.read(buf),
            position=_UniffiConverterOptionalString.read(buf),
            is_guardian=_UniffiConverterBool.read(buf),
            is_cohabit=_UniffiConverterBool.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.relation_type)
        _UniffiConverterOptionalString.check_lower(value.tel_number)
        _UniffiConverterOptionalString.check_lower(value.name)
        _UniffiConverterOptionalString.check_lower(value.mobile_number)
        _UniffiConverterOptionalString.check_lower(value.office)
        _UniffiConverterOptionalString.check_lower(value.job)
        _UniffiConverterOptionalString.check_lower(value.position)
        _UniffiConverterBool.check_lower(value.is_guardian)
        _UniffiConverterBool.check_lower(value.is_cohabit)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.relation_type, buf)
        _UniffiConverterOptionalString.write(value.tel_number, buf)
        _UniffiConverterOptionalString.write(value.name, buf)
        _UniffiConverterOptionalString.write(value.mobile_number, buf)
        _UniffiConverterOptionalString.write(value.office, buf)
        _UniffiConverterOptionalString.write(value.job, buf)
        _UniffiConverterOptionalString.write(value.position, buf)
        _UniffiConverterBool.write(value.is_guardian, buf)
        _UniffiConverterBool.write(value.is_cohabit, buf)


class StudentForignStudyInformation:
    """
    7+1 프로그램 정보를 반환합니다.
    """

    approval_date: "typing.Optional[str]"
    authentication_number: "typing.Optional[str]"
    issue_date: "typing.Optional[str]"
    def __init__(self, *, approval_date: "typing.Optional[str]", authentication_number: "typing.Optional[str]", issue_date: "typing.Optional[str]"):
        self.approval_date = approval_date
        self.authentication_number = authentication_number
        self.issue_date = issue_date

    def __str__(self):
        return "StudentForignStudyInformation(approval_date={}, authentication_number={}, issue_date={})".format(self.approval_date, self.authentication_number, self.issue_date)

    def __eq__(self, other):
        if self.approval_date != other.approval_date:
            return False
        if self.authentication_number != other.authentication_number:
            return False
        if self.issue_date != other.issue_date:
            return False
        return True

class _UniffiConverterTypeStudentForignStudyInformation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentForignStudyInformation(
            approval_date=_UniffiConverterOptionalString.read(buf),
            authentication_number=_UniffiConverterOptionalString.read(buf),
            issue_date=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.approval_date)
        _UniffiConverterOptionalString.check_lower(value.authentication_number)
        _UniffiConverterOptionalString.check_lower(value.issue_date)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.approval_date, buf)
        _UniffiConverterOptionalString.write(value.authentication_number, buf)
        _UniffiConverterOptionalString.write(value.issue_date, buf)


class StudentGraduation:
    """
    학생의 졸업 정보를 반환합니다. 졸업하지 않았다면 반환되지 않습니다.
    """

    graduation_cardinal: "int"
    graduation_certification_number: "int"
    graduation_year: "int"
    graduation_terms: "int"
    graduation_date: "str"
    academic_degree_number: "int"
    academic_degree_name: "str"
    early_graduation: "bool"
    graduation_rank: "int"
    graduation_personnel_number: "int"
    def __init__(self, *, graduation_cardinal: "int", graduation_certification_number: "int", graduation_year: "int", graduation_terms: "int", graduation_date: "str", academic_degree_number: "int", academic_degree_name: "str", early_graduation: "bool", graduation_rank: "int", graduation_personnel_number: "int"):
        self.graduation_cardinal = graduation_cardinal
        self.graduation_certification_number = graduation_certification_number
        self.graduation_year = graduation_year
        self.graduation_terms = graduation_terms
        self.graduation_date = graduation_date
        self.academic_degree_number = academic_degree_number
        self.academic_degree_name = academic_degree_name
        self.early_graduation = early_graduation
        self.graduation_rank = graduation_rank
        self.graduation_personnel_number = graduation_personnel_number

    def __str__(self):
        return "StudentGraduation(graduation_cardinal={}, graduation_certification_number={}, graduation_year={}, graduation_terms={}, graduation_date={}, academic_degree_number={}, academic_degree_name={}, early_graduation={}, graduation_rank={}, graduation_personnel_number={})".format(self.graduation_cardinal, self.graduation_certification_number, self.graduation_year, self.graduation_terms, self.graduation_date, self.academic_degree_number, self.academic_degree_name, self.early_graduation, self.graduation_rank, self.graduation_personnel_number)

    def __eq__(self, other):
        if self.graduation_cardinal != other.graduation_cardinal:
            return False
        if self.graduation_certification_number != other.graduation_certification_number:
            return False
        if self.graduation_year != other.graduation_year:
            return False
        if self.graduation_terms != other.graduation_terms:
            return False
        if self.graduation_date != other.graduation_date:
            return False
        if self.academic_degree_number != other.academic_degree_number:
            return False
        if self.academic_degree_name != other.academic_degree_name:
            return False
        if self.early_graduation != other.early_graduation:
            return False
        if self.graduation_rank != other.graduation_rank:
            return False
        if self.graduation_personnel_number != other.graduation_personnel_number:
            return False
        return True

class _UniffiConverterTypeStudentGraduation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentGraduation(
            graduation_cardinal=_UniffiConverterUInt32.read(buf),
            graduation_certification_number=_UniffiConverterUInt32.read(buf),
            graduation_year=_UniffiConverterUInt32.read(buf),
            graduation_terms=_UniffiConverterUInt32.read(buf),
            graduation_date=_UniffiConverterString.read(buf),
            academic_degree_number=_UniffiConverterUInt32.read(buf),
            academic_degree_name=_UniffiConverterString.read(buf),
            early_graduation=_UniffiConverterBool.read(buf),
            graduation_rank=_UniffiConverterUInt32.read(buf),
            graduation_personnel_number=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.graduation_cardinal)
        _UniffiConverterUInt32.check_lower(value.graduation_certification_number)
        _UniffiConverterUInt32.check_lower(value.graduation_year)
        _UniffiConverterUInt32.check_lower(value.graduation_terms)
        _UniffiConverterString.check_lower(value.graduation_date)
        _UniffiConverterUInt32.check_lower(value.academic_degree_number)
        _UniffiConverterString.check_lower(value.academic_degree_name)
        _UniffiConverterBool.check_lower(value.early_graduation)
        _UniffiConverterUInt32.check_lower(value.graduation_rank)
        _UniffiConverterUInt32.check_lower(value.graduation_personnel_number)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.graduation_cardinal, buf)
        _UniffiConverterUInt32.write(value.graduation_certification_number, buf)
        _UniffiConverterUInt32.write(value.graduation_year, buf)
        _UniffiConverterUInt32.write(value.graduation_terms, buf)
        _UniffiConverterString.write(value.graduation_date, buf)
        _UniffiConverterUInt32.write(value.academic_degree_number, buf)
        _UniffiConverterString.write(value.academic_degree_name, buf)
        _UniffiConverterBool.write(value.early_graduation, buf)
        _UniffiConverterUInt32.write(value.graduation_rank, buf)
        _UniffiConverterUInt32.write(value.graduation_personnel_number, buf)


class StudentInformation:
    """
    기본 학생 정보
    """

    apply_year: "int"
    student_number: "int"
    name: "str"
    rrn: "int"
    collage: "str"
    department: "str"
    major: "typing.Optional[str]"
    division: "typing.Optional[str]"
    grade: "int"
    term: "int"
    image: "bytes"
    alias: "typing.Optional[str]"
    kanji_name: "typing.Optional[str]"
    email: "typing.Optional[str]"
    tel_number: "typing.Optional[str]"
    mobile_number: "typing.Optional[str]"
    post_code: "typing.Optional[str]"
    address: "typing.Optional[str]"
    specific_address: "typing.Optional[str]"
    is_transfer_student: "bool"
    apply_date: "str"
    applied_collage: "str"
    applied_department: "str"
    plural_major: "typing.Optional[str]"
    sub_major: "typing.Optional[str]"
    connected_major: "typing.Optional[str]"
    abeek: "typing.Optional[str]"
    def __init__(self, *, apply_year: "int", student_number: "int", name: "str", rrn: "int", collage: "str", department: "str", major: "typing.Optional[str]", division: "typing.Optional[str]", grade: "int", term: "int", image: "bytes", alias: "typing.Optional[str]", kanji_name: "typing.Optional[str]", email: "typing.Optional[str]", tel_number: "typing.Optional[str]", mobile_number: "typing.Optional[str]", post_code: "typing.Optional[str]", address: "typing.Optional[str]", specific_address: "typing.Optional[str]", is_transfer_student: "bool", apply_date: "str", applied_collage: "str", applied_department: "str", plural_major: "typing.Optional[str]", sub_major: "typing.Optional[str]", connected_major: "typing.Optional[str]", abeek: "typing.Optional[str]"):
        self.apply_year = apply_year
        self.student_number = student_number
        self.name = name
        self.rrn = rrn
        self.collage = collage
        self.department = department
        self.major = major
        self.division = division
        self.grade = grade
        self.term = term
        self.image = image
        self.alias = alias
        self.kanji_name = kanji_name
        self.email = email
        self.tel_number = tel_number
        self.mobile_number = mobile_number
        self.post_code = post_code
        self.address = address
        self.specific_address = specific_address
        self.is_transfer_student = is_transfer_student
        self.apply_date = apply_date
        self.applied_collage = applied_collage
        self.applied_department = applied_department
        self.plural_major = plural_major
        self.sub_major = sub_major
        self.connected_major = connected_major
        self.abeek = abeek

    def __str__(self):
        return "StudentInformation(apply_year={}, student_number={}, name={}, rrn={}, collage={}, department={}, major={}, division={}, grade={}, term={}, image={}, alias={}, kanji_name={}, email={}, tel_number={}, mobile_number={}, post_code={}, address={}, specific_address={}, is_transfer_student={}, apply_date={}, applied_collage={}, applied_department={}, plural_major={}, sub_major={}, connected_major={}, abeek={})".format(self.apply_year, self.student_number, self.name, self.rrn, self.collage, self.department, self.major, self.division, self.grade, self.term, self.image, self.alias, self.kanji_name, self.email, self.tel_number, self.mobile_number, self.post_code, self.address, self.specific_address, self.is_transfer_student, self.apply_date, self.applied_collage, self.applied_department, self.plural_major, self.sub_major, self.connected_major, self.abeek)

    def __eq__(self, other):
        if self.apply_year != other.apply_year:
            return False
        if self.student_number != other.student_number:
            return False
        if self.name != other.name:
            return False
        if self.rrn != other.rrn:
            return False
        if self.collage != other.collage:
            return False
        if self.department != other.department:
            return False
        if self.major != other.major:
            return False
        if self.division != other.division:
            return False
        if self.grade != other.grade:
            return False
        if self.term != other.term:
            return False
        if self.image != other.image:
            return False
        if self.alias != other.alias:
            return False
        if self.kanji_name != other.kanji_name:
            return False
        if self.email != other.email:
            return False
        if self.tel_number != other.tel_number:
            return False
        if self.mobile_number != other.mobile_number:
            return False
        if self.post_code != other.post_code:
            return False
        if self.address != other.address:
            return False
        if self.specific_address != other.specific_address:
            return False
        if self.is_transfer_student != other.is_transfer_student:
            return False
        if self.apply_date != other.apply_date:
            return False
        if self.applied_collage != other.applied_collage:
            return False
        if self.applied_department != other.applied_department:
            return False
        if self.plural_major != other.plural_major:
            return False
        if self.sub_major != other.sub_major:
            return False
        if self.connected_major != other.connected_major:
            return False
        if self.abeek != other.abeek:
            return False
        return True

class _UniffiConverterTypeStudentInformation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentInformation(
            apply_year=_UniffiConverterUInt32.read(buf),
            student_number=_UniffiConverterUInt32.read(buf),
            name=_UniffiConverterString.read(buf),
            rrn=_UniffiConverterUInt32.read(buf),
            collage=_UniffiConverterString.read(buf),
            department=_UniffiConverterString.read(buf),
            major=_UniffiConverterOptionalString.read(buf),
            division=_UniffiConverterOptionalString.read(buf),
            grade=_UniffiConverterUInt32.read(buf),
            term=_UniffiConverterUInt32.read(buf),
            image=_UniffiConverterBytes.read(buf),
            alias=_UniffiConverterOptionalString.read(buf),
            kanji_name=_UniffiConverterOptionalString.read(buf),
            email=_UniffiConverterOptionalString.read(buf),
            tel_number=_UniffiConverterOptionalString.read(buf),
            mobile_number=_UniffiConverterOptionalString.read(buf),
            post_code=_UniffiConverterOptionalString.read(buf),
            address=_UniffiConverterOptionalString.read(buf),
            specific_address=_UniffiConverterOptionalString.read(buf),
            is_transfer_student=_UniffiConverterBool.read(buf),
            apply_date=_UniffiConverterString.read(buf),
            applied_collage=_UniffiConverterString.read(buf),
            applied_department=_UniffiConverterString.read(buf),
            plural_major=_UniffiConverterOptionalString.read(buf),
            sub_major=_UniffiConverterOptionalString.read(buf),
            connected_major=_UniffiConverterOptionalString.read(buf),
            abeek=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.apply_year)
        _UniffiConverterUInt32.check_lower(value.student_number)
        _UniffiConverterString.check_lower(value.name)
        _UniffiConverterUInt32.check_lower(value.rrn)
        _UniffiConverterString.check_lower(value.collage)
        _UniffiConverterString.check_lower(value.department)
        _UniffiConverterOptionalString.check_lower(value.major)
        _UniffiConverterOptionalString.check_lower(value.division)
        _UniffiConverterUInt32.check_lower(value.grade)
        _UniffiConverterUInt32.check_lower(value.term)
        _UniffiConverterBytes.check_lower(value.image)
        _UniffiConverterOptionalString.check_lower(value.alias)
        _UniffiConverterOptionalString.check_lower(value.kanji_name)
        _UniffiConverterOptionalString.check_lower(value.email)
        _UniffiConverterOptionalString.check_lower(value.tel_number)
        _UniffiConverterOptionalString.check_lower(value.mobile_number)
        _UniffiConverterOptionalString.check_lower(value.post_code)
        _UniffiConverterOptionalString.check_lower(value.address)
        _UniffiConverterOptionalString.check_lower(value.specific_address)
        _UniffiConverterBool.check_lower(value.is_transfer_student)
        _UniffiConverterString.check_lower(value.apply_date)
        _UniffiConverterString.check_lower(value.applied_collage)
        _UniffiConverterString.check_lower(value.applied_department)
        _UniffiConverterOptionalString.check_lower(value.plural_major)
        _UniffiConverterOptionalString.check_lower(value.sub_major)
        _UniffiConverterOptionalString.check_lower(value.connected_major)
        _UniffiConverterOptionalString.check_lower(value.abeek)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.apply_year, buf)
        _UniffiConverterUInt32.write(value.student_number, buf)
        _UniffiConverterString.write(value.name, buf)
        _UniffiConverterUInt32.write(value.rrn, buf)
        _UniffiConverterString.write(value.collage, buf)
        _UniffiConverterString.write(value.department, buf)
        _UniffiConverterOptionalString.write(value.major, buf)
        _UniffiConverterOptionalString.write(value.division, buf)
        _UniffiConverterUInt32.write(value.grade, buf)
        _UniffiConverterUInt32.write(value.term, buf)
        _UniffiConverterBytes.write(value.image, buf)
        _UniffiConverterOptionalString.write(value.alias, buf)
        _UniffiConverterOptionalString.write(value.kanji_name, buf)
        _UniffiConverterOptionalString.write(value.email, buf)
        _UniffiConverterOptionalString.write(value.tel_number, buf)
        _UniffiConverterOptionalString.write(value.mobile_number, buf)
        _UniffiConverterOptionalString.write(value.post_code, buf)
        _UniffiConverterOptionalString.write(value.address, buf)
        _UniffiConverterOptionalString.write(value.specific_address, buf)
        _UniffiConverterBool.write(value.is_transfer_student, buf)
        _UniffiConverterString.write(value.apply_date, buf)
        _UniffiConverterString.write(value.applied_collage, buf)
        _UniffiConverterString.write(value.applied_department, buf)
        _UniffiConverterOptionalString.write(value.plural_major, buf)
        _UniffiConverterOptionalString.write(value.sub_major, buf)
        _UniffiConverterOptionalString.write(value.connected_major, buf)
        _UniffiConverterOptionalString.write(value.abeek, buf)


class StudentLifelongInformation:
    """
    평생교육사 정보
    """

    apply_date: "typing.Optional[str]"
    lifelong_type: "typing.Optional[str]"
    qualification_number: "typing.Optional[str]"
    qualification_date: "typing.Optional[str]"
    def __init__(self, *, apply_date: "typing.Optional[str]", lifelong_type: "typing.Optional[str]", qualification_number: "typing.Optional[str]", qualification_date: "typing.Optional[str]"):
        self.apply_date = apply_date
        self.lifelong_type = lifelong_type
        self.qualification_number = qualification_number
        self.qualification_date = qualification_date

    def __str__(self):
        return "StudentLifelongInformation(apply_date={}, lifelong_type={}, qualification_number={}, qualification_date={})".format(self.apply_date, self.lifelong_type, self.qualification_number, self.qualification_date)

    def __eq__(self, other):
        if self.apply_date != other.apply_date:
            return False
        if self.lifelong_type != other.lifelong_type:
            return False
        if self.qualification_number != other.qualification_number:
            return False
        if self.qualification_date != other.qualification_date:
            return False
        return True

class _UniffiConverterTypeStudentLifelongInformation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentLifelongInformation(
            apply_date=_UniffiConverterOptionalString.read(buf),
            lifelong_type=_UniffiConverterOptionalString.read(buf),
            qualification_number=_UniffiConverterOptionalString.read(buf),
            qualification_date=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.apply_date)
        _UniffiConverterOptionalString.check_lower(value.lifelong_type)
        _UniffiConverterOptionalString.check_lower(value.qualification_number)
        _UniffiConverterOptionalString.check_lower(value.qualification_date)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.apply_date, buf)
        _UniffiConverterOptionalString.write(value.lifelong_type, buf)
        _UniffiConverterOptionalString.write(value.qualification_number, buf)
        _UniffiConverterOptionalString.write(value.qualification_date, buf)


class StudentQualification:
    """
    학생의 자격(교직이수, 평생교육사, 7+1 프로그램) 정보
    """

    teaching_major: "typing.Optional[StudentTeachingMajorInformation]"
    teaching_plural_major: "typing.Optional[StudentTeachingPluralMajorInformation]"
    lifelong: "typing.Optional[StudentLifelongInformation]"
    forign_study: "typing.Optional[StudentForignStudyInformation]"
    def __init__(self, *, teaching_major: "typing.Optional[StudentTeachingMajorInformation]", teaching_plural_major: "typing.Optional[StudentTeachingPluralMajorInformation]", lifelong: "typing.Optional[StudentLifelongInformation]", forign_study: "typing.Optional[StudentForignStudyInformation]"):
        self.teaching_major = teaching_major
        self.teaching_plural_major = teaching_plural_major
        self.lifelong = lifelong
        self.forign_study = forign_study

    def __str__(self):
        return "StudentQualification(teaching_major={}, teaching_plural_major={}, lifelong={}, forign_study={})".format(self.teaching_major, self.teaching_plural_major, self.lifelong, self.forign_study)

    def __eq__(self, other):
        if self.teaching_major != other.teaching_major:
            return False
        if self.teaching_plural_major != other.teaching_plural_major:
            return False
        if self.lifelong != other.lifelong:
            return False
        if self.forign_study != other.forign_study:
            return False
        return True

class _UniffiConverterTypeStudentQualification(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentQualification(
            teaching_major=_UniffiConverterOptionalTypeStudentTeachingMajorInformation.read(buf),
            teaching_plural_major=_UniffiConverterOptionalTypeStudentTeachingPluralMajorInformation.read(buf),
            lifelong=_UniffiConverterOptionalTypeStudentLifelongInformation.read(buf),
            forign_study=_UniffiConverterOptionalTypeStudentForignStudyInformation.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalTypeStudentTeachingMajorInformation.check_lower(value.teaching_major)
        _UniffiConverterOptionalTypeStudentTeachingPluralMajorInformation.check_lower(value.teaching_plural_major)
        _UniffiConverterOptionalTypeStudentLifelongInformation.check_lower(value.lifelong)
        _UniffiConverterOptionalTypeStudentForignStudyInformation.check_lower(value.forign_study)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalTypeStudentTeachingMajorInformation.write(value.teaching_major, buf)
        _UniffiConverterOptionalTypeStudentTeachingPluralMajorInformation.write(value.teaching_plural_major, buf)
        _UniffiConverterOptionalTypeStudentLifelongInformation.write(value.lifelong, buf)
        _UniffiConverterOptionalTypeStudentForignStudyInformation.write(value.forign_study, buf)


class StudentReligion:
    """
    학생의 종교 정보
    """

    religion_type: "typing.Optional[str]"
    start_date: "typing.Optional[str]"
    church: "typing.Optional[str]"
    church_man: "typing.Optional[str]"
    baptism_level: "typing.Optional[str]"
    baptism_grp: "typing.Optional[str]"
    service_department: "typing.Optional[str]"
    service_department_title: "typing.Optional[str]"
    church_address: "typing.Optional[str]"
    singeub: "typing.Optional[str]"
    baptism_date: "typing.Optional[str]"
    baptism_church: "typing.Optional[str]"
    baptism_man: "typing.Optional[str]"
    church_grp: "typing.Optional[str]"
    def __init__(self, *, religion_type: "typing.Optional[str]", start_date: "typing.Optional[str]", church: "typing.Optional[str]", church_man: "typing.Optional[str]", baptism_level: "typing.Optional[str]", baptism_grp: "typing.Optional[str]", service_department: "typing.Optional[str]", service_department_title: "typing.Optional[str]", church_address: "typing.Optional[str]", singeub: "typing.Optional[str]", baptism_date: "typing.Optional[str]", baptism_church: "typing.Optional[str]", baptism_man: "typing.Optional[str]", church_grp: "typing.Optional[str]"):
        self.religion_type = religion_type
        self.start_date = start_date
        self.church = church
        self.church_man = church_man
        self.baptism_level = baptism_level
        self.baptism_grp = baptism_grp
        self.service_department = service_department
        self.service_department_title = service_department_title
        self.church_address = church_address
        self.singeub = singeub
        self.baptism_date = baptism_date
        self.baptism_church = baptism_church
        self.baptism_man = baptism_man
        self.church_grp = church_grp

    def __str__(self):
        return "StudentReligion(religion_type={}, start_date={}, church={}, church_man={}, baptism_level={}, baptism_grp={}, service_department={}, service_department_title={}, church_address={}, singeub={}, baptism_date={}, baptism_church={}, baptism_man={}, church_grp={})".format(self.religion_type, self.start_date, self.church, self.church_man, self.baptism_level, self.baptism_grp, self.service_department, self.service_department_title, self.church_address, self.singeub, self.baptism_date, self.baptism_church, self.baptism_man, self.church_grp)

    def __eq__(self, other):
        if self.religion_type != other.religion_type:
            return False
        if self.start_date != other.start_date:
            return False
        if self.church != other.church:
            return False
        if self.church_man != other.church_man:
            return False
        if self.baptism_level != other.baptism_level:
            return False
        if self.baptism_grp != other.baptism_grp:
            return False
        if self.service_department != other.service_department:
            return False
        if self.service_department_title != other.service_department_title:
            return False
        if self.church_address != other.church_address:
            return False
        if self.singeub != other.singeub:
            return False
        if self.baptism_date != other.baptism_date:
            return False
        if self.baptism_church != other.baptism_church:
            return False
        if self.baptism_man != other.baptism_man:
            return False
        if self.church_grp != other.church_grp:
            return False
        return True

class _UniffiConverterTypeStudentReligion(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentReligion(
            religion_type=_UniffiConverterOptionalString.read(buf),
            start_date=_UniffiConverterOptionalString.read(buf),
            church=_UniffiConverterOptionalString.read(buf),
            church_man=_UniffiConverterOptionalString.read(buf),
            baptism_level=_UniffiConverterOptionalString.read(buf),
            baptism_grp=_UniffiConverterOptionalString.read(buf),
            service_department=_UniffiConverterOptionalString.read(buf),
            service_department_title=_UniffiConverterOptionalString.read(buf),
            church_address=_UniffiConverterOptionalString.read(buf),
            singeub=_UniffiConverterOptionalString.read(buf),
            baptism_date=_UniffiConverterOptionalString.read(buf),
            baptism_church=_UniffiConverterOptionalString.read(buf),
            baptism_man=_UniffiConverterOptionalString.read(buf),
            church_grp=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.religion_type)
        _UniffiConverterOptionalString.check_lower(value.start_date)
        _UniffiConverterOptionalString.check_lower(value.church)
        _UniffiConverterOptionalString.check_lower(value.church_man)
        _UniffiConverterOptionalString.check_lower(value.baptism_level)
        _UniffiConverterOptionalString.check_lower(value.baptism_grp)
        _UniffiConverterOptionalString.check_lower(value.service_department)
        _UniffiConverterOptionalString.check_lower(value.service_department_title)
        _UniffiConverterOptionalString.check_lower(value.church_address)
        _UniffiConverterOptionalString.check_lower(value.singeub)
        _UniffiConverterOptionalString.check_lower(value.baptism_date)
        _UniffiConverterOptionalString.check_lower(value.baptism_church)
        _UniffiConverterOptionalString.check_lower(value.baptism_man)
        _UniffiConverterOptionalString.check_lower(value.church_grp)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.religion_type, buf)
        _UniffiConverterOptionalString.write(value.start_date, buf)
        _UniffiConverterOptionalString.write(value.church, buf)
        _UniffiConverterOptionalString.write(value.church_man, buf)
        _UniffiConverterOptionalString.write(value.baptism_level, buf)
        _UniffiConverterOptionalString.write(value.baptism_grp, buf)
        _UniffiConverterOptionalString.write(value.service_department, buf)
        _UniffiConverterOptionalString.write(value.service_department_title, buf)
        _UniffiConverterOptionalString.write(value.church_address, buf)
        _UniffiConverterOptionalString.write(value.singeub, buf)
        _UniffiConverterOptionalString.write(value.baptism_date, buf)
        _UniffiConverterOptionalString.write(value.baptism_church, buf)
        _UniffiConverterOptionalString.write(value.baptism_man, buf)
        _UniffiConverterOptionalString.write(value.church_grp, buf)


class StudentResearchBankAccount:
    """
    연구비 입금 계좌 정보
    """

    bank: "typing.Optional[str]"
    account_number: "typing.Optional[str]"
    holder: "typing.Optional[str]"
    def __init__(self, *, bank: "typing.Optional[str]", account_number: "typing.Optional[str]", holder: "typing.Optional[str]"):
        self.bank = bank
        self.account_number = account_number
        self.holder = holder

    def __str__(self):
        return "StudentResearchBankAccount(bank={}, account_number={}, holder={})".format(self.bank, self.account_number, self.holder)

    def __eq__(self, other):
        if self.bank != other.bank:
            return False
        if self.account_number != other.account_number:
            return False
        if self.holder != other.holder:
            return False
        return True

class _UniffiConverterTypeStudentResearchBankAccount(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentResearchBankAccount(
            bank=_UniffiConverterOptionalString.read(buf),
            account_number=_UniffiConverterOptionalString.read(buf),
            holder=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.bank)
        _UniffiConverterOptionalString.check_lower(value.account_number)
        _UniffiConverterOptionalString.check_lower(value.holder)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.bank, buf)
        _UniffiConverterOptionalString.write(value.account_number, buf)
        _UniffiConverterOptionalString.write(value.holder, buf)


class StudentTeachingMajorInformation:
    """
    교직이수(주전공) 정보
    """

    major_name: "typing.Optional[str]"
    qualification_number: "typing.Optional[str]"
    initiation_date: "typing.Optional[str]"
    qualification_date: "typing.Optional[str]"
    def __init__(self, *, major_name: "typing.Optional[str]", qualification_number: "typing.Optional[str]", initiation_date: "typing.Optional[str]", qualification_date: "typing.Optional[str]"):
        self.major_name = major_name
        self.qualification_number = qualification_number
        self.initiation_date = initiation_date
        self.qualification_date = qualification_date

    def __str__(self):
        return "StudentTeachingMajorInformation(major_name={}, qualification_number={}, initiation_date={}, qualification_date={})".format(self.major_name, self.qualification_number, self.initiation_date, self.qualification_date)

    def __eq__(self, other):
        if self.major_name != other.major_name:
            return False
        if self.qualification_number != other.qualification_number:
            return False
        if self.initiation_date != other.initiation_date:
            return False
        if self.qualification_date != other.qualification_date:
            return False
        return True

class _UniffiConverterTypeStudentTeachingMajorInformation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentTeachingMajorInformation(
            major_name=_UniffiConverterOptionalString.read(buf),
            qualification_number=_UniffiConverterOptionalString.read(buf),
            initiation_date=_UniffiConverterOptionalString.read(buf),
            qualification_date=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.major_name)
        _UniffiConverterOptionalString.check_lower(value.qualification_number)
        _UniffiConverterOptionalString.check_lower(value.initiation_date)
        _UniffiConverterOptionalString.check_lower(value.qualification_date)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.major_name, buf)
        _UniffiConverterOptionalString.write(value.qualification_number, buf)
        _UniffiConverterOptionalString.write(value.initiation_date, buf)
        _UniffiConverterOptionalString.write(value.qualification_date, buf)


class StudentTeachingPluralMajorInformation:
    """
    교직이수(복수전공) 정보
    """

    major_name: "typing.Optional[str]"
    qualification_number: "typing.Optional[str]"
    qualification_date: "typing.Optional[str]"
    def __init__(self, *, major_name: "typing.Optional[str]", qualification_number: "typing.Optional[str]", qualification_date: "typing.Optional[str]"):
        self.major_name = major_name
        self.qualification_number = qualification_number
        self.qualification_date = qualification_date

    def __str__(self):
        return "StudentTeachingPluralMajorInformation(major_name={}, qualification_number={}, qualification_date={})".format(self.major_name, self.qualification_number, self.qualification_date)

    def __eq__(self, other):
        if self.major_name != other.major_name:
            return False
        if self.qualification_number != other.qualification_number:
            return False
        if self.qualification_date != other.qualification_date:
            return False
        return True

class _UniffiConverterTypeStudentTeachingPluralMajorInformation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentTeachingPluralMajorInformation(
            major_name=_UniffiConverterOptionalString.read(buf),
            qualification_number=_UniffiConverterOptionalString.read(buf),
            qualification_date=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.major_name)
        _UniffiConverterOptionalString.check_lower(value.qualification_number)
        _UniffiConverterOptionalString.check_lower(value.qualification_date)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.major_name, buf)
        _UniffiConverterOptionalString.write(value.qualification_number, buf)
        _UniffiConverterOptionalString.write(value.qualification_date, buf)


class StudentTransferRecord:
    """
    편입정보 내 기록
    """

    is_transfer: "str"
    admission_date: "str"
    admission_grade: "str"
    admission_term: "str"
    accepted_credit: "str"
    accepted_terms: "str"
    def __init__(self, *, is_transfer: "str", admission_date: "str", admission_grade: "str", admission_term: "str", accepted_credit: "str", accepted_terms: "str"):
        self.is_transfer = is_transfer
        self.admission_date = admission_date
        self.admission_grade = admission_grade
        self.admission_term = admission_term
        self.accepted_credit = accepted_credit
        self.accepted_terms = accepted_terms

    def __str__(self):
        return "StudentTransferRecord(is_transfer={}, admission_date={}, admission_grade={}, admission_term={}, accepted_credit={}, accepted_terms={})".format(self.is_transfer, self.admission_date, self.admission_grade, self.admission_term, self.accepted_credit, self.accepted_terms)

    def __eq__(self, other):
        if self.is_transfer != other.is_transfer:
            return False
        if self.admission_date != other.admission_date:
            return False
        if self.admission_grade != other.admission_grade:
            return False
        if self.admission_term != other.admission_term:
            return False
        if self.accepted_credit != other.accepted_credit:
            return False
        if self.accepted_terms != other.accepted_terms:
            return False
        return True

class _UniffiConverterTypeStudentTransferRecord(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentTransferRecord(
            is_transfer=_UniffiConverterString.read(buf),
            admission_date=_UniffiConverterString.read(buf),
            admission_grade=_UniffiConverterString.read(buf),
            admission_term=_UniffiConverterString.read(buf),
            accepted_credit=_UniffiConverterString.read(buf),
            accepted_terms=_UniffiConverterString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterString.check_lower(value.is_transfer)
        _UniffiConverterString.check_lower(value.admission_date)
        _UniffiConverterString.check_lower(value.admission_grade)
        _UniffiConverterString.check_lower(value.admission_term)
        _UniffiConverterString.check_lower(value.accepted_credit)
        _UniffiConverterString.check_lower(value.accepted_terms)

    @staticmethod
    def write(value, buf):
        _UniffiConverterString.write(value.is_transfer, buf)
        _UniffiConverterString.write(value.admission_date, buf)
        _UniffiConverterString.write(value.admission_grade, buf)
        _UniffiConverterString.write(value.admission_term, buf)
        _UniffiConverterString.write(value.accepted_credit, buf)
        _UniffiConverterString.write(value.accepted_terms, buf)


class StudentTransferRecords:
    """
    학생 편입 정보
    """

    records: "typing.List[StudentTransferRecord]"
    def __init__(self, *, records: "typing.List[StudentTransferRecord]"):
        self.records = records

    def __str__(self):
        return "StudentTransferRecords(records={})".format(self.records)

    def __eq__(self, other):
        if self.records != other.records:
            return False
        return True

class _UniffiConverterTypeStudentTransferRecords(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentTransferRecords(
            records=_UniffiConverterSequenceTypeStudentTransferRecord.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterSequenceTypeStudentTransferRecord.check_lower(value.records)

    @staticmethod
    def write(value, buf):
        _UniffiConverterSequenceTypeStudentTransferRecord.write(value.records, buf)


class StudentWorkInformation:
    """
    학생의 직업 정보
    """

    job: "typing.Optional[str]"
    public_official: "typing.Optional[str]"
    company_name: "typing.Optional[str]"
    department_name: "typing.Optional[str]"
    title: "typing.Optional[str]"
    zip_code: "typing.Optional[str]"
    address: "typing.Optional[str]"
    specific_address: "typing.Optional[str]"
    tel_number: "typing.Optional[str]"
    fax_number: "typing.Optional[str]"
    def __init__(self, *, job: "typing.Optional[str]", public_official: "typing.Optional[str]", company_name: "typing.Optional[str]", department_name: "typing.Optional[str]", title: "typing.Optional[str]", zip_code: "typing.Optional[str]", address: "typing.Optional[str]", specific_address: "typing.Optional[str]", tel_number: "typing.Optional[str]", fax_number: "typing.Optional[str]"):
        self.job = job
        self.public_official = public_official
        self.company_name = company_name
        self.department_name = department_name
        self.title = title
        self.zip_code = zip_code
        self.address = address
        self.specific_address = specific_address
        self.tel_number = tel_number
        self.fax_number = fax_number

    def __str__(self):
        return "StudentWorkInformation(job={}, public_official={}, company_name={}, department_name={}, title={}, zip_code={}, address={}, specific_address={}, tel_number={}, fax_number={})".format(self.job, self.public_official, self.company_name, self.department_name, self.title, self.zip_code, self.address, self.specific_address, self.tel_number, self.fax_number)

    def __eq__(self, other):
        if self.job != other.job:
            return False
        if self.public_official != other.public_official:
            return False
        if self.company_name != other.company_name:
            return False
        if self.department_name != other.department_name:
            return False
        if self.title != other.title:
            return False
        if self.zip_code != other.zip_code:
            return False
        if self.address != other.address:
            return False
        if self.specific_address != other.specific_address:
            return False
        if self.tel_number != other.tel_number:
            return False
        if self.fax_number != other.fax_number:
            return False
        return True

class _UniffiConverterTypeStudentWorkInformation(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return StudentWorkInformation(
            job=_UniffiConverterOptionalString.read(buf),
            public_official=_UniffiConverterOptionalString.read(buf),
            company_name=_UniffiConverterOptionalString.read(buf),
            department_name=_UniffiConverterOptionalString.read(buf),
            title=_UniffiConverterOptionalString.read(buf),
            zip_code=_UniffiConverterOptionalString.read(buf),
            address=_UniffiConverterOptionalString.read(buf),
            specific_address=_UniffiConverterOptionalString.read(buf),
            tel_number=_UniffiConverterOptionalString.read(buf),
            fax_number=_UniffiConverterOptionalString.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterOptionalString.check_lower(value.job)
        _UniffiConverterOptionalString.check_lower(value.public_official)
        _UniffiConverterOptionalString.check_lower(value.company_name)
        _UniffiConverterOptionalString.check_lower(value.department_name)
        _UniffiConverterOptionalString.check_lower(value.title)
        _UniffiConverterOptionalString.check_lower(value.zip_code)
        _UniffiConverterOptionalString.check_lower(value.address)
        _UniffiConverterOptionalString.check_lower(value.specific_address)
        _UniffiConverterOptionalString.check_lower(value.tel_number)
        _UniffiConverterOptionalString.check_lower(value.fax_number)

    @staticmethod
    def write(value, buf):
        _UniffiConverterOptionalString.write(value.job, buf)
        _UniffiConverterOptionalString.write(value.public_official, buf)
        _UniffiConverterOptionalString.write(value.company_name, buf)
        _UniffiConverterOptionalString.write(value.department_name, buf)
        _UniffiConverterOptionalString.write(value.title, buf)
        _UniffiConverterOptionalString.write(value.zip_code, buf)
        _UniffiConverterOptionalString.write(value.address, buf)
        _UniffiConverterOptionalString.write(value.specific_address, buf)
        _UniffiConverterOptionalString.write(value.tel_number, buf)
        _UniffiConverterOptionalString.write(value.fax_number, buf)


class UnsignedIntPair:
    """
    uniffi 지원을 위한 u32 Pair입니다.
    """

    first: "int"
    second: "int"
    def __init__(self, *, first: "int", second: "int"):
        self.first = first
        self.second = second

    def __str__(self):
        return "UnsignedIntPair(first={}, second={})".format(self.first, self.second)

    def __eq__(self, other):
        if self.first != other.first:
            return False
        if self.second != other.second:
            return False
        return True

class _UniffiConverterTypeUnsignedIntPair(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        return UnsignedIntPair(
            first=_UniffiConverterUInt32.read(buf),
            second=_UniffiConverterUInt32.read(buf),
        )

    @staticmethod
    def check_lower(value):
        _UniffiConverterUInt32.check_lower(value.first)
        _UniffiConverterUInt32.check_lower(value.second)

    @staticmethod
    def write(value, buf):
        _UniffiConverterUInt32.write(value.first, buf)
        _UniffiConverterUInt32.write(value.second, buf)





class ClassScore:
    """
    과목 점수
    """

    def __init__(self):
        raise RuntimeError("ClassScore cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class PASS:
        """
        P/F 과목의 Pass
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "ClassScore.PASS()".format()

        def __eq__(self, other):
            if not other.is_PASS():
                return False
            return True
    
    class FAILED:
        """
        P/F 과목의 Failed
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "ClassScore.FAILED()".format()

        def __eq__(self, other):
            if not other.is_FAILED():
                return False
            return True
    
    class SCORE:
        """
        일반 과목의 점수
        """

        def __init__(self, *values):
            if len(values) != 1:
                raise TypeError(f"Expected 1 arguments, found {len(values)}")
            self._values = values

        def __getitem__(self, index):
            return self._values[index]

        def __str__(self):
            return f"ClassScore.SCORE{self._values!r}"

        def __eq__(self, other):
            if not other.is_SCORE():
                return False
            return self._values == other._values
    class EMPTY:
        """
        성적 없음
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "ClassScore.EMPTY()".format()

        def __eq__(self, other):
            if not other.is_EMPTY():
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_PASS(self) -> bool:
        return isinstance(self, ClassScore.PASS)
    def is_pass(self) -> bool:
        return isinstance(self, ClassScore.PASS)
    def is_FAILED(self) -> bool:
        return isinstance(self, ClassScore.FAILED)
    def is_failed(self) -> bool:
        return isinstance(self, ClassScore.FAILED)
    def is_SCORE(self) -> bool:
        return isinstance(self, ClassScore.SCORE)
    def is_score(self) -> bool:
        return isinstance(self, ClassScore.SCORE)
    def is_EMPTY(self) -> bool:
        return isinstance(self, ClassScore.EMPTY)
    def is_empty(self) -> bool:
        return isinstance(self, ClassScore.EMPTY)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
ClassScore.PASS = type("ClassScore.PASS", (ClassScore.PASS, ClassScore,), {})  # type: ignore
ClassScore.FAILED = type("ClassScore.FAILED", (ClassScore.FAILED, ClassScore,), {})  # type: ignore
ClassScore.SCORE = type("ClassScore.SCORE", (ClassScore.SCORE, ClassScore,), {})  # type: ignore
ClassScore.EMPTY = type("ClassScore.EMPTY", (ClassScore.EMPTY, ClassScore,), {})  # type: ignore




class _UniffiConverterTypeClassScore(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return ClassScore.PASS(
            )
        if variant == 2:
            return ClassScore.FAILED(
            )
        if variant == 3:
            return ClassScore.SCORE(
                _UniffiConverterUInt32.read(buf),
            )
        if variant == 4:
            return ClassScore.EMPTY(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_PASS():
            return
        if value.is_FAILED():
            return
        if value.is_SCORE():
            _UniffiConverterUInt32.check_lower(value._values[0])
            return
        if value.is_EMPTY():
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_PASS():
            buf.write_i32(1)
        if value.is_FAILED():
            buf.write_i32(2)
        if value.is_SCORE():
            buf.write_i32(3)
            _UniffiConverterUInt32.write(value._values[0], buf)
        if value.is_EMPTY():
            buf.write_i32(4)







class CourseType(enum.Enum):
    """
    학위과정
    """

    PHD = 0
    """
    박사과정
    """

    
    MASTER = 1
    """
    석사과정
    """

    
    PHD_INTERGRATED = 2
    """
    석박과정
    """

    
    RESEARCH = 3
    """
    연구과정
    """

    
    BACHELOR = 4
    """
    학사과정
    """

    


class _UniffiConverterTypeCourseType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return CourseType.PHD
        if variant == 2:
            return CourseType.MASTER
        if variant == 3:
            return CourseType.PHD_INTERGRATED
        if variant == 4:
            return CourseType.RESEARCH
        if variant == 5:
            return CourseType.BACHELOR
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == CourseType.PHD:
            return
        if value == CourseType.MASTER:
            return
        if value == CourseType.PHD_INTERGRATED:
            return
        if value == CourseType.RESEARCH:
            return
        if value == CourseType.BACHELOR:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == CourseType.PHD:
            buf.write_i32(1)
        if value == CourseType.MASTER:
            buf.write_i32(2)
        if value == CourseType.PHD_INTERGRATED:
            buf.write_i32(3)
        if value == CourseType.RESEARCH:
            buf.write_i32(4)
        if value == CourseType.BACHELOR:
            buf.write_i32(5)







class LectureCategory:
    """
    강의를 찾을 때 사용하는 강의 카테고리
    """

    def __init__(self):
        raise RuntimeError("LectureCategory cannot be instantiated directly")

    # Each enum variant is a nested class of the enum itself.
    class MAJOR:
        """
        전공 강의
        """

        collage: "str"
        """
        단과대명
        """

        department: "str"
        """
        학부명
        """

        major: "typing.Optional[str]"
        """
        전공명
        """


        def __init__(self,collage: "str", department: "str", major: "typing.Optional[str]"):
            self.collage = collage
            self.department = department
            self.major = major

        def __str__(self):
            return "LectureCategory.MAJOR(collage={}, department={}, major={})".format(self.collage, self.department, self.major)

        def __eq__(self, other):
            if not other.is_MAJOR():
                return False
            if self.collage != other.collage:
                return False
            if self.department != other.department:
                return False
            if self.major != other.major:
                return False
            return True
    
    class REQUIRED_ELECTIVE:
        """
        교양필수
        """

        lecture_name: "str"
        """
        과목명
        """


        def __init__(self,lecture_name: "str"):
            self.lecture_name = lecture_name

        def __str__(self):
            return "LectureCategory.REQUIRED_ELECTIVE(lecture_name={})".format(self.lecture_name)

        def __eq__(self, other):
            if not other.is_REQUIRED_ELECTIVE():
                return False
            if self.lecture_name != other.lecture_name:
                return False
            return True
    
    class OPTIONAL_ELECTIVE:
        """
        교양선택
        """

        category: "str"
        """
        교양 분류
        """


        def __init__(self,category: "str"):
            self.category = category

        def __str__(self):
            return "LectureCategory.OPTIONAL_ELECTIVE(category={})".format(self.category)

        def __eq__(self, other):
            if not other.is_OPTIONAL_ELECTIVE():
                return False
            if self.category != other.category:
                return False
            return True
    
    class CHAPEL:
        """
        채플
        """

        lecture_name: "str"
        """
        과목명
        """


        def __init__(self,lecture_name: "str"):
            self.lecture_name = lecture_name

        def __str__(self):
            return "LectureCategory.CHAPEL(lecture_name={})".format(self.lecture_name)

        def __eq__(self, other):
            if not other.is_CHAPEL():
                return False
            if self.lecture_name != other.lecture_name:
                return False
            return True
    
    class EDUCATION:
        """
        교직
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "LectureCategory.EDUCATION()".format()

        def __eq__(self, other):
            if not other.is_EDUCATION():
                return False
            return True
    
    class GRADUATED:
        """
        대학원
        """

        collage: "str"
        """
        단과대명
        """

        department: "str"
        """
        학부명
        """


        def __init__(self,collage: "str", department: "str"):
            self.collage = collage
            self.department = department

        def __str__(self):
            return "LectureCategory.GRADUATED(collage={}, department={})".format(self.collage, self.department)

        def __eq__(self, other):
            if not other.is_GRADUATED():
                return False
            if self.collage != other.collage:
                return False
            if self.department != other.department:
                return False
            return True
    
    class CONNECTED_MAJOR:
        """
        연계전공
        """

        major: "str"
        """
        전공명
        """


        def __init__(self,major: "str"):
            self.major = major

        def __str__(self):
            return "LectureCategory.CONNECTED_MAJOR(major={})".format(self.major)

        def __eq__(self, other):
            if not other.is_CONNECTED_MAJOR():
                return False
            if self.major != other.major:
                return False
            return True
    
    class UNITED_MAJOR:
        """
        융합전공
        """

        major: "str"
        """
        전공명
        """


        def __init__(self,major: "str"):
            self.major = major

        def __str__(self):
            return "LectureCategory.UNITED_MAJOR(major={})".format(self.major)

        def __eq__(self, other):
            if not other.is_UNITED_MAJOR():
                return False
            if self.major != other.major:
                return False
            return True
    
    class FIND_BY_PROFESSOR:
        """
        교수명 검색
        """

        keyword: "str"
        """
        교수명
        """


        def __init__(self,keyword: "str"):
            self.keyword = keyword

        def __str__(self):
            return "LectureCategory.FIND_BY_PROFESSOR(keyword={})".format(self.keyword)

        def __eq__(self, other):
            if not other.is_FIND_BY_PROFESSOR():
                return False
            if self.keyword != other.keyword:
                return False
            return True
    
    class FIND_BY_LECTURE:
        """
        과목명 검색
        """

        keyword: "str"
        """
        과목명
        """


        def __init__(self,keyword: "str"):
            self.keyword = keyword

        def __str__(self):
            return "LectureCategory.FIND_BY_LECTURE(keyword={})".format(self.keyword)

        def __eq__(self, other):
            if not other.is_FIND_BY_LECTURE():
                return False
            if self.keyword != other.keyword:
                return False
            return True
    
    class RECOGNIZED_OTHER_MAJOR:
        """
        타전공인정과목
        """

        collage: "str"
        """
        단과대명
        """

        department: "str"
        """
        학부명
        """

        major: "typing.Optional[str]"
        """
        전공명
        """


        def __init__(self,collage: "str", department: "str", major: "typing.Optional[str]"):
            self.collage = collage
            self.department = department
            self.major = major

        def __str__(self):
            return "LectureCategory.RECOGNIZED_OTHER_MAJOR(collage={}, department={}, major={})".format(self.collage, self.department, self.major)

        def __eq__(self, other):
            if not other.is_RECOGNIZED_OTHER_MAJOR():
                return False
            if self.collage != other.collage:
                return False
            if self.department != other.department:
                return False
            if self.major != other.major:
                return False
            return True
    
    class CYBER:
        """
        숭실사이버대
        """


        def __init__(self,):
            pass

        def __str__(self):
            return "LectureCategory.CYBER()".format()

        def __eq__(self, other):
            if not other.is_CYBER():
                return False
            return True
    
    

    # For each variant, we have `is_NAME` and `is_name` methods for easily checking
    # whether an instance is that variant.
    def is_MAJOR(self) -> bool:
        return isinstance(self, LectureCategory.MAJOR)
    def is_major(self) -> bool:
        return isinstance(self, LectureCategory.MAJOR)
    def is_REQUIRED_ELECTIVE(self) -> bool:
        return isinstance(self, LectureCategory.REQUIRED_ELECTIVE)
    def is_required_elective(self) -> bool:
        return isinstance(self, LectureCategory.REQUIRED_ELECTIVE)
    def is_OPTIONAL_ELECTIVE(self) -> bool:
        return isinstance(self, LectureCategory.OPTIONAL_ELECTIVE)
    def is_optional_elective(self) -> bool:
        return isinstance(self, LectureCategory.OPTIONAL_ELECTIVE)
    def is_CHAPEL(self) -> bool:
        return isinstance(self, LectureCategory.CHAPEL)
    def is_chapel(self) -> bool:
        return isinstance(self, LectureCategory.CHAPEL)
    def is_EDUCATION(self) -> bool:
        return isinstance(self, LectureCategory.EDUCATION)
    def is_education(self) -> bool:
        return isinstance(self, LectureCategory.EDUCATION)
    def is_GRADUATED(self) -> bool:
        return isinstance(self, LectureCategory.GRADUATED)
    def is_graduated(self) -> bool:
        return isinstance(self, LectureCategory.GRADUATED)
    def is_CONNECTED_MAJOR(self) -> bool:
        return isinstance(self, LectureCategory.CONNECTED_MAJOR)
    def is_connected_major(self) -> bool:
        return isinstance(self, LectureCategory.CONNECTED_MAJOR)
    def is_UNITED_MAJOR(self) -> bool:
        return isinstance(self, LectureCategory.UNITED_MAJOR)
    def is_united_major(self) -> bool:
        return isinstance(self, LectureCategory.UNITED_MAJOR)
    def is_FIND_BY_PROFESSOR(self) -> bool:
        return isinstance(self, LectureCategory.FIND_BY_PROFESSOR)
    def is_find_by_professor(self) -> bool:
        return isinstance(self, LectureCategory.FIND_BY_PROFESSOR)
    def is_FIND_BY_LECTURE(self) -> bool:
        return isinstance(self, LectureCategory.FIND_BY_LECTURE)
    def is_find_by_lecture(self) -> bool:
        return isinstance(self, LectureCategory.FIND_BY_LECTURE)
    def is_RECOGNIZED_OTHER_MAJOR(self) -> bool:
        return isinstance(self, LectureCategory.RECOGNIZED_OTHER_MAJOR)
    def is_recognized_other_major(self) -> bool:
        return isinstance(self, LectureCategory.RECOGNIZED_OTHER_MAJOR)
    def is_CYBER(self) -> bool:
        return isinstance(self, LectureCategory.CYBER)
    def is_cyber(self) -> bool:
        return isinstance(self, LectureCategory.CYBER)
    

# Now, a little trick - we make each nested variant class be a subclass of the main
# enum class, so that method calls and instance checks etc will work intuitively.
# We might be able to do this a little more neatly with a metaclass, but this'll do.
LectureCategory.MAJOR = type("LectureCategory.MAJOR", (LectureCategory.MAJOR, LectureCategory,), {})  # type: ignore
LectureCategory.REQUIRED_ELECTIVE = type("LectureCategory.REQUIRED_ELECTIVE", (LectureCategory.REQUIRED_ELECTIVE, LectureCategory,), {})  # type: ignore
LectureCategory.OPTIONAL_ELECTIVE = type("LectureCategory.OPTIONAL_ELECTIVE", (LectureCategory.OPTIONAL_ELECTIVE, LectureCategory,), {})  # type: ignore
LectureCategory.CHAPEL = type("LectureCategory.CHAPEL", (LectureCategory.CHAPEL, LectureCategory,), {})  # type: ignore
LectureCategory.EDUCATION = type("LectureCategory.EDUCATION", (LectureCategory.EDUCATION, LectureCategory,), {})  # type: ignore
LectureCategory.GRADUATED = type("LectureCategory.GRADUATED", (LectureCategory.GRADUATED, LectureCategory,), {})  # type: ignore
LectureCategory.CONNECTED_MAJOR = type("LectureCategory.CONNECTED_MAJOR", (LectureCategory.CONNECTED_MAJOR, LectureCategory,), {})  # type: ignore
LectureCategory.UNITED_MAJOR = type("LectureCategory.UNITED_MAJOR", (LectureCategory.UNITED_MAJOR, LectureCategory,), {})  # type: ignore
LectureCategory.FIND_BY_PROFESSOR = type("LectureCategory.FIND_BY_PROFESSOR", (LectureCategory.FIND_BY_PROFESSOR, LectureCategory,), {})  # type: ignore
LectureCategory.FIND_BY_LECTURE = type("LectureCategory.FIND_BY_LECTURE", (LectureCategory.FIND_BY_LECTURE, LectureCategory,), {})  # type: ignore
LectureCategory.RECOGNIZED_OTHER_MAJOR = type("LectureCategory.RECOGNIZED_OTHER_MAJOR", (LectureCategory.RECOGNIZED_OTHER_MAJOR, LectureCategory,), {})  # type: ignore
LectureCategory.CYBER = type("LectureCategory.CYBER", (LectureCategory.CYBER, LectureCategory,), {})  # type: ignore




class _UniffiConverterTypeLectureCategory(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return LectureCategory.MAJOR(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
                _UniffiConverterOptionalString.read(buf),
            )
        if variant == 2:
            return LectureCategory.REQUIRED_ELECTIVE(
                _UniffiConverterString.read(buf),
            )
        if variant == 3:
            return LectureCategory.OPTIONAL_ELECTIVE(
                _UniffiConverterString.read(buf),
            )
        if variant == 4:
            return LectureCategory.CHAPEL(
                _UniffiConverterString.read(buf),
            )
        if variant == 5:
            return LectureCategory.EDUCATION(
            )
        if variant == 6:
            return LectureCategory.GRADUATED(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
            )
        if variant == 7:
            return LectureCategory.CONNECTED_MAJOR(
                _UniffiConverterString.read(buf),
            )
        if variant == 8:
            return LectureCategory.UNITED_MAJOR(
                _UniffiConverterString.read(buf),
            )
        if variant == 9:
            return LectureCategory.FIND_BY_PROFESSOR(
                _UniffiConverterString.read(buf),
            )
        if variant == 10:
            return LectureCategory.FIND_BY_LECTURE(
                _UniffiConverterString.read(buf),
            )
        if variant == 11:
            return LectureCategory.RECOGNIZED_OTHER_MAJOR(
                _UniffiConverterString.read(buf),
                _UniffiConverterString.read(buf),
                _UniffiConverterOptionalString.read(buf),
            )
        if variant == 12:
            return LectureCategory.CYBER(
            )
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value.is_MAJOR():
            _UniffiConverterString.check_lower(value.collage)
            _UniffiConverterString.check_lower(value.department)
            _UniffiConverterOptionalString.check_lower(value.major)
            return
        if value.is_REQUIRED_ELECTIVE():
            _UniffiConverterString.check_lower(value.lecture_name)
            return
        if value.is_OPTIONAL_ELECTIVE():
            _UniffiConverterString.check_lower(value.category)
            return
        if value.is_CHAPEL():
            _UniffiConverterString.check_lower(value.lecture_name)
            return
        if value.is_EDUCATION():
            return
        if value.is_GRADUATED():
            _UniffiConverterString.check_lower(value.collage)
            _UniffiConverterString.check_lower(value.department)
            return
        if value.is_CONNECTED_MAJOR():
            _UniffiConverterString.check_lower(value.major)
            return
        if value.is_UNITED_MAJOR():
            _UniffiConverterString.check_lower(value.major)
            return
        if value.is_FIND_BY_PROFESSOR():
            _UniffiConverterString.check_lower(value.keyword)
            return
        if value.is_FIND_BY_LECTURE():
            _UniffiConverterString.check_lower(value.keyword)
            return
        if value.is_RECOGNIZED_OTHER_MAJOR():
            _UniffiConverterString.check_lower(value.collage)
            _UniffiConverterString.check_lower(value.department)
            _UniffiConverterOptionalString.check_lower(value.major)
            return
        if value.is_CYBER():
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value.is_MAJOR():
            buf.write_i32(1)
            _UniffiConverterString.write(value.collage, buf)
            _UniffiConverterString.write(value.department, buf)
            _UniffiConverterOptionalString.write(value.major, buf)
        if value.is_REQUIRED_ELECTIVE():
            buf.write_i32(2)
            _UniffiConverterString.write(value.lecture_name, buf)
        if value.is_OPTIONAL_ELECTIVE():
            buf.write_i32(3)
            _UniffiConverterString.write(value.category, buf)
        if value.is_CHAPEL():
            buf.write_i32(4)
            _UniffiConverterString.write(value.lecture_name, buf)
        if value.is_EDUCATION():
            buf.write_i32(5)
        if value.is_GRADUATED():
            buf.write_i32(6)
            _UniffiConverterString.write(value.collage, buf)
            _UniffiConverterString.write(value.department, buf)
        if value.is_CONNECTED_MAJOR():
            buf.write_i32(7)
            _UniffiConverterString.write(value.major, buf)
        if value.is_UNITED_MAJOR():
            buf.write_i32(8)
            _UniffiConverterString.write(value.major, buf)
        if value.is_FIND_BY_PROFESSOR():
            buf.write_i32(9)
            _UniffiConverterString.write(value.keyword, buf)
        if value.is_FIND_BY_LECTURE():
            buf.write_i32(10)
            _UniffiConverterString.write(value.keyword, buf)
        if value.is_RECOGNIZED_OTHER_MAJOR():
            buf.write_i32(11)
            _UniffiConverterString.write(value.collage, buf)
            _UniffiConverterString.write(value.department, buf)
            _UniffiConverterOptionalString.write(value.major, buf)
        if value.is_CYBER():
            buf.write_i32(12)







class SemesterType(enum.Enum):
    """
    학기 종류

    각 애플리케이션에서의 변환은 애플리케이션 내에서 직접 처리하여야 합니다.
    """

    ONE = 0
    """
    1학기
    """

    
    SUMMER = 1
    """
    여름학기
    """

    
    TWO = 2
    """
    2학기
    """

    
    WINTER = 3
    """
    겨울학기
    """

    


class _UniffiConverterTypeSemesterType(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return SemesterType.ONE
        if variant == 2:
            return SemesterType.SUMMER
        if variant == 3:
            return SemesterType.TWO
        if variant == 4:
            return SemesterType.WINTER
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == SemesterType.ONE:
            return
        if value == SemesterType.SUMMER:
            return
        if value == SemesterType.TWO:
            return
        if value == SemesterType.WINTER:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == SemesterType.ONE:
            buf.write_i32(1)
        if value == SemesterType.SUMMER:
            buf.write_i32(2)
        if value == SemesterType.TWO:
            buf.write_i32(3)
        if value == SemesterType.WINTER:
            buf.write_i32(4)







class Weekday(enum.Enum):
    """
    한 주의 요일을 표현합니다.
    """

    MON = 0
    """
    월요일
    """

    
    TUE = 1
    """
    화요일
    """

    
    WED = 2
    """
    수요일
    """

    
    THU = 3
    """
    목요일
    """

    
    FRI = 4
    """
    금요일
    """

    
    SAT = 5
    """
    토요일
    """

    
    SUN = 6
    """
    일요일
    """

    


class _UniffiConverterTypeWeekday(_UniffiConverterRustBuffer):
    @staticmethod
    def read(buf):
        variant = buf.read_i32()
        if variant == 1:
            return Weekday.MON
        if variant == 2:
            return Weekday.TUE
        if variant == 3:
            return Weekday.WED
        if variant == 4:
            return Weekday.THU
        if variant == 5:
            return Weekday.FRI
        if variant == 6:
            return Weekday.SAT
        if variant == 7:
            return Weekday.SUN
        raise InternalError("Raw enum value doesn't match any cases")

    @staticmethod
    def check_lower(value):
        if value == Weekday.MON:
            return
        if value == Weekday.TUE:
            return
        if value == Weekday.WED:
            return
        if value == Weekday.THU:
            return
        if value == Weekday.FRI:
            return
        if value == Weekday.SAT:
            return
        if value == Weekday.SUN:
            return
        raise ValueError(value)

    @staticmethod
    def write(value, buf):
        if value == Weekday.MON:
            buf.write_i32(1)
        if value == Weekday.TUE:
            buf.write_i32(2)
        if value == Weekday.WED:
            buf.write_i32(3)
        if value == Weekday.THU:
            buf.write_i32(4)
        if value == Weekday.FRI:
            buf.write_i32(5)
        if value == Weekday.SAT:
            buf.write_i32(6)
        if value == Weekday.SUN:
            buf.write_i32(7)





class _UniffiConverterOptionalUInt32(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterUInt32.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterUInt32.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterUInt32.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalFloat(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterFloat.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterFloat.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterFloat.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterString.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterString.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterString.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeStudentForignStudyInformation(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeStudentForignStudyInformation.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeStudentForignStudyInformation.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeStudentForignStudyInformation.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeStudentLifelongInformation(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeStudentLifelongInformation.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeStudentLifelongInformation.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeStudentLifelongInformation.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeStudentTeachingMajorInformation(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeStudentTeachingMajorInformation.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeStudentTeachingMajorInformation.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeStudentTeachingMajorInformation.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalTypeStudentTeachingPluralMajorInformation(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterTypeStudentTeachingPluralMajorInformation.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterTypeStudentTeachingPluralMajorInformation.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterTypeStudentTeachingPluralMajorInformation.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterOptionalMapStringFloat(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        if value is not None:
            _UniffiConverterMapStringFloat.check_lower(value)

    @classmethod
    def write(cls, value, buf):
        if value is None:
            buf.write_u8(0)
            return

        buf.write_u8(1)
        _UniffiConverterMapStringFloat.write(value, buf)

    @classmethod
    def read(cls, buf):
        flag = buf.read_u8()
        if flag == 0:
            return None
        elif flag == 1:
            return _UniffiConverterMapStringFloat.read(buf)
        else:
            raise InternalError("Unexpected flag byte for optional type")



class _UniffiConverterSequenceString(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterString.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterString.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterString.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeChapelAbsenceRequest(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeChapelAbsenceRequest.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeChapelAbsenceRequest.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeChapelAbsenceRequest.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeChapelAttendance(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeChapelAttendance.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeChapelAttendance.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeChapelAttendance.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeCourseScheduleInformation(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeCourseScheduleInformation.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeCourseScheduleInformation.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeCourseScheduleInformation.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeStudentAcademicRecord(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeStudentAcademicRecord.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeStudentAcademicRecord.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeStudentAcademicRecord.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeStudentFamilyMember(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeStudentFamilyMember.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeStudentFamilyMember.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeStudentFamilyMember.read(buf) for i in range(count)
        ]



class _UniffiConverterSequenceTypeStudentTransferRecord(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, value):
        for item in value:
            _UniffiConverterTypeStudentTransferRecord.check_lower(item)

    @classmethod
    def write(cls, value, buf):
        items = len(value)
        buf.write_i32(items)
        for item in value:
            _UniffiConverterTypeStudentTransferRecord.write(item, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative sequence length")

        return [
            _UniffiConverterTypeStudentTransferRecord.read(buf) for i in range(count)
        ]



class _UniffiConverterMapStringFloat(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterString.check_lower(key)
            _UniffiConverterFloat.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterString.write(key, buf)
            _UniffiConverterFloat.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterString.read(buf)
            val = _UniffiConverterFloat.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapStringTypeGraduationRequirement(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterString.check_lower(key)
            _UniffiConverterTypeGraduationRequirement.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterString.write(key, buf)
            _UniffiConverterTypeGraduationRequirement.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterString.read(buf)
            val = _UniffiConverterTypeGraduationRequirement.read(buf)
            d[key] = val
        return d



class _UniffiConverterMapTypeWeekdaySequenceTypeCourseScheduleInformation(_UniffiConverterRustBuffer):
    @classmethod
    def check_lower(cls, items):
        for (key, value) in items.items():
            _UniffiConverterTypeWeekday.check_lower(key)
            _UniffiConverterSequenceTypeCourseScheduleInformation.check_lower(value)

    @classmethod
    def write(cls, items, buf):
        buf.write_i32(len(items))
        for (key, value) in items.items():
            _UniffiConverterTypeWeekday.write(key, buf)
            _UniffiConverterSequenceTypeCourseScheduleInformation.write(value, buf)

    @classmethod
    def read(cls, buf):
        count = buf.read_i32()
        if count < 0:
            raise InternalError("Unexpected negative map size")

        # It would be nice to use a dict comprehension,
        # but in Python 3.7 and before the evaluation order is not according to spec,
        # so we we're reading the value before the key.
        # This loop makes the order explicit: first reading the key, then the value.
        d = {}
        for i in range(count):
            key = _UniffiConverterTypeWeekday.read(buf)
            val = _UniffiConverterSequenceTypeCourseScheduleInformation.read(buf)
            d[key] = val
        return d


class _UniffiConverterTypeU32Pair:
    @staticmethod
    def write(value, buf):
        _UniffiConverterTypeUnsignedIntPair.write(value, buf)

    @staticmethod
    def read(buf):
        return _UniffiConverterTypeUnsignedIntPair.read(buf)

    @staticmethod
    def lift(value):
        return _UniffiConverterTypeUnsignedIntPair.lift(value)

    @staticmethod
    def check_lower(value):
        return _UniffiConverterTypeUnsignedIntPair.check_lower(value)

    @staticmethod
    def lower(value):
        return _UniffiConverterTypeUnsignedIntPair.lower(value)

# objects.
class LectureCategoryBuilderProtocol(typing.Protocol):
    """
    새로운 `LectureCategory`를 만드는 빌더입니다.
    """

    def chapel(self, lecture_name: "str"):
        """
        채플 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def connected_major(self, major: "str"):
        """
        연계전공 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def cyber(self, ):
        """
        숭실사이버대 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def education(self, ):
        """
        교직 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def find_by_lecture(self, keyword: "str"):
        """
        과목명으로 찾기 위한 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def find_by_professor(self, keyword: "str"):
        """
        교수명으로 찾기 위한 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def graduated(self, collage: "str",department: "str"):
        """
        대학원 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def major(self, collage: "str",department: "str",major: "typing.Optional[str]"):
        """
        전공과목 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def optional_elective(self, category: "str"):
        """
        교양선택 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def recognized_other_major(self, collage: "str",department: "str",major: "typing.Optional[str]"):
        """
        타전공인정과목 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def required_elective(self, lecture_name: "str"):
        """
        교양필수 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
    def united_major(self, major: "str"):
        """
        융합전공 분류의 [`LectureCategory`]를 만듭니다.
        """

        raise NotImplementedError
# LectureCategoryBuilder is a Rust-only trait - it's a wrapper around a Rust implementation.
class LectureCategoryBuilder():
    """
    새로운 `LectureCategory`를 만드는 빌더입니다.
    """

    _pointer: ctypes.c_void_p
    def __init__(self, ):
        """
        `LectureCategoryBuilder`를 만듭니다.
        """

        self._pointer = _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_constructor_lecturecategorybuilder_new,)

    def __del__(self):
        # In case of partial initialization of instances.
        pointer = getattr(self, "_pointer", None)
        if pointer is not None:
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_free_lecturecategorybuilder, pointer)

    def _uniffi_clone_pointer(self):
        return _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_clone_lecturecategorybuilder, self._pointer)

    # Used by alternative constructors or any methods which return this type.
    @classmethod
    def _make_instance_(cls, pointer):
        # Lightly yucky way to bypass the usual __init__ logic
        # and just create a new instance with the required pointer.
        inst = cls.__new__(cls)
        inst._pointer = pointer
        return inst


    def chapel(self, lecture_name: "str") -> "LectureCategory":
        """
        채플 분류의 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(lecture_name)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_chapel,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(lecture_name))
        )





    def connected_major(self, major: "str") -> "LectureCategory":
        """
        연계전공 분류의 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(major)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_connected_major,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(major))
        )





    def cyber(self, ) -> "LectureCategory":
        """
        숭실사이버대 분류의 [`LectureCategory`]를 만듭니다.
        """

        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_cyber,self._uniffi_clone_pointer(),)
        )





    def education(self, ) -> "LectureCategory":
        """
        교직 분류의 [`LectureCategory`]를 만듭니다.
        """

        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_education,self._uniffi_clone_pointer(),)
        )





    def find_by_lecture(self, keyword: "str") -> "LectureCategory":
        """
        과목명으로 찾기 위한 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(keyword)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_lecture,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(keyword))
        )





    def find_by_professor(self, keyword: "str") -> "LectureCategory":
        """
        교수명으로 찾기 위한 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(keyword)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_find_by_professor,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(keyword))
        )





    def graduated(self, collage: "str",department: "str") -> "LectureCategory":
        """
        대학원 분류의 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(collage)
        
        _UniffiConverterString.check_lower(department)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_graduated,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(collage),
        _UniffiConverterString.lower(department))
        )





    def major(self, collage: "str",department: "str",major: "typing.Optional[str]") -> "LectureCategory":
        """
        전공과목 분류의 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(collage)
        
        _UniffiConverterString.check_lower(department)
        
        _UniffiConverterOptionalString.check_lower(major)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_major,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(collage),
        _UniffiConverterString.lower(department),
        _UniffiConverterOptionalString.lower(major))
        )





    def optional_elective(self, category: "str") -> "LectureCategory":
        """
        교양선택 분류의 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(category)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_optional_elective,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(category))
        )





    def recognized_other_major(self, collage: "str",department: "str",major: "typing.Optional[str]") -> "LectureCategory":
        """
        타전공인정과목 분류의 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(collage)
        
        _UniffiConverterString.check_lower(department)
        
        _UniffiConverterOptionalString.check_lower(major)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_recognized_other_major,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(collage),
        _UniffiConverterString.lower(department),
        _UniffiConverterOptionalString.lower(major))
        )





    def required_elective(self, lecture_name: "str") -> "LectureCategory":
        """
        교양필수 분류의 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(lecture_name)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_required_elective,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(lecture_name))
        )





    def united_major(self, major: "str") -> "LectureCategory":
        """
        융합전공 분류의 [`LectureCategory`]를 만듭니다.
        """

        _UniffiConverterString.check_lower(major)
        
        return _UniffiConverterTypeLectureCategory.lift(
            _uniffi_rust_call(_UniffiLib.uniffi_rusaint_fn_method_lecturecategorybuilder_united_major,self._uniffi_clone_pointer(),
        _UniffiConverterString.lower(major))
        )






class _UniffiConverterTypeLectureCategoryBuilder:

    @staticmethod
    def lift(value: int):
        return LectureCategoryBuilder._make_instance_(value)

    @staticmethod
    def check_lower(value: LectureCategoryBuilder):
        if not isinstance(value, LectureCategoryBuilder):
            raise TypeError("Expected LectureCategoryBuilder instance, {} found".format(type(value).__name__))

    @staticmethod
    def lower(value: LectureCategoryBuilderProtocol):
        if not isinstance(value, LectureCategoryBuilder):
            raise TypeError("Expected LectureCategoryBuilder instance, {} found".format(type(value).__name__))
        return value._uniffi_clone_pointer()

    @classmethod
    def read(cls, buf: _UniffiRustBuffer):
        ptr = buf.read_u64()
        if ptr == 0:
            raise InternalError("Raw pointer value was null")
        return cls.lift(ptr)

    @classmethod
    def write(cls, value: LectureCategoryBuilderProtocol, buf: _UniffiRustBuffer):
        buf.write_u64(cls.lower(value))
U32Pair = UnsignedIntPair

# Async support

__all__ = [
    "InternalError",
    "ClassScore",
    "CourseType",
    "LectureCategory",
    "SemesterType",
    "Weekday",
    "ChapelAbsenceRequest",
    "ChapelAttendance",
    "ChapelInformation",
    "ClassGrade",
    "CourseScheduleInformation",
    "GeneralChapelInformation",
    "GradeSummary",
    "GraduationRequirement",
    "GraduationRequirements",
    "GraduationStudent",
    "Lecture",
    "LectureAssessmentResult",
    "PersonalCourseSchedule",
    "Scholarship",
    "SemesterGrade",
    "StudentAcademicRecord",
    "StudentAcademicRecords",
    "StudentBankAccount",
    "StudentFamily",
    "StudentFamilyMember",
    "StudentForignStudyInformation",
    "StudentGraduation",
    "StudentInformation",
    "StudentLifelongInformation",
    "StudentQualification",
    "StudentReligion",
    "StudentResearchBankAccount",
    "StudentTeachingMajorInformation",
    "StudentTeachingPluralMajorInformation",
    "StudentTransferRecord",
    "StudentTransferRecords",
    "StudentWorkInformation",
    "UnsignedIntPair",
    "LectureCategoryBuilder",
]

