"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
import dateutil.parser
from orq_poc_python_multi_env_version import utils
from orq_poc_python_multi_env_version.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from orq_poc_python_multi_env_version.utils import (
    FieldMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


UpdatePromptModelType = Literal[
    "chat", "completion", "embedding", "vision", "image", "tts", "stt", "rerank"
]
r"""The type of the model"""

UpdatePromptFormat = Literal["url", "b64_json", "text", "json_object"]
r"""Only supported on `image` models."""

UpdatePromptQuality = Literal["standard", "hd"]
r"""Only supported on `image` models."""

UpdatePromptResponseFormatPromptsType = Literal["json_object"]


class UpdatePromptResponseFormat2TypedDict(TypedDict):
    type: UpdatePromptResponseFormatPromptsType


class UpdatePromptResponseFormat2(BaseModel):
    type: UpdatePromptResponseFormatPromptsType


UpdatePromptResponseFormatType = Literal["json_schema"]


class UpdatePromptResponseFormatJSONSchemaTypedDict(TypedDict):
    name: str
    strict: bool
    schema_: Dict[str, Any]


class UpdatePromptResponseFormatJSONSchema(BaseModel):
    name: str

    strict: bool

    schema_: Annotated[Dict[str, Any], pydantic.Field(alias="schema")]


class UpdatePromptResponseFormat1TypedDict(TypedDict):
    type: UpdatePromptResponseFormatType
    json_schema: UpdatePromptResponseFormatJSONSchemaTypedDict


class UpdatePromptResponseFormat1(BaseModel):
    type: UpdatePromptResponseFormatType

    json_schema: UpdatePromptResponseFormatJSONSchema


UpdatePromptResponseFormatTypedDict = TypeAliasType(
    "UpdatePromptResponseFormatTypedDict",
    Union[UpdatePromptResponseFormat2TypedDict, UpdatePromptResponseFormat1TypedDict],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseFormat = TypeAliasType(
    "UpdatePromptResponseFormat",
    Union[UpdatePromptResponseFormat2, UpdatePromptResponseFormat1],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptPhotoRealVersion = Literal["v1", "v2"]
r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

UpdatePromptEncodingFormat = Literal["float", "base64"]
r"""The format to return the embeddings"""


class UpdatePromptModelParametersTypedDict(TypedDict):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    max_tokens: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_k: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_p: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    frequency_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    presence_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    num_images: NotRequired[float]
    r"""Only supported on `image` models."""
    seed: NotRequired[float]
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""
    format: NotRequired[UpdatePromptFormat]
    r"""Only supported on `image` models."""
    dimensions: NotRequired[str]
    r"""Only supported on `image` models."""
    quality: NotRequired[UpdatePromptQuality]
    r"""Only supported on `image` models."""
    style: NotRequired[str]
    r"""Only supported on `image` models."""
    response_format: NotRequired[Nullable[UpdatePromptResponseFormatTypedDict]]
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """
    photo_real_version: NotRequired[UpdatePromptPhotoRealVersion]
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""
    encoding_format: NotRequired[UpdatePromptEncodingFormat]
    r"""The format to return the embeddings"""


class UpdatePromptModelParameters(BaseModel):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: Optional[float] = None
    r"""Only supported on `chat` and `completion` models."""

    max_tokens: Annotated[Optional[float], pydantic.Field(alias="maxTokens")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_k: Annotated[Optional[float], pydantic.Field(alias="topK")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_p: Annotated[Optional[float], pydantic.Field(alias="topP")] = None
    r"""Only supported on `chat` and `completion` models."""

    frequency_penalty: Annotated[
        Optional[float], pydantic.Field(alias="frequencyPenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    presence_penalty: Annotated[
        Optional[float], pydantic.Field(alias="presencePenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    num_images: Annotated[Optional[float], pydantic.Field(alias="numImages")] = None
    r"""Only supported on `image` models."""

    seed: Optional[float] = None
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""

    format: Optional[UpdatePromptFormat] = None
    r"""Only supported on `image` models."""

    dimensions: Optional[str] = None
    r"""Only supported on `image` models."""

    quality: Optional[UpdatePromptQuality] = None
    r"""Only supported on `image` models."""

    style: Optional[str] = None
    r"""Only supported on `image` models."""

    response_format: Annotated[
        OptionalNullable[UpdatePromptResponseFormat],
        pydantic.Field(alias="responseFormat"),
    ] = UNSET
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """

    photo_real_version: Annotated[
        Optional[UpdatePromptPhotoRealVersion], pydantic.Field(alias="photoRealVersion")
    ] = None
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

    encoding_format: Optional[UpdatePromptEncodingFormat] = None
    r"""The format to return the embeddings"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "temperature",
            "maxTokens",
            "topK",
            "topP",
            "frequencyPenalty",
            "presencePenalty",
            "numImages",
            "seed",
            "format",
            "dimensions",
            "quality",
            "style",
            "responseFormat",
            "photoRealVersion",
            "encoding_format",
        ]
        nullable_fields = ["responseFormat"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptProvider = Literal[
    "cohere",
    "openai",
    "anthropic",
    "huggingface",
    "replicate",
    "google",
    "google-ai",
    "azure",
    "aws",
    "anyscale",
    "perplexity",
    "groq",
    "fal",
    "leonardoai",
    "nvidia",
]

UpdatePromptRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""

UpdatePrompt2PromptsType = Literal["image_url"]


class UpdatePrompt2ImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2ImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt22TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsType
    image_url: UpdatePrompt2ImageURLTypedDict


class UpdatePrompt22(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsType

    image_url: UpdatePrompt2ImageURL


UpdatePrompt2Type = Literal["text"]


class UpdatePrompt21TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2Type
    text: str


class UpdatePrompt21(BaseModel):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2Type

    text: str


UpdatePromptContent2TypedDict = TypeAliasType(
    "UpdatePromptContent2TypedDict",
    Union[UpdatePrompt21TypedDict, UpdatePrompt22TypedDict],
)


UpdatePromptContent2 = TypeAliasType(
    "UpdatePromptContent2", Union[UpdatePrompt21, UpdatePrompt22]
)


UpdatePromptContentTypedDict = TypeAliasType(
    "UpdatePromptContentTypedDict", Union[str, List[UpdatePromptContent2TypedDict]]
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptContent = TypeAliasType(
    "UpdatePromptContent", Union[str, List[UpdatePromptContent2]]
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptType = Literal["function"]


class UpdatePromptFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptToolCallsTypedDict(TypedDict):
    type: UpdatePromptType
    function: UpdatePromptFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class UpdatePromptToolCalls(BaseModel):
    type: UpdatePromptType

    function: UpdatePromptFunction

    id: Optional[str] = None

    index: Optional[float] = None


class UpdatePromptMessagesTypedDict(TypedDict):
    role: UpdatePromptRole
    r"""The role of the prompt message"""
    content: UpdatePromptContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[List[UpdatePromptToolCallsTypedDict]]


class UpdatePromptMessages(BaseModel):
    role: UpdatePromptRole
    r"""The role of the prompt message"""

    content: UpdatePromptContent
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[List[UpdatePromptToolCalls]] = None


class UpdatePromptPromptConfigTypedDict(TypedDict):
    messages: List[UpdatePromptMessagesTypedDict]
    stream: NotRequired[bool]
    model: NotRequired[str]
    model_type: NotRequired[UpdatePromptModelType]
    r"""The type of the model"""
    model_parameters: NotRequired[UpdatePromptModelParametersTypedDict]
    r"""Model Parameters: Not all parameters apply to every model"""
    provider: NotRequired[UpdatePromptProvider]
    version: NotRequired[str]


class UpdatePromptPromptConfig(BaseModel):
    messages: List[UpdatePromptMessages]

    stream: Optional[bool] = None

    model: Optional[str] = None

    model_type: Optional[UpdatePromptModelType] = None
    r"""The type of the model"""

    model_parameters: Optional[UpdatePromptModelParameters] = None
    r"""Model Parameters: Not all parameters apply to every model"""

    provider: Optional[UpdatePromptProvider] = None

    version: Optional[str] = None


class UpdatePromptMetadataTypedDict(TypedDict):
    use_cases: NotRequired[List[str]]
    language: NotRequired[str]


class UpdatePromptMetadata(BaseModel):
    use_cases: Optional[List[str]] = None

    language: Optional[str] = None


class UpdatePromptRequestBodyTypedDict(TypedDict):
    display_name: NotRequired[str]
    description: NotRequired[Nullable[str]]
    prompt_config: NotRequired[UpdatePromptPromptConfigTypedDict]
    metadata: NotRequired[UpdatePromptMetadataTypedDict]
    key: NotRequired[str]


class UpdatePromptRequestBody(BaseModel):
    display_name: Optional[str] = None

    description: OptionalNullable[str] = UNSET

    prompt_config: Optional[UpdatePromptPromptConfig] = None

    metadata: Optional[UpdatePromptMetadata] = None

    key: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "display_name",
            "description",
            "prompt_config",
            "metadata",
            "key",
        ]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdatePromptRequestTypedDict(TypedDict):
    id: str
    r"""Prompt ID"""
    request_body: NotRequired[UpdatePromptRequestBodyTypedDict]


class UpdatePromptRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Prompt ID"""

    request_body: Annotated[
        Optional[UpdatePromptRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdatePromptPromptsResponseBodyData(BaseModel):
    message: str


class UpdatePromptPromptsResponseBody(Exception):
    r"""Prompt not found."""

    data: UpdatePromptPromptsResponseBodyData

    def __init__(self, data: UpdatePromptPromptsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdatePromptPromptsResponseBodyData)


UpdatePromptOwnerPrompts2 = Literal["vendor"]

UpdatePromptResponseBodyOwnerTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyOwnerTypedDict", Union[str, UpdatePromptOwnerPrompts2]
)


UpdatePromptResponseBodyOwner = TypeAliasType(
    "UpdatePromptResponseBodyOwner", Union[str, UpdatePromptOwnerPrompts2]
)


UpdatePromptResponseBodyPromptsModelType = Literal[
    "chat", "completion", "embedding", "vision", "image", "tts", "stt", "rerank"
]
r"""The type of the model"""

UpdatePromptResponseBodyPromptsFormat = Literal[
    "url", "b64_json", "text", "json_object"
]
r"""Only supported on `image` models."""

UpdatePromptResponseBodyPromptsQuality = Literal["standard", "hd"]
r"""Only supported on `image` models."""

UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3PromptConfigType = Literal[
    "json_object"
]


class UpdatePromptResponseFormatPromptsResponse2002TypedDict(TypedDict):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3PromptConfigType


class UpdatePromptResponseFormatPromptsResponse2002(BaseModel):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3PromptConfigType


UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3Type = Literal[
    "json_schema"
]


class UpdatePromptResponseFormatPromptsResponse200JSONSchemaTypedDict(TypedDict):
    name: str
    strict: bool
    schema_: Dict[str, Any]


class UpdatePromptResponseFormatPromptsResponse200JSONSchema(BaseModel):
    name: str

    strict: bool

    schema_: Annotated[Dict[str, Any], pydantic.Field(alias="schema")]


class UpdatePromptResponseFormatPromptsResponse2001TypedDict(TypedDict):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3Type
    json_schema: UpdatePromptResponseFormatPromptsResponse200JSONSchemaTypedDict


class UpdatePromptResponseFormatPromptsResponse2001(BaseModel):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3Type

    json_schema: UpdatePromptResponseFormatPromptsResponse200JSONSchema


UpdatePromptResponseBodyPromptsResponseFormatTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponseFormatTypedDict",
    Union[
        UpdatePromptResponseFormatPromptsResponse2002TypedDict,
        UpdatePromptResponseFormatPromptsResponse2001TypedDict,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyPromptsResponseFormat = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponseFormat",
    Union[
        UpdatePromptResponseFormatPromptsResponse2002,
        UpdatePromptResponseFormatPromptsResponse2001,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyPromptsPhotoRealVersion = Literal["v1", "v2"]
r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

UpdatePromptResponseBodyPromptsEncodingFormat = Literal["float", "base64"]
r"""The format to return the embeddings"""


class UpdatePromptResponseBodyPromptsModelParametersTypedDict(TypedDict):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    max_tokens: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_k: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_p: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    frequency_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    presence_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    num_images: NotRequired[float]
    r"""Only supported on `image` models."""
    seed: NotRequired[float]
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""
    format: NotRequired[UpdatePromptResponseBodyPromptsFormat]
    r"""Only supported on `image` models."""
    dimensions: NotRequired[str]
    r"""Only supported on `image` models."""
    quality: NotRequired[UpdatePromptResponseBodyPromptsQuality]
    r"""Only supported on `image` models."""
    style: NotRequired[str]
    r"""Only supported on `image` models."""
    response_format: NotRequired[
        Nullable[UpdatePromptResponseBodyPromptsResponseFormatTypedDict]
    ]
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """
    photo_real_version: NotRequired[UpdatePromptResponseBodyPromptsPhotoRealVersion]
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""
    encoding_format: NotRequired[UpdatePromptResponseBodyPromptsEncodingFormat]
    r"""The format to return the embeddings"""


class UpdatePromptResponseBodyPromptsModelParameters(BaseModel):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: Optional[float] = None
    r"""Only supported on `chat` and `completion` models."""

    max_tokens: Annotated[Optional[float], pydantic.Field(alias="maxTokens")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_k: Annotated[Optional[float], pydantic.Field(alias="topK")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_p: Annotated[Optional[float], pydantic.Field(alias="topP")] = None
    r"""Only supported on `chat` and `completion` models."""

    frequency_penalty: Annotated[
        Optional[float], pydantic.Field(alias="frequencyPenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    presence_penalty: Annotated[
        Optional[float], pydantic.Field(alias="presencePenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    num_images: Annotated[Optional[float], pydantic.Field(alias="numImages")] = None
    r"""Only supported on `image` models."""

    seed: Optional[float] = None
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""

    format: Optional[UpdatePromptResponseBodyPromptsFormat] = None
    r"""Only supported on `image` models."""

    dimensions: Optional[str] = None
    r"""Only supported on `image` models."""

    quality: Optional[UpdatePromptResponseBodyPromptsQuality] = None
    r"""Only supported on `image` models."""

    style: Optional[str] = None
    r"""Only supported on `image` models."""

    response_format: Annotated[
        OptionalNullable[UpdatePromptResponseBodyPromptsResponseFormat],
        pydantic.Field(alias="responseFormat"),
    ] = UNSET
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """

    photo_real_version: Annotated[
        Optional[UpdatePromptResponseBodyPromptsPhotoRealVersion],
        pydantic.Field(alias="photoRealVersion"),
    ] = None
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

    encoding_format: Optional[UpdatePromptResponseBodyPromptsEncodingFormat] = None
    r"""The format to return the embeddings"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "temperature",
            "maxTokens",
            "topK",
            "topP",
            "frequencyPenalty",
            "presencePenalty",
            "numImages",
            "seed",
            "format",
            "dimensions",
            "quality",
            "style",
            "responseFormat",
            "photoRealVersion",
            "encoding_format",
        ]
        nullable_fields = ["responseFormat"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptResponseBodyPromptsProvider = Literal[
    "cohere",
    "openai",
    "anthropic",
    "huggingface",
    "replicate",
    "google",
    "google-ai",
    "azure",
    "aws",
    "anyscale",
    "perplexity",
    "groq",
    "fal",
    "leonardoai",
    "nvidia",
]

UpdatePromptResponseBodyPromptsRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""

UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3PromptConfigType = Literal[
    "image_url"
]


class UpdatePrompt2PromptsResponse200ImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    id: NotRequired[str]
    r"""The orq.ai id of the image"""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponse200ImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    id: Optional[str] = None
    r"""The orq.ai id of the image"""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponse2002TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3PromptConfigType
    image_url: UpdatePrompt2PromptsResponse200ImageURLTypedDict


class UpdatePrompt2PromptsResponse2002(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3PromptConfigType

    image_url: UpdatePrompt2PromptsResponse200ImageURL


UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3Type = Literal["text"]


class UpdatePrompt2PromptsResponse2001TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3Type
    text: str


class UpdatePrompt2PromptsResponse2001(BaseModel):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3Type

    text: str


UpdatePromptContentPromptsResponse2002TypedDict = TypeAliasType(
    "UpdatePromptContentPromptsResponse2002TypedDict",
    Union[
        UpdatePrompt2PromptsResponse2001TypedDict,
        UpdatePrompt2PromptsResponse2002TypedDict,
    ],
)


UpdatePromptContentPromptsResponse2002 = TypeAliasType(
    "UpdatePromptContentPromptsResponse2002",
    Union[UpdatePrompt2PromptsResponse2001, UpdatePrompt2PromptsResponse2002],
)


UpdatePromptResponseBodyPromptsContentTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyPromptsContentTypedDict",
    Union[str, List[UpdatePromptContentPromptsResponse2002TypedDict]],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsContent = TypeAliasType(
    "UpdatePromptResponseBodyPromptsContent",
    Union[str, List[UpdatePromptContentPromptsResponse2002]],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsResponse200Type = Literal["function"]


class UpdatePromptResponseBodyPromptsFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyPromptsFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyPromptsToolCallsTypedDict(TypedDict):
    type: UpdatePromptResponseBodyPromptsResponse200Type
    function: UpdatePromptResponseBodyPromptsFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class UpdatePromptResponseBodyPromptsToolCalls(BaseModel):
    type: UpdatePromptResponseBodyPromptsResponse200Type

    function: UpdatePromptResponseBodyPromptsFunction

    id: Optional[str] = None

    index: Optional[float] = None


class UpdatePromptResponseBodyPromptsMessagesTypedDict(TypedDict):
    role: UpdatePromptResponseBodyPromptsRole
    r"""The role of the prompt message"""
    content: UpdatePromptResponseBodyPromptsContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[List[UpdatePromptResponseBodyPromptsToolCallsTypedDict]]


class UpdatePromptResponseBodyPromptsMessages(BaseModel):
    role: UpdatePromptResponseBodyPromptsRole
    r"""The role of the prompt message"""

    content: UpdatePromptResponseBodyPromptsContent
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[List[UpdatePromptResponseBodyPromptsToolCalls]] = None


class UpdatePromptResponseBodyPromptsPromptConfigTypedDict(TypedDict):
    messages: List[UpdatePromptResponseBodyPromptsMessagesTypedDict]
    stream: NotRequired[bool]
    model: NotRequired[str]
    model_db_id: NotRequired[str]
    r"""The id of the resource"""
    model_type: NotRequired[UpdatePromptResponseBodyPromptsModelType]
    r"""The type of the model"""
    model_parameters: NotRequired[
        UpdatePromptResponseBodyPromptsModelParametersTypedDict
    ]
    r"""Model Parameters: Not all parameters apply to every model"""
    provider: NotRequired[UpdatePromptResponseBodyPromptsProvider]
    integration_id: NotRequired[Nullable[str]]
    r"""The id of the resource"""
    version: NotRequired[str]


class UpdatePromptResponseBodyPromptsPromptConfig(BaseModel):
    messages: List[UpdatePromptResponseBodyPromptsMessages]

    stream: Optional[bool] = None

    model: Optional[str] = None

    model_db_id: Optional[str] = None
    r"""The id of the resource"""

    model_type: Optional[UpdatePromptResponseBodyPromptsModelType] = None
    r"""The type of the model"""

    model_parameters: Optional[UpdatePromptResponseBodyPromptsModelParameters] = None
    r"""Model Parameters: Not all parameters apply to every model"""

    provider: Optional[UpdatePromptResponseBodyPromptsProvider] = None

    integration_id: OptionalNullable[str] = UNSET
    r"""The id of the resource"""

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "stream",
            "model",
            "model_db_id",
            "model_type",
            "model_parameters",
            "provider",
            "integration_id",
            "version",
        ]
        nullable_fields = ["integration_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdatePromptResponseBodyPromptsMetadataTypedDict(TypedDict):
    use_cases: NotRequired[List[str]]
    language: NotRequired[str]


class UpdatePromptResponseBodyPromptsMetadata(BaseModel):
    use_cases: Optional[List[str]] = None

    language: Optional[str] = None


UpdatePromptResponseBodyPromptsResponse200ApplicationJSONModelType = Literal[
    "chat", "completion", "embedding", "vision", "image", "tts", "stt", "rerank"
]
r"""The type of the model"""

UpdatePromptResponseBodyPromptsResponse200ApplicationJSON3Format = Literal[
    "url", "b64_json", "text", "json_object"
]
r"""Only supported on `image` models."""

UpdatePromptResponseBodyPromptsResponse200ApplicationJSONQuality = Literal[
    "standard", "hd"
]
r"""Only supported on `image` models."""

UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3VersionsPromptConfigType = Literal[
    "json_object"
]


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody32TypedDict(
    TypedDict
):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3VersionsPromptConfigType


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody32(
    BaseModel
):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3VersionsPromptConfigType


UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3VersionsType = (
    Literal["json_schema"]
)


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3JSONSchemaTypedDict(
    TypedDict
):
    name: str
    strict: bool
    schema_: Dict[str, Any]


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3JSONSchema(
    BaseModel
):
    name: str

    strict: bool

    schema_: Annotated[Dict[str, Any], pydantic.Field(alias="schema")]


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody31TypedDict(
    TypedDict
):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3VersionsType
    json_schema: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3JSONSchemaTypedDict


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody31(
    BaseModel
):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3VersionsType

    json_schema: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody3JSONSchema


UpdatePromptResponseBodyPromptsResponse200ApplicationJSONResponseFormatTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponse200ApplicationJSONResponseFormatTypedDict",
    Union[
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody32TypedDict,
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody31TypedDict,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyPromptsResponse200ApplicationJSONResponseFormat = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponse200ApplicationJSONResponseFormat",
    Union[
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody32,
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody31,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyPromptsResponse200ApplicationJSONPhotoRealVersion = Literal[
    "v1", "v2"
]
r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

UpdatePromptResponseBodyPromptsResponse200ApplicationJSONEncodingFormat = Literal[
    "float", "base64"
]
r"""The format to return the embeddings"""


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONModelParametersTypedDict(
    TypedDict
):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    max_tokens: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_k: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_p: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    frequency_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    presence_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    num_images: NotRequired[float]
    r"""Only supported on `image` models."""
    seed: NotRequired[float]
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""
    format: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSON3Format
    ]
    r"""Only supported on `image` models."""
    dimensions: NotRequired[str]
    r"""Only supported on `image` models."""
    quality: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONQuality
    ]
    r"""Only supported on `image` models."""
    style: NotRequired[str]
    r"""Only supported on `image` models."""
    response_format: NotRequired[
        Nullable[
            UpdatePromptResponseBodyPromptsResponse200ApplicationJSONResponseFormatTypedDict
        ]
    ]
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """
    photo_real_version: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONPhotoRealVersion
    ]
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""
    encoding_format: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONEncodingFormat
    ]
    r"""The format to return the embeddings"""


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONModelParameters(
    BaseModel
):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: Optional[float] = None
    r"""Only supported on `chat` and `completion` models."""

    max_tokens: Annotated[Optional[float], pydantic.Field(alias="maxTokens")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_k: Annotated[Optional[float], pydantic.Field(alias="topK")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_p: Annotated[Optional[float], pydantic.Field(alias="topP")] = None
    r"""Only supported on `chat` and `completion` models."""

    frequency_penalty: Annotated[
        Optional[float], pydantic.Field(alias="frequencyPenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    presence_penalty: Annotated[
        Optional[float], pydantic.Field(alias="presencePenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    num_images: Annotated[Optional[float], pydantic.Field(alias="numImages")] = None
    r"""Only supported on `image` models."""

    seed: Optional[float] = None
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""

    format: Optional[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSON3Format
    ] = None
    r"""Only supported on `image` models."""

    dimensions: Optional[str] = None
    r"""Only supported on `image` models."""

    quality: Optional[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONQuality
    ] = None
    r"""Only supported on `image` models."""

    style: Optional[str] = None
    r"""Only supported on `image` models."""

    response_format: Annotated[
        OptionalNullable[
            UpdatePromptResponseBodyPromptsResponse200ApplicationJSONResponseFormat
        ],
        pydantic.Field(alias="responseFormat"),
    ] = UNSET
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """

    photo_real_version: Annotated[
        Optional[
            UpdatePromptResponseBodyPromptsResponse200ApplicationJSONPhotoRealVersion
        ],
        pydantic.Field(alias="photoRealVersion"),
    ] = None
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

    encoding_format: Optional[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONEncodingFormat
    ] = None
    r"""The format to return the embeddings"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "temperature",
            "maxTokens",
            "topK",
            "topP",
            "frequencyPenalty",
            "presencePenalty",
            "numImages",
            "seed",
            "format",
            "dimensions",
            "quality",
            "style",
            "responseFormat",
            "photoRealVersion",
            "encoding_format",
        ]
        nullable_fields = ["responseFormat"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptResponseBodyPromptsResponse200ApplicationJSONProvider = Literal[
    "cohere",
    "openai",
    "anthropic",
    "huggingface",
    "replicate",
    "google",
    "google-ai",
    "azure",
    "aws",
    "anyscale",
    "perplexity",
    "groq",
    "fal",
    "leonardoai",
    "nvidia",
]

UpdatePromptResponseBodyPromptsResponse200ApplicationJSONRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""

UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3VersionsPromptConfigType = (
    Literal["image_url"]
)


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3ImageURLTypedDict(
    TypedDict
):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    id: NotRequired[str]
    r"""The orq.ai id of the image"""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3ImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    id: Optional[str] = None
    r"""The orq.ai id of the image"""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody32TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3VersionsPromptConfigType
    image_url: (
        UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3ImageURLTypedDict
    )


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody32(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3VersionsPromptConfigType

    image_url: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3ImageURL


UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3VersionsType = Literal[
    "text"
]


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody31TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3VersionsType
    text: str


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody31(BaseModel):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody3VersionsType

    text: str


UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody32TypedDict = (
    TypeAliasType(
        "UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody32TypedDict",
        Union[
            UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody31TypedDict,
            UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody32TypedDict,
        ],
    )
)


UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody32 = TypeAliasType(
    "UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody32",
    Union[
        UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody31,
        UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody32,
    ],
)


UpdatePromptResponseBodyPromptsResponse200ApplicationJSONContentTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponse200ApplicationJSONContentTypedDict",
    Union[
        str,
        List[
            UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody32TypedDict
        ],
    ],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsResponse200ApplicationJSONContent = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponse200ApplicationJSONContent",
    Union[
        str, List[UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody32]
    ],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsResponse200ApplicationJSON3Type = Literal["function"]


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONFunctionTypedDict(
    TypedDict
):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONToolCallsTypedDict(
    TypedDict
):
    type: UpdatePromptResponseBodyPromptsResponse200ApplicationJSON3Type
    function: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONToolCalls(BaseModel):
    type: UpdatePromptResponseBodyPromptsResponse200ApplicationJSON3Type

    function: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONFunction

    id: Optional[str] = None

    index: Optional[float] = None


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONMessagesTypedDict(
    TypedDict
):
    role: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONRole
    r"""The role of the prompt message"""
    content: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[
        List[
            UpdatePromptResponseBodyPromptsResponse200ApplicationJSONToolCallsTypedDict
        ]
    ]


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONMessages(BaseModel):
    role: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONRole
    r"""The role of the prompt message"""

    content: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONContent
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[
        List[UpdatePromptResponseBodyPromptsResponse200ApplicationJSONToolCalls]
    ] = None


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONPromptConfigTypedDict(
    TypedDict
):
    messages: List[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONMessagesTypedDict
    ]
    stream: NotRequired[bool]
    model: NotRequired[str]
    model_db_id: NotRequired[str]
    r"""The id of the resource"""
    model_type: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONModelType
    ]
    r"""The type of the model"""
    model_parameters: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONModelParametersTypedDict
    ]
    r"""Model Parameters: Not all parameters apply to every model"""
    provider: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONProvider
    ]
    integration_id: NotRequired[Nullable[str]]
    r"""The id of the resource"""
    version: NotRequired[str]


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONPromptConfig(BaseModel):
    messages: List[UpdatePromptResponseBodyPromptsResponse200ApplicationJSONMessages]

    stream: Optional[bool] = None

    model: Optional[str] = None

    model_db_id: Optional[str] = None
    r"""The id of the resource"""

    model_type: Optional[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONModelType
    ] = None
    r"""The type of the model"""

    model_parameters: Optional[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONModelParameters
    ] = None
    r"""Model Parameters: Not all parameters apply to every model"""

    provider: Optional[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONProvider
    ] = None

    integration_id: OptionalNullable[str] = UNSET
    r"""The id of the resource"""

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "stream",
            "model",
            "model_db_id",
            "model_type",
            "model_parameters",
            "provider",
            "integration_id",
            "version",
        ]
        nullable_fields = ["integration_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONMetadataTypedDict(
    TypedDict
):
    use_cases: NotRequired[List[str]]
    language: NotRequired[str]


class UpdatePromptResponseBodyPromptsResponse200ApplicationJSONMetadata(BaseModel):
    use_cases: Optional[List[str]] = None

    language: Optional[str] = None


class UpdatePromptResponseBodyVersionsTypedDict(TypedDict):
    r"""Prompt version model returned from the API"""

    id: str
    created_by_id: str
    display_name: str
    updated_by_id: str
    prompt_config: (
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONPromptConfigTypedDict
    )
    metadata: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONMetadataTypedDict
    commit: str
    timestamp: str
    description: NotRequired[Nullable[str]]


class UpdatePromptResponseBodyVersions(BaseModel):
    r"""Prompt version model returned from the API"""

    id: Annotated[str, pydantic.Field(alias="_id")]

    created_by_id: str

    display_name: str

    updated_by_id: str

    prompt_config: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONPromptConfig

    metadata: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONMetadata

    commit: str

    timestamp: str

    description: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptResponseBodyPromptsType = Literal["template"]


class ResponseBody3TypedDict(TypedDict):
    r"""Prompt template model returned from the API"""

    id: str
    owner: UpdatePromptResponseBodyOwnerTypedDict
    domain_id: str
    created_by_id: str
    display_name: str
    updated_by_id: str
    prompt_config: UpdatePromptResponseBodyPromptsPromptConfigTypedDict
    metadata: UpdatePromptResponseBodyPromptsMetadataTypedDict
    versions: List[UpdatePromptResponseBodyVersionsTypedDict]
    type: UpdatePromptResponseBodyPromptsType
    description: NotRequired[Nullable[str]]
    created: NotRequired[datetime]
    r"""The date and time the resource was created"""
    updated: NotRequired[datetime]
    r"""The date and time the resource was last updated"""


class ResponseBody3(BaseModel):
    r"""Prompt template model returned from the API"""

    id: Annotated[str, pydantic.Field(alias="_id")]

    owner: UpdatePromptResponseBodyOwner

    domain_id: str

    created_by_id: str

    display_name: str

    updated_by_id: str

    prompt_config: UpdatePromptResponseBodyPromptsPromptConfig

    metadata: UpdatePromptResponseBodyPromptsMetadata

    versions: List[UpdatePromptResponseBodyVersions]

    type: UpdatePromptResponseBodyPromptsType

    description: OptionalNullable[str] = UNSET

    created: Optional[datetime] = None
    r"""The date and time the resource was created"""

    updated: Optional[datetime] = dateutil.parser.isoparse("2024-11-26T10:00:21.083Z")
    r"""The date and time the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "created", "updated"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptOwner2 = Literal["vendor"]

ResponseBodyOwnerTypedDict = TypeAliasType(
    "ResponseBodyOwnerTypedDict", Union[str, UpdatePromptOwner2]
)


ResponseBodyOwner = TypeAliasType("ResponseBodyOwner", Union[str, UpdatePromptOwner2])


UpdatePromptResponseBodyModelType = Literal[
    "chat", "completion", "embedding", "vision", "image", "tts", "stt", "rerank"
]
r"""The type of the model"""

UpdatePromptResponseBodyFormat = Literal["url", "b64_json", "text", "json_object"]
r"""Only supported on `image` models."""

UpdatePromptResponseBodyQuality = Literal["standard", "hd"]
r"""Only supported on `image` models."""

UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBodyType = Literal[
    "json_object"
]


class UpdatePromptResponseFormatPromptsResponse2TypedDict(TypedDict):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBodyType


class UpdatePromptResponseFormatPromptsResponse2(BaseModel):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBodyType


UpdatePromptResponseFormatPromptsResponse200ApplicationJSONType = Literal["json_schema"]


class UpdatePromptResponseFormatPromptsResponseJSONSchemaTypedDict(TypedDict):
    name: str
    strict: bool
    schema_: Dict[str, Any]


class UpdatePromptResponseFormatPromptsResponseJSONSchema(BaseModel):
    name: str

    strict: bool

    schema_: Annotated[Dict[str, Any], pydantic.Field(alias="schema")]


class UpdatePromptResponseFormatPromptsResponse1TypedDict(TypedDict):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONType
    json_schema: UpdatePromptResponseFormatPromptsResponseJSONSchemaTypedDict


class UpdatePromptResponseFormatPromptsResponse1(BaseModel):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONType

    json_schema: UpdatePromptResponseFormatPromptsResponseJSONSchema


UpdatePromptResponseBodyResponseFormatTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyResponseFormatTypedDict",
    Union[
        UpdatePromptResponseFormatPromptsResponse2TypedDict,
        UpdatePromptResponseFormatPromptsResponse1TypedDict,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyResponseFormat = TypeAliasType(
    "UpdatePromptResponseBodyResponseFormat",
    Union[
        UpdatePromptResponseFormatPromptsResponse2,
        UpdatePromptResponseFormatPromptsResponse1,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyPhotoRealVersion = Literal["v1", "v2"]
r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

UpdatePromptResponseBodyEncodingFormat = Literal["float", "base64"]
r"""The format to return the embeddings"""


class UpdatePromptResponseBodyModelParametersTypedDict(TypedDict):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    max_tokens: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_k: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_p: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    frequency_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    presence_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    num_images: NotRequired[float]
    r"""Only supported on `image` models."""
    seed: NotRequired[float]
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""
    format: NotRequired[UpdatePromptResponseBodyFormat]
    r"""Only supported on `image` models."""
    dimensions: NotRequired[str]
    r"""Only supported on `image` models."""
    quality: NotRequired[UpdatePromptResponseBodyQuality]
    r"""Only supported on `image` models."""
    style: NotRequired[str]
    r"""Only supported on `image` models."""
    response_format: NotRequired[
        Nullable[UpdatePromptResponseBodyResponseFormatTypedDict]
    ]
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """
    photo_real_version: NotRequired[UpdatePromptResponseBodyPhotoRealVersion]
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""
    encoding_format: NotRequired[UpdatePromptResponseBodyEncodingFormat]
    r"""The format to return the embeddings"""


class UpdatePromptResponseBodyModelParameters(BaseModel):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: Optional[float] = None
    r"""Only supported on `chat` and `completion` models."""

    max_tokens: Annotated[Optional[float], pydantic.Field(alias="maxTokens")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_k: Annotated[Optional[float], pydantic.Field(alias="topK")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_p: Annotated[Optional[float], pydantic.Field(alias="topP")] = None
    r"""Only supported on `chat` and `completion` models."""

    frequency_penalty: Annotated[
        Optional[float], pydantic.Field(alias="frequencyPenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    presence_penalty: Annotated[
        Optional[float], pydantic.Field(alias="presencePenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    num_images: Annotated[Optional[float], pydantic.Field(alias="numImages")] = None
    r"""Only supported on `image` models."""

    seed: Optional[float] = None
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""

    format: Optional[UpdatePromptResponseBodyFormat] = None
    r"""Only supported on `image` models."""

    dimensions: Optional[str] = None
    r"""Only supported on `image` models."""

    quality: Optional[UpdatePromptResponseBodyQuality] = None
    r"""Only supported on `image` models."""

    style: Optional[str] = None
    r"""Only supported on `image` models."""

    response_format: Annotated[
        OptionalNullable[UpdatePromptResponseBodyResponseFormat],
        pydantic.Field(alias="responseFormat"),
    ] = UNSET
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """

    photo_real_version: Annotated[
        Optional[UpdatePromptResponseBodyPhotoRealVersion],
        pydantic.Field(alias="photoRealVersion"),
    ] = None
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

    encoding_format: Optional[UpdatePromptResponseBodyEncodingFormat] = None
    r"""The format to return the embeddings"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "temperature",
            "maxTokens",
            "topK",
            "topP",
            "frequencyPenalty",
            "presencePenalty",
            "numImages",
            "seed",
            "format",
            "dimensions",
            "quality",
            "style",
            "responseFormat",
            "photoRealVersion",
            "encoding_format",
        ]
        nullable_fields = ["responseFormat"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptResponseBodyProvider = Literal[
    "cohere",
    "openai",
    "anthropic",
    "huggingface",
    "replicate",
    "google",
    "google-ai",
    "azure",
    "aws",
    "anyscale",
    "perplexity",
    "groq",
    "fal",
    "leonardoai",
    "nvidia",
]

UpdatePromptResponseBodyRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""

UpdatePrompt2PromptsResponse200ApplicationJSONResponseBodyType = Literal["image_url"]


class UpdatePrompt2PromptsResponseImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    id: NotRequired[str]
    r"""The orq.ai id of the image"""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponseImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    id: Optional[str] = None
    r"""The orq.ai id of the image"""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponse2TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBodyType
    image_url: UpdatePrompt2PromptsResponseImageURLTypedDict


class UpdatePrompt2PromptsResponse2(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBodyType

    image_url: UpdatePrompt2PromptsResponseImageURL


UpdatePrompt2PromptsResponse200ApplicationJSONType = Literal["text"]


class UpdatePrompt2PromptsResponse1TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONType
    text: str


class UpdatePrompt2PromptsResponse1(BaseModel):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONType

    text: str


UpdatePromptContentPromptsResponse2TypedDict = TypeAliasType(
    "UpdatePromptContentPromptsResponse2TypedDict",
    Union[
        UpdatePrompt2PromptsResponse1TypedDict, UpdatePrompt2PromptsResponse2TypedDict
    ],
)


UpdatePromptContentPromptsResponse2 = TypeAliasType(
    "UpdatePromptContentPromptsResponse2",
    Union[UpdatePrompt2PromptsResponse1, UpdatePrompt2PromptsResponse2],
)


UpdatePromptResponseBodyContentTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyContentTypedDict",
    Union[str, List[UpdatePromptContentPromptsResponse2TypedDict]],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyContent = TypeAliasType(
    "UpdatePromptResponseBodyContent",
    Union[str, List[UpdatePromptContentPromptsResponse2]],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsResponse200ApplicationJSONType = Literal["function"]


class UpdatePromptResponseBodyFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyToolCallsTypedDict(TypedDict):
    type: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONType
    function: UpdatePromptResponseBodyFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class UpdatePromptResponseBodyToolCalls(BaseModel):
    type: UpdatePromptResponseBodyPromptsResponse200ApplicationJSONType

    function: UpdatePromptResponseBodyFunction

    id: Optional[str] = None

    index: Optional[float] = None


class UpdatePromptResponseBodyMessagesTypedDict(TypedDict):
    role: UpdatePromptResponseBodyRole
    r"""The role of the prompt message"""
    content: UpdatePromptResponseBodyContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[List[UpdatePromptResponseBodyToolCallsTypedDict]]


class UpdatePromptResponseBodyMessages(BaseModel):
    role: UpdatePromptResponseBodyRole
    r"""The role of the prompt message"""

    content: UpdatePromptResponseBodyContent
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[List[UpdatePromptResponseBodyToolCalls]] = None


class UpdatePromptResponseBodyPromptConfigTypedDict(TypedDict):
    messages: List[UpdatePromptResponseBodyMessagesTypedDict]
    stream: NotRequired[bool]
    model: NotRequired[str]
    model_db_id: NotRequired[str]
    r"""The id of the resource"""
    model_type: NotRequired[UpdatePromptResponseBodyModelType]
    r"""The type of the model"""
    model_parameters: NotRequired[UpdatePromptResponseBodyModelParametersTypedDict]
    r"""Model Parameters: Not all parameters apply to every model"""
    provider: NotRequired[UpdatePromptResponseBodyProvider]
    integration_id: NotRequired[Nullable[str]]
    r"""The id of the resource"""
    version: NotRequired[str]


class UpdatePromptResponseBodyPromptConfig(BaseModel):
    messages: List[UpdatePromptResponseBodyMessages]

    stream: Optional[bool] = None

    model: Optional[str] = None

    model_db_id: Optional[str] = None
    r"""The id of the resource"""

    model_type: Optional[UpdatePromptResponseBodyModelType] = None
    r"""The type of the model"""

    model_parameters: Optional[UpdatePromptResponseBodyModelParameters] = None
    r"""Model Parameters: Not all parameters apply to every model"""

    provider: Optional[UpdatePromptResponseBodyProvider] = None

    integration_id: OptionalNullable[str] = UNSET
    r"""The id of the resource"""

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "stream",
            "model",
            "model_db_id",
            "model_type",
            "model_parameters",
            "provider",
            "integration_id",
            "version",
        ]
        nullable_fields = ["integration_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdatePromptResponseBodyMetadataTypedDict(TypedDict):
    use_cases: NotRequired[List[str]]
    language: NotRequired[str]


class UpdatePromptResponseBodyMetadata(BaseModel):
    use_cases: Optional[List[str]] = None

    language: Optional[str] = None


UpdatePromptResponseBodyPromptsResponseModelType = Literal[
    "chat", "completion", "embedding", "vision", "image", "tts", "stt", "rerank"
]
r"""The type of the model"""

UpdatePromptResponseBodyPromptsResponse200Format = Literal[
    "url", "b64_json", "text", "json_object"
]
r"""Only supported on `image` models."""

UpdatePromptResponseBodyPromptsResponseQuality = Literal["standard", "hd"]
r"""Only supported on `image` models."""

UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2VersionsType = (
    Literal["json_object"]
)


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSON2TypedDict(TypedDict):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2VersionsType


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSON2(BaseModel):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2VersionsType


UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2Type = Literal[
    "json_schema"
]


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONJSONSchemaTypedDict(
    TypedDict
):
    name: str
    strict: bool
    schema_: Dict[str, Any]


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONJSONSchema(BaseModel):
    name: str

    strict: bool

    schema_: Annotated[Dict[str, Any], pydantic.Field(alias="schema")]


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSON1TypedDict(TypedDict):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2Type
    json_schema: (
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSONJSONSchemaTypedDict
    )


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSON1(BaseModel):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2Type

    json_schema: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONJSONSchema


UpdatePromptResponseBodyPromptsResponseResponseFormatTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponseResponseFormatTypedDict",
    Union[
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSON2TypedDict,
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSON1TypedDict,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyPromptsResponseResponseFormat = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponseResponseFormat",
    Union[
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSON2,
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSON1,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyPromptsResponsePhotoRealVersion = Literal["v1", "v2"]
r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

UpdatePromptResponseBodyPromptsResponseEncodingFormat = Literal["float", "base64"]
r"""The format to return the embeddings"""


class UpdatePromptResponseBodyPromptsResponseModelParametersTypedDict(TypedDict):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    max_tokens: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_k: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_p: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    frequency_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    presence_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    num_images: NotRequired[float]
    r"""Only supported on `image` models."""
    seed: NotRequired[float]
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""
    format: NotRequired[UpdatePromptResponseBodyPromptsResponse200Format]
    r"""Only supported on `image` models."""
    dimensions: NotRequired[str]
    r"""Only supported on `image` models."""
    quality: NotRequired[UpdatePromptResponseBodyPromptsResponseQuality]
    r"""Only supported on `image` models."""
    style: NotRequired[str]
    r"""Only supported on `image` models."""
    response_format: NotRequired[
        Nullable[UpdatePromptResponseBodyPromptsResponseResponseFormatTypedDict]
    ]
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """
    photo_real_version: NotRequired[
        UpdatePromptResponseBodyPromptsResponsePhotoRealVersion
    ]
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""
    encoding_format: NotRequired[UpdatePromptResponseBodyPromptsResponseEncodingFormat]
    r"""The format to return the embeddings"""


class UpdatePromptResponseBodyPromptsResponseModelParameters(BaseModel):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: Optional[float] = None
    r"""Only supported on `chat` and `completion` models."""

    max_tokens: Annotated[Optional[float], pydantic.Field(alias="maxTokens")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_k: Annotated[Optional[float], pydantic.Field(alias="topK")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_p: Annotated[Optional[float], pydantic.Field(alias="topP")] = None
    r"""Only supported on `chat` and `completion` models."""

    frequency_penalty: Annotated[
        Optional[float], pydantic.Field(alias="frequencyPenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    presence_penalty: Annotated[
        Optional[float], pydantic.Field(alias="presencePenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    num_images: Annotated[Optional[float], pydantic.Field(alias="numImages")] = None
    r"""Only supported on `image` models."""

    seed: Optional[float] = None
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""

    format: Optional[UpdatePromptResponseBodyPromptsResponse200Format] = None
    r"""Only supported on `image` models."""

    dimensions: Optional[str] = None
    r"""Only supported on `image` models."""

    quality: Optional[UpdatePromptResponseBodyPromptsResponseQuality] = None
    r"""Only supported on `image` models."""

    style: Optional[str] = None
    r"""Only supported on `image` models."""

    response_format: Annotated[
        OptionalNullable[UpdatePromptResponseBodyPromptsResponseResponseFormat],
        pydantic.Field(alias="responseFormat"),
    ] = UNSET
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """

    photo_real_version: Annotated[
        Optional[UpdatePromptResponseBodyPromptsResponsePhotoRealVersion],
        pydantic.Field(alias="photoRealVersion"),
    ] = None
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

    encoding_format: Optional[UpdatePromptResponseBodyPromptsResponseEncodingFormat] = (
        None
    )
    r"""The format to return the embeddings"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "temperature",
            "maxTokens",
            "topK",
            "topP",
            "frequencyPenalty",
            "presencePenalty",
            "numImages",
            "seed",
            "format",
            "dimensions",
            "quality",
            "style",
            "responseFormat",
            "photoRealVersion",
            "encoding_format",
        ]
        nullable_fields = ["responseFormat"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptResponseBodyPromptsResponseProvider = Literal[
    "cohere",
    "openai",
    "anthropic",
    "huggingface",
    "replicate",
    "google",
    "google-ai",
    "azure",
    "aws",
    "anyscale",
    "perplexity",
    "groq",
    "fal",
    "leonardoai",
    "nvidia",
]

UpdatePromptResponseBodyPromptsResponseRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""

UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2VersionsType = Literal[
    "image_url"
]


class UpdatePrompt2PromptsResponse200ApplicationJSONImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    id: NotRequired[str]
    r"""The orq.ai id of the image"""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponse200ApplicationJSONImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    id: Optional[str] = None
    r"""The orq.ai id of the image"""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponse200ApplicationJSON2TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2VersionsType
    image_url: UpdatePrompt2PromptsResponse200ApplicationJSONImageURLTypedDict


class UpdatePrompt2PromptsResponse200ApplicationJSON2(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2VersionsType

    image_url: UpdatePrompt2PromptsResponse200ApplicationJSONImageURL


UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2Type = Literal["text"]


class UpdatePrompt2PromptsResponse200ApplicationJSON1TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2Type
    text: str


class UpdatePrompt2PromptsResponse200ApplicationJSON1(BaseModel):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2Type

    text: str


UpdatePromptContentPromptsResponse200ApplicationJSON2TypedDict = TypeAliasType(
    "UpdatePromptContentPromptsResponse200ApplicationJSON2TypedDict",
    Union[
        UpdatePrompt2PromptsResponse200ApplicationJSON1TypedDict,
        UpdatePrompt2PromptsResponse200ApplicationJSON2TypedDict,
    ],
)


UpdatePromptContentPromptsResponse200ApplicationJSON2 = TypeAliasType(
    "UpdatePromptContentPromptsResponse200ApplicationJSON2",
    Union[
        UpdatePrompt2PromptsResponse200ApplicationJSON1,
        UpdatePrompt2PromptsResponse200ApplicationJSON2,
    ],
)


UpdatePromptResponseBodyPromptsResponseContentTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponseContentTypedDict",
    Union[str, List[UpdatePromptContentPromptsResponse200ApplicationJSON2TypedDict]],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsResponseContent = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponseContent",
    Union[str, List[UpdatePromptContentPromptsResponse200ApplicationJSON2]],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsResponse200ApplicationJSON2Type = Literal["function"]


class UpdatePromptResponseBodyPromptsResponseFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyPromptsResponseFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyPromptsResponseToolCallsTypedDict(TypedDict):
    type: UpdatePromptResponseBodyPromptsResponse200ApplicationJSON2Type
    function: UpdatePromptResponseBodyPromptsResponseFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class UpdatePromptResponseBodyPromptsResponseToolCalls(BaseModel):
    type: UpdatePromptResponseBodyPromptsResponse200ApplicationJSON2Type

    function: UpdatePromptResponseBodyPromptsResponseFunction

    id: Optional[str] = None

    index: Optional[float] = None


class UpdatePromptResponseBodyPromptsResponseMessagesTypedDict(TypedDict):
    role: UpdatePromptResponseBodyPromptsResponseRole
    r"""The role of the prompt message"""
    content: UpdatePromptResponseBodyPromptsResponseContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[
        List[UpdatePromptResponseBodyPromptsResponseToolCallsTypedDict]
    ]


class UpdatePromptResponseBodyPromptsResponseMessages(BaseModel):
    role: UpdatePromptResponseBodyPromptsResponseRole
    r"""The role of the prompt message"""

    content: UpdatePromptResponseBodyPromptsResponseContent
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[List[UpdatePromptResponseBodyPromptsResponseToolCalls]] = None


class UpdatePromptResponseBodyPromptsResponsePromptConfigTypedDict(TypedDict):
    messages: List[UpdatePromptResponseBodyPromptsResponseMessagesTypedDict]
    stream: NotRequired[bool]
    model: NotRequired[str]
    model_db_id: NotRequired[str]
    r"""The id of the resource"""
    model_type: NotRequired[UpdatePromptResponseBodyPromptsResponseModelType]
    r"""The type of the model"""
    model_parameters: NotRequired[
        UpdatePromptResponseBodyPromptsResponseModelParametersTypedDict
    ]
    r"""Model Parameters: Not all parameters apply to every model"""
    provider: NotRequired[UpdatePromptResponseBodyPromptsResponseProvider]
    integration_id: NotRequired[Nullable[str]]
    r"""The id of the resource"""
    version: NotRequired[str]


class UpdatePromptResponseBodyPromptsResponsePromptConfig(BaseModel):
    messages: List[UpdatePromptResponseBodyPromptsResponseMessages]

    stream: Optional[bool] = None

    model: Optional[str] = None

    model_db_id: Optional[str] = None
    r"""The id of the resource"""

    model_type: Optional[UpdatePromptResponseBodyPromptsResponseModelType] = None
    r"""The type of the model"""

    model_parameters: Optional[
        UpdatePromptResponseBodyPromptsResponseModelParameters
    ] = None
    r"""Model Parameters: Not all parameters apply to every model"""

    provider: Optional[UpdatePromptResponseBodyPromptsResponseProvider] = None

    integration_id: OptionalNullable[str] = UNSET
    r"""The id of the resource"""

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "stream",
            "model",
            "model_db_id",
            "model_type",
            "model_parameters",
            "provider",
            "integration_id",
            "version",
        ]
        nullable_fields = ["integration_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdatePromptResponseBodyPromptsResponseMetadataTypedDict(TypedDict):
    use_cases: NotRequired[List[str]]
    language: NotRequired[str]


class UpdatePromptResponseBodyPromptsResponseMetadata(BaseModel):
    use_cases: Optional[List[str]] = None

    language: Optional[str] = None


class ResponseBodyVersionsTypedDict(TypedDict):
    r"""Prompt version model returned from the API"""

    id: str
    created_by_id: str
    display_name: str
    updated_by_id: str
    prompt_config: UpdatePromptResponseBodyPromptsResponsePromptConfigTypedDict
    metadata: UpdatePromptResponseBodyPromptsResponseMetadataTypedDict
    commit: str
    timestamp: str
    description: NotRequired[Nullable[str]]


class ResponseBodyVersions(BaseModel):
    r"""Prompt version model returned from the API"""

    id: Annotated[str, pydantic.Field(alias="_id")]

    created_by_id: str

    display_name: str

    updated_by_id: str

    prompt_config: UpdatePromptResponseBodyPromptsResponsePromptConfig

    metadata: UpdatePromptResponseBodyPromptsResponseMetadata

    commit: str

    timestamp: str

    description: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptResponseBodyType = Literal["snippet"]


class ResponseBody2TypedDict(TypedDict):
    r"""Prompt snippet model returned from the API"""

    id: str
    owner: ResponseBodyOwnerTypedDict
    domain_id: str
    created_by_id: str
    display_name: str
    updated_by_id: str
    prompt_config: UpdatePromptResponseBodyPromptConfigTypedDict
    metadata: UpdatePromptResponseBodyMetadataTypedDict
    versions: List[ResponseBodyVersionsTypedDict]
    key: str
    type: UpdatePromptResponseBodyType
    description: NotRequired[Nullable[str]]
    created: NotRequired[datetime]
    r"""The date and time the resource was created"""
    updated: NotRequired[datetime]
    r"""The date and time the resource was last updated"""


class ResponseBody2(BaseModel):
    r"""Prompt snippet model returned from the API"""

    id: Annotated[str, pydantic.Field(alias="_id")]

    owner: ResponseBodyOwner

    domain_id: str

    created_by_id: str

    display_name: str

    updated_by_id: str

    prompt_config: UpdatePromptResponseBodyPromptConfig

    metadata: UpdatePromptResponseBodyMetadata

    versions: List[ResponseBodyVersions]

    key: str

    type: UpdatePromptResponseBodyType

    description: OptionalNullable[str] = UNSET

    created: Optional[datetime] = None
    r"""The date and time the resource was created"""

    updated: Optional[datetime] = dateutil.parser.isoparse("2024-11-26T10:00:21.083Z")
    r"""The date and time the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "created", "updated"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


Owner2 = Literal["vendor"]

OwnerTypedDict = TypeAliasType("OwnerTypedDict", Union[str, Owner2])


Owner = TypeAliasType("Owner", Union[str, Owner2])


ResponseBodyModelType = Literal[
    "chat", "completion", "embedding", "vision", "image", "tts", "stt", "rerank"
]
r"""The type of the model"""

ResponseBodyFormat = Literal["url", "b64_json", "text", "json_object"]
r"""Only supported on `image` models."""

ResponseBodyQuality = Literal["standard", "hd"]
r"""Only supported on `image` models."""

UpdatePromptResponseFormatPromptsResponse200Type = Literal["json_object"]


class UpdatePromptResponseFormatPrompts2TypedDict(TypedDict):
    type: UpdatePromptResponseFormatPromptsResponse200Type


class UpdatePromptResponseFormatPrompts2(BaseModel):
    type: UpdatePromptResponseFormatPromptsResponse200Type


UpdatePromptResponseFormatPromptsResponseType = Literal["json_schema"]


class UpdatePromptResponseFormatPromptsJSONSchemaTypedDict(TypedDict):
    name: str
    strict: bool
    schema_: Dict[str, Any]


class UpdatePromptResponseFormatPromptsJSONSchema(BaseModel):
    name: str

    strict: bool

    schema_: Annotated[Dict[str, Any], pydantic.Field(alias="schema")]


class UpdatePromptResponseFormatPrompts1TypedDict(TypedDict):
    type: UpdatePromptResponseFormatPromptsResponseType
    json_schema: UpdatePromptResponseFormatPromptsJSONSchemaTypedDict


class UpdatePromptResponseFormatPrompts1(BaseModel):
    type: UpdatePromptResponseFormatPromptsResponseType

    json_schema: UpdatePromptResponseFormatPromptsJSONSchema


ResponseBodyResponseFormatTypedDict = TypeAliasType(
    "ResponseBodyResponseFormatTypedDict",
    Union[
        UpdatePromptResponseFormatPrompts2TypedDict,
        UpdatePromptResponseFormatPrompts1TypedDict,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


ResponseBodyResponseFormat = TypeAliasType(
    "ResponseBodyResponseFormat",
    Union[UpdatePromptResponseFormatPrompts2, UpdatePromptResponseFormatPrompts1],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


ResponseBodyPhotoRealVersion = Literal["v1", "v2"]
r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

ResponseBodyEncodingFormat = Literal["float", "base64"]
r"""The format to return the embeddings"""


class ResponseBodyModelParametersTypedDict(TypedDict):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    max_tokens: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_k: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_p: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    frequency_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    presence_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    num_images: NotRequired[float]
    r"""Only supported on `image` models."""
    seed: NotRequired[float]
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""
    format: NotRequired[ResponseBodyFormat]
    r"""Only supported on `image` models."""
    dimensions: NotRequired[str]
    r"""Only supported on `image` models."""
    quality: NotRequired[ResponseBodyQuality]
    r"""Only supported on `image` models."""
    style: NotRequired[str]
    r"""Only supported on `image` models."""
    response_format: NotRequired[Nullable[ResponseBodyResponseFormatTypedDict]]
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """
    photo_real_version: NotRequired[ResponseBodyPhotoRealVersion]
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""
    encoding_format: NotRequired[ResponseBodyEncodingFormat]
    r"""The format to return the embeddings"""


class ResponseBodyModelParameters(BaseModel):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: Optional[float] = None
    r"""Only supported on `chat` and `completion` models."""

    max_tokens: Annotated[Optional[float], pydantic.Field(alias="maxTokens")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_k: Annotated[Optional[float], pydantic.Field(alias="topK")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_p: Annotated[Optional[float], pydantic.Field(alias="topP")] = None
    r"""Only supported on `chat` and `completion` models."""

    frequency_penalty: Annotated[
        Optional[float], pydantic.Field(alias="frequencyPenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    presence_penalty: Annotated[
        Optional[float], pydantic.Field(alias="presencePenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    num_images: Annotated[Optional[float], pydantic.Field(alias="numImages")] = None
    r"""Only supported on `image` models."""

    seed: Optional[float] = None
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""

    format: Optional[ResponseBodyFormat] = None
    r"""Only supported on `image` models."""

    dimensions: Optional[str] = None
    r"""Only supported on `image` models."""

    quality: Optional[ResponseBodyQuality] = None
    r"""Only supported on `image` models."""

    style: Optional[str] = None
    r"""Only supported on `image` models."""

    response_format: Annotated[
        OptionalNullable[ResponseBodyResponseFormat],
        pydantic.Field(alias="responseFormat"),
    ] = UNSET
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """

    photo_real_version: Annotated[
        Optional[ResponseBodyPhotoRealVersion], pydantic.Field(alias="photoRealVersion")
    ] = None
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

    encoding_format: Optional[ResponseBodyEncodingFormat] = None
    r"""The format to return the embeddings"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "temperature",
            "maxTokens",
            "topK",
            "topP",
            "frequencyPenalty",
            "presencePenalty",
            "numImages",
            "seed",
            "format",
            "dimensions",
            "quality",
            "style",
            "responseFormat",
            "photoRealVersion",
            "encoding_format",
        ]
        nullable_fields = ["responseFormat"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


ResponseBodyProvider = Literal[
    "cohere",
    "openai",
    "anthropic",
    "huggingface",
    "replicate",
    "google",
    "google-ai",
    "azure",
    "aws",
    "anyscale",
    "perplexity",
    "groq",
    "fal",
    "leonardoai",
    "nvidia",
]

ResponseBodyRole = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""

UpdatePrompt2PromptsResponse200Type = Literal["image_url"]


class UpdatePrompt2PromptsImageURLTypedDict(TypedDict):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    id: NotRequired[str]
    r"""The orq.ai id of the image"""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    id: Optional[str] = None
    r"""The orq.ai id of the image"""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2Prompts2TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200Type
    image_url: UpdatePrompt2PromptsImageURLTypedDict


class UpdatePrompt2Prompts2(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200Type

    image_url: UpdatePrompt2PromptsImageURL


UpdatePrompt2PromptsResponseType = Literal["text"]


class UpdatePrompt2Prompts1TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponseType
    text: str


class UpdatePrompt2Prompts1(BaseModel):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponseType

    text: str


UpdatePromptContentPrompts2TypedDict = TypeAliasType(
    "UpdatePromptContentPrompts2TypedDict",
    Union[UpdatePrompt2Prompts1TypedDict, UpdatePrompt2Prompts2TypedDict],
)


UpdatePromptContentPrompts2 = TypeAliasType(
    "UpdatePromptContentPrompts2", Union[UpdatePrompt2Prompts1, UpdatePrompt2Prompts2]
)


ResponseBodyContentTypedDict = TypeAliasType(
    "ResponseBodyContentTypedDict",
    Union[str, List[UpdatePromptContentPrompts2TypedDict]],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


ResponseBodyContent = TypeAliasType(
    "ResponseBodyContent", Union[str, List[UpdatePromptContentPrompts2]]
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsResponseType = Literal["function"]


class ResponseBodyFunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class ResponseBodyFunction(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class ResponseBodyToolCallsTypedDict(TypedDict):
    type: UpdatePromptResponseBodyPromptsResponseType
    function: ResponseBodyFunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class ResponseBodyToolCalls(BaseModel):
    type: UpdatePromptResponseBodyPromptsResponseType

    function: ResponseBodyFunction

    id: Optional[str] = None

    index: Optional[float] = None


class ResponseBodyMessagesTypedDict(TypedDict):
    role: ResponseBodyRole
    r"""The role of the prompt message"""
    content: ResponseBodyContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[List[ResponseBodyToolCallsTypedDict]]


class ResponseBodyMessages(BaseModel):
    role: ResponseBodyRole
    r"""The role of the prompt message"""

    content: ResponseBodyContent
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[List[ResponseBodyToolCalls]] = None


class ResponseBodyPromptConfigTypedDict(TypedDict):
    messages: List[ResponseBodyMessagesTypedDict]
    stream: NotRequired[bool]
    model: NotRequired[str]
    model_db_id: NotRequired[str]
    r"""The id of the resource"""
    model_type: NotRequired[ResponseBodyModelType]
    r"""The type of the model"""
    model_parameters: NotRequired[ResponseBodyModelParametersTypedDict]
    r"""Model Parameters: Not all parameters apply to every model"""
    provider: NotRequired[ResponseBodyProvider]
    integration_id: NotRequired[Nullable[str]]
    r"""The id of the resource"""
    version: NotRequired[str]


class ResponseBodyPromptConfig(BaseModel):
    messages: List[ResponseBodyMessages]

    stream: Optional[bool] = None

    model: Optional[str] = None

    model_db_id: Optional[str] = None
    r"""The id of the resource"""

    model_type: Optional[ResponseBodyModelType] = None
    r"""The type of the model"""

    model_parameters: Optional[ResponseBodyModelParameters] = None
    r"""Model Parameters: Not all parameters apply to every model"""

    provider: Optional[ResponseBodyProvider] = None

    integration_id: OptionalNullable[str] = UNSET
    r"""The id of the resource"""

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "stream",
            "model",
            "model_db_id",
            "model_type",
            "model_parameters",
            "provider",
            "integration_id",
            "version",
        ]
        nullable_fields = ["integration_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ResponseBodyMetadataTypedDict(TypedDict):
    use_cases: NotRequired[List[str]]
    language: NotRequired[str]


class ResponseBodyMetadata(BaseModel):
    use_cases: Optional[List[str]] = None

    language: Optional[str] = None


UpdatePromptResponseBodyPromptsResponse200ModelType = Literal[
    "chat", "completion", "embedding", "vision", "image", "tts", "stt", "rerank"
]
r"""The type of the model"""

UpdatePromptResponseBodyPromptsResponse200ApplicationJSONFormat = Literal[
    "url", "b64_json", "text", "json_object"
]
r"""Only supported on `image` models."""

UpdatePromptResponseBodyPromptsResponse200Quality = Literal["standard", "hd"]
r"""Only supported on `image` models."""

UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1VersionsType = (
    Literal["json_object"]
)


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2TypedDict(
    TypedDict
):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1VersionsType


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2(
    BaseModel
):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1VersionsType


UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1Type = Literal[
    "json_schema"
]


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBodyJSONSchemaTypedDict(
    TypedDict
):
    name: str
    strict: bool
    schema_: Dict[str, Any]


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBodyJSONSchema(
    BaseModel
):
    name: str

    strict: bool

    schema_: Annotated[Dict[str, Any], pydantic.Field(alias="schema")]


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1TypedDict(
    TypedDict
):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1Type
    json_schema: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBodyJSONSchemaTypedDict


class UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1(
    BaseModel
):
    type: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1Type

    json_schema: UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBodyJSONSchema


UpdatePromptResponseBodyPromptsResponse200ResponseFormatTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponse200ResponseFormatTypedDict",
    Union[
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2TypedDict,
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1TypedDict,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyPromptsResponse200ResponseFormat = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponse200ResponseFormat",
    Union[
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody2,
        UpdatePromptResponseFormatPromptsResponse200ApplicationJSONResponseBody1,
    ],
)
r"""An object specifying the format that the model must output.

Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
"""


UpdatePromptResponseBodyPromptsResponse200PhotoRealVersion = Literal["v1", "v2"]
r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

UpdatePromptResponseBodyPromptsResponse200EncodingFormat = Literal["float", "base64"]
r"""The format to return the embeddings"""


class UpdatePromptResponseBodyPromptsResponse200ModelParametersTypedDict(TypedDict):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    max_tokens: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_k: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    top_p: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    frequency_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    presence_penalty: NotRequired[float]
    r"""Only supported on `chat` and `completion` models."""
    num_images: NotRequired[float]
    r"""Only supported on `image` models."""
    seed: NotRequired[float]
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""
    format: NotRequired[UpdatePromptResponseBodyPromptsResponse200ApplicationJSONFormat]
    r"""Only supported on `image` models."""
    dimensions: NotRequired[str]
    r"""Only supported on `image` models."""
    quality: NotRequired[UpdatePromptResponseBodyPromptsResponse200Quality]
    r"""Only supported on `image` models."""
    style: NotRequired[str]
    r"""Only supported on `image` models."""
    response_format: NotRequired[
        Nullable[UpdatePromptResponseBodyPromptsResponse200ResponseFormatTypedDict]
    ]
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """
    photo_real_version: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200PhotoRealVersion
    ]
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""
    encoding_format: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200EncodingFormat
    ]
    r"""The format to return the embeddings"""


class UpdatePromptResponseBodyPromptsResponse200ModelParameters(BaseModel):
    r"""Model Parameters: Not all parameters apply to every model"""

    temperature: Optional[float] = None
    r"""Only supported on `chat` and `completion` models."""

    max_tokens: Annotated[Optional[float], pydantic.Field(alias="maxTokens")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_k: Annotated[Optional[float], pydantic.Field(alias="topK")] = None
    r"""Only supported on `chat` and `completion` models."""

    top_p: Annotated[Optional[float], pydantic.Field(alias="topP")] = None
    r"""Only supported on `chat` and `completion` models."""

    frequency_penalty: Annotated[
        Optional[float], pydantic.Field(alias="frequencyPenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    presence_penalty: Annotated[
        Optional[float], pydantic.Field(alias="presencePenalty")
    ] = None
    r"""Only supported on `chat` and `completion` models."""

    num_images: Annotated[Optional[float], pydantic.Field(alias="numImages")] = None
    r"""Only supported on `image` models."""

    seed: Optional[float] = None
    r"""Best effort deterministic seed for the model. Currently only OpenAI models support these"""

    format: Optional[
        UpdatePromptResponseBodyPromptsResponse200ApplicationJSONFormat
    ] = None
    r"""Only supported on `image` models."""

    dimensions: Optional[str] = None
    r"""Only supported on `image` models."""

    quality: Optional[UpdatePromptResponseBodyPromptsResponse200Quality] = None
    r"""Only supported on `image` models."""

    style: Optional[str] = None
    r"""Only supported on `image` models."""

    response_format: Annotated[
        OptionalNullable[UpdatePromptResponseBodyPromptsResponse200ResponseFormat],
        pydantic.Field(alias="responseFormat"),
    ] = UNSET
    r"""An object specifying the format that the model must output.

    Setting to `{ \"type\": \"json_schema\", \"json_schema\": {...} }` enables Structured Outputs which ensures the model will match your supplied JSON schema

    Setting to `{ \"type\": \"json_object\" }` enables JSON mode, which ensures the message the model generates is valid JSON.

    Important: when using JSON mode, you must also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in a long-running and seemingly \"stuck\" request. Also note that the message content may be partially cut off if finish_reason=\"length\", which indicates the generation exceeded max_tokens or the conversation exceeded the max context length.
    """

    photo_real_version: Annotated[
        Optional[UpdatePromptResponseBodyPromptsResponse200PhotoRealVersion],
        pydantic.Field(alias="photoRealVersion"),
    ] = None
    r"""The version of photoReal to use. Must be v1 or v2. Only available for `leonardoai` provider"""

    encoding_format: Optional[
        UpdatePromptResponseBodyPromptsResponse200EncodingFormat
    ] = None
    r"""The format to return the embeddings"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "temperature",
            "maxTokens",
            "topK",
            "topP",
            "frequencyPenalty",
            "presencePenalty",
            "numImages",
            "seed",
            "format",
            "dimensions",
            "quality",
            "style",
            "responseFormat",
            "photoRealVersion",
            "encoding_format",
        ]
        nullable_fields = ["responseFormat"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptResponseBodyPromptsResponse200Provider = Literal[
    "cohere",
    "openai",
    "anthropic",
    "huggingface",
    "replicate",
    "google",
    "google-ai",
    "azure",
    "aws",
    "anyscale",
    "perplexity",
    "groq",
    "fal",
    "leonardoai",
    "nvidia",
]

UpdatePromptResponseBodyPromptsResponse200Role = Literal[
    "system",
    "assistant",
    "user",
    "exception",
    "tool",
    "prompt",
    "correction",
    "expected_output",
]
r"""The role of the prompt message"""

UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1VersionsType = Literal[
    "image_url"
]


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBodyImageURLTypedDict(
    TypedDict
):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""
    id: NotRequired[str]
    r"""The orq.ai id of the image"""
    detail: NotRequired[str]
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBodyImageURL(BaseModel):
    url: str
    r"""Either a URL of the image or the base64 encoded data URI."""

    id: Optional[str] = None
    r"""The orq.ai id of the image"""

    detail: Optional[str] = None
    r"""Specifies the detail level of the image. Currently only supported with OpenAI models"""


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2TypedDict(TypedDict):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1VersionsType
    image_url: (
        UpdatePrompt2PromptsResponse200ApplicationJSONResponseBodyImageURLTypedDict
    )


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2(BaseModel):
    r"""The image part of the prompt message. Only supported with vision models."""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1VersionsType

    image_url: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBodyImageURL


UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1Type = Literal["text"]


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1TypedDict(TypedDict):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1Type
    text: str


class UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1(BaseModel):
    r"""Text content part of a prompt message"""

    type: UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1Type

    text: str


UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody2TypedDict = (
    TypeAliasType(
        "UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody2TypedDict",
        Union[
            UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1TypedDict,
            UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2TypedDict,
        ],
    )
)


UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody2 = TypeAliasType(
    "UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody2",
    Union[
        UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody1,
        UpdatePrompt2PromptsResponse200ApplicationJSONResponseBody2,
    ],
)


UpdatePromptResponseBodyPromptsResponse200ContentTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponse200ContentTypedDict",
    Union[
        str,
        List[
            UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody2TypedDict
        ],
    ],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsResponse200Content = TypeAliasType(
    "UpdatePromptResponseBodyPromptsResponse200Content",
    Union[str, List[UpdatePromptContentPromptsResponse200ApplicationJSONResponseBody2]],
)
r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""


UpdatePromptResponseBodyPromptsResponse200ApplicationJSON1Type = Literal["function"]


class UpdatePromptResponseBodyPromptsResponse200FunctionTypedDict(TypedDict):
    name: str
    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyPromptsResponse200Function(BaseModel):
    name: str

    arguments: str
    r"""JSON string arguments for the functions"""


class UpdatePromptResponseBodyPromptsResponse200ToolCallsTypedDict(TypedDict):
    type: UpdatePromptResponseBodyPromptsResponse200ApplicationJSON1Type
    function: UpdatePromptResponseBodyPromptsResponse200FunctionTypedDict
    id: NotRequired[str]
    index: NotRequired[float]


class UpdatePromptResponseBodyPromptsResponse200ToolCalls(BaseModel):
    type: UpdatePromptResponseBodyPromptsResponse200ApplicationJSON1Type

    function: UpdatePromptResponseBodyPromptsResponse200Function

    id: Optional[str] = None

    index: Optional[float] = None


class UpdatePromptResponseBodyPromptsResponse200MessagesTypedDict(TypedDict):
    role: UpdatePromptResponseBodyPromptsResponse200Role
    r"""The role of the prompt message"""
    content: UpdatePromptResponseBodyPromptsResponse200ContentTypedDict
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""
    tool_calls: NotRequired[
        List[UpdatePromptResponseBodyPromptsResponse200ToolCallsTypedDict]
    ]


class UpdatePromptResponseBodyPromptsResponse200Messages(BaseModel):
    role: UpdatePromptResponseBodyPromptsResponse200Role
    r"""The role of the prompt message"""

    content: UpdatePromptResponseBodyPromptsResponse200Content
    r"""The contents of the user message. Either the text content of the message or an array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts."""

    tool_calls: Optional[List[UpdatePromptResponseBodyPromptsResponse200ToolCalls]] = (
        None
    )


class UpdatePromptResponseBodyPromptsResponse200PromptConfigTypedDict(TypedDict):
    messages: List[UpdatePromptResponseBodyPromptsResponse200MessagesTypedDict]
    stream: NotRequired[bool]
    model: NotRequired[str]
    model_db_id: NotRequired[str]
    r"""The id of the resource"""
    model_type: NotRequired[UpdatePromptResponseBodyPromptsResponse200ModelType]
    r"""The type of the model"""
    model_parameters: NotRequired[
        UpdatePromptResponseBodyPromptsResponse200ModelParametersTypedDict
    ]
    r"""Model Parameters: Not all parameters apply to every model"""
    provider: NotRequired[UpdatePromptResponseBodyPromptsResponse200Provider]
    integration_id: NotRequired[Nullable[str]]
    r"""The id of the resource"""
    version: NotRequired[str]


class UpdatePromptResponseBodyPromptsResponse200PromptConfig(BaseModel):
    messages: List[UpdatePromptResponseBodyPromptsResponse200Messages]

    stream: Optional[bool] = None

    model: Optional[str] = None

    model_db_id: Optional[str] = None
    r"""The id of the resource"""

    model_type: Optional[UpdatePromptResponseBodyPromptsResponse200ModelType] = None
    r"""The type of the model"""

    model_parameters: Optional[
        UpdatePromptResponseBodyPromptsResponse200ModelParameters
    ] = None
    r"""Model Parameters: Not all parameters apply to every model"""

    provider: Optional[UpdatePromptResponseBodyPromptsResponse200Provider] = None

    integration_id: OptionalNullable[str] = UNSET
    r"""The id of the resource"""

    version: Optional[str] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "stream",
            "model",
            "model_db_id",
            "model_type",
            "model_parameters",
            "provider",
            "integration_id",
            "version",
        ]
        nullable_fields = ["integration_id"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdatePromptResponseBodyPromptsResponse200MetadataTypedDict(TypedDict):
    use_cases: NotRequired[List[str]]
    language: NotRequired[str]


class UpdatePromptResponseBodyPromptsResponse200Metadata(BaseModel):
    use_cases: Optional[List[str]] = None

    language: Optional[str] = None


class VersionsTypedDict(TypedDict):
    r"""Prompt version model returned from the API"""

    id: str
    created_by_id: str
    display_name: str
    updated_by_id: str
    prompt_config: UpdatePromptResponseBodyPromptsResponse200PromptConfigTypedDict
    metadata: UpdatePromptResponseBodyPromptsResponse200MetadataTypedDict
    commit: str
    timestamp: str
    description: NotRequired[Nullable[str]]


class Versions(BaseModel):
    r"""Prompt version model returned from the API"""

    id: Annotated[str, pydantic.Field(alias="_id")]

    created_by_id: str

    display_name: str

    updated_by_id: str

    prompt_config: UpdatePromptResponseBodyPromptsResponse200PromptConfig

    metadata: UpdatePromptResponseBodyPromptsResponse200Metadata

    commit: str

    timestamp: str

    description: OptionalNullable[str] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


ResponseBodyType = Literal["prompt"]


class ResponseBody1TypedDict(TypedDict):
    r"""Prompt model returned from the API"""

    id: str
    owner: OwnerTypedDict
    domain_id: str
    created_by_id: str
    display_name: str
    updated_by_id: str
    prompt_config: ResponseBodyPromptConfigTypedDict
    metadata: ResponseBodyMetadataTypedDict
    versions: List[VersionsTypedDict]
    type: ResponseBodyType
    description: NotRequired[Nullable[str]]
    created: NotRequired[datetime]
    r"""The date and time the resource was created"""
    updated: NotRequired[datetime]
    r"""The date and time the resource was last updated"""


class ResponseBody1(BaseModel):
    r"""Prompt model returned from the API"""

    id: Annotated[str, pydantic.Field(alias="_id")]

    owner: Owner

    domain_id: str

    created_by_id: str

    display_name: str

    updated_by_id: str

    prompt_config: ResponseBodyPromptConfig

    metadata: ResponseBodyMetadata

    versions: List[Versions]

    type: ResponseBodyType

    description: OptionalNullable[str] = UNSET

    created: Optional[datetime] = None
    r"""The date and time the resource was created"""

    updated: Optional[datetime] = dateutil.parser.isoparse("2024-11-26T10:00:21.083Z")
    r"""The date and time the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["description", "created", "updated"]
        nullable_fields = ["description"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


UpdatePromptResponseBodyTypedDict = TypeAliasType(
    "UpdatePromptResponseBodyTypedDict",
    Union[ResponseBody1TypedDict, ResponseBody3TypedDict, ResponseBody2TypedDict],
)
r"""Prompt updated."""


UpdatePromptResponseBody = TypeAliasType(
    "UpdatePromptResponseBody", Union[ResponseBody1, ResponseBody3, ResponseBody2]
)
r"""Prompt updated."""
