from pytanga.components import AbstractComponent


class interfacerefComponent(AbstractComponent):

    def __init__(self, interface=None, subinterface=None):
        self._xmlns = {}
        self.attributes = self.setAttributes(interface, subinterface)
        self.parent_xmlns = {}
        self._children: List[AbstractComponent] = []
        self.childrenData = []
        self.tag = 'interface-ref'

    @property
    def xmlns(self):
        return self._xmlns

    @xmlns.setter
    def xmlns(self, xmlns):
        self._xmlns = xmlns

    def setAttributes(self, interface, subinterface):
        attributes = {}
        attributes['config'] = {}
        if(interface):
            attributes['config']['interface'] = interface
        if(subinterface):
            attributes['config']['subinterface'] = subinterface
        if(attributes['config'] == {}):
            del attributes['config']
        return attributes

    def add(self, component) -> None:
        self._children.append(component)

    def remove(self, component) -> None:
        self._children.remove(component)

    def is_composite(self) -> bool:
        return False

    def getXMLNS(self):
        childrenData = []
        for child in self._children:
            self.parent_xmlns.update(child.getXMLNS())
        return self.parent_xmlns

    def parse(self, serializer):
        self.childrenData = []
        self.getXMLNS()
        for child in self._children:
            self.childrenData.append(child.parse(serializer))
        return serializer.parse(self)

