import abc
import asyncio
from ..core.base import AbstractReader as AbstractReader, AbstractWriter as AbstractWriter
from ..utils import import_name as import_name
from _typeshed import Incomplete
from aioworkers.core.config import ValueExtractor as ValueExtractor

class AbstractQueue(AbstractReader, AbstractWriter, metaclass=abc.ABCMeta): ...

class Queue(asyncio.Queue, AbstractQueue):
    def __init__(self, config: Incomplete | None = ..., *, loop: Incomplete | None = ..., **kwargs) -> None: ...
    def set_config(self, config) -> None: ...
    def __len__(self) -> int: ...

class PriorityQueue(asyncio.PriorityQueue, Queue):
    def __init__(self, config: Incomplete | None = ..., *, loop: Incomplete | None = ..., **kwargs) -> None: ...

class ScoreQueueMixin:
    default_score: str
    def __init__(self, *args, **kwargs) -> None: ...
    def set_config(self, config) -> None: ...
    async def init(self) -> None: ...
    def put(self, value, score: Incomplete | None = ...): ...
    async def get(self, score: bool = ...): ...

def score_queue(default_score: Incomplete | None = ...): ...

class ScoreQueue(PriorityQueue): ...
